/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryClientFactory;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.bigquery.connector.common.LoggingBigQueryTracerFactory;
import com.google.cloud.spark.bigquery.BigQueryRelation;
import com.google.cloud.spark.bigquery.BigQueryStreamingSink;
import com.google.cloud.spark.bigquery.BigQueryUtilScala;
import com.google.cloud.spark.bigquery.GuiceInjectorCreator;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.direct.DirectBigQueryRelation;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableInfo;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.spark.bigquery.repackaged.com.google.inject.Injector;
import com.google.cloud.spark.bigquery.write.CreatableRelationProviderHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;

public class BigQueryRelationProviderBase
implements DataSourceRegister {
    private final Supplier<GuiceInjectorCreator> getGuiceInjectorCreator;

    public BigQueryRelationProviderBase(Supplier<GuiceInjectorCreator> getGuiceInjectorCreator) {
        this.getGuiceInjectorCreator = getGuiceInjectorCreator;
        BigQueryUtilScala.validateScalaVersionCompatibility();
    }

    public BigQueryRelationProviderBase() {
        this(() -> new GuiceInjectorCreator(){});
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        return this.createRelationInternal(sqlContext, parameters, Optional.empty());
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters, StructType schema) {
        return this.createRelationInternal(sqlContext, parameters, Optional.of(schema));
    }

    public Sink createSink(SQLContext sqlContext, Map<String, String> parameters, List<String> partitionColumns, OutputMode outputMode) {
        Injector injector = this.getGuiceInjectorCreator.get().createGuiceInjector(sqlContext, parameters, Optional.empty());
        SparkBigQueryConfig opts = injector.getInstance(SparkBigQueryConfig.class);
        BigQueryClient bigQueryClient = injector.getInstance(BigQueryClient.class);
        return new BigQueryStreamingSink(sqlContext, parameters, partitionColumns, outputMode, opts, bigQueryClient);
    }

    protected BigQueryRelation createRelationInternal(SQLContext sqlContext, Map<String, String> parameters, Optional<StructType> schema) {
        Injector injector = this.getGuiceInjectorCreator.get().createGuiceInjector(sqlContext, parameters, schema);
        SparkBigQueryConfig opts = injector.getInstance(SparkBigQueryConfig.class);
        BigQueryClient bigQueryClient = injector.getInstance(BigQueryClient.class);
        TableInfo tableInfo = bigQueryClient.getReadTable(opts.toReadTableOptions());
        String tableName = BigQueryUtil.friendlyTableName(opts.getTableId());
        BigQueryClientFactory bigQueryReadClientFactory = injector.getInstance(BigQueryClientFactory.class);
        LoggingBigQueryTracerFactory bigQueryTracerFactory = injector.getInstance(LoggingBigQueryTracerFactory.class);
        TableInfo table = Optional.ofNullable(tableInfo).orElseThrow(() -> new RuntimeException("Table " + tableName + " not found"));
        TableDefinition.Type tableType = ((TableDefinition)table.getDefinition()).getType();
        if (tableType == TableDefinition.Type.TABLE || tableType == TableDefinition.Type.EXTERNAL || tableType == TableDefinition.Type.SNAPSHOT) {
            return new DirectBigQueryRelation(opts, table, bigQueryClient, bigQueryReadClientFactory, bigQueryTracerFactory, sqlContext);
        }
        if (tableType == TableDefinition.Type.VIEW || tableType == TableDefinition.Type.MATERIALIZED_VIEW) {
            if (opts.isViewsEnabled()) {
                return new DirectBigQueryRelation(opts, table, bigQueryClient, bigQueryReadClientFactory, bigQueryTracerFactory, sqlContext);
            }
            throw new RuntimeException(String.format("Views were not enabled. You can enable views by setting '%s' to true. Notice additional cost may occur.", "viewsEnabled"));
        }
        throw new UnsupportedOperationException("The type of table " + tableName + " is currently not supported: " + tableType);
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> parameters, Dataset<Row> data) {
        ImmutableMap<String, String> customDefaults = ImmutableMap.of();
        return new CreatableRelationProviderHelper().createRelation(sqlContext, mode, parameters, data, customDefaults);
    }

    public String shortName() {
        return "bigquery";
    }
}

