/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.bigquery.connector.common.IdentityTokenSupplier;
import com.google.cloud.bigquery.storage.v1.BigQueryReadClient;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCombiningIterator
implements Iterator<ReadRowsResponse> {
    private static final Logger log = LoggerFactory.getLogger(StreamCombiningIterator.class);
    private static final Object EOS = new Object();
    private final ArrayBlockingQueue<Object> responses;
    private final ArrayBlockingQueue<Observer> observersQueue;
    private final AtomicInteger observersLeft;
    private final int bufferEntriesPerStream;
    private final int numRetries;
    private final Object lock = new Object();
    private final BigQueryReadClient client;
    Object last;
    volatile boolean cancelled = false;
    private final Collection<Observer> observers;
    private static final long IDENTITY_TOKEN_TTL_IN_MINUTES = 50L;
    private static final LoadingCache<String, Optional<String>> READ_SESSION_TO_IDENTITY_TOKEN_CACHE = CacheBuilder.newBuilder().expireAfterWrite(50L, TimeUnit.MINUTES).build(CacheLoader.from(IdentityTokenSupplier::fetchIdentityToken));

    StreamCombiningIterator(BigQueryReadClient client, Collection<ReadRowsRequest.Builder> requests, int bufferEntriesPerStream, int numRetries) {
        this.client = client;
        this.observersLeft = new AtomicInteger(requests.size());
        this.bufferEntriesPerStream = bufferEntriesPerStream;
        Preconditions.checkArgument((this.bufferEntriesPerStream > 0 ? 1 : 0) != 0, (String)"bufferEntriesPerstream must be positive.  Received: %s", (int)this.bufferEntriesPerStream);
        if (this.bufferEntriesPerStream > 0 || requests.size() > 0) {
            log.info("new combining stream with {} streams and {} buffered entries", (Object)requests.size(), (Object)this.bufferEntriesPerStream);
        }
        this.responses = new ArrayBlockingQueue(requests.size() * this.bufferEntriesPerStream + 1);
        this.observersQueue = new ArrayBlockingQueue(requests.size() * this.bufferEntriesPerStream);
        this.numRetries = numRetries;
        this.observers = requests.stream().map(x$0 -> new Observer((ReadRowsRequest.Builder)x$0)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void stopWithError(Throwable error) {
        Object object = this.lock;
        synchronized (object) {
            if (this.cancelled) {
                return;
            }
            try {
                this.completeStream(false);
            }
            finally {
                Preconditions.checkState((boolean)this.responses.add(error), (Object)"Responses should always have capacity to add element");
            }
        }
    }

    private boolean hasActiveObservers() {
        return this.observersLeft.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadRowsResponse next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            ReadRowsResponse tmp;
            Observer observer = this.observersQueue.poll();
            Preconditions.checkState((observer != null ? 1 : 0) != 0);
            observer.request();
            ReadRowsResponse readRowsResponse = tmp = (ReadRowsResponse)this.last;
            return readRowsResponse;
        }
        finally {
            if (this.last != EOS) {
                this.last = null;
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.last == null) {
            try {
                this.last = this.responses.take();
            }
            catch (InterruptedException e) {
                this.cancel();
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        if (this.last instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)this.last;
            runtimeException.addSuppressed(new RuntimeException("Asynchronous task failed"));
            throw runtimeException;
        }
        if (this.last instanceof Throwable) {
            Throwable throwable = (Throwable)this.last;
            throw new UncheckedExecutionException(throwable);
        }
        return this.last != EOS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.cancelled) {
                return;
            }
            this.completeStream(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeFinished() {
        Iterator<Observer> iterator = this.lock;
        synchronized (iterator) {
            if (this.cancelled) {
                return;
            }
            if (this.hasActiveObservers()) {
                return;
            }
            this.completeStream(true);
        }
        for (Observer observer : this.observers) {
            observer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeStream(boolean addEos) {
        this.cancelled = true;
        this.observersLeft.set(0);
        try {
            for (Observer observer : this.observers) {
                observer.cancel();
            }
        }
        finally {
            if (addEos) {
                this.responses.add(EOS);
            }
        }
    }

    private String parseReadSessionId(String stream) {
        int streamsIndex = stream.indexOf("/streams");
        if (streamsIndex != -1) {
            return stream.substring(0, streamsIndex);
        }
        log.warn("Stream name {} in invalid format", (Object)stream);
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newConnection(Observer observer, ReadRowsRequest.Builder request) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.cancelled) {
                GrpcCallContext callContext = GrpcCallContext.createDefault();
                try {
                    callContext = (ApiCallContext)((Optional)READ_SESSION_TO_IDENTITY_TOKEN_CACHE.get((Object)this.parseReadSessionId(request.getReadStream()))).map(token -> GrpcCallContext.createDefault().withExtraHeaders(Collections.singletonMap("x-bigquerystorage-api-token", Collections.singletonList(token)))).orElse(GrpcCallContext.createDefault());
                }
                catch (ExecutionException e) {
                    log.error("Unable to obtain identity token", (Throwable)e);
                }
                this.client.readRowsCallable().call((Object)request.build(), (ResponseObserver)observer, (ApiCallContext)callContext);
            }
        }
    }

    class Observer
    implements ResponseObserver<ReadRowsResponse> {
        private long readRowsCount = 0L;
        private int retries = 0;
        StreamController controller;
        AtomicInteger enqueuedCount = new AtomicInteger(0);
        private final Object controllerLock = new Object();
        ReadRowsRequest.Builder builder;

        Observer(ReadRowsRequest.Builder builder) {
            this.builder = builder;
            StreamCombiningIterator.this.newConnection(this, builder);
        }

        public void onResponse(ReadRowsResponse value) {
            this.readRowsCount += value.getRowCount();
            Preconditions.checkState((boolean)StreamCombiningIterator.this.observersQueue.add(this));
            Preconditions.checkState((boolean)StreamCombiningIterator.this.responses.add(value), (Object)"Expected capacity in responses");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStart(StreamController controller) {
            Object object = StreamCombiningIterator.this.lock;
            synchronized (object) {
                if (StreamCombiningIterator.this.cancelled) {
                    controller.cancel();
                    return;
                }
                Object object2 = this.controllerLock;
                synchronized (object2) {
                    this.controller = controller;
                    controller.disableAutoInboundFlowControl();
                    this.enqueuedCount.incrementAndGet();
                    this.request();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            if (BigQueryUtil.isRetryable(t) && this.retries < StreamCombiningIterator.this.numRetries) {
                Object object = this.controllerLock;
                synchronized (object) {
                    this.controller = null;
                }
                this.builder.setOffset(this.readRowsCount);
                StreamCombiningIterator.this.newConnection(this, this.builder);
                ++this.retries;
            } else if (BigQueryUtil.isReadSessionExpired(t)) {
                RuntimeException runtimeException = new RuntimeException("Read session expired after 6 hours. Dataframes on BigQuery tables cannot be operated on beyond this time-limit. Your options: (1) try finishing within 6 hours, (2) use Spark dataframe caching, (3) read from a newly created BigQuery dataframe.", t);
                StreamCombiningIterator.this.stopWithError(runtimeException);
            } else {
                StreamCombiningIterator.this.stopWithError(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            Object object = this.controllerLock;
            synchronized (object) {
                this.controller = null;
            }
            int left = StreamCombiningIterator.this.observersLeft.decrementAndGet();
            StreamCombiningIterator.this.maybeFinished();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void request() {
            if (StreamCombiningIterator.this.cancelled) {
                return;
            }
            boolean canExit = false;
            int count = this.enqueuedCount.decrementAndGet();
            if (count > StreamCombiningIterator.this.bufferEntriesPerStream / 4) {
                return;
            }
            int addBack = StreamCombiningIterator.this.bufferEntriesPerStream - count;
            Preconditions.checkState((addBack > 0 ? 1 : 0) != 0);
            this.enqueuedCount.addAndGet(addBack);
            while (!canExit) {
                Object object = this.controllerLock;
                synchronized (object) {
                    if (this.controller == null) {
                        return;
                    }
                    try {
                        this.controller.request(addBack);
                        canExit = true;
                    }
                    catch (RuntimeException e) {
                        log.info("Exception on flow control request {} {}", (Object)e, (Object)this.builder.getReadStream());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = this.controllerLock;
            synchronized (object) {
                if (this.controller != null) {
                    try {
                        this.controller.cancel();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

