/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class DecompressReadRowsResponse {
    public static InputStream decompressArrowRecordBatch(ReadRowsResponse response, ReadSession.TableReadOptions.ResponseCompressionCodec compressionCodec) throws IOException {
        ByteString responseBytes = response.getArrowRecordBatch().getSerializedRecordBatch();
        return DecompressReadRowsResponse.decompressRecordBatchInternal(response, compressionCodec, responseBytes);
    }

    public static InputStream decompressAvroRecordBatch(ReadRowsResponse response, ReadSession.TableReadOptions.ResponseCompressionCodec compressionCodec) throws IOException {
        ByteString responseBytes = response.getAvroRows().getSerializedBinaryRows();
        return DecompressReadRowsResponse.decompressRecordBatchInternal(response, compressionCodec, responseBytes);
    }

    private static InputStream decompressRecordBatchInternal(ReadRowsResponse response, ReadSession.TableReadOptions.ResponseCompressionCodec compressionCodec, ByteString responseBytes) throws IOException {
        long uncompressedByteSize = response.getUncompressedByteSize();
        if (uncompressedByteSize <= 0L) {
            return responseBytes.newInput();
        }
        byte[] compressed = responseBytes.toByteArray();
        switch (compressionCodec) {
            case RESPONSE_COMPRESSION_CODEC_LZ4: {
                LZ4Factory factory = LZ4Factory.fastestInstance();
                LZ4FastDecompressor decompressor = factory.fastDecompressor();
                byte[] decompressed = new byte[(int)uncompressedByteSize];
                decompressor.decompress(compressed, 0, decompressed, 0, (int)uncompressedByteSize);
                return new ByteArrayInputStream(decompressed);
            }
        }
        throw new IOException("Missing a compression codec to decode a compressed ReadRowsResponse.");
    }
}

