/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.api.client.util.Base64;
import com.google.auth.Credentials;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ImpersonatedCredentials;
import com.google.cloud.bigquery.connector.common.AccessTokenProvider;
import com.google.cloud.bigquery.connector.common.AccessTokenProviderCredentials;
import com.google.cloud.bigquery.connector.common.BigQueryProxyTransporterBuilder;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryCredentialsSupplier {
    private final Credentials credentials;
    public static final String CLOUD_PLATFORM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    private static final Logger log = LoggerFactory.getLogger(BigQueryCredentialsSupplier.class);

    public BigQueryCredentialsSupplier(Optional<String> accessTokenProviderFQCN, Optional<String> accessTokenProviderConfig, Optional<String> accessToken, Optional<String> credentialsKey, Optional<String> credentialsFile, String loggedInUserName, Set<String> loggedInUserGroups, Optional<Map<String, String>> impersonationServiceAccountsForUsers, Optional<Map<String, String>> impersonationServiceAccountsForGroups, Optional<String> impersonationServiceAccount, Optional<ImmutableList<String>> credentialsScopes, Optional<URI> proxyUri, Optional<String> proxyUsername, Optional<String> proxyPassword) {
        GoogleCredentials credentials;
        if (accessTokenProviderFQCN.isPresent()) {
            AccessTokenProvider accessTokenProvider = accessTokenProviderConfig.map(config -> BigQueryUtil.createVerifiedInstance((String)accessTokenProviderFQCN.get(), AccessTokenProvider.class, config)).orElseGet(() -> BigQueryUtil.createVerifiedInstance((String)accessTokenProviderFQCN.get(), AccessTokenProvider.class, new Object[0]));
            credentials = new AccessTokenProviderCredentials(BigQueryUtil.verifySerialization(accessTokenProvider));
        } else {
            credentials = accessToken.isPresent() ? BigQueryCredentialsSupplier.createCredentialsFromAccessToken(accessToken.get()) : (credentialsKey.isPresent() ? BigQueryCredentialsSupplier.createCredentialsFromKey(credentialsKey.get(), proxyUri, proxyUsername, proxyPassword) : (credentialsFile.isPresent() ? BigQueryCredentialsSupplier.createCredentialsFromFile(credentialsFile.get(), proxyUri, proxyUsername, proxyPassword) : BigQueryCredentialsSupplier.createDefaultCredentials()));
        }
        Optional<GoogleCredentials> impersonatedCredentials = BigQueryCredentialsSupplier.createCredentialsFromImpersonation(loggedInUserName, loggedInUserGroups, impersonationServiceAccountsForUsers, impersonationServiceAccountsForGroups, impersonationServiceAccount, credentials, proxyUri, proxyUsername, proxyPassword);
        credentials = impersonatedCredentials.orElse(credentials);
        this.credentials = (Credentials)credentialsScopes.map(arg_0 -> ((GoogleCredentials)credentials).createScoped(arg_0)).orElse(credentials);
    }

    private static GoogleCredentials createCredentialsFromAccessToken(String accessToken) {
        return GoogleCredentials.create((AccessToken)new AccessToken(accessToken, null));
    }

    private static Optional<GoogleCredentials> createCredentialsFromImpersonation(String loggedInUserName, Set<String> loggedInUserGroups, Optional<Map<String, String>> impersonationServiceAccountsForUsers, Optional<Map<String, String>> impersonationServiceAccountsForGroups, Optional<String> impersonationServiceAccount, GoogleCredentials sourceCredentials, Optional<URI> proxyUri, Optional<String> proxyUsername, Optional<String> proxyPassword) {
        Optional<String> serviceAccountToImpersonate = Stream.of(() -> BigQueryCredentialsSupplier.getServiceAccountToImpersonateByKeys(impersonationServiceAccountsForUsers, (Collection)Optional.ofNullable(loggedInUserName).map(ImmutableList::of).orElseGet(ImmutableList::of)), () -> BigQueryCredentialsSupplier.getServiceAccountToImpersonateByKeys(impersonationServiceAccountsForGroups, Optional.ofNullable(loggedInUserGroups).orElse(new HashSet())), () -> impersonationServiceAccount).map(Supplier::get).filter(Optional::isPresent).map(Optional::get).filter(sa -> !Strings.isNullOrEmpty((String)sa)).findFirst();
        HttpTransportFactory httpTransportFactory = BigQueryProxyTransporterBuilder.createHttpTransportFactory(proxyUri, proxyUsername, proxyPassword);
        return serviceAccountToImpersonate.map(sa -> ImpersonatedCredentials.newBuilder().setSourceCredentials(sourceCredentials).setTargetPrincipal((String)serviceAccountToImpersonate.get()).setScopes((List)ImmutableList.of((Object)CLOUD_PLATFORM_SCOPE)).setHttpTransportFactory(httpTransportFactory).build());
    }

    private static Optional<String> getServiceAccountToImpersonateByKeys(Optional<Map<String, String>> serviceAccountMapping, Collection<String> keys) {
        return serviceAccountMapping.flatMap(mapping -> mapping.entrySet().stream().filter(e -> keys.contains(e.getKey())).map(Map.Entry::getValue).findFirst());
    }

    private static GoogleCredentials createCredentialsFromKey(String key, Optional<URI> proxyUri, Optional<String> proxyUsername, Optional<String> proxyPassword) {
        try {
            if (proxyUri.isPresent()) {
                HttpTransportFactory httpTransportFactory = BigQueryProxyTransporterBuilder.createHttpTransportFactory(proxyUri, proxyUsername, proxyPassword);
                return GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)key)), (HttpTransportFactory)httpTransportFactory);
            }
            return GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)key)));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create Credentials from key", e);
        }
    }

    private static GoogleCredentials createCredentialsFromFile(String file, Optional<URI> proxyUri, Optional<String> proxyUsername, Optional<String> proxyPassword) {
        try {
            if (proxyUri.isPresent()) {
                HttpTransportFactory httpTransportFactory = BigQueryProxyTransporterBuilder.createHttpTransportFactory(proxyUri, proxyUsername, proxyPassword);
                return GoogleCredentials.fromStream((InputStream)new FileInputStream(file), (HttpTransportFactory)httpTransportFactory);
            }
            return GoogleCredentials.fromStream((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create Credentials from file", e);
        }
    }

    public static GoogleCredentials createDefaultCredentials() {
        try {
            return GoogleCredentials.getApplicationDefault();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create default Credentials", e);
        }
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getUniverseDomain() {
        String universeDomain = "googleapis.com";
        try {
            universeDomain = this.getCredentials().getUniverseDomain();
        }
        catch (IOException e) {
            log.warn("Caught Exception while querying the Universe Domain, continuing with GOOGLE_DEFAULT_UNIVERSE");
        }
        return universeDomain;
    }
}

