/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.TransportOptions;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryClientFactory;
import com.google.cloud.bigquery.connector.common.BigQueryConfig;
import com.google.cloud.bigquery.connector.common.BigQueryCredentialsSupplier;
import com.google.cloud.bigquery.connector.common.BigQueryJobCompletionListener;
import com.google.cloud.bigquery.connector.common.BigQueryProxyConfig;
import com.google.cloud.bigquery.connector.common.BigQueryProxyTransporterBuilder;
import com.google.cloud.bigquery.connector.common.BigQueryTracerFactory;
import com.google.cloud.bigquery.connector.common.EnvironmentContext;
import com.google.cloud.bigquery.connector.common.HttpUtil;
import com.google.cloud.bigquery.connector.common.LoggingBigQueryTracerFactory;
import com.google.cloud.bigquery.connector.common.UserAgentProvider;
import com.google.cloud.http.HttpTransportOptions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class BigQueryClientModule
implements Module {
    private static final int DESTINATION_TABLE_CACHE_MAX_SIZE = 1000;
    private static Cache<String, TableInfo> cacheInstance;

    @Provides
    @Singleton
    public static HeaderProvider createHeaderProvider(BigQueryConfig config, UserAgentProvider userAgentProvider) {
        return HttpUtil.createHeaderProvider(config, userAgentProvider.getUserAgent());
    }

    public void configure(Binder binder) {
        binder.bind(BigQueryClientFactory.class).in(Scopes.SINGLETON);
        binder.bind(BigQueryTracerFactory.class).toInstance((Object)new LoggingBigQueryTracerFactory(14));
    }

    @Provides
    @Singleton
    public BigQueryCredentialsSupplier provideBigQueryCredentialsSupplier(BigQueryConfig config) {
        BigQueryProxyConfig proxyConfig = config.getBigQueryProxyConfig();
        return new BigQueryCredentialsSupplier(config.getAccessTokenProviderFQCN(), config.getAccessTokenProviderConfig(), config.getAccessToken(), config.getCredentialsKey(), config.getCredentialsFile(), config.getLoggedInUserName(), config.getLoggedInUserGroups(), config.getImpersonationServiceAccountsForUsers(), config.getImpersonationServiceAccountsForGroups(), config.getImpersonationServiceAccount(), config.getCredentialsScopes(), proxyConfig.getProxyUri(), proxyConfig.getProxyUsername(), proxyConfig.getProxyPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Provides
    @Singleton
    public Cache<String, TableInfo> provideDestinationTableCache(BigQueryConfig config) {
        if (cacheInstance != null) return cacheInstance;
        Class<BigQueryClientModule> clazz = BigQueryClientModule.class;
        synchronized (BigQueryClientModule.class) {
            if (cacheInstance != null) return cacheInstance;
            cacheInstance = CacheBuilder.newBuilder().expireAfterWrite((long)config.getCacheExpirationTimeInMinutes(), TimeUnit.MINUTES).maximumSize(1000L).build();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return cacheInstance;
        }
    }

    @Provides
    @Singleton
    public BigQueryClient provideBigQueryClient(BigQueryConfig config, HeaderProvider headerProvider, BigQueryCredentialsSupplier bigQueryCredentialsSupplier, Cache<String, TableInfo> destinationTableCache, EnvironmentContext environmentContext, BigQueryJobCompletionListener jobCompletionListener) {
        BigQueryOptions.Builder options = (BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)((BigQueryOptions.Builder)BigQueryOptions.newBuilder().setHeaderProvider(headerProvider)).setProjectId(config.getParentProjectId())).setCredentials(bigQueryCredentialsSupplier.getCredentials())).setRetrySettings(config.getBigQueryClientRetrySettings())).setUniverseDomain(bigQueryCredentialsSupplier.getUniverseDomain());
        HttpTransportOptions.Builder httpTransportOptionsBuilder = HttpTransportOptions.newBuilder().setConnectTimeout(config.getBigQueryClientConnectTimeout()).setReadTimeout(config.getBigQueryClientReadTimeout());
        BigQueryProxyConfig proxyConfig = config.getBigQueryProxyConfig();
        if (proxyConfig.getProxyUri().isPresent()) {
            httpTransportOptionsBuilder.setHttpTransportFactory(BigQueryProxyTransporterBuilder.createHttpTransportFactory(proxyConfig.getProxyUri(), proxyConfig.getProxyUsername(), proxyConfig.getProxyPassword()));
        }
        config.getBigQueryHttpEndpoint().ifPresent(arg_0 -> ((BigQueryOptions.Builder)options).setHost(arg_0));
        options.setTransportOptions((TransportOptions)httpTransportOptionsBuilder.build());
        ImmutableMap bigQueryJobLabels = ImmutableMap.builder().putAll(environmentContext.getBigQueryJobLabels()).putAll(config.getBigQueryJobLabels()).build();
        return new BigQueryClient((BigQuery)options.build().getService(), config.getMaterializationProject(), config.getMaterializationDataset(), destinationTableCache, (Map<String, String>)bigQueryJobLabels, config.getQueryJobPriority(), Optional.of(jobCompletionListener), config.getBigQueryJobTimeoutInMinutes());
    }
}

