/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/bundle/bundle.proto

// Protobuf Java Version: 3.25.5
package com.google.firestore.bundle;

/**
 *
 *
 * <pre>
 * A Firestore bundle is a length-prefixed stream of JSON representations of
 * `BundleElement`.
 * Only one `BundleMetadata` is expected, and it should be the first element.
 * The named queries follow after `metadata`. Every `document_metadata` is
 * immediately followed by a `document`.
 * </pre>
 *
 * Protobuf type {@code google.firestore.bundle.BundleElement}
 */
public final class BundleElement extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.bundle.BundleElement)
    BundleElementOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BundleElement.newBuilder() to construct.
  private BundleElement(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BundleElement() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BundleElement();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.bundle.BundleProto
        .internal_static_google_firestore_bundle_BundleElement_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.bundle.BundleProto
        .internal_static_google_firestore_bundle_BundleElement_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.bundle.BundleElement.class,
            com.google.firestore.bundle.BundleElement.Builder.class);
  }

  private int elementTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object elementType_;

  public enum ElementTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    METADATA(1),
    NAMED_QUERY(2),
    DOCUMENT_METADATA(3),
    DOCUMENT(4),
    ELEMENTTYPE_NOT_SET(0);
    private final int value;

    private ElementTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ElementTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ElementTypeCase forNumber(int value) {
      switch (value) {
        case 1:
          return METADATA;
        case 2:
          return NAMED_QUERY;
        case 3:
          return DOCUMENT_METADATA;
        case 4:
          return DOCUMENT;
        case 0:
          return ELEMENTTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ElementTypeCase getElementTypeCase() {
    return ElementTypeCase.forNumber(elementTypeCase_);
  }

  public static final int METADATA_FIELD_NUMBER = 1;
  /**
   * <code>.google.firestore.bundle.BundleMetadata metadata = 1;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return elementTypeCase_ == 1;
  }
  /**
   * <code>.google.firestore.bundle.BundleMetadata metadata = 1;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.firestore.bundle.BundleMetadata getMetadata() {
    if (elementTypeCase_ == 1) {
      return (com.google.firestore.bundle.BundleMetadata) elementType_;
    }
    return com.google.firestore.bundle.BundleMetadata.getDefaultInstance();
  }
  /** <code>.google.firestore.bundle.BundleMetadata metadata = 1;</code> */
  @java.lang.Override
  public com.google.firestore.bundle.BundleMetadataOrBuilder getMetadataOrBuilder() {
    if (elementTypeCase_ == 1) {
      return (com.google.firestore.bundle.BundleMetadata) elementType_;
    }
    return com.google.firestore.bundle.BundleMetadata.getDefaultInstance();
  }

  public static final int NAMED_QUERY_FIELD_NUMBER = 2;
  /**
   * <code>.google.firestore.bundle.NamedQuery named_query = 2;</code>
   *
   * @return Whether the namedQuery field is set.
   */
  @java.lang.Override
  public boolean hasNamedQuery() {
    return elementTypeCase_ == 2;
  }
  /**
   * <code>.google.firestore.bundle.NamedQuery named_query = 2;</code>
   *
   * @return The namedQuery.
   */
  @java.lang.Override
  public com.google.firestore.bundle.NamedQuery getNamedQuery() {
    if (elementTypeCase_ == 2) {
      return (com.google.firestore.bundle.NamedQuery) elementType_;
    }
    return com.google.firestore.bundle.NamedQuery.getDefaultInstance();
  }
  /** <code>.google.firestore.bundle.NamedQuery named_query = 2;</code> */
  @java.lang.Override
  public com.google.firestore.bundle.NamedQueryOrBuilder getNamedQueryOrBuilder() {
    if (elementTypeCase_ == 2) {
      return (com.google.firestore.bundle.NamedQuery) elementType_;
    }
    return com.google.firestore.bundle.NamedQuery.getDefaultInstance();
  }

  public static final int DOCUMENT_METADATA_FIELD_NUMBER = 3;
  /**
   * <code>.google.firestore.bundle.BundledDocumentMetadata document_metadata = 3;</code>
   *
   * @return Whether the documentMetadata field is set.
   */
  @java.lang.Override
  public boolean hasDocumentMetadata() {
    return elementTypeCase_ == 3;
  }
  /**
   * <code>.google.firestore.bundle.BundledDocumentMetadata document_metadata = 3;</code>
   *
   * @return The documentMetadata.
   */
  @java.lang.Override
  public com.google.firestore.bundle.BundledDocumentMetadata getDocumentMetadata() {
    if (elementTypeCase_ == 3) {
      return (com.google.firestore.bundle.BundledDocumentMetadata) elementType_;
    }
    return com.google.firestore.bundle.BundledDocumentMetadata.getDefaultInstance();
  }
  /** <code>.google.firestore.bundle.BundledDocumentMetadata document_metadata = 3;</code> */
  @java.lang.Override
  public com.google.firestore.bundle.BundledDocumentMetadataOrBuilder
      getDocumentMetadataOrBuilder() {
    if (elementTypeCase_ == 3) {
      return (com.google.firestore.bundle.BundledDocumentMetadata) elementType_;
    }
    return com.google.firestore.bundle.BundledDocumentMetadata.getDefaultInstance();
  }

  public static final int DOCUMENT_FIELD_NUMBER = 4;
  /**
   * <code>.google.firestore.v1.Document document = 4;</code>
   *
   * @return Whether the document field is set.
   */
  @java.lang.Override
  public boolean hasDocument() {
    return elementTypeCase_ == 4;
  }
  /**
   * <code>.google.firestore.v1.Document document = 4;</code>
   *
   * @return The document.
   */
  @java.lang.Override
  public com.google.firestore.v1.Document getDocument() {
    if (elementTypeCase_ == 4) {
      return (com.google.firestore.v1.Document) elementType_;
    }
    return com.google.firestore.v1.Document.getDefaultInstance();
  }
  /** <code>.google.firestore.v1.Document document = 4;</code> */
  @java.lang.Override
  public com.google.firestore.v1.DocumentOrBuilder getDocumentOrBuilder() {
    if (elementTypeCase_ == 4) {
      return (com.google.firestore.v1.Document) elementType_;
    }
    return com.google.firestore.v1.Document.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (elementTypeCase_ == 1) {
      output.writeMessage(1, (com.google.firestore.bundle.BundleMetadata) elementType_);
    }
    if (elementTypeCase_ == 2) {
      output.writeMessage(2, (com.google.firestore.bundle.NamedQuery) elementType_);
    }
    if (elementTypeCase_ == 3) {
      output.writeMessage(3, (com.google.firestore.bundle.BundledDocumentMetadata) elementType_);
    }
    if (elementTypeCase_ == 4) {
      output.writeMessage(4, (com.google.firestore.v1.Document) elementType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (elementTypeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.firestore.bundle.BundleMetadata) elementType_);
    }
    if (elementTypeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.firestore.bundle.NamedQuery) elementType_);
    }
    if (elementTypeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.firestore.bundle.BundledDocumentMetadata) elementType_);
    }
    if (elementTypeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.firestore.v1.Document) elementType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.bundle.BundleElement)) {
      return super.equals(obj);
    }
    com.google.firestore.bundle.BundleElement other =
        (com.google.firestore.bundle.BundleElement) obj;

    if (!getElementTypeCase().equals(other.getElementTypeCase())) return false;
    switch (elementTypeCase_) {
      case 1:
        if (!getMetadata().equals(other.getMetadata())) return false;
        break;
      case 2:
        if (!getNamedQuery().equals(other.getNamedQuery())) return false;
        break;
      case 3:
        if (!getDocumentMetadata().equals(other.getDocumentMetadata())) return false;
        break;
      case 4:
        if (!getDocument().equals(other.getDocument())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (elementTypeCase_) {
      case 1:
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
        break;
      case 2:
        hash = (37 * hash) + NAMED_QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getNamedQuery().hashCode();
        break;
      case 3:
        hash = (37 * hash) + DOCUMENT_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getDocumentMetadata().hashCode();
        break;
      case 4:
        hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getDocument().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.bundle.BundleElement parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.bundle.BundleElement parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.bundle.BundleElement parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.bundle.BundleElement parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.bundle.BundleElement parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.bundle.BundleElement parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.bundle.BundleElement parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.bundle.BundleElement parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.bundle.BundleElement parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.bundle.BundleElement parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.bundle.BundleElement parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.bundle.BundleElement parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.bundle.BundleElement prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Firestore bundle is a length-prefixed stream of JSON representations of
   * `BundleElement`.
   * Only one `BundleMetadata` is expected, and it should be the first element.
   * The named queries follow after `metadata`. Every `document_metadata` is
   * immediately followed by a `document`.
   * </pre>
   *
   * Protobuf type {@code google.firestore.bundle.BundleElement}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.bundle.BundleElement)
      com.google.firestore.bundle.BundleElementOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.bundle.BundleProto
          .internal_static_google_firestore_bundle_BundleElement_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.bundle.BundleProto
          .internal_static_google_firestore_bundle_BundleElement_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.bundle.BundleElement.class,
              com.google.firestore.bundle.BundleElement.Builder.class);
    }

    // Construct using com.google.firestore.bundle.BundleElement.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (metadataBuilder_ != null) {
        metadataBuilder_.clear();
      }
      if (namedQueryBuilder_ != null) {
        namedQueryBuilder_.clear();
      }
      if (documentMetadataBuilder_ != null) {
        documentMetadataBuilder_.clear();
      }
      if (documentBuilder_ != null) {
        documentBuilder_.clear();
      }
      elementTypeCase_ = 0;
      elementType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.bundle.BundleProto
          .internal_static_google_firestore_bundle_BundleElement_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.bundle.BundleElement getDefaultInstanceForType() {
      return com.google.firestore.bundle.BundleElement.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.bundle.BundleElement build() {
      com.google.firestore.bundle.BundleElement result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.bundle.BundleElement buildPartial() {
      com.google.firestore.bundle.BundleElement result =
          new com.google.firestore.bundle.BundleElement(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.bundle.BundleElement result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.firestore.bundle.BundleElement result) {
      result.elementTypeCase_ = elementTypeCase_;
      result.elementType_ = this.elementType_;
      if (elementTypeCase_ == 1 && metadataBuilder_ != null) {
        result.elementType_ = metadataBuilder_.build();
      }
      if (elementTypeCase_ == 2 && namedQueryBuilder_ != null) {
        result.elementType_ = namedQueryBuilder_.build();
      }
      if (elementTypeCase_ == 3 && documentMetadataBuilder_ != null) {
        result.elementType_ = documentMetadataBuilder_.build();
      }
      if (elementTypeCase_ == 4 && documentBuilder_ != null) {
        result.elementType_ = documentBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.bundle.BundleElement) {
        return mergeFrom((com.google.firestore.bundle.BundleElement) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.bundle.BundleElement other) {
      if (other == com.google.firestore.bundle.BundleElement.getDefaultInstance()) return this;
      switch (other.getElementTypeCase()) {
        case METADATA:
          {
            mergeMetadata(other.getMetadata());
            break;
          }
        case NAMED_QUERY:
          {
            mergeNamedQuery(other.getNamedQuery());
            break;
          }
        case DOCUMENT_METADATA:
          {
            mergeDocumentMetadata(other.getDocumentMetadata());
            break;
          }
        case DOCUMENT:
          {
            mergeDocument(other.getDocument());
            break;
          }
        case ELEMENTTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                elementTypeCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getNamedQueryFieldBuilder().getBuilder(), extensionRegistry);
                elementTypeCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getDocumentMetadataFieldBuilder().getBuilder(), extensionRegistry);
                elementTypeCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDocumentFieldBuilder().getBuilder(), extensionRegistry);
                elementTypeCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int elementTypeCase_ = 0;
    private java.lang.Object elementType_;

    public ElementTypeCase getElementTypeCase() {
      return ElementTypeCase.forNumber(elementTypeCase_);
    }

    public Builder clearElementType() {
      elementTypeCase_ = 0;
      elementType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.bundle.BundleMetadata,
            com.google.firestore.bundle.BundleMetadata.Builder,
            com.google.firestore.bundle.BundleMetadataOrBuilder>
        metadataBuilder_;
    /**
     * <code>.google.firestore.bundle.BundleMetadata metadata = 1;</code>
     *
     * @return Whether the metadata field is set.
     */
    @java.lang.Override
    public boolean hasMetadata() {
      return elementTypeCase_ == 1;
    }
    /**
     * <code>.google.firestore.bundle.BundleMetadata metadata = 1;</code>
     *
     * @return The metadata.
     */
    @java.lang.Override
    public com.google.firestore.bundle.BundleMetadata getMetadata() {
      if (metadataBuilder_ == null) {
        if (elementTypeCase_ == 1) {
          return (com.google.firestore.bundle.BundleMetadata) elementType_;
        }
        return com.google.firestore.bundle.BundleMetadata.getDefaultInstance();
      } else {
        if (elementTypeCase_ == 1) {
          return metadataBuilder_.getMessage();
        }
        return com.google.firestore.bundle.BundleMetadata.getDefaultInstance();
      }
    }
    /** <code>.google.firestore.bundle.BundleMetadata metadata = 1;</code> */
    public Builder setMetadata(com.google.firestore.bundle.BundleMetadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        elementType_ = value;
        onChanged();
      } else {
        metadataBuilder_.setMessage(value);
      }
      elementTypeCase_ = 1;
      return this;
    }
    /** <code>.google.firestore.bundle.BundleMetadata metadata = 1;</code> */
    public Builder setMetadata(com.google.firestore.bundle.BundleMetadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        elementType_ = builderForValue.build();
        onChanged();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      elementTypeCase_ = 1;
      return this;
    }
    /** <code>.google.firestore.bundle.BundleMetadata metadata = 1;</code> */
    public Builder mergeMetadata(com.google.firestore.bundle.BundleMetadata value) {
      if (metadataBuilder_ == null) {
        if (elementTypeCase_ == 1
            && elementType_ != com.google.firestore.bundle.BundleMetadata.getDefaultInstance()) {
          elementType_ =
              com.google.firestore.bundle.BundleMetadata.newBuilder(
                      (com.google.firestore.bundle.BundleMetadata) elementType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          elementType_ = value;
        }
        onChanged();
      } else {
        if (elementTypeCase_ == 1) {
          metadataBuilder_.mergeFrom(value);
        } else {
          metadataBuilder_.setMessage(value);
        }
      }
      elementTypeCase_ = 1;
      return this;
    }
    /** <code>.google.firestore.bundle.BundleMetadata metadata = 1;</code> */
    public Builder clearMetadata() {
      if (metadataBuilder_ == null) {
        if (elementTypeCase_ == 1) {
          elementTypeCase_ = 0;
          elementType_ = null;
          onChanged();
        }
      } else {
        if (elementTypeCase_ == 1) {
          elementTypeCase_ = 0;
          elementType_ = null;
        }
        metadataBuilder_.clear();
      }
      return this;
    }
    /** <code>.google.firestore.bundle.BundleMetadata metadata = 1;</code> */
    public com.google.firestore.bundle.BundleMetadata.Builder getMetadataBuilder() {
      return getMetadataFieldBuilder().getBuilder();
    }
    /** <code>.google.firestore.bundle.BundleMetadata metadata = 1;</code> */
    @java.lang.Override
    public com.google.firestore.bundle.BundleMetadataOrBuilder getMetadataOrBuilder() {
      if ((elementTypeCase_ == 1) && (metadataBuilder_ != null)) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        if (elementTypeCase_ == 1) {
          return (com.google.firestore.bundle.BundleMetadata) elementType_;
        }
        return com.google.firestore.bundle.BundleMetadata.getDefaultInstance();
      }
    }
    /** <code>.google.firestore.bundle.BundleMetadata metadata = 1;</code> */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.bundle.BundleMetadata,
            com.google.firestore.bundle.BundleMetadata.Builder,
            com.google.firestore.bundle.BundleMetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        if (!(elementTypeCase_ == 1)) {
          elementType_ = com.google.firestore.bundle.BundleMetadata.getDefaultInstance();
        }
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.bundle.BundleMetadata,
                com.google.firestore.bundle.BundleMetadata.Builder,
                com.google.firestore.bundle.BundleMetadataOrBuilder>(
                (com.google.firestore.bundle.BundleMetadata) elementType_,
                getParentForChildren(),
                isClean());
        elementType_ = null;
      }
      elementTypeCase_ = 1;
      onChanged();
      return metadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.bundle.NamedQuery,
            com.google.firestore.bundle.NamedQuery.Builder,
            com.google.firestore.bundle.NamedQueryOrBuilder>
        namedQueryBuilder_;
    /**
     * <code>.google.firestore.bundle.NamedQuery named_query = 2;</code>
     *
     * @return Whether the namedQuery field is set.
     */
    @java.lang.Override
    public boolean hasNamedQuery() {
      return elementTypeCase_ == 2;
    }
    /**
     * <code>.google.firestore.bundle.NamedQuery named_query = 2;</code>
     *
     * @return The namedQuery.
     */
    @java.lang.Override
    public com.google.firestore.bundle.NamedQuery getNamedQuery() {
      if (namedQueryBuilder_ == null) {
        if (elementTypeCase_ == 2) {
          return (com.google.firestore.bundle.NamedQuery) elementType_;
        }
        return com.google.firestore.bundle.NamedQuery.getDefaultInstance();
      } else {
        if (elementTypeCase_ == 2) {
          return namedQueryBuilder_.getMessage();
        }
        return com.google.firestore.bundle.NamedQuery.getDefaultInstance();
      }
    }
    /** <code>.google.firestore.bundle.NamedQuery named_query = 2;</code> */
    public Builder setNamedQuery(com.google.firestore.bundle.NamedQuery value) {
      if (namedQueryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        elementType_ = value;
        onChanged();
      } else {
        namedQueryBuilder_.setMessage(value);
      }
      elementTypeCase_ = 2;
      return this;
    }
    /** <code>.google.firestore.bundle.NamedQuery named_query = 2;</code> */
    public Builder setNamedQuery(com.google.firestore.bundle.NamedQuery.Builder builderForValue) {
      if (namedQueryBuilder_ == null) {
        elementType_ = builderForValue.build();
        onChanged();
      } else {
        namedQueryBuilder_.setMessage(builderForValue.build());
      }
      elementTypeCase_ = 2;
      return this;
    }
    /** <code>.google.firestore.bundle.NamedQuery named_query = 2;</code> */
    public Builder mergeNamedQuery(com.google.firestore.bundle.NamedQuery value) {
      if (namedQueryBuilder_ == null) {
        if (elementTypeCase_ == 2
            && elementType_ != com.google.firestore.bundle.NamedQuery.getDefaultInstance()) {
          elementType_ =
              com.google.firestore.bundle.NamedQuery.newBuilder(
                      (com.google.firestore.bundle.NamedQuery) elementType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          elementType_ = value;
        }
        onChanged();
      } else {
        if (elementTypeCase_ == 2) {
          namedQueryBuilder_.mergeFrom(value);
        } else {
          namedQueryBuilder_.setMessage(value);
        }
      }
      elementTypeCase_ = 2;
      return this;
    }
    /** <code>.google.firestore.bundle.NamedQuery named_query = 2;</code> */
    public Builder clearNamedQuery() {
      if (namedQueryBuilder_ == null) {
        if (elementTypeCase_ == 2) {
          elementTypeCase_ = 0;
          elementType_ = null;
          onChanged();
        }
      } else {
        if (elementTypeCase_ == 2) {
          elementTypeCase_ = 0;
          elementType_ = null;
        }
        namedQueryBuilder_.clear();
      }
      return this;
    }
    /** <code>.google.firestore.bundle.NamedQuery named_query = 2;</code> */
    public com.google.firestore.bundle.NamedQuery.Builder getNamedQueryBuilder() {
      return getNamedQueryFieldBuilder().getBuilder();
    }
    /** <code>.google.firestore.bundle.NamedQuery named_query = 2;</code> */
    @java.lang.Override
    public com.google.firestore.bundle.NamedQueryOrBuilder getNamedQueryOrBuilder() {
      if ((elementTypeCase_ == 2) && (namedQueryBuilder_ != null)) {
        return namedQueryBuilder_.getMessageOrBuilder();
      } else {
        if (elementTypeCase_ == 2) {
          return (com.google.firestore.bundle.NamedQuery) elementType_;
        }
        return com.google.firestore.bundle.NamedQuery.getDefaultInstance();
      }
    }
    /** <code>.google.firestore.bundle.NamedQuery named_query = 2;</code> */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.bundle.NamedQuery,
            com.google.firestore.bundle.NamedQuery.Builder,
            com.google.firestore.bundle.NamedQueryOrBuilder>
        getNamedQueryFieldBuilder() {
      if (namedQueryBuilder_ == null) {
        if (!(elementTypeCase_ == 2)) {
          elementType_ = com.google.firestore.bundle.NamedQuery.getDefaultInstance();
        }
        namedQueryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.bundle.NamedQuery,
                com.google.firestore.bundle.NamedQuery.Builder,
                com.google.firestore.bundle.NamedQueryOrBuilder>(
                (com.google.firestore.bundle.NamedQuery) elementType_,
                getParentForChildren(),
                isClean());
        elementType_ = null;
      }
      elementTypeCase_ = 2;
      onChanged();
      return namedQueryBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.bundle.BundledDocumentMetadata,
            com.google.firestore.bundle.BundledDocumentMetadata.Builder,
            com.google.firestore.bundle.BundledDocumentMetadataOrBuilder>
        documentMetadataBuilder_;
    /**
     * <code>.google.firestore.bundle.BundledDocumentMetadata document_metadata = 3;</code>
     *
     * @return Whether the documentMetadata field is set.
     */
    @java.lang.Override
    public boolean hasDocumentMetadata() {
      return elementTypeCase_ == 3;
    }
    /**
     * <code>.google.firestore.bundle.BundledDocumentMetadata document_metadata = 3;</code>
     *
     * @return The documentMetadata.
     */
    @java.lang.Override
    public com.google.firestore.bundle.BundledDocumentMetadata getDocumentMetadata() {
      if (documentMetadataBuilder_ == null) {
        if (elementTypeCase_ == 3) {
          return (com.google.firestore.bundle.BundledDocumentMetadata) elementType_;
        }
        return com.google.firestore.bundle.BundledDocumentMetadata.getDefaultInstance();
      } else {
        if (elementTypeCase_ == 3) {
          return documentMetadataBuilder_.getMessage();
        }
        return com.google.firestore.bundle.BundledDocumentMetadata.getDefaultInstance();
      }
    }
    /** <code>.google.firestore.bundle.BundledDocumentMetadata document_metadata = 3;</code> */
    public Builder setDocumentMetadata(com.google.firestore.bundle.BundledDocumentMetadata value) {
      if (documentMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        elementType_ = value;
        onChanged();
      } else {
        documentMetadataBuilder_.setMessage(value);
      }
      elementTypeCase_ = 3;
      return this;
    }
    /** <code>.google.firestore.bundle.BundledDocumentMetadata document_metadata = 3;</code> */
    public Builder setDocumentMetadata(
        com.google.firestore.bundle.BundledDocumentMetadata.Builder builderForValue) {
      if (documentMetadataBuilder_ == null) {
        elementType_ = builderForValue.build();
        onChanged();
      } else {
        documentMetadataBuilder_.setMessage(builderForValue.build());
      }
      elementTypeCase_ = 3;
      return this;
    }
    /** <code>.google.firestore.bundle.BundledDocumentMetadata document_metadata = 3;</code> */
    public Builder mergeDocumentMetadata(
        com.google.firestore.bundle.BundledDocumentMetadata value) {
      if (documentMetadataBuilder_ == null) {
        if (elementTypeCase_ == 3
            && elementType_
                != com.google.firestore.bundle.BundledDocumentMetadata.getDefaultInstance()) {
          elementType_ =
              com.google.firestore.bundle.BundledDocumentMetadata.newBuilder(
                      (com.google.firestore.bundle.BundledDocumentMetadata) elementType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          elementType_ = value;
        }
        onChanged();
      } else {
        if (elementTypeCase_ == 3) {
          documentMetadataBuilder_.mergeFrom(value);
        } else {
          documentMetadataBuilder_.setMessage(value);
        }
      }
      elementTypeCase_ = 3;
      return this;
    }
    /** <code>.google.firestore.bundle.BundledDocumentMetadata document_metadata = 3;</code> */
    public Builder clearDocumentMetadata() {
      if (documentMetadataBuilder_ == null) {
        if (elementTypeCase_ == 3) {
          elementTypeCase_ = 0;
          elementType_ = null;
          onChanged();
        }
      } else {
        if (elementTypeCase_ == 3) {
          elementTypeCase_ = 0;
          elementType_ = null;
        }
        documentMetadataBuilder_.clear();
      }
      return this;
    }
    /** <code>.google.firestore.bundle.BundledDocumentMetadata document_metadata = 3;</code> */
    public com.google.firestore.bundle.BundledDocumentMetadata.Builder
        getDocumentMetadataBuilder() {
      return getDocumentMetadataFieldBuilder().getBuilder();
    }
    /** <code>.google.firestore.bundle.BundledDocumentMetadata document_metadata = 3;</code> */
    @java.lang.Override
    public com.google.firestore.bundle.BundledDocumentMetadataOrBuilder
        getDocumentMetadataOrBuilder() {
      if ((elementTypeCase_ == 3) && (documentMetadataBuilder_ != null)) {
        return documentMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (elementTypeCase_ == 3) {
          return (com.google.firestore.bundle.BundledDocumentMetadata) elementType_;
        }
        return com.google.firestore.bundle.BundledDocumentMetadata.getDefaultInstance();
      }
    }
    /** <code>.google.firestore.bundle.BundledDocumentMetadata document_metadata = 3;</code> */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.bundle.BundledDocumentMetadata,
            com.google.firestore.bundle.BundledDocumentMetadata.Builder,
            com.google.firestore.bundle.BundledDocumentMetadataOrBuilder>
        getDocumentMetadataFieldBuilder() {
      if (documentMetadataBuilder_ == null) {
        if (!(elementTypeCase_ == 3)) {
          elementType_ = com.google.firestore.bundle.BundledDocumentMetadata.getDefaultInstance();
        }
        documentMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.bundle.BundledDocumentMetadata,
                com.google.firestore.bundle.BundledDocumentMetadata.Builder,
                com.google.firestore.bundle.BundledDocumentMetadataOrBuilder>(
                (com.google.firestore.bundle.BundledDocumentMetadata) elementType_,
                getParentForChildren(),
                isClean());
        elementType_ = null;
      }
      elementTypeCase_ = 3;
      onChanged();
      return documentMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.Document,
            com.google.firestore.v1.Document.Builder,
            com.google.firestore.v1.DocumentOrBuilder>
        documentBuilder_;
    /**
     * <code>.google.firestore.v1.Document document = 4;</code>
     *
     * @return Whether the document field is set.
     */
    @java.lang.Override
    public boolean hasDocument() {
      return elementTypeCase_ == 4;
    }
    /**
     * <code>.google.firestore.v1.Document document = 4;</code>
     *
     * @return The document.
     */
    @java.lang.Override
    public com.google.firestore.v1.Document getDocument() {
      if (documentBuilder_ == null) {
        if (elementTypeCase_ == 4) {
          return (com.google.firestore.v1.Document) elementType_;
        }
        return com.google.firestore.v1.Document.getDefaultInstance();
      } else {
        if (elementTypeCase_ == 4) {
          return documentBuilder_.getMessage();
        }
        return com.google.firestore.v1.Document.getDefaultInstance();
      }
    }
    /** <code>.google.firestore.v1.Document document = 4;</code> */
    public Builder setDocument(com.google.firestore.v1.Document value) {
      if (documentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        elementType_ = value;
        onChanged();
      } else {
        documentBuilder_.setMessage(value);
      }
      elementTypeCase_ = 4;
      return this;
    }
    /** <code>.google.firestore.v1.Document document = 4;</code> */
    public Builder setDocument(com.google.firestore.v1.Document.Builder builderForValue) {
      if (documentBuilder_ == null) {
        elementType_ = builderForValue.build();
        onChanged();
      } else {
        documentBuilder_.setMessage(builderForValue.build());
      }
      elementTypeCase_ = 4;
      return this;
    }
    /** <code>.google.firestore.v1.Document document = 4;</code> */
    public Builder mergeDocument(com.google.firestore.v1.Document value) {
      if (documentBuilder_ == null) {
        if (elementTypeCase_ == 4
            && elementType_ != com.google.firestore.v1.Document.getDefaultInstance()) {
          elementType_ =
              com.google.firestore.v1.Document.newBuilder(
                      (com.google.firestore.v1.Document) elementType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          elementType_ = value;
        }
        onChanged();
      } else {
        if (elementTypeCase_ == 4) {
          documentBuilder_.mergeFrom(value);
        } else {
          documentBuilder_.setMessage(value);
        }
      }
      elementTypeCase_ = 4;
      return this;
    }
    /** <code>.google.firestore.v1.Document document = 4;</code> */
    public Builder clearDocument() {
      if (documentBuilder_ == null) {
        if (elementTypeCase_ == 4) {
          elementTypeCase_ = 0;
          elementType_ = null;
          onChanged();
        }
      } else {
        if (elementTypeCase_ == 4) {
          elementTypeCase_ = 0;
          elementType_ = null;
        }
        documentBuilder_.clear();
      }
      return this;
    }
    /** <code>.google.firestore.v1.Document document = 4;</code> */
    public com.google.firestore.v1.Document.Builder getDocumentBuilder() {
      return getDocumentFieldBuilder().getBuilder();
    }
    /** <code>.google.firestore.v1.Document document = 4;</code> */
    @java.lang.Override
    public com.google.firestore.v1.DocumentOrBuilder getDocumentOrBuilder() {
      if ((elementTypeCase_ == 4) && (documentBuilder_ != null)) {
        return documentBuilder_.getMessageOrBuilder();
      } else {
        if (elementTypeCase_ == 4) {
          return (com.google.firestore.v1.Document) elementType_;
        }
        return com.google.firestore.v1.Document.getDefaultInstance();
      }
    }
    /** <code>.google.firestore.v1.Document document = 4;</code> */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.Document,
            com.google.firestore.v1.Document.Builder,
            com.google.firestore.v1.DocumentOrBuilder>
        getDocumentFieldBuilder() {
      if (documentBuilder_ == null) {
        if (!(elementTypeCase_ == 4)) {
          elementType_ = com.google.firestore.v1.Document.getDefaultInstance();
        }
        documentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.Document,
                com.google.firestore.v1.Document.Builder,
                com.google.firestore.v1.DocumentOrBuilder>(
                (com.google.firestore.v1.Document) elementType_, getParentForChildren(), isClean());
        elementType_ = null;
      }
      elementTypeCase_ = 4;
      onChanged();
      return documentBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.bundle.BundleElement)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.bundle.BundleElement)
  private static final com.google.firestore.bundle.BundleElement DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.bundle.BundleElement();
  }

  public static com.google.firestore.bundle.BundleElement getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BundleElement> PARSER =
      new com.google.protobuf.AbstractParser<BundleElement>() {
        @java.lang.Override
        public BundleElement parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BundleElement> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BundleElement> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.bundle.BundleElement getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
