/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.propagators;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class XCloudTraceContextPropagator
implements TextMapPropagator {
    private static final String FIELD = "x-cloud-trace-context";
    private static final Collection<String> FIELDS = Collections.singletonList("x-cloud-trace-context");
    private static final Pattern VALUE_PATTERN = Pattern.compile("(?<traceid>[0-9a-f]{32})\\/(?<spanid>[\\d]{1,20});o=(?<sampled>\\d+)");
    private static final Logger LOGGER = Logger.getLogger(XCloudTraceContextPropagator.class.getCanonicalName());
    private final boolean oneway;

    public XCloudTraceContextPropagator(boolean oneway) {
        this.oneway = oneway;
    }

    public Collection<String> fields() {
        return FIELDS;
    }

    public <C> void inject(Context context, C carrier, TextMapSetter<C> setter) {
        if (this.oneway) {
            return;
        }
        Span current = Span.fromContext((Context)context);
        if (!current.getSpanContext().isValid()) {
            return;
        }
        String sampledString = current.getSpanContext().isSampled() ? "1" : "0";
        String spanIdString = Long.toUnsignedString(Long.parseUnsignedLong(current.getSpanContext().getSpanId(), 16));
        String value = current.getSpanContext().getTraceId() + "/" + spanIdString + ";o=" + sampledString;
        setter.set(carrier, FIELD, value);
    }

    public <C> Context extract(Context context, C carrier, TextMapGetter<C> getter) {
        if (context == null || getter == null) {
            return context;
        }
        if (Span.fromContext((Context)context).getSpanContext().isRemote()) {
            return context;
        }
        String value = getter.get(carrier, FIELD);
        if (value == null) {
            return context;
        }
        Matcher matcher = VALUE_PATTERN.matcher(value);
        if (!matcher.matches()) {
            LOGGER.fine(() -> "Found x-cloud-trace-context header with invalid format: " + value);
            return context;
        }
        String traceId = matcher.group("traceid");
        if (!TraceId.isValid((CharSequence)traceId)) {
            LOGGER.warning(() -> "Found x-cloud-trace-context header with invalid trace: " + traceId + ", header: " + value);
            return context;
        }
        String spanId = SpanId.fromLong((long)Long.parseUnsignedLong(matcher.group("spanid")));
        if (!SpanId.isValid((CharSequence)spanId)) {
            LOGGER.warning(() -> "Found x-cloud-trace-context header with invalid span: " + spanId + ", header: " + value);
            return context;
        }
        boolean sampled = "1".equals(matcher.group("sampled"));
        SpanContext parent = SpanContext.createFromRemoteParent((String)traceId, (String)spanId, (TraceFlags)(sampled ? TraceFlags.getSampled() : TraceFlags.getDefault()), (TraceState)TraceState.getDefault());
        return context.with((ImplicitContextKeyed)Span.wrap((SpanContext)parent));
    }
}

