/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.trace;

import com.google.cloud.opentelemetry.trace.CloudTraceClient;
import com.google.devtools.cloudtrace.v2.BatchWriteSpansRequest;
import com.google.devtools.cloudtrace.v2.ProjectName;
import com.google.devtools.cloudtrace.v2.Span;
import com.google.devtools.cloudtrace.v2.TraceServiceGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.List;

class MockCloudTraceClient
implements CloudTraceClient {
    private final TraceServiceGrpc.TraceServiceBlockingStub blockingStub;

    MockCloudTraceClient(String host, int port) {
        this(ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext());
    }

    private MockCloudTraceClient(ManagedChannelBuilder<?> channelBuilder) {
        ManagedChannel channel = channelBuilder.build();
        this.blockingStub = TraceServiceGrpc.newBlockingStub((Channel)channel);
    }

    @Override
    public final void batchWriteSpans(ProjectName name, List<Span> spans) {
        BatchWriteSpansRequest request = BatchWriteSpansRequest.newBuilder().setName(name.toString()).addAllSpans(spans).build();
        this.blockingStub.batchWriteSpans(request);
    }

    @Override
    public final void shutdown() {
    }
}

