/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.trace;

import com.google.auth.Credentials;
import com.google.cloud.opentelemetry.trace.TraceConfiguration;
import com.google.cloud.trace.v2.stub.TraceServiceStub;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.cloudtrace.v2.AttributeValue;
import java.time.Duration;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class AutoValue_TraceConfiguration
extends TraceConfiguration {
    private final Supplier<String> projectIdSupplier;
    private final Credentials credentials;
    private final TraceServiceStub traceServiceStub;
    private final String traceServiceEndpoint;
    private final Map<String, AttributeValue> fixedAttributes;
    private final ImmutableMap<String, String> attributeMapping;
    private final Duration deadline;
    private final boolean insecureEndpoint;

    private AutoValue_TraceConfiguration(Supplier<String> projectIdSupplier, @Nullable Credentials credentials, @Nullable TraceServiceStub traceServiceStub, @Nullable String traceServiceEndpoint, Map<String, AttributeValue> fixedAttributes, ImmutableMap<String, String> attributeMapping, Duration deadline, boolean insecureEndpoint) {
        this.projectIdSupplier = projectIdSupplier;
        this.credentials = credentials;
        this.traceServiceStub = traceServiceStub;
        this.traceServiceEndpoint = traceServiceEndpoint;
        this.fixedAttributes = fixedAttributes;
        this.attributeMapping = attributeMapping;
        this.deadline = deadline;
        this.insecureEndpoint = insecureEndpoint;
    }

    @Override
    Supplier<String> getProjectIdSupplier() {
        return this.projectIdSupplier;
    }

    @Override
    @Nullable
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    @Deprecated
    @Nullable
    public TraceServiceStub getTraceServiceStub() {
        return this.traceServiceStub;
    }

    @Override
    @Nullable
    public String getTraceServiceEndpoint() {
        return this.traceServiceEndpoint;
    }

    @Override
    public Map<String, AttributeValue> getFixedAttributes() {
        return this.fixedAttributes;
    }

    @Override
    public ImmutableMap<String, String> getAttributeMapping() {
        return this.attributeMapping;
    }

    @Override
    public Duration getDeadline() {
        return this.deadline;
    }

    @Override
    @VisibleForTesting
    boolean getInsecureEndpoint() {
        return this.insecureEndpoint;
    }

    public String toString() {
        return "TraceConfiguration{projectIdSupplier=" + String.valueOf(this.projectIdSupplier) + ", credentials=" + String.valueOf(this.credentials) + ", traceServiceStub=" + String.valueOf(this.traceServiceStub) + ", traceServiceEndpoint=" + this.traceServiceEndpoint + ", fixedAttributes=" + String.valueOf(this.fixedAttributes) + ", attributeMapping=" + String.valueOf(this.attributeMapping) + ", deadline=" + String.valueOf(this.deadline) + ", insecureEndpoint=" + this.insecureEndpoint + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TraceConfiguration) {
            TraceConfiguration that = (TraceConfiguration)o;
            return this.projectIdSupplier.equals(that.getProjectIdSupplier()) && (this.credentials == null ? that.getCredentials() == null : this.credentials.equals(that.getCredentials())) && (this.traceServiceStub == null ? that.getTraceServiceStub() == null : this.traceServiceStub.equals(that.getTraceServiceStub())) && (this.traceServiceEndpoint == null ? that.getTraceServiceEndpoint() == null : this.traceServiceEndpoint.equals(that.getTraceServiceEndpoint())) && this.fixedAttributes.equals(that.getFixedAttributes()) && this.attributeMapping.equals(that.getAttributeMapping()) && this.deadline.equals(that.getDeadline()) && this.insecureEndpoint == that.getInsecureEndpoint();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.projectIdSupplier.hashCode();
        h$ *= 1000003;
        h$ ^= this.credentials == null ? 0 : this.credentials.hashCode();
        h$ *= 1000003;
        h$ ^= this.traceServiceStub == null ? 0 : this.traceServiceStub.hashCode();
        h$ *= 1000003;
        h$ ^= this.traceServiceEndpoint == null ? 0 : this.traceServiceEndpoint.hashCode();
        h$ *= 1000003;
        h$ ^= this.fixedAttributes.hashCode();
        h$ *= 1000003;
        h$ ^= this.attributeMapping.hashCode();
        h$ *= 1000003;
        h$ ^= this.deadline.hashCode();
        h$ *= 1000003;
        return h$ ^= this.insecureEndpoint ? 1231 : 1237;
    }

    static final class Builder
    extends TraceConfiguration.Builder {
        private Supplier<String> projectIdSupplier;
        private Credentials credentials;
        private TraceServiceStub traceServiceStub;
        private String traceServiceEndpoint;
        private Map<String, AttributeValue> fixedAttributes;
        private ImmutableMap.Builder<String, String> attributeMappingBuilder$;
        private ImmutableMap<String, String> attributeMapping;
        private Duration deadline;
        private boolean insecureEndpoint;
        private byte set$0;

        Builder() {
        }

        @Override
        TraceConfiguration.Builder setProjectIdSupplier(Supplier<String> projectIdSupplier) {
            if (projectIdSupplier == null) {
                throw new NullPointerException("Null projectIdSupplier");
            }
            this.projectIdSupplier = projectIdSupplier;
            return this;
        }

        @Override
        public TraceConfiguration.Builder setCredentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public TraceConfiguration.Builder setTraceServiceStub(TraceServiceStub traceServiceStub) {
            this.traceServiceStub = traceServiceStub;
            return this;
        }

        @Override
        public TraceConfiguration.Builder setTraceServiceEndpoint(String traceServiceEndpoint) {
            this.traceServiceEndpoint = traceServiceEndpoint;
            return this;
        }

        @Override
        public TraceConfiguration.Builder setFixedAttributes(Map<String, AttributeValue> fixedAttributes) {
            if (fixedAttributes == null) {
                throw new NullPointerException("Null fixedAttributes");
            }
            this.fixedAttributes = fixedAttributes;
            return this;
        }

        @Override
        Map<String, AttributeValue> getFixedAttributes() {
            if (this.fixedAttributes == null) {
                throw new IllegalStateException("Property \"fixedAttributes\" has not been set");
            }
            return this.fixedAttributes;
        }

        @Override
        public TraceConfiguration.Builder setAttributeMapping(ImmutableMap<String, String> attributeMapping) {
            if (attributeMapping == null) {
                throw new NullPointerException("Null attributeMapping");
            }
            if (this.attributeMappingBuilder$ != null) {
                throw new IllegalStateException("Cannot set attributeMapping after calling attributeMappingBuilder()");
            }
            this.attributeMapping = attributeMapping;
            return this;
        }

        @Override
        public ImmutableMap.Builder<String, String> attributeMappingBuilder() {
            if (this.attributeMappingBuilder$ == null) {
                if (this.attributeMapping == null) {
                    this.attributeMappingBuilder$ = ImmutableMap.builder();
                } else {
                    this.attributeMappingBuilder$ = ImmutableMap.builder();
                    this.attributeMappingBuilder$.putAll(this.attributeMapping);
                    this.attributeMapping = null;
                }
            }
            return this.attributeMappingBuilder$;
        }

        @Override
        public TraceConfiguration.Builder setDeadline(Duration deadline) {
            if (deadline == null) {
                throw new NullPointerException("Null deadline");
            }
            this.deadline = deadline;
            return this;
        }

        @Override
        Duration getDeadline() {
            if (this.deadline == null) {
                throw new IllegalStateException("Property \"deadline\" has not been set");
            }
            return this.deadline;
        }

        @Override
        TraceConfiguration.Builder setInsecureEndpoint(boolean insecureEndpoint) {
            this.insecureEndpoint = insecureEndpoint;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        TraceConfiguration autoBuild() {
            if (this.attributeMappingBuilder$ != null) {
                this.attributeMapping = this.attributeMappingBuilder$.buildOrThrow();
            } else if (this.attributeMapping == null) {
                this.attributeMapping = ImmutableMap.of();
            }
            if (this.set$0 != 1 || this.projectIdSupplier == null || this.fixedAttributes == null || this.deadline == null) {
                StringBuilder missing = new StringBuilder();
                if (this.projectIdSupplier == null) {
                    missing.append(" projectIdSupplier");
                }
                if (this.fixedAttributes == null) {
                    missing.append(" fixedAttributes");
                }
                if (this.deadline == null) {
                    missing.append(" deadline");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" insecureEndpoint");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_TraceConfiguration(this.projectIdSupplier, this.credentials, this.traceServiceStub, this.traceServiceEndpoint, this.fixedAttributes, this.attributeMapping, this.deadline, this.insecureEndpoint);
        }
    }
}

