/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.metric;

import com.google.api.MetricDescriptor;
import com.google.cloud.opentelemetry.metric.MetricTimeSeriesBuilder;
import com.google.cloud.opentelemetry.metric.MetricTranslator;
import com.google.cloud.opentelemetry.metric.MetricWithLabels;
import com.google.cloud.opentelemetry.metric.ResourceTranslator;
import com.google.monitoring.v3.Point;
import com.google.monitoring.v3.TimeSeries;
import com.google.monitoring.v3.TypedValue;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.PointData;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class AggregateByLabelMetricTimeSeriesBuilder
implements MetricTimeSeriesBuilder {
    public static final String LABEL_INSTRUMENTATION_SOURCE = "instrumentation_source";
    public static final String LABEL_INSTRUMENTATION_VERSION = "instrumentation_version";
    private final Map<String, MetricDescriptor> descriptors = new HashMap<String, MetricDescriptor>();
    private final Map<MetricWithLabels, TimeSeries.Builder> pendingTimeSeries = new HashMap<MetricWithLabels, TimeSeries.Builder>();
    private final String projectId;
    private final String prefix;

    public AggregateByLabelMetricTimeSeriesBuilder(String projectId, String prefix) {
        this.projectId = projectId;
        this.prefix = prefix;
    }

    @Override
    public void recordPoint(MetricData metricData, LongPointData pointData) {
        this.recordPointInTimeSeries(metricData, (PointData)pointData, Point.newBuilder().setValue(TypedValue.newBuilder().setInt64Value(pointData.getValue())).setInterval(MetricTranslator.mapInterval((PointData)pointData, metricData)).build());
    }

    @Override
    public void recordPoint(MetricData metricData, DoublePointData pointData) {
        this.recordPointInTimeSeries(metricData, (PointData)pointData, Point.newBuilder().setValue(TypedValue.newBuilder().setDoubleValue(pointData.getValue())).setInterval(MetricTranslator.mapInterval((PointData)pointData, metricData)).build());
    }

    @Override
    public void recordPoint(MetricData metricData, HistogramPointData pointData) {
        this.recordPointInTimeSeries(metricData, (PointData)pointData, Point.newBuilder().setValue(TypedValue.newBuilder().setDistributionValue(MetricTranslator.mapDistribution(pointData, this.projectId))).setInterval(MetricTranslator.mapInterval((PointData)pointData, metricData)).build());
    }

    private void recordPointInTimeSeries(MetricData metric, PointData point, Point builtPoint) {
        MetricDescriptor descriptor = MetricTranslator.mapMetricDescriptor(this.prefix, metric, point);
        if (descriptor == null) {
            return;
        }
        this.descriptors.putIfAbsent(descriptor.getType(), descriptor);
        Attributes metricAttributes = this.attachInstrumentationLibraryLabels(point.getAttributes(), metric.getInstrumentationScopeInfo());
        MetricWithLabels key = new MetricWithLabels(descriptor.getType(), metricAttributes);
        this.pendingTimeSeries.computeIfAbsent(key, k -> this.makeTimeSeriesHeader(metric, metricAttributes, descriptor)).addPoints(builtPoint);
    }

    private TimeSeries.Builder makeTimeSeriesHeader(MetricData metric, Attributes attributes, MetricDescriptor descriptor) {
        return TimeSeries.newBuilder().setMetric(MetricTranslator.mapMetric(attributes, descriptor.getType())).setMetricKind(descriptor.getMetricKind()).setResource(ResourceTranslator.mapResource(metric.getResource()));
    }

    private Attributes attachInstrumentationLibraryLabels(Attributes attributes, InstrumentationScopeInfo instrumentationScopeInfo) {
        return attributes.toBuilder().put(AttributeKey.stringKey((String)LABEL_INSTRUMENTATION_SOURCE), (Object)instrumentationScopeInfo.getName()).put(AttributeKey.stringKey((String)LABEL_INSTRUMENTATION_VERSION), (Object)Objects.requireNonNullElse(instrumentationScopeInfo.getVersion(), "")).build();
    }

    @Override
    public Collection<MetricDescriptor> getDescriptors() {
        return this.descriptors.values();
    }

    @Override
    public List<TimeSeries> getTimeSeries() {
        return this.pendingTimeSeries.values().stream().map(TimeSeries.Builder::build).collect(Collectors.toList());
    }
}

