/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.metric;

import com.google.auth.Credentials;
import com.google.auto.value.AutoValue;
import com.google.cloud.ServiceOptions;
import com.google.cloud.monitoring.v3.stub.MetricServiceStubSettings;
import com.google.cloud.opentelemetry.metric.AutoValue_MetricConfiguration;
import com.google.cloud.opentelemetry.metric.MetricDescriptorStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import java.time.Duration;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class MetricConfiguration {
    static final String DEFAULT_PREFIX = "workload.googleapis.com";
    private static final Duration DEFAULT_DEADLINE = Duration.ofSeconds(12L, 0L);

    MetricConfiguration() {
    }

    abstract Supplier<String> getProjectIdSupplier();

    @Nullable
    public abstract Credentials getCredentials();

    public final String getProjectId() {
        return this.getProjectIdSupplier().get();
    }

    public abstract String getPrefix();

    public abstract Duration getDeadline();

    public abstract MetricDescriptorStrategy getDescriptorStrategy();

    @Nullable
    public abstract String getMetricServiceEndpoint();

    @VisibleForTesting
    abstract boolean getInsecureEndpoint();

    public static Builder builder() {
        return new AutoValue_MetricConfiguration.Builder().setProjectIdSupplier((Supplier<String>)Suppliers.memoize(ServiceOptions::getDefaultProjectId)).setPrefix(DEFAULT_PREFIX).setDeadline(DEFAULT_DEADLINE).setDescriptorStrategy(MetricDescriptorStrategy.SEND_ONCE).setInsecureEndpoint(false).setMetricServiceEndpoint(MetricServiceStubSettings.getDefaultEndpoint());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        abstract Duration getDeadline();

        abstract Builder setProjectIdSupplier(Supplier<String> var1);

        public final Builder setProjectId(String projectId) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"Project ID cannot be null or empty.");
            this.setProjectIdSupplier(() -> projectId);
            return this;
        }

        public abstract Builder setPrefix(String var1);

        public abstract Builder setCredentials(Credentials var1);

        public abstract Builder setDeadline(Duration var1);

        public abstract Builder setDescriptorStrategy(MetricDescriptorStrategy var1);

        public abstract Builder setMetricServiceEndpoint(String var1);

        @VisibleForTesting
        abstract Builder setInsecureEndpoint(boolean var1);

        abstract MetricConfiguration autoBuild();

        public MetricConfiguration build() {
            Preconditions.checkArgument((this.getDeadline().compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (Object)"Deadline must be positive.");
            return this.autoBuild();
        }
    }
}

