/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.metric;

import com.google.auth.Credentials;
import com.google.auto.value.AutoValue;
import com.google.cloud.ServiceOptions;
import com.google.cloud.monitoring.v3.stub.MetricServiceStubSettings;
import com.google.cloud.opentelemetry.metric.AutoValue_MetricConfiguration;
import com.google.cloud.opentelemetry.metric.MetricDescriptorStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.time.Duration;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class MetricConfiguration {
    private static final String DEFAULT_PROJECT_ID = Strings.nullToEmpty((String)ServiceOptions.getDefaultProjectId());
    private static final Duration DEFAULT_DEADLINE = Duration.ofSeconds(10L, 0L);

    MetricConfiguration() {
    }

    @Nullable
    public abstract Credentials getCredentials();

    public abstract String getProjectId();

    public abstract Duration getDeadline();

    public abstract MetricDescriptorStrategy getDescriptorStrategy();

    @Nullable
    public abstract String getMetricServiceEndpoint();

    @VisibleForTesting
    abstract boolean getInsecureEndpoint();

    public static Builder builder() {
        return new AutoValue_MetricConfiguration.Builder().setProjectId(DEFAULT_PROJECT_ID).setDeadline(DEFAULT_DEADLINE).setDescriptorStrategy(MetricDescriptorStrategy.SEND_ONCE).setInsecureEndpoint(false).setMetricServiceEndpoint(MetricServiceStubSettings.getDefaultEndpoint());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        abstract String getProjectId();

        abstract Duration getDeadline();

        public abstract Builder setProjectId(String var1);

        public abstract Builder setCredentials(Credentials var1);

        public abstract Builder setDeadline(Duration var1);

        public abstract Builder setDescriptorStrategy(MetricDescriptorStrategy var1);

        public abstract Builder setMetricServiceEndpoint(String var1);

        @VisibleForTesting
        abstract Builder setInsecureEndpoint(boolean var1);

        abstract MetricConfiguration autoBuild();

        public MetricConfiguration build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getProjectId()) ? 1 : 0) != 0, (Object)"Cannot find a project ID from either configurations or application default.");
            Preconditions.checkArgument((this.getDeadline().compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (Object)"Deadline must be positive.");
            return this.autoBuild();
        }
    }
}

