/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.metric;

import com.google.api.MetricDescriptor;
import com.google.api.client.util.Preconditions;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.cloud.opentelemetry.metric.AggregateByLabelMetricTimeSeriesBuilder;
import com.google.cloud.opentelemetry.metric.CloudMetricClient;
import com.google.cloud.opentelemetry.metric.CloudMetricClientImpl;
import com.google.cloud.opentelemetry.metric.MetricConfiguration;
import com.google.cloud.opentelemetry.metric.MetricDescriptorStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.monitoring.v3.CreateMetricDescriptorRequest;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeSeries;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Duration;

public class GoogleCloudMetricExporter
implements MetricExporter {
    private static final Logger logger = LoggerFactory.getLogger(GoogleCloudMetricExporter.class);
    private static final String PROJECT_NAME_PREFIX = "projects/";
    private static final int MAX_BATCH_SIZE = 200;
    private final CloudMetricClient metricServiceClient;
    private final String projectId;
    private final MetricDescriptorStrategy metricDescriptorStrategy;

    GoogleCloudMetricExporter(String projectId, CloudMetricClient client, MetricDescriptorStrategy descriptorStrategy) {
        this.projectId = projectId;
        this.metricServiceClient = client;
        this.metricDescriptorStrategy = descriptorStrategy;
    }

    public static GoogleCloudMetricExporter createWithDefaultConfiguration() throws IOException {
        MetricConfiguration configuration = MetricConfiguration.builder().build();
        return GoogleCloudMetricExporter.createWithConfiguration(configuration);
    }

    public static GoogleCloudMetricExporter createWithConfiguration(MetricConfiguration configuration) throws IOException {
        String projectId = configuration.getProjectId();
        MetricServiceSettings.Builder builder = MetricServiceSettings.newBuilder();
        if (configuration.getInsecureEndpoint()) {
            builder.setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create());
            builder.setTransportChannelProvider((TransportChannelProvider)FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)ManagedChannelBuilder.forTarget((String)configuration.getMetricServiceEndpoint()).usePlaintext().build())));
        } else {
            GoogleCredentials credentials = configuration.getCredentials() == null ? GoogleCredentials.getApplicationDefault() : configuration.getCredentials();
            builder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)((Credentials)Preconditions.checkNotNull((Object)credentials, (Object)"Credentials not provided."))));
            builder.setEndpoint(configuration.getMetricServiceEndpoint());
        }
        builder.createMetricDescriptorSettings().setSimpleTimeoutNoRetries(Duration.ofMillis((long)configuration.getDeadline().toMillis()));
        return new GoogleCloudMetricExporter(projectId, new CloudMetricClientImpl(MetricServiceClient.create((MetricServiceSettings)builder.build())), configuration.getDescriptorStrategy());
    }

    @VisibleForTesting
    static GoogleCloudMetricExporter createWithClient(String projectId, CloudMetricClient metricServiceClient, MetricDescriptorStrategy descriptorStrategy) {
        return new GoogleCloudMetricExporter(projectId, metricServiceClient, descriptorStrategy);
    }

    private void exportDescriptor(MetricDescriptor descriptor) {
        logger.trace("Creating metric descriptor: %s", (Object)descriptor);
        this.metricServiceClient.createMetricDescriptor(CreateMetricDescriptorRequest.newBuilder().setName(PROJECT_NAME_PREFIX + this.projectId).setMetricDescriptor(descriptor).build());
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return AggregationTemporality.CUMULATIVE;
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        AggregateByLabelMetricTimeSeriesBuilder builder = new AggregateByLabelMetricTimeSeriesBuilder(this.projectId);
        block9: for (MetricData metricData : metrics) {
            switch (metricData.getType()) {
                case LONG_GAUGE: {
                    for (LongPointData point : metricData.getLongGaugeData().getPoints()) {
                        builder.recordPoint(metricData, point);
                    }
                    continue block9;
                }
                case LONG_SUM: {
                    for (LongPointData point : metricData.getLongSumData().getPoints()) {
                        builder.recordPoint(metricData, point);
                    }
                    continue block9;
                }
                case DOUBLE_GAUGE: {
                    for (LongPointData point : metricData.getDoubleGaugeData().getPoints()) {
                        builder.recordPoint(metricData, (DoublePointData)point);
                    }
                    continue block9;
                }
                case DOUBLE_SUM: {
                    for (LongPointData point : metricData.getDoubleSumData().getPoints()) {
                        builder.recordPoint(metricData, (DoublePointData)point);
                    }
                    continue block9;
                }
                case HISTOGRAM: {
                    for (LongPointData point : metricData.getHistogramData().getPoints()) {
                        builder.recordPoint(metricData, (HistogramPointData)point);
                    }
                    continue block9;
                }
                default: {
                    logger.error("OpenTelemetry Metric type {} not supported.", (Object)metricData.getType());
                    continue block9;
                }
            }
        }
        try {
            Collection<MetricDescriptor> descriptors = builder.getDescriptors();
            if (!descriptors.isEmpty()) {
                this.metricDescriptorStrategy.exportDescriptors(descriptors, this::exportDescriptor);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to create metric descriptors", (Throwable)e);
        }
        List<TimeSeries> series = builder.getTimeSeries();
        GoogleCloudMetricExporter.createTimeSeriesBatch(this.metricServiceClient, ProjectName.of((String)this.projectId), series);
        if (series.size() < metrics.size()) {
            return CompletableResultCode.ofFailure();
        }
        return CompletableResultCode.ofSuccess();
    }

    private static void createTimeSeriesBatch(CloudMetricClient metricServiceClient, ProjectName projectName, List<TimeSeries> allTimesSeries) {
        List batches = Lists.partition(allTimesSeries, (int)200);
        for (List timeSeries : batches) {
            metricServiceClient.createTimeSeries(projectName, new ArrayList<TimeSeries>(timeSeries));
        }
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.metricServiceClient.shutdown();
        return CompletableResultCode.ofSuccess();
    }

    static class MetricWithLabels {
        private final String metricType;
        private final Attributes attributes;

        MetricWithLabels(String metricType, Attributes attributes) {
            this.metricType = metricType;
            this.attributes = attributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricWithLabels that = (MetricWithLabels)o;
            return Objects.equals(this.metricType, that.metricType) && Objects.equals(this.attributes, that.attributes);
        }

        public int hashCode() {
            return Objects.hash(this.metricType, this.attributes);
        }
    }
}

