/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.metric;

import com.google.api.MetricDescriptor;
import com.google.cloud.opentelemetry.metric.MetricExporter;
import com.google.cloud.opentelemetry.metric.MetricTimeSeriesBuilder;
import com.google.cloud.opentelemetry.metric.MetricTranslator;
import com.google.cloud.opentelemetry.metric.ResourceTranslator;
import com.google.monitoring.v3.Point;
import com.google.monitoring.v3.TimeSeries;
import com.google.monitoring.v3.TypedValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.PointData;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AggregateByLabelMetricTimeSeriesBuilder
implements MetricTimeSeriesBuilder {
    private final Map<String, MetricDescriptor> descriptors = new HashMap<String, MetricDescriptor>();
    private final Map<MetricExporter.MetricWithLabels, TimeSeries.Builder> pendingTimeSeries = new HashMap<MetricExporter.MetricWithLabels, TimeSeries.Builder>();
    private final String projectId;

    public AggregateByLabelMetricTimeSeriesBuilder(String projectId) {
        this.projectId = projectId;
    }

    @Override
    public void recordPoint(MetricData metric, LongPointData point) {
        MetricDescriptor descriptor = MetricTranslator.mapMetricDescriptor(metric, (PointData)point);
        if (descriptor == null) {
            return;
        }
        this.descriptors.putIfAbsent(descriptor.getType(), descriptor);
        MetricExporter.MetricWithLabels key = new MetricExporter.MetricWithLabels(descriptor.getType(), point.getAttributes());
        this.pendingTimeSeries.computeIfAbsent(key, k -> this.makeTimeSeriesHeader(metric, point.getAttributes(), descriptor)).addPoints(Point.newBuilder().setValue(TypedValue.newBuilder().setInt64Value(point.getValue())).setInterval(MetricTranslator.mapInterval((PointData)point, metric)).build());
    }

    @Override
    public void recordPoint(MetricData metric, DoublePointData point) {
        MetricDescriptor descriptor = MetricTranslator.mapMetricDescriptor(metric, (PointData)point);
        if (descriptor == null) {
            return;
        }
        this.descriptors.putIfAbsent(descriptor.getType(), descriptor);
        MetricExporter.MetricWithLabels key = new MetricExporter.MetricWithLabels(descriptor.getType(), point.getAttributes());
        this.pendingTimeSeries.computeIfAbsent(key, k -> this.makeTimeSeriesHeader(metric, point.getAttributes(), descriptor)).addPoints(Point.newBuilder().setValue(TypedValue.newBuilder().setDoubleValue(point.getValue())).setInterval(MetricTranslator.mapInterval((PointData)point, metric)));
    }

    @Override
    public void recordPoint(MetricData metric, HistogramPointData point) {
        MetricDescriptor descriptor = MetricTranslator.mapMetricDescriptor(metric, (PointData)point);
        if (descriptor == null) {
            return;
        }
        this.descriptors.putIfAbsent(descriptor.getType(), descriptor);
        MetricExporter.MetricWithLabels key = new MetricExporter.MetricWithLabels(descriptor.getType(), point.getAttributes());
        this.pendingTimeSeries.computeIfAbsent(key, k -> this.makeTimeSeriesHeader(metric, point.getAttributes(), descriptor)).addPoints(Point.newBuilder().setValue(TypedValue.newBuilder().setDistributionValue(MetricTranslator.mapDistribution(point, this.projectId))).setInterval(MetricTranslator.mapInterval((PointData)point, metric)));
    }

    private TimeSeries.Builder makeTimeSeriesHeader(MetricData metric, Attributes attributes, MetricDescriptor descriptor) {
        return TimeSeries.newBuilder().setMetric(MetricTranslator.mapMetric(attributes, descriptor.getType())).setMetricKind(descriptor.getMetricKind()).setResource(ResourceTranslator.mapResource(metric.getResource()));
    }

    @Override
    public Collection<MetricDescriptor> getDescriptors() {
        return this.descriptors.values();
    }

    @Override
    public List<TimeSeries> getTimeSeries() {
        return this.pendingTimeSeries.values().stream().map(b -> b.build()).collect(Collectors.toList());
    }
}

