/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.metric;

import com.google.api.MetricDescriptor;
import com.google.api.client.util.Preconditions;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.cloud.monitoring.v3.stub.MetricServiceStub;
import com.google.cloud.opentelemetry.metric.AggregateByLabelMetricTimeSeriesBuilder;
import com.google.cloud.opentelemetry.metric.CloudMetricClient;
import com.google.cloud.opentelemetry.metric.CloudMetricClientImpl;
import com.google.cloud.opentelemetry.metric.MetricConfiguration;
import com.google.cloud.opentelemetry.metric.MetricDescriptorStrategy;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.monitoring.v3.CreateMetricDescriptorRequest;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeSeries;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.data.DoubleHistogramPointData;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Duration;

public class MetricExporter
implements io.opentelemetry.sdk.metrics.export.MetricExporter {
    private static final Logger logger = LoggerFactory.getLogger(MetricExporter.class);
    private static final String PROJECT_NAME_PREFIX = "projects/";
    private static final int MAX_BATCH_SIZE = 200;
    private final CloudMetricClient metricServiceClient;
    private final String projectId;
    private final MetricDescriptorStrategy metricDescriptorStrategy;

    MetricExporter(String projectId, CloudMetricClient client, MetricDescriptorStrategy descriptorStrategy) {
        this.projectId = projectId;
        this.metricServiceClient = client;
        this.metricDescriptorStrategy = descriptorStrategy;
    }

    public static MetricExporter createWithDefaultConfiguration() throws IOException {
        MetricConfiguration configuration = MetricConfiguration.builder().build();
        return MetricExporter.createWithConfiguration(configuration);
    }

    public static MetricExporter createWithConfiguration(MetricConfiguration configuration) throws IOException {
        String projectId = configuration.getProjectId();
        MetricServiceStub stub = configuration.getMetricServiceStub();
        if (stub == null) {
            GoogleCredentials credentials = configuration.getCredentials() == null ? GoogleCredentials.getApplicationDefault() : configuration.getCredentials();
            return MetricExporter.createWithCredentials(projectId, (Credentials)credentials, configuration.getDeadline(), configuration.getDescriptorStrategy());
        }
        return MetricExporter.createWithClient(projectId, new CloudMetricClientImpl(MetricServiceClient.create((MetricServiceStub)stub)), configuration.getDescriptorStrategy());
    }

    @VisibleForTesting
    static MetricExporter createWithClient(String projectId, CloudMetricClient metricServiceClient, MetricDescriptorStrategy descriptorStrategy) {
        return new MetricExporter(projectId, metricServiceClient, descriptorStrategy);
    }

    private static MetricExporter createWithCredentials(String projectId, Credentials credentials, java.time.Duration deadline, MetricDescriptorStrategy descriptorStrategy) throws IOException {
        MetricServiceSettings.Builder builder = (MetricServiceSettings.Builder)MetricServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)((Credentials)Preconditions.checkNotNull((Object)credentials, (Object)"Credentials not provided."))));
        builder.createMetricDescriptorSettings().setSimpleTimeoutNoRetries(Duration.ofMillis((long)deadline.toMillis()));
        return new MetricExporter(projectId, new CloudMetricClientImpl(MetricServiceClient.create((MetricServiceSettings)builder.build())), descriptorStrategy);
    }

    private void exportDescriptor(MetricDescriptor descriptor) {
        logger.trace("Creating metric descriptor: %s", (Object)descriptor);
        this.metricServiceClient.createMetricDescriptor(CreateMetricDescriptorRequest.newBuilder().setName(PROJECT_NAME_PREFIX + this.projectId).setMetricDescriptor(descriptor).build());
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        AggregateByLabelMetricTimeSeriesBuilder builder = new AggregateByLabelMetricTimeSeriesBuilder(this.projectId);
        block9: for (MetricData metricData : metrics) {
            switch (metricData.getType()) {
                case LONG_GAUGE: {
                    for (LongPointData point : metricData.getLongGaugeData().getPoints()) {
                        builder.recordPoint(metricData, point);
                    }
                    continue block9;
                }
                case LONG_SUM: {
                    for (LongPointData point : metricData.getLongSumData().getPoints()) {
                        builder.recordPoint(metricData, point);
                    }
                    continue block9;
                }
                case DOUBLE_GAUGE: {
                    for (LongPointData point : metricData.getDoubleGaugeData().getPoints()) {
                        builder.recordPoint(metricData, (DoublePointData)point);
                    }
                    continue block9;
                }
                case DOUBLE_SUM: {
                    for (LongPointData point : metricData.getDoubleSumData().getPoints()) {
                        builder.recordPoint(metricData, (DoublePointData)point);
                    }
                    continue block9;
                }
                case HISTOGRAM: {
                    for (LongPointData point : metricData.getDoubleHistogramData().getPoints()) {
                        builder.recordPoint(metricData, (DoubleHistogramPointData)point);
                    }
                    continue block9;
                }
                default: {
                    logger.error("OpenTelemetry Metric type {} not supported.", (Object)metricData.getType());
                    continue block9;
                }
            }
        }
        try {
            Collection<MetricDescriptor> descriptors = builder.getDescriptors();
            if (!descriptors.isEmpty()) {
                this.metricDescriptorStrategy.exportDescriptors(descriptors, this::exportDescriptor);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to create metric descriptors", (Throwable)e);
        }
        List<TimeSeries> series = builder.getTimeSeries();
        MetricExporter.createTimeSeriesBatch(this.metricServiceClient, ProjectName.of((String)this.projectId), series);
        if (series.size() < metrics.size()) {
            return CompletableResultCode.ofFailure();
        }
        return CompletableResultCode.ofSuccess();
    }

    private static void createTimeSeriesBatch(CloudMetricClient metricServiceClient, ProjectName projectName, List<TimeSeries> allTimesSeries) {
        List batches = Lists.partition(allTimesSeries, (int)200);
        for (List timeSeries : batches) {
            metricServiceClient.createTimeSeries(projectName, new ArrayList<TimeSeries>(timeSeries));
        }
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.metricServiceClient.shutdown();
        return CompletableResultCode.ofSuccess();
    }

    static class MetricWithLabels {
        private final String metricType;
        private final Attributes attributes;

        MetricWithLabels(String metricType, Attributes attributes) {
            this.metricType = metricType;
            this.attributes = attributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricWithLabels that = (MetricWithLabels)o;
            return Objects.equals(this.metricType, that.metricType) && Objects.equals(this.attributes, that.attributes);
        }

        public int hashCode() {
            return Objects.hash(this.metricType, this.attributes);
        }
    }
}

