/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.metric;

import com.google.api.MetricDescriptor;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.monitoring.v3.stub.GrpcMetricServiceStub;
import com.google.cloud.monitoring.v3.stub.MetricServiceStubSettings;
import com.google.cloud.opentelemetry.metric.CloudMetricClient;
import com.google.monitoring.v3.CreateMetricDescriptorRequest;
import com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeSeries;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.util.List;

class MockCloudMetricClient
implements CloudMetricClient {
    private final GrpcMetricServiceStub stub;

    MockCloudMetricClient(String host, int port) throws IOException {
        this.stub = GrpcMetricServiceStub.create((MetricServiceStubSettings)((MetricServiceStubSettings.Builder)((MetricServiceStubSettings.Builder)MetricServiceStubSettings.newBuilder().setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).setTransportChannelProvider((TransportChannelProvider)FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build())))).build());
    }

    @Override
    public final MetricDescriptor createMetricDescriptor(CreateMetricDescriptorRequest request) {
        return (MetricDescriptor)this.stub.createMetricDescriptorCallable().call((Object)request);
    }

    @Override
    public final void createTimeSeries(ProjectName name, List<TimeSeries> timeSeries) {
        CreateTimeSeriesRequest request = CreateTimeSeriesRequest.newBuilder().setName(name.toString()).addAllTimeSeries(timeSeries).build();
        this.stub.createTimeSeriesCallable().call((Object)request);
    }

    @Override
    public final void shutdown() {
    }
}

