/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.metric;

import com.google.api.LabelDescriptor;
import com.google.api.Metric;
import com.google.api.MetricDescriptor;
import com.google.cloud.opentelemetry.metric.MetricExporter;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Longs;
import com.google.monitoring.v3.Point;
import com.google.monitoring.v3.TimeInterval;
import com.google.monitoring.v3.TypedValue;
import com.google.protobuf.Timestamp;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricTranslator {
    private static final Logger logger = LoggerFactory.getLogger(MetricTranslator.class);
    static final String DESCRIPTOR_TYPE_URL = "custom.googleapis.com/OpenTelemetry/";
    static final Set<String> KNOWN_DOMAINS = ImmutableSet.of((Object)"googleapis.com", (Object)"kubernetes.io", (Object)"istio.io", (Object)"knative.dev");
    static final long NANO_PER_SECOND = 1000000000L;
    static final String METRIC_DESCRIPTOR_TIME_UNIT = "ns";
    static final Set<MetricData.Type> GAUGE_TYPES = ImmutableSet.of((Object)MetricData.Type.NON_MONOTONIC_LONG, (Object)MetricData.Type.NON_MONOTONIC_DOUBLE);
    static final Set<MetricData.Type> CUMULATIVE_TYPES = ImmutableSet.of((Object)MetricData.Type.MONOTONIC_LONG, (Object)MetricData.Type.MONOTONIC_DOUBLE);
    static final Set<MetricData.Type> LONG_TYPES = ImmutableSet.of((Object)MetricData.Type.NON_MONOTONIC_LONG, (Object)MetricData.Type.MONOTONIC_LONG);
    static final Set<MetricData.Type> DOUBLE_TYPES = ImmutableSet.of((Object)MetricData.Type.NON_MONOTONIC_DOUBLE, (Object)MetricData.Type.MONOTONIC_DOUBLE);

    static Metric mapMetric(MetricData.Point metricPoint, String type) {
        Metric.Builder metricBuilder = Metric.newBuilder().setType(type);
        metricPoint.getLabels().forEach((arg_0, arg_1) -> ((Metric.Builder)metricBuilder).putLabels(arg_0, arg_1));
        return metricBuilder.build();
    }

    static MetricDescriptor mapMetricDescriptor(MetricData metric, MetricData.Point metricPoint) {
        MetricDescriptor.Builder builder = MetricDescriptor.newBuilder().setDisplayName(metric.getName()).setDescription(metric.getDescription()).setType(MetricTranslator.mapMetricType(metric.getInstrumentationLibraryInfo().getName())).setUnit(metric.getUnit());
        metricPoint.getLabels().forEach((key, value) -> builder.addLabels(MetricTranslator.mapLabel(key, value)));
        MetricData.Type metricType = metric.getType();
        if (GAUGE_TYPES.contains(metricType)) {
            builder.setMetricKind(MetricDescriptor.MetricKind.GAUGE);
        } else if (CUMULATIVE_TYPES.contains(metricType)) {
            builder.setMetricKind(MetricDescriptor.MetricKind.CUMULATIVE);
        } else {
            logger.error("Metric type {} not supported. Only gauge and cumulative types are supported.", (Object)metricType);
            return null;
        }
        if (LONG_TYPES.contains(metricType)) {
            builder.setValueType(MetricDescriptor.ValueType.INT64);
        } else if (DOUBLE_TYPES.contains(metricType)) {
            builder.setValueType(MetricDescriptor.ValueType.DOUBLE);
        } else {
            logger.error("Metric type {} not supported. Only long and double types are supported.", (Object)metricType);
            return null;
        }
        return builder.build();
    }

    private static String mapMetricType(String instrumentName) {
        for (String domain : KNOWN_DOMAINS) {
            if (!instrumentName.contains(domain)) continue;
            return instrumentName;
        }
        return DESCRIPTOR_TYPE_URL + instrumentName;
    }

    static LabelDescriptor mapLabel(String key, String value) {
        LabelDescriptor.Builder builder = LabelDescriptor.newBuilder().setKey(key);
        if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            builder.setValueType(LabelDescriptor.ValueType.BOOL);
        } else if (Longs.tryParse((String)value) != null) {
            builder.setValueType(LabelDescriptor.ValueType.INT64);
        } else {
            builder.setValueType(LabelDescriptor.ValueType.STRING);
        }
        return builder.build();
    }

    static Point mapPoint(MetricData metric, MetricData.Point point, MetricExporter.MetricWithLabels updateKey, Map<MetricExporter.MetricWithLabels, Long> lastUpdatedTime) {
        Point.Builder pointBuilder = Point.newBuilder();
        MetricData.Type type = metric.getType();
        if (LONG_TYPES.contains(type)) {
            pointBuilder.setValue(TypedValue.newBuilder().setInt64Value(((MetricData.LongPoint)point).getValue()));
        } else if (DOUBLE_TYPES.contains(type)) {
            pointBuilder.setValue(TypedValue.newBuilder().setDoubleValue(((MetricData.DoublePoint)point).getValue()));
        } else {
            logger.error("Type {} not supported", (Object)type);
            return null;
        }
        pointBuilder.setInterval(MetricTranslator.mapInterval(point));
        lastUpdatedTime.put(updateKey, point.getEpochNanos());
        return pointBuilder.build();
    }

    static TimeInterval mapInterval(MetricData.Point point) {
        Timestamp startTime = MetricTranslator.mapTimestamp(point.getStartEpochNanos());
        Timestamp endTime = MetricTranslator.mapTimestamp(point.getEpochNanos());
        return TimeInterval.newBuilder().setStartTime(startTime).setEndTime(endTime).build();
    }

    private static Timestamp mapTimestamp(long epochNanos) {
        return Timestamp.newBuilder().setSeconds(epochNanos / 1000000000L).setNanos((int)(epochNanos % 1000000000L)).build();
    }
}

