/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.metric;

import com.google.api.Metric;
import com.google.api.MetricDescriptor;
import com.google.api.MonitoredResource;
import com.google.api.client.util.Preconditions;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.cloud.monitoring.v3.stub.MetricServiceStub;
import com.google.cloud.opentelemetry.metric.CloudMetricClient;
import com.google.cloud.opentelemetry.metric.CloudMetricClientImpl;
import com.google.cloud.opentelemetry.metric.MetricConfiguration;
import com.google.cloud.opentelemetry.metric.MetricTranslator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.monitoring.v3.CreateMetricDescriptorRequest;
import com.google.monitoring.v3.Point;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeSeries;
import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Duration;

public class MetricExporter
implements io.opentelemetry.sdk.metrics.export.MetricExporter {
    private static final Logger logger = LoggerFactory.getLogger(MetricExporter.class);
    private static final String PROJECT_NAME_PREFIX = "projects/";
    private static final long WRITE_INTERVAL_SECOND = 12L;
    private static final int MAX_BATCH_SIZE = 200;
    private static final long NANO_PER_SECOND = 1000000000L;
    private final CloudMetricClient metricServiceClient;
    private final String projectId;
    private final Map<MetricWithLabels, Long> lastUpdatedTime = new HashMap<MetricWithLabels, Long>();

    MetricExporter(String projectId, CloudMetricClient client) {
        this.projectId = projectId;
        this.metricServiceClient = client;
    }

    public static MetricExporter createWithDefaultConfiguration() throws IOException {
        MetricConfiguration configuration = MetricConfiguration.builder().build();
        return MetricExporter.createWithConfiguration(configuration);
    }

    public static MetricExporter createWithConfiguration(MetricConfiguration configuration) throws IOException {
        String projectId = configuration.getProjectId();
        MetricServiceStub stub = configuration.getMetricServiceStub();
        if (stub == null) {
            GoogleCredentials credentials = configuration.getCredentials() == null ? GoogleCredentials.getApplicationDefault() : configuration.getCredentials();
            return MetricExporter.createWithCredentials(projectId, (Credentials)credentials, configuration.getDeadline());
        }
        return MetricExporter.createWithClient(projectId, new CloudMetricClientImpl(MetricServiceClient.create((MetricServiceStub)stub)));
    }

    @VisibleForTesting
    static MetricExporter createWithClient(String projectId, CloudMetricClient metricServiceClient) {
        return new MetricExporter(projectId, metricServiceClient);
    }

    private static MetricExporter createWithCredentials(String projectId, Credentials credentials, java.time.Duration deadline) throws IOException {
        MetricServiceSettings.Builder builder = (MetricServiceSettings.Builder)MetricServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)((Credentials)Preconditions.checkNotNull((Object)credentials, (Object)"Credentials not provided."))));
        builder.createMetricDescriptorSettings().setSimpleTimeoutNoRetries(Duration.ofMillis((long)deadline.toMillis()));
        return new MetricExporter(projectId, new CloudMetricClientImpl(MetricServiceClient.create((MetricServiceSettings)builder.build())));
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        ArrayList<TimeSeries> allTimesSeries = new ArrayList<TimeSeries>();
        for (MetricData metricData : metrics) {
            if (metricData.getPoints().size() != 1) {
                logger.error("There should be exactly one point in each metricData, found {}", (Object)metricData.getPoints().size());
                continue;
            }
            MetricData.Point metricPoint = (MetricData.Point)metricData.getPoints().iterator().next();
            MetricDescriptor descriptor = MetricTranslator.mapMetricDescriptor(metricData, metricPoint);
            if (descriptor == null) continue;
            this.metricServiceClient.createMetricDescriptor(CreateMetricDescriptorRequest.newBuilder().setName(PROJECT_NAME_PREFIX + this.projectId).setMetricDescriptor(descriptor).build());
            MetricWithLabels updateKey = new MetricWithLabels(descriptor.getType(), metricPoint.getLabels());
            long pointCollectionTime = metricPoint.getEpochNanos();
            if (this.lastUpdatedTime.containsKey(updateKey) && pointCollectionTime <= this.lastUpdatedTime.get(updateKey) / 1000000000L + 12L) continue;
            Metric metric = MetricTranslator.mapMetric(metricPoint, descriptor.getType());
            Point point = MetricTranslator.mapPoint(metricData, metricPoint, updateKey, this.lastUpdatedTime);
            if (point == null) continue;
            allTimesSeries.add(TimeSeries.newBuilder().setMetric(metric).addPoints(point).setResource(MonitoredResource.newBuilder().build()).setMetricKind(descriptor.getMetricKind()).build());
        }
        MetricExporter.createTimeSeriesBatch(this.metricServiceClient, ProjectName.of((String)this.projectId), allTimesSeries);
        if (allTimesSeries.size() < metrics.size()) {
            return CompletableResultCode.ofFailure();
        }
        return CompletableResultCode.ofSuccess();
    }

    private static void createTimeSeriesBatch(CloudMetricClient metricServiceClient, ProjectName projectName, List<TimeSeries> allTimesSeries) {
        List batches = Lists.partition(allTimesSeries, (int)200);
        for (List timeSeries : batches) {
            metricServiceClient.createTimeSeries(projectName, new ArrayList<TimeSeries>(timeSeries));
        }
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public void shutdown() {
        this.metricServiceClient.shutdown();
    }

    static class MetricWithLabels {
        private final String metricType;
        private final Labels labels;

        MetricWithLabels(String metricType, Labels labels) {
            this.metricType = metricType;
            this.labels = labels;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricWithLabels that = (MetricWithLabels)o;
            return Objects.equals(this.metricType, that.metricType) && Objects.equals(this.labels, that.labels);
        }

        public int hashCode() {
            return Objects.hash(this.metricType, this.labels);
        }
    }
}

