/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.detectors;

import com.google.cloud.opentelemetry.detectors.EnvVars;
import com.google.cloud.opentelemetry.detectors.GCEResource;
import com.google.cloud.opentelemetry.detectors.GCPMetadataConfig;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;

public final class GKEResource
implements ResourceProvider {
    private final GCPMetadataConfig metadata;
    private final EnvVars envVars;

    public GKEResource() {
        this.metadata = GCPMetadataConfig.DEFAULT_INSTANCE;
        this.envVars = EnvVars.DEFAULT_INSTANCE;
    }

    public GKEResource(GCPMetadataConfig metadataConfig, EnvVars envVars) {
        this.metadata = metadataConfig;
        this.envVars = envVars;
    }

    public Attributes getAttributes() {
        String clusterName;
        String containerName;
        GCEResource gce = new GCEResource(this.metadata);
        Attributes gceAttributes = gce.getAttributes();
        if (this.envVars.get("KUBERNETES_SERVICE_HOST") == null) {
            return gceAttributes;
        }
        AttributesBuilder attrBuilders = Attributes.builder();
        attrBuilders.putAll(gceAttributes);
        attrBuilders.put(ResourceAttributes.CLOUD_PLATFORM, (Object)"gcp_kubernetes_engine");
        String podName = this.envVars.get("POD_NAME");
        if (podName != null && !podName.isEmpty()) {
            attrBuilders.put(ResourceAttributes.K8S_POD_NAME, (Object)podName);
        } else {
            attrBuilders.put(ResourceAttributes.K8S_POD_NAME, (Object)this.envVars.get("HOSTNAME"));
        }
        String namespace = this.envVars.get("NAMESPACE");
        if (namespace != null && !namespace.isEmpty()) {
            attrBuilders.put(ResourceAttributes.K8S_NAMESPACE_NAME, (Object)namespace);
        }
        if ((containerName = this.envVars.get("CONTAINER_NAME")) != null && !containerName.isEmpty()) {
            attrBuilders.put(ResourceAttributes.K8S_CONTAINER_NAME, (Object)containerName);
        }
        if ((clusterName = this.metadata.getClusterName()) != null && !clusterName.isEmpty()) {
            attrBuilders.put(ResourceAttributes.K8S_CLUSTER_NAME, (Object)clusterName);
        }
        return attrBuilders.build();
    }

    public Resource createResource(ConfigProperties config) {
        return Resource.create((Attributes)this.getAttributes());
    }
}

