/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.detectors;

import com.google.cloud.opentelemetry.detectors.GCPMetadataConfig;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;

public final class GCEResource
implements ResourceProvider {
    private final GCPMetadataConfig metadata;

    public GCEResource() {
        this(GCPMetadataConfig.DEFAULT_INSTANCE);
    }

    public GCEResource(GCPMetadataConfig metadataConfig) {
        this.metadata = metadataConfig;
    }

    public Attributes getAttributes() {
        String hostType;
        String instanceName;
        String instanceId;
        String zone;
        if (!this.metadata.isRunningOnGcp()) {
            return Attributes.empty();
        }
        AttributesBuilder attrBuilders = Attributes.builder();
        attrBuilders.put(ResourceAttributes.CLOUD_PROVIDER, (Object)"gcp");
        attrBuilders.put(ResourceAttributes.CLOUD_PLATFORM, (Object)"gcp_compute_engine");
        String projectId = this.metadata.getProjectId();
        if (projectId != null) {
            attrBuilders.put(ResourceAttributes.CLOUD_ACCOUNT_ID, (Object)projectId);
        }
        if ((zone = this.metadata.getZone()) != null) {
            attrBuilders.put(ResourceAttributes.CLOUD_AVAILABILITY_ZONE, (Object)zone);
            String[] splitArr = zone.split("-");
            if (splitArr.length > 2) {
                attrBuilders.put(ResourceAttributes.CLOUD_REGION, (Object)(splitArr[0] + "-" + splitArr[1]));
            }
        }
        if ((instanceId = this.metadata.getInstanceId()) != null) {
            attrBuilders.put(ResourceAttributes.HOST_ID, (Object)instanceId);
        }
        if ((instanceName = this.metadata.getInstanceName()) != null) {
            attrBuilders.put(ResourceAttributes.HOST_NAME, (Object)instanceName);
        }
        if ((hostType = this.metadata.getMachineType()) != null) {
            attrBuilders.put(ResourceAttributes.HOST_TYPE, (Object)hostType);
        }
        return attrBuilders.build();
    }

    public Resource createResource(ConfigProperties config) {
        return Resource.create((Attributes)this.getAttributes());
    }
}

