/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.grpc.multiendpoint;

import com.google.cloud.grpc.multiendpoint.Endpoint;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.time.Duration;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@CheckReturnValue
public final class MultiEndpoint {
    @GuardedBy(value="this")
    private final Map<String, Endpoint> endpointsMap = new HashMap<String, Endpoint>();
    @GuardedBy(value="this")
    private volatile String currentId;
    private final Duration recoveryTimeout;
    private final Duration switchingDelay;
    @GuardedBy(value="this")
    private ScheduledFuture<?> scheduledSwitch;
    @GuardedBy(value="this")
    private volatile String switchTo;
    final ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(1);

    private MultiEndpoint(Builder builder) {
        this.recoveryTimeout = builder.recoveryTimeout;
        this.switchingDelay = builder.switchingDelay;
        this.setEndpoints(builder.endpoints);
    }

    public String getCurrentId() {
        return this.currentId;
    }

    synchronized Map<String, Endpoint> getEndpointsMap() {
        return this.endpointsMap;
    }

    Duration getRecoveryTimeout() {
        return this.recoveryTimeout;
    }

    boolean isRecoveryEnabled() {
        return !this.recoveryTimeout.isNegative() && !this.recoveryTimeout.isZero();
    }

    private boolean isSwitchingDelayed() {
        return !this.switchingDelay.isNegative() && !this.switchingDelay.isZero();
    }

    public synchronized void setEndpointAvailable(String endpointId, boolean available) {
        Endpoint endpoint = this.endpointsMap.get(endpointId);
        if (endpoint == null) {
            return;
        }
        endpoint.setAvailability(available);
        this.maybeUpdateCurrentEndpoint();
    }

    public synchronized void setEndpoints(List<String> endpoints) {
        Preconditions.checkNotNull(endpoints);
        Preconditions.checkArgument((!endpoints.isEmpty() ? 1 : 0) != 0, (Object)"Endpoints list must not be empty.");
        this.endpointsMap.keySet().retainAll(endpoints);
        int priority = 0;
        for (String endpointId : endpoints) {
            Endpoint existingEndpoint = this.endpointsMap.get(endpointId);
            if (existingEndpoint != null) {
                existingEndpoint.setPriority(priority++);
                continue;
            }
            this.endpointsMap.put(endpointId, new Endpoint(endpointId, Endpoint.EndpointState.UNAVAILABLE, priority++, this));
        }
        this.maybeUpdateCurrentEndpoint();
    }

    synchronized void maybeUpdateCurrentEndpoint() {
        Optional<Endpoint> topEndpoint = this.endpointsMap.values().stream().filter(c -> c.getState().equals((Object)Endpoint.EndpointState.AVAILABLE)).min(Comparator.comparingInt(Endpoint::getPriority));
        Endpoint current = this.endpointsMap.get(this.currentId);
        if (current != null && current.getState().equals((Object)Endpoint.EndpointState.RECOVERING) && (!topEndpoint.isPresent() || topEndpoint.get().getPriority() >= current.getPriority())) {
            return;
        }
        if (!topEndpoint.isPresent() && current == null) {
            topEndpoint = this.endpointsMap.values().stream().min(Comparator.comparingInt(Endpoint::getPriority));
        }
        topEndpoint.ifPresent(endpoint -> this.updateCurrentEndpoint(current, endpoint.getId()));
    }

    private synchronized void updateCurrentEndpoint(Endpoint current, String newCurrentId) {
        if (current == null || current.getState().equals((Object)Endpoint.EndpointState.UNAVAILABLE)) {
            this.currentId = newCurrentId;
            return;
        }
        if (!this.isSwitchingDelayed()) {
            this.currentId = newCurrentId;
            return;
        }
        this.switchTo = newCurrentId;
        if (this.switchTo.equals(this.currentId)) {
            return;
        }
        if (this.scheduledSwitch == null || this.scheduledSwitch.isDone()) {
            this.scheduledSwitch = this.executor.schedule(this::switchCurrentEndpoint, this.switchingDelay.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void switchCurrentEndpoint() {
        this.currentId = this.switchTo;
    }

    public String toString() {
        return "MultiEndpoint{endpointsMap=" + this.endpointsMap + ", currentId='" + this.currentId + "', recoveryTimeout=" + this.recoveryTimeout + ", switchingDelay=" + this.switchingDelay + ", scheduledSwitch=" + this.scheduledSwitch + ", switchTo='" + this.switchTo + "', executor=" + this.executor + '}';
    }

    public static final class Builder {
        private final List<String> endpoints;
        private Duration recoveryTimeout = Duration.ZERO;
        private Duration switchingDelay = Duration.ZERO;

        public Builder(List<String> endpoints) {
            Preconditions.checkNotNull(endpoints);
            Preconditions.checkArgument((!endpoints.isEmpty() ? 1 : 0) != 0, (Object)"Endpoints list must not be empty.");
            this.endpoints = endpoints;
        }

        @CanIgnoreReturnValue
        public Builder withRecoveryTimeout(Duration timeout) {
            Preconditions.checkNotNull((Object)timeout);
            this.recoveryTimeout = timeout;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withSwitchingDelay(Duration delay) {
            Preconditions.checkNotNull((Object)delay);
            this.switchingDelay = delay;
            return this;
        }

        public MultiEndpoint build() {
            return new MultiEndpoint(this);
        }
    }
}

