/*
 * Decompiled with CFR 0.152.
 */
package com.google.identity.accesscontextmanager.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata;
import com.google.identity.accesscontextmanager.v1.AccessContextManagerSettings;
import com.google.identity.accesscontextmanager.v1.AccessLevel;
import com.google.identity.accesscontextmanager.v1.AccessLevelName;
import com.google.identity.accesscontextmanager.v1.AccessPolicy;
import com.google.identity.accesscontextmanager.v1.AccessPolicyName;
import com.google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest;
import com.google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse;
import com.google.identity.accesscontextmanager.v1.CreateAccessLevelRequest;
import com.google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest;
import com.google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest;
import com.google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest;
import com.google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest;
import com.google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest;
import com.google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest;
import com.google.identity.accesscontextmanager.v1.GcpUserAccessBinding;
import com.google.identity.accesscontextmanager.v1.GcpUserAccessBindingName;
import com.google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata;
import com.google.identity.accesscontextmanager.v1.GetAccessLevelRequest;
import com.google.identity.accesscontextmanager.v1.GetAccessPolicyRequest;
import com.google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest;
import com.google.identity.accesscontextmanager.v1.GetServicePerimeterRequest;
import com.google.identity.accesscontextmanager.v1.ListAccessLevelsRequest;
import com.google.identity.accesscontextmanager.v1.ListAccessLevelsResponse;
import com.google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest;
import com.google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse;
import com.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest;
import com.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse;
import com.google.identity.accesscontextmanager.v1.ListServicePerimetersRequest;
import com.google.identity.accesscontextmanager.v1.ListServicePerimetersResponse;
import com.google.identity.accesscontextmanager.v1.OrganizationName;
import com.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest;
import com.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse;
import com.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest;
import com.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse;
import com.google.identity.accesscontextmanager.v1.ServicePerimeter;
import com.google.identity.accesscontextmanager.v1.ServicePerimeterName;
import com.google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest;
import com.google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest;
import com.google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest;
import com.google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest;
import com.google.identity.accesscontextmanager.v1.stub.AccessContextManagerStub;
import com.google.identity.accesscontextmanager.v1.stub.AccessContextManagerStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AccessContextManagerClient
implements BackgroundResource {
    private final AccessContextManagerSettings settings;
    private final AccessContextManagerStub stub;
    private final OperationsClient operationsClient;

    public static final AccessContextManagerClient create() throws IOException {
        return AccessContextManagerClient.create(AccessContextManagerSettings.newBuilder().build());
    }

    public static final AccessContextManagerClient create(AccessContextManagerSettings settings) throws IOException {
        return new AccessContextManagerClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AccessContextManagerClient create(AccessContextManagerStub stub) {
        return new AccessContextManagerClient(stub);
    }

    protected AccessContextManagerClient(AccessContextManagerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AccessContextManagerStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AccessContextManagerClient(AccessContextManagerStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final AccessContextManagerSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AccessContextManagerStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListAccessPoliciesPagedResponse listAccessPolicies(ListAccessPoliciesRequest request) {
        return (ListAccessPoliciesPagedResponse)((Object)this.listAccessPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAccessPoliciesRequest, ListAccessPoliciesPagedResponse> listAccessPoliciesPagedCallable() {
        return this.stub.listAccessPoliciesPagedCallable();
    }

    public final UnaryCallable<ListAccessPoliciesRequest, ListAccessPoliciesResponse> listAccessPoliciesCallable() {
        return this.stub.listAccessPoliciesCallable();
    }

    public final AccessPolicy getAccessPolicy(AccessPolicyName name) {
        GetAccessPolicyRequest request = GetAccessPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAccessPolicy(request);
    }

    public final AccessPolicy getAccessPolicy(String name) {
        GetAccessPolicyRequest request = GetAccessPolicyRequest.newBuilder().setName(name).build();
        return this.getAccessPolicy(request);
    }

    public final AccessPolicy getAccessPolicy(GetAccessPolicyRequest request) {
        return (AccessPolicy)this.getAccessPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetAccessPolicyRequest, AccessPolicy> getAccessPolicyCallable() {
        return this.stub.getAccessPolicyCallable();
    }

    public final OperationFuture<AccessPolicy, AccessContextManagerOperationMetadata> createAccessPolicyAsync(AccessPolicy request) {
        return this.createAccessPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AccessPolicy, AccessPolicy, AccessContextManagerOperationMetadata> createAccessPolicyOperationCallable() {
        return this.stub.createAccessPolicyOperationCallable();
    }

    public final UnaryCallable<AccessPolicy, Operation> createAccessPolicyCallable() {
        return this.stub.createAccessPolicyCallable();
    }

    public final OperationFuture<AccessPolicy, AccessContextManagerOperationMetadata> updateAccessPolicyAsync(AccessPolicy policy, FieldMask updateMask) {
        UpdateAccessPolicyRequest request = UpdateAccessPolicyRequest.newBuilder().setPolicy(policy).setUpdateMask(updateMask).build();
        return this.updateAccessPolicyAsync(request);
    }

    public final OperationFuture<AccessPolicy, AccessContextManagerOperationMetadata> updateAccessPolicyAsync(UpdateAccessPolicyRequest request) {
        return this.updateAccessPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAccessPolicyRequest, AccessPolicy, AccessContextManagerOperationMetadata> updateAccessPolicyOperationCallable() {
        return this.stub.updateAccessPolicyOperationCallable();
    }

    public final UnaryCallable<UpdateAccessPolicyRequest, Operation> updateAccessPolicyCallable() {
        return this.stub.updateAccessPolicyCallable();
    }

    public final OperationFuture<Empty, AccessContextManagerOperationMetadata> deleteAccessPolicyAsync(AccessPolicyName name) {
        DeleteAccessPolicyRequest request = DeleteAccessPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAccessPolicyAsync(request);
    }

    public final OperationFuture<Empty, AccessContextManagerOperationMetadata> deleteAccessPolicyAsync(String name) {
        DeleteAccessPolicyRequest request = DeleteAccessPolicyRequest.newBuilder().setName(name).build();
        return this.deleteAccessPolicyAsync(request);
    }

    public final OperationFuture<Empty, AccessContextManagerOperationMetadata> deleteAccessPolicyAsync(DeleteAccessPolicyRequest request) {
        return this.deleteAccessPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAccessPolicyRequest, Empty, AccessContextManagerOperationMetadata> deleteAccessPolicyOperationCallable() {
        return this.stub.deleteAccessPolicyOperationCallable();
    }

    public final UnaryCallable<DeleteAccessPolicyRequest, Operation> deleteAccessPolicyCallable() {
        return this.stub.deleteAccessPolicyCallable();
    }

    public final ListAccessLevelsPagedResponse listAccessLevels(AccessPolicyName parent) {
        ListAccessLevelsRequest request = ListAccessLevelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAccessLevels(request);
    }

    public final ListAccessLevelsPagedResponse listAccessLevels(String parent) {
        ListAccessLevelsRequest request = ListAccessLevelsRequest.newBuilder().setParent(parent).build();
        return this.listAccessLevels(request);
    }

    public final ListAccessLevelsPagedResponse listAccessLevels(ListAccessLevelsRequest request) {
        return (ListAccessLevelsPagedResponse)((Object)this.listAccessLevelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAccessLevelsRequest, ListAccessLevelsPagedResponse> listAccessLevelsPagedCallable() {
        return this.stub.listAccessLevelsPagedCallable();
    }

    public final UnaryCallable<ListAccessLevelsRequest, ListAccessLevelsResponse> listAccessLevelsCallable() {
        return this.stub.listAccessLevelsCallable();
    }

    public final AccessLevel getAccessLevel(AccessLevelName name) {
        GetAccessLevelRequest request = GetAccessLevelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAccessLevel(request);
    }

    public final AccessLevel getAccessLevel(String name) {
        GetAccessLevelRequest request = GetAccessLevelRequest.newBuilder().setName(name).build();
        return this.getAccessLevel(request);
    }

    public final AccessLevel getAccessLevel(GetAccessLevelRequest request) {
        return (AccessLevel)this.getAccessLevelCallable().call((Object)request);
    }

    public final UnaryCallable<GetAccessLevelRequest, AccessLevel> getAccessLevelCallable() {
        return this.stub.getAccessLevelCallable();
    }

    public final OperationFuture<AccessLevel, AccessContextManagerOperationMetadata> createAccessLevelAsync(AccessPolicyName parent, AccessLevel accessLevel) {
        CreateAccessLevelRequest request = CreateAccessLevelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAccessLevel(accessLevel).build();
        return this.createAccessLevelAsync(request);
    }

    public final OperationFuture<AccessLevel, AccessContextManagerOperationMetadata> createAccessLevelAsync(String parent, AccessLevel accessLevel) {
        CreateAccessLevelRequest request = CreateAccessLevelRequest.newBuilder().setParent(parent).setAccessLevel(accessLevel).build();
        return this.createAccessLevelAsync(request);
    }

    public final OperationFuture<AccessLevel, AccessContextManagerOperationMetadata> createAccessLevelAsync(CreateAccessLevelRequest request) {
        return this.createAccessLevelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAccessLevelRequest, AccessLevel, AccessContextManagerOperationMetadata> createAccessLevelOperationCallable() {
        return this.stub.createAccessLevelOperationCallable();
    }

    public final UnaryCallable<CreateAccessLevelRequest, Operation> createAccessLevelCallable() {
        return this.stub.createAccessLevelCallable();
    }

    public final OperationFuture<AccessLevel, AccessContextManagerOperationMetadata> updateAccessLevelAsync(AccessLevel accessLevel, FieldMask updateMask) {
        UpdateAccessLevelRequest request = UpdateAccessLevelRequest.newBuilder().setAccessLevel(accessLevel).setUpdateMask(updateMask).build();
        return this.updateAccessLevelAsync(request);
    }

    public final OperationFuture<AccessLevel, AccessContextManagerOperationMetadata> updateAccessLevelAsync(UpdateAccessLevelRequest request) {
        return this.updateAccessLevelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAccessLevelRequest, AccessLevel, AccessContextManagerOperationMetadata> updateAccessLevelOperationCallable() {
        return this.stub.updateAccessLevelOperationCallable();
    }

    public final UnaryCallable<UpdateAccessLevelRequest, Operation> updateAccessLevelCallable() {
        return this.stub.updateAccessLevelCallable();
    }

    public final OperationFuture<Empty, AccessContextManagerOperationMetadata> deleteAccessLevelAsync(AccessLevelName name) {
        DeleteAccessLevelRequest request = DeleteAccessLevelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAccessLevelAsync(request);
    }

    public final OperationFuture<Empty, AccessContextManagerOperationMetadata> deleteAccessLevelAsync(String name) {
        DeleteAccessLevelRequest request = DeleteAccessLevelRequest.newBuilder().setName(name).build();
        return this.deleteAccessLevelAsync(request);
    }

    public final OperationFuture<Empty, AccessContextManagerOperationMetadata> deleteAccessLevelAsync(DeleteAccessLevelRequest request) {
        return this.deleteAccessLevelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAccessLevelRequest, Empty, AccessContextManagerOperationMetadata> deleteAccessLevelOperationCallable() {
        return this.stub.deleteAccessLevelOperationCallable();
    }

    public final UnaryCallable<DeleteAccessLevelRequest, Operation> deleteAccessLevelCallable() {
        return this.stub.deleteAccessLevelCallable();
    }

    public final OperationFuture<ReplaceAccessLevelsResponse, AccessContextManagerOperationMetadata> replaceAccessLevelsAsync(ReplaceAccessLevelsRequest request) {
        return this.replaceAccessLevelsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ReplaceAccessLevelsRequest, ReplaceAccessLevelsResponse, AccessContextManagerOperationMetadata> replaceAccessLevelsOperationCallable() {
        return this.stub.replaceAccessLevelsOperationCallable();
    }

    public final UnaryCallable<ReplaceAccessLevelsRequest, Operation> replaceAccessLevelsCallable() {
        return this.stub.replaceAccessLevelsCallable();
    }

    public final ListServicePerimetersPagedResponse listServicePerimeters(AccessPolicyName parent) {
        ListServicePerimetersRequest request = ListServicePerimetersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServicePerimeters(request);
    }

    public final ListServicePerimetersPagedResponse listServicePerimeters(String parent) {
        ListServicePerimetersRequest request = ListServicePerimetersRequest.newBuilder().setParent(parent).build();
        return this.listServicePerimeters(request);
    }

    public final ListServicePerimetersPagedResponse listServicePerimeters(ListServicePerimetersRequest request) {
        return (ListServicePerimetersPagedResponse)((Object)this.listServicePerimetersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServicePerimetersRequest, ListServicePerimetersPagedResponse> listServicePerimetersPagedCallable() {
        return this.stub.listServicePerimetersPagedCallable();
    }

    public final UnaryCallable<ListServicePerimetersRequest, ListServicePerimetersResponse> listServicePerimetersCallable() {
        return this.stub.listServicePerimetersCallable();
    }

    public final ServicePerimeter getServicePerimeter(ServicePerimeterName name) {
        GetServicePerimeterRequest request = GetServicePerimeterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getServicePerimeter(request);
    }

    public final ServicePerimeter getServicePerimeter(String name) {
        GetServicePerimeterRequest request = GetServicePerimeterRequest.newBuilder().setName(name).build();
        return this.getServicePerimeter(request);
    }

    public final ServicePerimeter getServicePerimeter(GetServicePerimeterRequest request) {
        return (ServicePerimeter)this.getServicePerimeterCallable().call((Object)request);
    }

    public final UnaryCallable<GetServicePerimeterRequest, ServicePerimeter> getServicePerimeterCallable() {
        return this.stub.getServicePerimeterCallable();
    }

    public final OperationFuture<ServicePerimeter, AccessContextManagerOperationMetadata> createServicePerimeterAsync(AccessPolicyName parent, ServicePerimeter servicePerimeter) {
        CreateServicePerimeterRequest request = CreateServicePerimeterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setServicePerimeter(servicePerimeter).build();
        return this.createServicePerimeterAsync(request);
    }

    public final OperationFuture<ServicePerimeter, AccessContextManagerOperationMetadata> createServicePerimeterAsync(String parent, ServicePerimeter servicePerimeter) {
        CreateServicePerimeterRequest request = CreateServicePerimeterRequest.newBuilder().setParent(parent).setServicePerimeter(servicePerimeter).build();
        return this.createServicePerimeterAsync(request);
    }

    public final OperationFuture<ServicePerimeter, AccessContextManagerOperationMetadata> createServicePerimeterAsync(CreateServicePerimeterRequest request) {
        return this.createServicePerimeterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateServicePerimeterRequest, ServicePerimeter, AccessContextManagerOperationMetadata> createServicePerimeterOperationCallable() {
        return this.stub.createServicePerimeterOperationCallable();
    }

    public final UnaryCallable<CreateServicePerimeterRequest, Operation> createServicePerimeterCallable() {
        return this.stub.createServicePerimeterCallable();
    }

    public final OperationFuture<ServicePerimeter, AccessContextManagerOperationMetadata> updateServicePerimeterAsync(ServicePerimeter servicePerimeter, FieldMask updateMask) {
        UpdateServicePerimeterRequest request = UpdateServicePerimeterRequest.newBuilder().setServicePerimeter(servicePerimeter).setUpdateMask(updateMask).build();
        return this.updateServicePerimeterAsync(request);
    }

    public final OperationFuture<ServicePerimeter, AccessContextManagerOperationMetadata> updateServicePerimeterAsync(UpdateServicePerimeterRequest request) {
        return this.updateServicePerimeterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateServicePerimeterRequest, ServicePerimeter, AccessContextManagerOperationMetadata> updateServicePerimeterOperationCallable() {
        return this.stub.updateServicePerimeterOperationCallable();
    }

    public final UnaryCallable<UpdateServicePerimeterRequest, Operation> updateServicePerimeterCallable() {
        return this.stub.updateServicePerimeterCallable();
    }

    public final OperationFuture<Empty, AccessContextManagerOperationMetadata> deleteServicePerimeterAsync(ServicePerimeterName name) {
        DeleteServicePerimeterRequest request = DeleteServicePerimeterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteServicePerimeterAsync(request);
    }

    public final OperationFuture<Empty, AccessContextManagerOperationMetadata> deleteServicePerimeterAsync(String name) {
        DeleteServicePerimeterRequest request = DeleteServicePerimeterRequest.newBuilder().setName(name).build();
        return this.deleteServicePerimeterAsync(request);
    }

    public final OperationFuture<Empty, AccessContextManagerOperationMetadata> deleteServicePerimeterAsync(DeleteServicePerimeterRequest request) {
        return this.deleteServicePerimeterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteServicePerimeterRequest, Empty, AccessContextManagerOperationMetadata> deleteServicePerimeterOperationCallable() {
        return this.stub.deleteServicePerimeterOperationCallable();
    }

    public final UnaryCallable<DeleteServicePerimeterRequest, Operation> deleteServicePerimeterCallable() {
        return this.stub.deleteServicePerimeterCallable();
    }

    public final OperationFuture<ReplaceServicePerimetersResponse, AccessContextManagerOperationMetadata> replaceServicePerimetersAsync(ReplaceServicePerimetersRequest request) {
        return this.replaceServicePerimetersOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ReplaceServicePerimetersRequest, ReplaceServicePerimetersResponse, AccessContextManagerOperationMetadata> replaceServicePerimetersOperationCallable() {
        return this.stub.replaceServicePerimetersOperationCallable();
    }

    public final UnaryCallable<ReplaceServicePerimetersRequest, Operation> replaceServicePerimetersCallable() {
        return this.stub.replaceServicePerimetersCallable();
    }

    public final OperationFuture<CommitServicePerimetersResponse, AccessContextManagerOperationMetadata> commitServicePerimetersAsync(CommitServicePerimetersRequest request) {
        return this.commitServicePerimetersOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CommitServicePerimetersRequest, CommitServicePerimetersResponse, AccessContextManagerOperationMetadata> commitServicePerimetersOperationCallable() {
        return this.stub.commitServicePerimetersOperationCallable();
    }

    public final UnaryCallable<CommitServicePerimetersRequest, Operation> commitServicePerimetersCallable() {
        return this.stub.commitServicePerimetersCallable();
    }

    public final ListGcpUserAccessBindingsPagedResponse listGcpUserAccessBindings(OrganizationName parent) {
        ListGcpUserAccessBindingsRequest request = ListGcpUserAccessBindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGcpUserAccessBindings(request);
    }

    public final ListGcpUserAccessBindingsPagedResponse listGcpUserAccessBindings(String parent) {
        ListGcpUserAccessBindingsRequest request = ListGcpUserAccessBindingsRequest.newBuilder().setParent(parent).build();
        return this.listGcpUserAccessBindings(request);
    }

    public final ListGcpUserAccessBindingsPagedResponse listGcpUserAccessBindings(ListGcpUserAccessBindingsRequest request) {
        return (ListGcpUserAccessBindingsPagedResponse)((Object)this.listGcpUserAccessBindingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsPagedResponse> listGcpUserAccessBindingsPagedCallable() {
        return this.stub.listGcpUserAccessBindingsPagedCallable();
    }

    public final UnaryCallable<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse> listGcpUserAccessBindingsCallable() {
        return this.stub.listGcpUserAccessBindingsCallable();
    }

    public final GcpUserAccessBinding getGcpUserAccessBinding(GcpUserAccessBindingName name) {
        GetGcpUserAccessBindingRequest request = GetGcpUserAccessBindingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGcpUserAccessBinding(request);
    }

    public final GcpUserAccessBinding getGcpUserAccessBinding(String name) {
        GetGcpUserAccessBindingRequest request = GetGcpUserAccessBindingRequest.newBuilder().setName(name).build();
        return this.getGcpUserAccessBinding(request);
    }

    public final GcpUserAccessBinding getGcpUserAccessBinding(GetGcpUserAccessBindingRequest request) {
        return (GcpUserAccessBinding)this.getGcpUserAccessBindingCallable().call((Object)request);
    }

    public final UnaryCallable<GetGcpUserAccessBindingRequest, GcpUserAccessBinding> getGcpUserAccessBindingCallable() {
        return this.stub.getGcpUserAccessBindingCallable();
    }

    public final OperationFuture<GcpUserAccessBinding, GcpUserAccessBindingOperationMetadata> createGcpUserAccessBindingAsync(OrganizationName parent, GcpUserAccessBinding gcpUserAccessBinding) {
        CreateGcpUserAccessBindingRequest request = CreateGcpUserAccessBindingRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGcpUserAccessBinding(gcpUserAccessBinding).build();
        return this.createGcpUserAccessBindingAsync(request);
    }

    public final OperationFuture<GcpUserAccessBinding, GcpUserAccessBindingOperationMetadata> createGcpUserAccessBindingAsync(String parent, GcpUserAccessBinding gcpUserAccessBinding) {
        CreateGcpUserAccessBindingRequest request = CreateGcpUserAccessBindingRequest.newBuilder().setParent(parent).setGcpUserAccessBinding(gcpUserAccessBinding).build();
        return this.createGcpUserAccessBindingAsync(request);
    }

    public final OperationFuture<GcpUserAccessBinding, GcpUserAccessBindingOperationMetadata> createGcpUserAccessBindingAsync(CreateGcpUserAccessBindingRequest request) {
        return this.createGcpUserAccessBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateGcpUserAccessBindingRequest, GcpUserAccessBinding, GcpUserAccessBindingOperationMetadata> createGcpUserAccessBindingOperationCallable() {
        return this.stub.createGcpUserAccessBindingOperationCallable();
    }

    public final UnaryCallable<CreateGcpUserAccessBindingRequest, Operation> createGcpUserAccessBindingCallable() {
        return this.stub.createGcpUserAccessBindingCallable();
    }

    public final OperationFuture<GcpUserAccessBinding, GcpUserAccessBindingOperationMetadata> updateGcpUserAccessBindingAsync(GcpUserAccessBinding gcpUserAccessBinding, FieldMask updateMask) {
        UpdateGcpUserAccessBindingRequest request = UpdateGcpUserAccessBindingRequest.newBuilder().setGcpUserAccessBinding(gcpUserAccessBinding).setUpdateMask(updateMask).build();
        return this.updateGcpUserAccessBindingAsync(request);
    }

    public final OperationFuture<GcpUserAccessBinding, GcpUserAccessBindingOperationMetadata> updateGcpUserAccessBindingAsync(UpdateGcpUserAccessBindingRequest request) {
        return this.updateGcpUserAccessBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateGcpUserAccessBindingRequest, GcpUserAccessBinding, GcpUserAccessBindingOperationMetadata> updateGcpUserAccessBindingOperationCallable() {
        return this.stub.updateGcpUserAccessBindingOperationCallable();
    }

    public final UnaryCallable<UpdateGcpUserAccessBindingRequest, Operation> updateGcpUserAccessBindingCallable() {
        return this.stub.updateGcpUserAccessBindingCallable();
    }

    public final OperationFuture<Empty, GcpUserAccessBindingOperationMetadata> deleteGcpUserAccessBindingAsync(GcpUserAccessBindingName name) {
        DeleteGcpUserAccessBindingRequest request = DeleteGcpUserAccessBindingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteGcpUserAccessBindingAsync(request);
    }

    public final OperationFuture<Empty, GcpUserAccessBindingOperationMetadata> deleteGcpUserAccessBindingAsync(String name) {
        DeleteGcpUserAccessBindingRequest request = DeleteGcpUserAccessBindingRequest.newBuilder().setName(name).build();
        return this.deleteGcpUserAccessBindingAsync(request);
    }

    public final OperationFuture<Empty, GcpUserAccessBindingOperationMetadata> deleteGcpUserAccessBindingAsync(DeleteGcpUserAccessBindingRequest request) {
        return this.deleteGcpUserAccessBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteGcpUserAccessBindingRequest, Empty, GcpUserAccessBindingOperationMetadata> deleteGcpUserAccessBindingOperationCallable() {
        return this.stub.deleteGcpUserAccessBindingOperationCallable();
    }

    public final UnaryCallable<DeleteGcpUserAccessBindingRequest, Operation> deleteGcpUserAccessBindingCallable() {
        return this.stub.deleteGcpUserAccessBindingCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListGcpUserAccessBindingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse, GcpUserAccessBinding, ListGcpUserAccessBindingsPage, ListGcpUserAccessBindingsFixedSizeCollection> {
        private ListGcpUserAccessBindingsFixedSizeCollection(List<ListGcpUserAccessBindingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGcpUserAccessBindingsFixedSizeCollection createEmptyCollection() {
            return new ListGcpUserAccessBindingsFixedSizeCollection(null, 0);
        }

        protected ListGcpUserAccessBindingsFixedSizeCollection createCollection(List<ListGcpUserAccessBindingsPage> pages, int collectionSize) {
            return new ListGcpUserAccessBindingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGcpUserAccessBindingsPage
    extends AbstractPage<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse, GcpUserAccessBinding, ListGcpUserAccessBindingsPage> {
        private ListGcpUserAccessBindingsPage(PageContext<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse, GcpUserAccessBinding> context, ListGcpUserAccessBindingsResponse response) {
            super(context, (Object)response);
        }

        private static ListGcpUserAccessBindingsPage createEmptyPage() {
            return new ListGcpUserAccessBindingsPage(null, null);
        }

        protected ListGcpUserAccessBindingsPage createPage(PageContext<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse, GcpUserAccessBinding> context, ListGcpUserAccessBindingsResponse response) {
            return new ListGcpUserAccessBindingsPage(context, response);
        }

        public ApiFuture<ListGcpUserAccessBindingsPage> createPageAsync(PageContext<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse, GcpUserAccessBinding> context, ApiFuture<ListGcpUserAccessBindingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGcpUserAccessBindingsPagedResponse
    extends AbstractPagedListResponse<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse, GcpUserAccessBinding, ListGcpUserAccessBindingsPage, ListGcpUserAccessBindingsFixedSizeCollection> {
        public static ApiFuture<ListGcpUserAccessBindingsPagedResponse> createAsync(PageContext<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse, GcpUserAccessBinding> context, ApiFuture<ListGcpUserAccessBindingsResponse> futureResponse) {
            ApiFuture<ListGcpUserAccessBindingsPage> futurePage = ListGcpUserAccessBindingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGcpUserAccessBindingsPagedResponse((ListGcpUserAccessBindingsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGcpUserAccessBindingsPagedResponse(ListGcpUserAccessBindingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGcpUserAccessBindingsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListServicePerimetersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServicePerimetersRequest, ListServicePerimetersResponse, ServicePerimeter, ListServicePerimetersPage, ListServicePerimetersFixedSizeCollection> {
        private ListServicePerimetersFixedSizeCollection(List<ListServicePerimetersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServicePerimetersFixedSizeCollection createEmptyCollection() {
            return new ListServicePerimetersFixedSizeCollection(null, 0);
        }

        protected ListServicePerimetersFixedSizeCollection createCollection(List<ListServicePerimetersPage> pages, int collectionSize) {
            return new ListServicePerimetersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServicePerimetersPage
    extends AbstractPage<ListServicePerimetersRequest, ListServicePerimetersResponse, ServicePerimeter, ListServicePerimetersPage> {
        private ListServicePerimetersPage(PageContext<ListServicePerimetersRequest, ListServicePerimetersResponse, ServicePerimeter> context, ListServicePerimetersResponse response) {
            super(context, (Object)response);
        }

        private static ListServicePerimetersPage createEmptyPage() {
            return new ListServicePerimetersPage(null, null);
        }

        protected ListServicePerimetersPage createPage(PageContext<ListServicePerimetersRequest, ListServicePerimetersResponse, ServicePerimeter> context, ListServicePerimetersResponse response) {
            return new ListServicePerimetersPage(context, response);
        }

        public ApiFuture<ListServicePerimetersPage> createPageAsync(PageContext<ListServicePerimetersRequest, ListServicePerimetersResponse, ServicePerimeter> context, ApiFuture<ListServicePerimetersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServicePerimetersPagedResponse
    extends AbstractPagedListResponse<ListServicePerimetersRequest, ListServicePerimetersResponse, ServicePerimeter, ListServicePerimetersPage, ListServicePerimetersFixedSizeCollection> {
        public static ApiFuture<ListServicePerimetersPagedResponse> createAsync(PageContext<ListServicePerimetersRequest, ListServicePerimetersResponse, ServicePerimeter> context, ApiFuture<ListServicePerimetersResponse> futureResponse) {
            ApiFuture<ListServicePerimetersPage> futurePage = ListServicePerimetersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServicePerimetersPagedResponse((ListServicePerimetersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServicePerimetersPagedResponse(ListServicePerimetersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServicePerimetersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAccessLevelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAccessLevelsRequest, ListAccessLevelsResponse, AccessLevel, ListAccessLevelsPage, ListAccessLevelsFixedSizeCollection> {
        private ListAccessLevelsFixedSizeCollection(List<ListAccessLevelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAccessLevelsFixedSizeCollection createEmptyCollection() {
            return new ListAccessLevelsFixedSizeCollection(null, 0);
        }

        protected ListAccessLevelsFixedSizeCollection createCollection(List<ListAccessLevelsPage> pages, int collectionSize) {
            return new ListAccessLevelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAccessLevelsPage
    extends AbstractPage<ListAccessLevelsRequest, ListAccessLevelsResponse, AccessLevel, ListAccessLevelsPage> {
        private ListAccessLevelsPage(PageContext<ListAccessLevelsRequest, ListAccessLevelsResponse, AccessLevel> context, ListAccessLevelsResponse response) {
            super(context, (Object)response);
        }

        private static ListAccessLevelsPage createEmptyPage() {
            return new ListAccessLevelsPage(null, null);
        }

        protected ListAccessLevelsPage createPage(PageContext<ListAccessLevelsRequest, ListAccessLevelsResponse, AccessLevel> context, ListAccessLevelsResponse response) {
            return new ListAccessLevelsPage(context, response);
        }

        public ApiFuture<ListAccessLevelsPage> createPageAsync(PageContext<ListAccessLevelsRequest, ListAccessLevelsResponse, AccessLevel> context, ApiFuture<ListAccessLevelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAccessLevelsPagedResponse
    extends AbstractPagedListResponse<ListAccessLevelsRequest, ListAccessLevelsResponse, AccessLevel, ListAccessLevelsPage, ListAccessLevelsFixedSizeCollection> {
        public static ApiFuture<ListAccessLevelsPagedResponse> createAsync(PageContext<ListAccessLevelsRequest, ListAccessLevelsResponse, AccessLevel> context, ApiFuture<ListAccessLevelsResponse> futureResponse) {
            ApiFuture<ListAccessLevelsPage> futurePage = ListAccessLevelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAccessLevelsPagedResponse((ListAccessLevelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAccessLevelsPagedResponse(ListAccessLevelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAccessLevelsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAccessPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAccessPoliciesRequest, ListAccessPoliciesResponse, AccessPolicy, ListAccessPoliciesPage, ListAccessPoliciesFixedSizeCollection> {
        private ListAccessPoliciesFixedSizeCollection(List<ListAccessPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAccessPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListAccessPoliciesFixedSizeCollection(null, 0);
        }

        protected ListAccessPoliciesFixedSizeCollection createCollection(List<ListAccessPoliciesPage> pages, int collectionSize) {
            return new ListAccessPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAccessPoliciesPage
    extends AbstractPage<ListAccessPoliciesRequest, ListAccessPoliciesResponse, AccessPolicy, ListAccessPoliciesPage> {
        private ListAccessPoliciesPage(PageContext<ListAccessPoliciesRequest, ListAccessPoliciesResponse, AccessPolicy> context, ListAccessPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static ListAccessPoliciesPage createEmptyPage() {
            return new ListAccessPoliciesPage(null, null);
        }

        protected ListAccessPoliciesPage createPage(PageContext<ListAccessPoliciesRequest, ListAccessPoliciesResponse, AccessPolicy> context, ListAccessPoliciesResponse response) {
            return new ListAccessPoliciesPage(context, response);
        }

        public ApiFuture<ListAccessPoliciesPage> createPageAsync(PageContext<ListAccessPoliciesRequest, ListAccessPoliciesResponse, AccessPolicy> context, ApiFuture<ListAccessPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAccessPoliciesPagedResponse
    extends AbstractPagedListResponse<ListAccessPoliciesRequest, ListAccessPoliciesResponse, AccessPolicy, ListAccessPoliciesPage, ListAccessPoliciesFixedSizeCollection> {
        public static ApiFuture<ListAccessPoliciesPagedResponse> createAsync(PageContext<ListAccessPoliciesRequest, ListAccessPoliciesResponse, AccessPolicy> context, ApiFuture<ListAccessPoliciesResponse> futureResponse) {
            ApiFuture<ListAccessPoliciesPage> futurePage = ListAccessPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAccessPoliciesPagedResponse((ListAccessPoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAccessPoliciesPagedResponse(ListAccessPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAccessPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }
}

