/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iam.admin.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.iam.admin.v1.IAMClient;
import com.google.cloud.iam.admin.v1.stub.GrpcIAMStub;
import com.google.cloud.iam.admin.v1.stub.IAMStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.admin.v1.CreateRoleRequest;
import com.google.iam.admin.v1.CreateServiceAccountKeyRequest;
import com.google.iam.admin.v1.CreateServiceAccountRequest;
import com.google.iam.admin.v1.DeleteRoleRequest;
import com.google.iam.admin.v1.DeleteServiceAccountKeyRequest;
import com.google.iam.admin.v1.DeleteServiceAccountRequest;
import com.google.iam.admin.v1.DisableServiceAccountRequest;
import com.google.iam.admin.v1.EnableServiceAccountRequest;
import com.google.iam.admin.v1.GetRoleRequest;
import com.google.iam.admin.v1.GetServiceAccountKeyRequest;
import com.google.iam.admin.v1.GetServiceAccountRequest;
import com.google.iam.admin.v1.LintPolicyRequest;
import com.google.iam.admin.v1.LintPolicyResponse;
import com.google.iam.admin.v1.ListRolesRequest;
import com.google.iam.admin.v1.ListRolesResponse;
import com.google.iam.admin.v1.ListServiceAccountKeysRequest;
import com.google.iam.admin.v1.ListServiceAccountKeysResponse;
import com.google.iam.admin.v1.ListServiceAccountsRequest;
import com.google.iam.admin.v1.ListServiceAccountsResponse;
import com.google.iam.admin.v1.PatchServiceAccountRequest;
import com.google.iam.admin.v1.Permission;
import com.google.iam.admin.v1.QueryAuditableServicesRequest;
import com.google.iam.admin.v1.QueryAuditableServicesResponse;
import com.google.iam.admin.v1.QueryGrantableRolesRequest;
import com.google.iam.admin.v1.QueryGrantableRolesResponse;
import com.google.iam.admin.v1.QueryTestablePermissionsRequest;
import com.google.iam.admin.v1.QueryTestablePermissionsResponse;
import com.google.iam.admin.v1.Role;
import com.google.iam.admin.v1.ServiceAccount;
import com.google.iam.admin.v1.ServiceAccountKey;
import com.google.iam.admin.v1.SignBlobRequest;
import com.google.iam.admin.v1.SignBlobResponse;
import com.google.iam.admin.v1.SignJwtRequest;
import com.google.iam.admin.v1.SignJwtResponse;
import com.google.iam.admin.v1.UndeleteRoleRequest;
import com.google.iam.admin.v1.UndeleteServiceAccountRequest;
import com.google.iam.admin.v1.UndeleteServiceAccountResponse;
import com.google.iam.admin.v1.UpdateRoleRequest;
import com.google.iam.admin.v1.UploadServiceAccountKeyRequest;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class IAMStubSettings
extends StubSettings<IAMStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListServiceAccountsRequest, ListServiceAccountsResponse, IAMClient.ListServiceAccountsPagedResponse> listServiceAccountsSettings;
    private final UnaryCallSettings<GetServiceAccountRequest, ServiceAccount> getServiceAccountSettings;
    private final UnaryCallSettings<CreateServiceAccountRequest, ServiceAccount> createServiceAccountSettings;
    private final UnaryCallSettings<ServiceAccount, ServiceAccount> updateServiceAccountSettings;
    private final UnaryCallSettings<PatchServiceAccountRequest, ServiceAccount> patchServiceAccountSettings;
    private final UnaryCallSettings<DeleteServiceAccountRequest, Empty> deleteServiceAccountSettings;
    private final UnaryCallSettings<UndeleteServiceAccountRequest, UndeleteServiceAccountResponse> undeleteServiceAccountSettings;
    private final UnaryCallSettings<EnableServiceAccountRequest, Empty> enableServiceAccountSettings;
    private final UnaryCallSettings<DisableServiceAccountRequest, Empty> disableServiceAccountSettings;
    private final UnaryCallSettings<ListServiceAccountKeysRequest, ListServiceAccountKeysResponse> listServiceAccountKeysSettings;
    private final UnaryCallSettings<GetServiceAccountKeyRequest, ServiceAccountKey> getServiceAccountKeySettings;
    private final UnaryCallSettings<CreateServiceAccountKeyRequest, ServiceAccountKey> createServiceAccountKeySettings;
    private final UnaryCallSettings<UploadServiceAccountKeyRequest, ServiceAccountKey> uploadServiceAccountKeySettings;
    private final UnaryCallSettings<DeleteServiceAccountKeyRequest, Empty> deleteServiceAccountKeySettings;
    private final UnaryCallSettings<SignBlobRequest, SignBlobResponse> signBlobSettings;
    private final UnaryCallSettings<SignJwtRequest, SignJwtResponse> signJwtSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private final PagedCallSettings<QueryGrantableRolesRequest, QueryGrantableRolesResponse, IAMClient.QueryGrantableRolesPagedResponse> queryGrantableRolesSettings;
    private final PagedCallSettings<ListRolesRequest, ListRolesResponse, IAMClient.ListRolesPagedResponse> listRolesSettings;
    private final UnaryCallSettings<GetRoleRequest, Role> getRoleSettings;
    private final UnaryCallSettings<CreateRoleRequest, Role> createRoleSettings;
    private final UnaryCallSettings<UpdateRoleRequest, Role> updateRoleSettings;
    private final UnaryCallSettings<DeleteRoleRequest, Role> deleteRoleSettings;
    private final UnaryCallSettings<UndeleteRoleRequest, Role> undeleteRoleSettings;
    private final PagedCallSettings<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse, IAMClient.QueryTestablePermissionsPagedResponse> queryTestablePermissionsSettings;
    private final UnaryCallSettings<QueryAuditableServicesRequest, QueryAuditableServicesResponse> queryAuditableServicesSettings;
    private final UnaryCallSettings<LintPolicyRequest, LintPolicyResponse> lintPolicySettings;
    private static final PagedListDescriptor<ListServiceAccountsRequest, ListServiceAccountsResponse, ServiceAccount> LIST_SERVICE_ACCOUNTS_PAGE_STR_DESC = new PagedListDescriptor<ListServiceAccountsRequest, ListServiceAccountsResponse, ServiceAccount>(){

        public String emptyToken() {
            return "";
        }

        public ListServiceAccountsRequest injectToken(ListServiceAccountsRequest payload, String token) {
            return ListServiceAccountsRequest.newBuilder((ListServiceAccountsRequest)payload).setPageToken(token).build();
        }

        public ListServiceAccountsRequest injectPageSize(ListServiceAccountsRequest payload, int pageSize) {
            return ListServiceAccountsRequest.newBuilder((ListServiceAccountsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServiceAccountsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServiceAccountsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ServiceAccount> extractResources(ListServiceAccountsResponse payload) {
            return payload.getAccountsList() == null ? ImmutableList.of() : payload.getAccountsList();
        }
    };
    private static final PagedListDescriptor<QueryGrantableRolesRequest, QueryGrantableRolesResponse, Role> QUERY_GRANTABLE_ROLES_PAGE_STR_DESC = new PagedListDescriptor<QueryGrantableRolesRequest, QueryGrantableRolesResponse, Role>(){

        public String emptyToken() {
            return "";
        }

        public QueryGrantableRolesRequest injectToken(QueryGrantableRolesRequest payload, String token) {
            return QueryGrantableRolesRequest.newBuilder((QueryGrantableRolesRequest)payload).setPageToken(token).build();
        }

        public QueryGrantableRolesRequest injectPageSize(QueryGrantableRolesRequest payload, int pageSize) {
            return QueryGrantableRolesRequest.newBuilder((QueryGrantableRolesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(QueryGrantableRolesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(QueryGrantableRolesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Role> extractResources(QueryGrantableRolesResponse payload) {
            return payload.getRolesList() == null ? ImmutableList.of() : payload.getRolesList();
        }
    };
    private static final PagedListDescriptor<ListRolesRequest, ListRolesResponse, Role> LIST_ROLES_PAGE_STR_DESC = new PagedListDescriptor<ListRolesRequest, ListRolesResponse, Role>(){

        public String emptyToken() {
            return "";
        }

        public ListRolesRequest injectToken(ListRolesRequest payload, String token) {
            return ListRolesRequest.newBuilder((ListRolesRequest)payload).setPageToken(token).build();
        }

        public ListRolesRequest injectPageSize(ListRolesRequest payload, int pageSize) {
            return ListRolesRequest.newBuilder((ListRolesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRolesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRolesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Role> extractResources(ListRolesResponse payload) {
            return payload.getRolesList() == null ? ImmutableList.of() : payload.getRolesList();
        }
    };
    private static final PagedListDescriptor<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse, Permission> QUERY_TESTABLE_PERMISSIONS_PAGE_STR_DESC = new PagedListDescriptor<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse, Permission>(){

        public String emptyToken() {
            return "";
        }

        public QueryTestablePermissionsRequest injectToken(QueryTestablePermissionsRequest payload, String token) {
            return QueryTestablePermissionsRequest.newBuilder((QueryTestablePermissionsRequest)payload).setPageToken(token).build();
        }

        public QueryTestablePermissionsRequest injectPageSize(QueryTestablePermissionsRequest payload, int pageSize) {
            return QueryTestablePermissionsRequest.newBuilder((QueryTestablePermissionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(QueryTestablePermissionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(QueryTestablePermissionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Permission> extractResources(QueryTestablePermissionsResponse payload) {
            return payload.getPermissionsList() == null ? ImmutableList.of() : payload.getPermissionsList();
        }
    };
    private static final PagedListResponseFactory<ListServiceAccountsRequest, ListServiceAccountsResponse, IAMClient.ListServiceAccountsPagedResponse> LIST_SERVICE_ACCOUNTS_PAGE_STR_FACT = new PagedListResponseFactory<ListServiceAccountsRequest, ListServiceAccountsResponse, IAMClient.ListServiceAccountsPagedResponse>(){

        public ApiFuture<IAMClient.ListServiceAccountsPagedResponse> getFuturePagedResponse(UnaryCallable<ListServiceAccountsRequest, ListServiceAccountsResponse> callable, ListServiceAccountsRequest request, ApiCallContext context, ApiFuture<ListServiceAccountsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICE_ACCOUNTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return IAMClient.ListServiceAccountsPagedResponse.createAsync((PageContext<ListServiceAccountsRequest, ListServiceAccountsResponse, ServiceAccount>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<QueryGrantableRolesRequest, QueryGrantableRolesResponse, IAMClient.QueryGrantableRolesPagedResponse> QUERY_GRANTABLE_ROLES_PAGE_STR_FACT = new PagedListResponseFactory<QueryGrantableRolesRequest, QueryGrantableRolesResponse, IAMClient.QueryGrantableRolesPagedResponse>(){

        public ApiFuture<IAMClient.QueryGrantableRolesPagedResponse> getFuturePagedResponse(UnaryCallable<QueryGrantableRolesRequest, QueryGrantableRolesResponse> callable, QueryGrantableRolesRequest request, ApiCallContext context, ApiFuture<QueryGrantableRolesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)QUERY_GRANTABLE_ROLES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return IAMClient.QueryGrantableRolesPagedResponse.createAsync((PageContext<QueryGrantableRolesRequest, QueryGrantableRolesResponse, Role>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRolesRequest, ListRolesResponse, IAMClient.ListRolesPagedResponse> LIST_ROLES_PAGE_STR_FACT = new PagedListResponseFactory<ListRolesRequest, ListRolesResponse, IAMClient.ListRolesPagedResponse>(){

        public ApiFuture<IAMClient.ListRolesPagedResponse> getFuturePagedResponse(UnaryCallable<ListRolesRequest, ListRolesResponse> callable, ListRolesRequest request, ApiCallContext context, ApiFuture<ListRolesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ROLES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return IAMClient.ListRolesPagedResponse.createAsync((PageContext<ListRolesRequest, ListRolesResponse, Role>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse, IAMClient.QueryTestablePermissionsPagedResponse> QUERY_TESTABLE_PERMISSIONS_PAGE_STR_FACT = new PagedListResponseFactory<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse, IAMClient.QueryTestablePermissionsPagedResponse>(){

        public ApiFuture<IAMClient.QueryTestablePermissionsPagedResponse> getFuturePagedResponse(UnaryCallable<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse> callable, QueryTestablePermissionsRequest request, ApiCallContext context, ApiFuture<QueryTestablePermissionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)QUERY_TESTABLE_PERMISSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return IAMClient.QueryTestablePermissionsPagedResponse.createAsync((PageContext<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse, Permission>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListServiceAccountsRequest, ListServiceAccountsResponse, IAMClient.ListServiceAccountsPagedResponse> listServiceAccountsSettings() {
        return this.listServiceAccountsSettings;
    }

    public UnaryCallSettings<GetServiceAccountRequest, ServiceAccount> getServiceAccountSettings() {
        return this.getServiceAccountSettings;
    }

    public UnaryCallSettings<CreateServiceAccountRequest, ServiceAccount> createServiceAccountSettings() {
        return this.createServiceAccountSettings;
    }

    public UnaryCallSettings<ServiceAccount, ServiceAccount> updateServiceAccountSettings() {
        return this.updateServiceAccountSettings;
    }

    public UnaryCallSettings<PatchServiceAccountRequest, ServiceAccount> patchServiceAccountSettings() {
        return this.patchServiceAccountSettings;
    }

    public UnaryCallSettings<DeleteServiceAccountRequest, Empty> deleteServiceAccountSettings() {
        return this.deleteServiceAccountSettings;
    }

    public UnaryCallSettings<UndeleteServiceAccountRequest, UndeleteServiceAccountResponse> undeleteServiceAccountSettings() {
        return this.undeleteServiceAccountSettings;
    }

    public UnaryCallSettings<EnableServiceAccountRequest, Empty> enableServiceAccountSettings() {
        return this.enableServiceAccountSettings;
    }

    public UnaryCallSettings<DisableServiceAccountRequest, Empty> disableServiceAccountSettings() {
        return this.disableServiceAccountSettings;
    }

    public UnaryCallSettings<ListServiceAccountKeysRequest, ListServiceAccountKeysResponse> listServiceAccountKeysSettings() {
        return this.listServiceAccountKeysSettings;
    }

    public UnaryCallSettings<GetServiceAccountKeyRequest, ServiceAccountKey> getServiceAccountKeySettings() {
        return this.getServiceAccountKeySettings;
    }

    public UnaryCallSettings<CreateServiceAccountKeyRequest, ServiceAccountKey> createServiceAccountKeySettings() {
        return this.createServiceAccountKeySettings;
    }

    public UnaryCallSettings<UploadServiceAccountKeyRequest, ServiceAccountKey> uploadServiceAccountKeySettings() {
        return this.uploadServiceAccountKeySettings;
    }

    public UnaryCallSettings<DeleteServiceAccountKeyRequest, Empty> deleteServiceAccountKeySettings() {
        return this.deleteServiceAccountKeySettings;
    }

    @Deprecated
    public UnaryCallSettings<SignBlobRequest, SignBlobResponse> signBlobSettings() {
        return this.signBlobSettings;
    }

    @Deprecated
    public UnaryCallSettings<SignJwtRequest, SignJwtResponse> signJwtSettings() {
        return this.signJwtSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public PagedCallSettings<QueryGrantableRolesRequest, QueryGrantableRolesResponse, IAMClient.QueryGrantableRolesPagedResponse> queryGrantableRolesSettings() {
        return this.queryGrantableRolesSettings;
    }

    public PagedCallSettings<ListRolesRequest, ListRolesResponse, IAMClient.ListRolesPagedResponse> listRolesSettings() {
        return this.listRolesSettings;
    }

    public UnaryCallSettings<GetRoleRequest, Role> getRoleSettings() {
        return this.getRoleSettings;
    }

    public UnaryCallSettings<CreateRoleRequest, Role> createRoleSettings() {
        return this.createRoleSettings;
    }

    public UnaryCallSettings<UpdateRoleRequest, Role> updateRoleSettings() {
        return this.updateRoleSettings;
    }

    public UnaryCallSettings<DeleteRoleRequest, Role> deleteRoleSettings() {
        return this.deleteRoleSettings;
    }

    public UnaryCallSettings<UndeleteRoleRequest, Role> undeleteRoleSettings() {
        return this.undeleteRoleSettings;
    }

    public PagedCallSettings<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse, IAMClient.QueryTestablePermissionsPagedResponse> queryTestablePermissionsSettings() {
        return this.queryTestablePermissionsSettings;
    }

    public UnaryCallSettings<QueryAuditableServicesRequest, QueryAuditableServicesResponse> queryAuditableServicesSettings() {
        return this.queryAuditableServicesSettings;
    }

    public UnaryCallSettings<LintPolicyRequest, LintPolicyResponse> lintPolicySettings() {
        return this.lintPolicySettings;
    }

    public IAMStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcIAMStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "iam.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "iam.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return IAMStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IAMStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected IAMStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listServiceAccountsSettings = settingsBuilder.listServiceAccountsSettings().build();
        this.getServiceAccountSettings = settingsBuilder.getServiceAccountSettings().build();
        this.createServiceAccountSettings = settingsBuilder.createServiceAccountSettings().build();
        this.updateServiceAccountSettings = settingsBuilder.updateServiceAccountSettings().build();
        this.patchServiceAccountSettings = settingsBuilder.patchServiceAccountSettings().build();
        this.deleteServiceAccountSettings = settingsBuilder.deleteServiceAccountSettings().build();
        this.undeleteServiceAccountSettings = settingsBuilder.undeleteServiceAccountSettings().build();
        this.enableServiceAccountSettings = settingsBuilder.enableServiceAccountSettings().build();
        this.disableServiceAccountSettings = settingsBuilder.disableServiceAccountSettings().build();
        this.listServiceAccountKeysSettings = settingsBuilder.listServiceAccountKeysSettings().build();
        this.getServiceAccountKeySettings = settingsBuilder.getServiceAccountKeySettings().build();
        this.createServiceAccountKeySettings = settingsBuilder.createServiceAccountKeySettings().build();
        this.uploadServiceAccountKeySettings = settingsBuilder.uploadServiceAccountKeySettings().build();
        this.deleteServiceAccountKeySettings = settingsBuilder.deleteServiceAccountKeySettings().build();
        this.signBlobSettings = settingsBuilder.signBlobSettings().build();
        this.signJwtSettings = settingsBuilder.signJwtSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
        this.queryGrantableRolesSettings = settingsBuilder.queryGrantableRolesSettings().build();
        this.listRolesSettings = settingsBuilder.listRolesSettings().build();
        this.getRoleSettings = settingsBuilder.getRoleSettings().build();
        this.createRoleSettings = settingsBuilder.createRoleSettings().build();
        this.updateRoleSettings = settingsBuilder.updateRoleSettings().build();
        this.deleteRoleSettings = settingsBuilder.deleteRoleSettings().build();
        this.undeleteRoleSettings = settingsBuilder.undeleteRoleSettings().build();
        this.queryTestablePermissionsSettings = settingsBuilder.queryTestablePermissionsSettings().build();
        this.queryAuditableServicesSettings = settingsBuilder.queryAuditableServicesSettings().build();
        this.lintPolicySettings = settingsBuilder.lintPolicySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<IAMStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListServiceAccountsRequest, ListServiceAccountsResponse, IAMClient.ListServiceAccountsPagedResponse> listServiceAccountsSettings;
        private final UnaryCallSettings.Builder<GetServiceAccountRequest, ServiceAccount> getServiceAccountSettings;
        private final UnaryCallSettings.Builder<CreateServiceAccountRequest, ServiceAccount> createServiceAccountSettings;
        private final UnaryCallSettings.Builder<ServiceAccount, ServiceAccount> updateServiceAccountSettings;
        private final UnaryCallSettings.Builder<PatchServiceAccountRequest, ServiceAccount> patchServiceAccountSettings;
        private final UnaryCallSettings.Builder<DeleteServiceAccountRequest, Empty> deleteServiceAccountSettings;
        private final UnaryCallSettings.Builder<UndeleteServiceAccountRequest, UndeleteServiceAccountResponse> undeleteServiceAccountSettings;
        private final UnaryCallSettings.Builder<EnableServiceAccountRequest, Empty> enableServiceAccountSettings;
        private final UnaryCallSettings.Builder<DisableServiceAccountRequest, Empty> disableServiceAccountSettings;
        private final UnaryCallSettings.Builder<ListServiceAccountKeysRequest, ListServiceAccountKeysResponse> listServiceAccountKeysSettings;
        private final UnaryCallSettings.Builder<GetServiceAccountKeyRequest, ServiceAccountKey> getServiceAccountKeySettings;
        private final UnaryCallSettings.Builder<CreateServiceAccountKeyRequest, ServiceAccountKey> createServiceAccountKeySettings;
        private final UnaryCallSettings.Builder<UploadServiceAccountKeyRequest, ServiceAccountKey> uploadServiceAccountKeySettings;
        private final UnaryCallSettings.Builder<DeleteServiceAccountKeyRequest, Empty> deleteServiceAccountKeySettings;
        private final UnaryCallSettings.Builder<SignBlobRequest, SignBlobResponse> signBlobSettings;
        private final UnaryCallSettings.Builder<SignJwtRequest, SignJwtResponse> signJwtSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private final PagedCallSettings.Builder<QueryGrantableRolesRequest, QueryGrantableRolesResponse, IAMClient.QueryGrantableRolesPagedResponse> queryGrantableRolesSettings;
        private final PagedCallSettings.Builder<ListRolesRequest, ListRolesResponse, IAMClient.ListRolesPagedResponse> listRolesSettings;
        private final UnaryCallSettings.Builder<GetRoleRequest, Role> getRoleSettings;
        private final UnaryCallSettings.Builder<CreateRoleRequest, Role> createRoleSettings;
        private final UnaryCallSettings.Builder<UpdateRoleRequest, Role> updateRoleSettings;
        private final UnaryCallSettings.Builder<DeleteRoleRequest, Role> deleteRoleSettings;
        private final UnaryCallSettings.Builder<UndeleteRoleRequest, Role> undeleteRoleSettings;
        private final PagedCallSettings.Builder<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse, IAMClient.QueryTestablePermissionsPagedResponse> queryTestablePermissionsSettings;
        private final UnaryCallSettings.Builder<QueryAuditableServicesRequest, QueryAuditableServicesResponse> queryAuditableServicesSettings;
        private final UnaryCallSettings.Builder<LintPolicyRequest, LintPolicyResponse> lintPolicySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listServiceAccountsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICE_ACCOUNTS_PAGE_STR_FACT);
            this.getServiceAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateServiceAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchServiceAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeleteServiceAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.enableServiceAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.disableServiceAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listServiceAccountKeysSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getServiceAccountKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceAccountKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.uploadServiceAccountKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceAccountKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.signBlobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.signJwtSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.queryGrantableRolesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)QUERY_GRANTABLE_ROLES_PAGE_STR_FACT);
            this.listRolesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ROLES_PAGE_STR_FACT);
            this.getRoleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRoleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRoleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRoleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeleteRoleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.queryTestablePermissionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)QUERY_TESTABLE_PERMISSIONS_PAGE_STR_FACT);
            this.queryAuditableServicesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.lintPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listServiceAccountsSettings, this.getServiceAccountSettings, this.createServiceAccountSettings, this.updateServiceAccountSettings, this.patchServiceAccountSettings, this.deleteServiceAccountSettings, this.undeleteServiceAccountSettings, this.enableServiceAccountSettings, this.disableServiceAccountSettings, this.listServiceAccountKeysSettings, this.getServiceAccountKeySettings, this.createServiceAccountKeySettings, (Object[])new UnaryCallSettings.Builder[]{this.uploadServiceAccountKeySettings, this.deleteServiceAccountKeySettings, this.signBlobSettings, this.signJwtSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings, this.queryGrantableRolesSettings, this.listRolesSettings, this.getRoleSettings, this.createRoleSettings, this.updateRoleSettings, this.deleteRoleSettings, this.undeleteRoleSettings, this.queryTestablePermissionsSettings, this.queryAuditableServicesSettings, this.lintPolicySettings});
            Builder.initDefaults(this);
        }

        protected Builder(IAMStubSettings settings) {
            super((StubSettings)settings);
            this.listServiceAccountsSettings = settings.listServiceAccountsSettings.toBuilder();
            this.getServiceAccountSettings = settings.getServiceAccountSettings.toBuilder();
            this.createServiceAccountSettings = settings.createServiceAccountSettings.toBuilder();
            this.updateServiceAccountSettings = settings.updateServiceAccountSettings.toBuilder();
            this.patchServiceAccountSettings = settings.patchServiceAccountSettings.toBuilder();
            this.deleteServiceAccountSettings = settings.deleteServiceAccountSettings.toBuilder();
            this.undeleteServiceAccountSettings = settings.undeleteServiceAccountSettings.toBuilder();
            this.enableServiceAccountSettings = settings.enableServiceAccountSettings.toBuilder();
            this.disableServiceAccountSettings = settings.disableServiceAccountSettings.toBuilder();
            this.listServiceAccountKeysSettings = settings.listServiceAccountKeysSettings.toBuilder();
            this.getServiceAccountKeySettings = settings.getServiceAccountKeySettings.toBuilder();
            this.createServiceAccountKeySettings = settings.createServiceAccountKeySettings.toBuilder();
            this.uploadServiceAccountKeySettings = settings.uploadServiceAccountKeySettings.toBuilder();
            this.deleteServiceAccountKeySettings = settings.deleteServiceAccountKeySettings.toBuilder();
            this.signBlobSettings = settings.signBlobSettings.toBuilder();
            this.signJwtSettings = settings.signJwtSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.queryGrantableRolesSettings = settings.queryGrantableRolesSettings.toBuilder();
            this.listRolesSettings = settings.listRolesSettings.toBuilder();
            this.getRoleSettings = settings.getRoleSettings.toBuilder();
            this.createRoleSettings = settings.createRoleSettings.toBuilder();
            this.updateRoleSettings = settings.updateRoleSettings.toBuilder();
            this.deleteRoleSettings = settings.deleteRoleSettings.toBuilder();
            this.undeleteRoleSettings = settings.undeleteRoleSettings.toBuilder();
            this.queryTestablePermissionsSettings = settings.queryTestablePermissionsSettings.toBuilder();
            this.queryAuditableServicesSettings = settings.queryAuditableServicesSettings.toBuilder();
            this.lintPolicySettings = settings.lintPolicySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listServiceAccountsSettings, this.getServiceAccountSettings, this.createServiceAccountSettings, this.updateServiceAccountSettings, this.patchServiceAccountSettings, this.deleteServiceAccountSettings, this.undeleteServiceAccountSettings, this.enableServiceAccountSettings, this.disableServiceAccountSettings, this.listServiceAccountKeysSettings, this.getServiceAccountKeySettings, this.createServiceAccountKeySettings, (Object[])new UnaryCallSettings.Builder[]{this.uploadServiceAccountKeySettings, this.deleteServiceAccountKeySettings, this.signBlobSettings, this.signJwtSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings, this.queryGrantableRolesSettings, this.listRolesSettings, this.getRoleSettings, this.createRoleSettings, this.updateRoleSettings, this.deleteRoleSettings, this.undeleteRoleSettings, this.queryTestablePermissionsSettings, this.queryAuditableServicesSettings, this.lintPolicySettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(IAMStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)IAMStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IAMStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(IAMStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(IAMStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listServiceAccountsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getServiceAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createServiceAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateServiceAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchServiceAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteServiceAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.undeleteServiceAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.enableServiceAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.disableServiceAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listServiceAccountKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getServiceAccountKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createServiceAccountKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.uploadServiceAccountKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteServiceAccountKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.signBlobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.signJwtSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.queryGrantableRolesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listRolesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getRoleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createRoleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateRoleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteRoleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.undeleteRoleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.queryTestablePermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.queryAuditableServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.lintPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListServiceAccountsRequest, ListServiceAccountsResponse, IAMClient.ListServiceAccountsPagedResponse> listServiceAccountsSettings() {
            return this.listServiceAccountsSettings;
        }

        public UnaryCallSettings.Builder<GetServiceAccountRequest, ServiceAccount> getServiceAccountSettings() {
            return this.getServiceAccountSettings;
        }

        public UnaryCallSettings.Builder<CreateServiceAccountRequest, ServiceAccount> createServiceAccountSettings() {
            return this.createServiceAccountSettings;
        }

        public UnaryCallSettings.Builder<ServiceAccount, ServiceAccount> updateServiceAccountSettings() {
            return this.updateServiceAccountSettings;
        }

        public UnaryCallSettings.Builder<PatchServiceAccountRequest, ServiceAccount> patchServiceAccountSettings() {
            return this.patchServiceAccountSettings;
        }

        public UnaryCallSettings.Builder<DeleteServiceAccountRequest, Empty> deleteServiceAccountSettings() {
            return this.deleteServiceAccountSettings;
        }

        public UnaryCallSettings.Builder<UndeleteServiceAccountRequest, UndeleteServiceAccountResponse> undeleteServiceAccountSettings() {
            return this.undeleteServiceAccountSettings;
        }

        public UnaryCallSettings.Builder<EnableServiceAccountRequest, Empty> enableServiceAccountSettings() {
            return this.enableServiceAccountSettings;
        }

        public UnaryCallSettings.Builder<DisableServiceAccountRequest, Empty> disableServiceAccountSettings() {
            return this.disableServiceAccountSettings;
        }

        public UnaryCallSettings.Builder<ListServiceAccountKeysRequest, ListServiceAccountKeysResponse> listServiceAccountKeysSettings() {
            return this.listServiceAccountKeysSettings;
        }

        public UnaryCallSettings.Builder<GetServiceAccountKeyRequest, ServiceAccountKey> getServiceAccountKeySettings() {
            return this.getServiceAccountKeySettings;
        }

        public UnaryCallSettings.Builder<CreateServiceAccountKeyRequest, ServiceAccountKey> createServiceAccountKeySettings() {
            return this.createServiceAccountKeySettings;
        }

        public UnaryCallSettings.Builder<UploadServiceAccountKeyRequest, ServiceAccountKey> uploadServiceAccountKeySettings() {
            return this.uploadServiceAccountKeySettings;
        }

        public UnaryCallSettings.Builder<DeleteServiceAccountKeyRequest, Empty> deleteServiceAccountKeySettings() {
            return this.deleteServiceAccountKeySettings;
        }

        @Deprecated
        public UnaryCallSettings.Builder<SignBlobRequest, SignBlobResponse> signBlobSettings() {
            return this.signBlobSettings;
        }

        @Deprecated
        public UnaryCallSettings.Builder<SignJwtRequest, SignJwtResponse> signJwtSettings() {
            return this.signJwtSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public PagedCallSettings.Builder<QueryGrantableRolesRequest, QueryGrantableRolesResponse, IAMClient.QueryGrantableRolesPagedResponse> queryGrantableRolesSettings() {
            return this.queryGrantableRolesSettings;
        }

        public PagedCallSettings.Builder<ListRolesRequest, ListRolesResponse, IAMClient.ListRolesPagedResponse> listRolesSettings() {
            return this.listRolesSettings;
        }

        public UnaryCallSettings.Builder<GetRoleRequest, Role> getRoleSettings() {
            return this.getRoleSettings;
        }

        public UnaryCallSettings.Builder<CreateRoleRequest, Role> createRoleSettings() {
            return this.createRoleSettings;
        }

        public UnaryCallSettings.Builder<UpdateRoleRequest, Role> updateRoleSettings() {
            return this.updateRoleSettings;
        }

        public UnaryCallSettings.Builder<DeleteRoleRequest, Role> deleteRoleSettings() {
            return this.deleteRoleSettings;
        }

        public UnaryCallSettings.Builder<UndeleteRoleRequest, Role> undeleteRoleSettings() {
            return this.undeleteRoleSettings;
        }

        public PagedCallSettings.Builder<QueryTestablePermissionsRequest, QueryTestablePermissionsResponse, IAMClient.QueryTestablePermissionsPagedResponse> queryTestablePermissionsSettings() {
            return this.queryTestablePermissionsSettings;
        }

        public UnaryCallSettings.Builder<QueryAuditableServicesRequest, QueryAuditableServicesResponse> queryAuditableServicesSettings() {
            return this.queryAuditableServicesSettings;
        }

        public UnaryCallSettings.Builder<LintPolicyRequest, LintPolicyResponse> lintPolicySettings() {
            return this.lintPolicySettings;
        }

        public IAMStubSettings build() throws IOException {
            return new IAMStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

