/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workstations.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.workstations.v1.CreateWorkstationClusterRequest;
import com.google.cloud.workstations.v1.CreateWorkstationConfigRequest;
import com.google.cloud.workstations.v1.CreateWorkstationRequest;
import com.google.cloud.workstations.v1.DeleteWorkstationClusterRequest;
import com.google.cloud.workstations.v1.DeleteWorkstationConfigRequest;
import com.google.cloud.workstations.v1.DeleteWorkstationRequest;
import com.google.cloud.workstations.v1.GenerateAccessTokenRequest;
import com.google.cloud.workstations.v1.GenerateAccessTokenResponse;
import com.google.cloud.workstations.v1.GetWorkstationClusterRequest;
import com.google.cloud.workstations.v1.GetWorkstationConfigRequest;
import com.google.cloud.workstations.v1.GetWorkstationRequest;
import com.google.cloud.workstations.v1.ListUsableWorkstationConfigsRequest;
import com.google.cloud.workstations.v1.ListUsableWorkstationConfigsResponse;
import com.google.cloud.workstations.v1.ListUsableWorkstationsRequest;
import com.google.cloud.workstations.v1.ListUsableWorkstationsResponse;
import com.google.cloud.workstations.v1.ListWorkstationClustersRequest;
import com.google.cloud.workstations.v1.ListWorkstationClustersResponse;
import com.google.cloud.workstations.v1.ListWorkstationConfigsRequest;
import com.google.cloud.workstations.v1.ListWorkstationConfigsResponse;
import com.google.cloud.workstations.v1.ListWorkstationsRequest;
import com.google.cloud.workstations.v1.ListWorkstationsResponse;
import com.google.cloud.workstations.v1.OperationMetadata;
import com.google.cloud.workstations.v1.StartWorkstationRequest;
import com.google.cloud.workstations.v1.StopWorkstationRequest;
import com.google.cloud.workstations.v1.UpdateWorkstationClusterRequest;
import com.google.cloud.workstations.v1.UpdateWorkstationConfigRequest;
import com.google.cloud.workstations.v1.UpdateWorkstationRequest;
import com.google.cloud.workstations.v1.Workstation;
import com.google.cloud.workstations.v1.WorkstationCluster;
import com.google.cloud.workstations.v1.WorkstationConfig;
import com.google.cloud.workstations.v1.WorkstationsClient;
import com.google.cloud.workstations.v1.stub.HttpJsonWorkstationsCallableFactory;
import com.google.cloud.workstations.v1.stub.WorkstationsStub;
import com.google.cloud.workstations.v1.stub.WorkstationsStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonWorkstationsStub
extends WorkstationsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(OperationMetadata.getDescriptor()).add(WorkstationCluster.getDescriptor()).add(WorkstationConfig.getDescriptor()).add(Workstation.getDescriptor()).build();
    private static final ApiMethodDescriptor<GetWorkstationClusterRequest, WorkstationCluster> getWorkstationClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/GetWorkstationCluster").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/workstationClusters/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)WorkstationCluster.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListWorkstationClustersRequest, ListWorkstationClustersResponse> listWorkstationClustersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/ListWorkstationClusters").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/workstationClusters", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListWorkstationClustersResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateWorkstationClusterRequest, Operation> createWorkstationClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/CreateWorkstationCluster").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/workstationClusters", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "workstationClusterId", (Object)request.getWorkstationClusterId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("workstationCluster", (Message)request.getWorkstationCluster(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateWorkstationClusterRequest, Operation> updateWorkstationClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/UpdateWorkstationCluster").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{workstationCluster.name=projects/*/locations/*/workstationClusters/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "workstationCluster.name", (Object)request.getWorkstationCluster().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("workstationCluster", (Message)request.getWorkstationCluster(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteWorkstationClusterRequest, Operation> deleteWorkstationClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/DeleteWorkstationCluster").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/workstationClusters/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "force", (Object)request.getForce());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetWorkstationConfigRequest, WorkstationConfig> getWorkstationConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/GetWorkstationConfig").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/workstationClusters/*/workstationConfigs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)WorkstationConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse> listWorkstationConfigsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/ListWorkstationConfigs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/workstationClusters/*}/workstationConfigs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListWorkstationConfigsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse> listUsableWorkstationConfigsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/ListUsableWorkstationConfigs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/workstationClusters/*}/workstationConfigs:listUsable", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListUsableWorkstationConfigsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateWorkstationConfigRequest, Operation> createWorkstationConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/CreateWorkstationConfig").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/workstationClusters/*}/workstationConfigs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "workstationConfigId", (Object)request.getWorkstationConfigId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("workstationConfig", (Message)request.getWorkstationConfig(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateWorkstationConfigRequest, Operation> updateWorkstationConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/UpdateWorkstationConfig").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{workstationConfig.name=projects/*/locations/*/workstationClusters/*/workstationConfigs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "workstationConfig.name", (Object)request.getWorkstationConfig().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("workstationConfig", (Message)request.getWorkstationConfig(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteWorkstationConfigRequest, Operation> deleteWorkstationConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/DeleteWorkstationConfig").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/workstationClusters/*/workstationConfigs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "force", (Object)request.getForce());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetWorkstationRequest, Workstation> getWorkstationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/GetWorkstation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/workstationClusters/*/workstationConfigs/*/workstations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Workstation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListWorkstationsRequest, ListWorkstationsResponse> listWorkstationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/ListWorkstations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/workstationClusters/*/workstationConfigs/*}/workstations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListWorkstationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse> listUsableWorkstationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/ListUsableWorkstations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/workstationClusters/*/workstationConfigs/*}/workstations:listUsable", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListUsableWorkstationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateWorkstationRequest, Operation> createWorkstationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/CreateWorkstation").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/workstationClusters/*/workstationConfigs/*}/workstations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "workstationId", (Object)request.getWorkstationId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("workstation", (Message)request.getWorkstation(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateWorkstationRequest, Operation> updateWorkstationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/UpdateWorkstation").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{workstation.name=projects/*/locations/*/workstationClusters/*/workstationConfigs/*/workstations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "workstation.name", (Object)request.getWorkstation().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("workstation", (Message)request.getWorkstation(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteWorkstationRequest, Operation> deleteWorkstationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/DeleteWorkstation").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/workstationClusters/*/workstationConfigs/*/workstations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<StartWorkstationRequest, Operation> startWorkstationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/StartWorkstation").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/workstationClusters/*/workstationConfigs/*/workstations/*}:start", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<StopWorkstationRequest, Operation> stopWorkstationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/StopWorkstation").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/workstationClusters/*/workstationConfigs/*/workstations/*}:stop", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.workstations.v1.Workstations/GenerateAccessToken").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{workstation=projects/*/locations/*/workstationClusters/*/workstationConfigs/*/workstations/*}:generateAccessToken", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "workstation", (Object)request.getWorkstation());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearWorkstation().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GenerateAccessTokenResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/locations/*/workstationClusters/*/workstationConfigs/*}:setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/locations/*/workstationClusters/*/workstationConfigs/*/workstations/*}:setIamPolicy"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/locations/*/workstationClusters/*/workstationConfigs/*}:getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/locations/*/workstationClusters/*/workstationConfigs/*/workstations/*}:getIamPolicy"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/locations/*/workstationClusters/*/workstationConfigs/*}:testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/locations/*/workstationClusters/*/workstationConfigs/*/workstations/*}:testIamPermissions"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetWorkstationClusterRequest, WorkstationCluster> getWorkstationClusterCallable;
    private final UnaryCallable<ListWorkstationClustersRequest, ListWorkstationClustersResponse> listWorkstationClustersCallable;
    private final UnaryCallable<ListWorkstationClustersRequest, WorkstationsClient.ListWorkstationClustersPagedResponse> listWorkstationClustersPagedCallable;
    private final UnaryCallable<CreateWorkstationClusterRequest, Operation> createWorkstationClusterCallable;
    private final OperationCallable<CreateWorkstationClusterRequest, WorkstationCluster, OperationMetadata> createWorkstationClusterOperationCallable;
    private final UnaryCallable<UpdateWorkstationClusterRequest, Operation> updateWorkstationClusterCallable;
    private final OperationCallable<UpdateWorkstationClusterRequest, WorkstationCluster, OperationMetadata> updateWorkstationClusterOperationCallable;
    private final UnaryCallable<DeleteWorkstationClusterRequest, Operation> deleteWorkstationClusterCallable;
    private final OperationCallable<DeleteWorkstationClusterRequest, WorkstationCluster, OperationMetadata> deleteWorkstationClusterOperationCallable;
    private final UnaryCallable<GetWorkstationConfigRequest, WorkstationConfig> getWorkstationConfigCallable;
    private final UnaryCallable<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse> listWorkstationConfigsCallable;
    private final UnaryCallable<ListWorkstationConfigsRequest, WorkstationsClient.ListWorkstationConfigsPagedResponse> listWorkstationConfigsPagedCallable;
    private final UnaryCallable<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse> listUsableWorkstationConfigsCallable;
    private final UnaryCallable<ListUsableWorkstationConfigsRequest, WorkstationsClient.ListUsableWorkstationConfigsPagedResponse> listUsableWorkstationConfigsPagedCallable;
    private final UnaryCallable<CreateWorkstationConfigRequest, Operation> createWorkstationConfigCallable;
    private final OperationCallable<CreateWorkstationConfigRequest, WorkstationConfig, OperationMetadata> createWorkstationConfigOperationCallable;
    private final UnaryCallable<UpdateWorkstationConfigRequest, Operation> updateWorkstationConfigCallable;
    private final OperationCallable<UpdateWorkstationConfigRequest, WorkstationConfig, OperationMetadata> updateWorkstationConfigOperationCallable;
    private final UnaryCallable<DeleteWorkstationConfigRequest, Operation> deleteWorkstationConfigCallable;
    private final OperationCallable<DeleteWorkstationConfigRequest, WorkstationConfig, OperationMetadata> deleteWorkstationConfigOperationCallable;
    private final UnaryCallable<GetWorkstationRequest, Workstation> getWorkstationCallable;
    private final UnaryCallable<ListWorkstationsRequest, ListWorkstationsResponse> listWorkstationsCallable;
    private final UnaryCallable<ListWorkstationsRequest, WorkstationsClient.ListWorkstationsPagedResponse> listWorkstationsPagedCallable;
    private final UnaryCallable<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse> listUsableWorkstationsCallable;
    private final UnaryCallable<ListUsableWorkstationsRequest, WorkstationsClient.ListUsableWorkstationsPagedResponse> listUsableWorkstationsPagedCallable;
    private final UnaryCallable<CreateWorkstationRequest, Operation> createWorkstationCallable;
    private final OperationCallable<CreateWorkstationRequest, Workstation, OperationMetadata> createWorkstationOperationCallable;
    private final UnaryCallable<UpdateWorkstationRequest, Operation> updateWorkstationCallable;
    private final OperationCallable<UpdateWorkstationRequest, Workstation, OperationMetadata> updateWorkstationOperationCallable;
    private final UnaryCallable<DeleteWorkstationRequest, Operation> deleteWorkstationCallable;
    private final OperationCallable<DeleteWorkstationRequest, Workstation, OperationMetadata> deleteWorkstationOperationCallable;
    private final UnaryCallable<StartWorkstationRequest, Operation> startWorkstationCallable;
    private final OperationCallable<StartWorkstationRequest, Workstation, OperationMetadata> startWorkstationOperationCallable;
    private final UnaryCallable<StopWorkstationRequest, Operation> stopWorkstationCallable;
    private final OperationCallable<StopWorkstationRequest, Workstation, OperationMetadata> stopWorkstationOperationCallable;
    private final UnaryCallable<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonWorkstationsStub create(WorkstationsStubSettings settings) throws IOException {
        return new HttpJsonWorkstationsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonWorkstationsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonWorkstationsStub(WorkstationsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonWorkstationsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonWorkstationsStub(WorkstationsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonWorkstationsStub(WorkstationsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonWorkstationsCallableFactory());
    }

    protected HttpJsonWorkstationsStub(WorkstationsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings getWorkstationClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getWorkstationClusterMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listWorkstationClustersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listWorkstationClustersMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createWorkstationClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createWorkstationClusterMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateWorkstationClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateWorkstationClusterMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("workstation_cluster.name", String.valueOf(request.getWorkstationCluster().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteWorkstationClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteWorkstationClusterMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getWorkstationConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getWorkstationConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listWorkstationConfigsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listWorkstationConfigsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listUsableWorkstationConfigsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listUsableWorkstationConfigsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createWorkstationConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createWorkstationConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateWorkstationConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateWorkstationConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("workstation_config.name", String.valueOf(request.getWorkstationConfig().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteWorkstationConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteWorkstationConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getWorkstationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getWorkstationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listWorkstationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listWorkstationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listUsableWorkstationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listUsableWorkstationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createWorkstationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createWorkstationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateWorkstationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateWorkstationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("workstation.name", String.valueOf(request.getWorkstation().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteWorkstationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteWorkstationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings startWorkstationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(startWorkstationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings stopWorkstationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(stopWorkstationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings generateAccessTokenTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(generateAccessTokenMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("workstation", String.valueOf(request.getWorkstation()));
            return builder.build();
        }).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.getWorkstationClusterCallable = callableFactory.createUnaryCallable(getWorkstationClusterTransportSettings, settings.getWorkstationClusterSettings(), clientContext);
        this.listWorkstationClustersCallable = callableFactory.createUnaryCallable(listWorkstationClustersTransportSettings, settings.listWorkstationClustersSettings(), clientContext);
        this.listWorkstationClustersPagedCallable = callableFactory.createPagedCallable(listWorkstationClustersTransportSettings, settings.listWorkstationClustersSettings(), clientContext);
        this.createWorkstationClusterCallable = callableFactory.createUnaryCallable(createWorkstationClusterTransportSettings, settings.createWorkstationClusterSettings(), clientContext);
        this.createWorkstationClusterOperationCallable = callableFactory.createOperationCallable(createWorkstationClusterTransportSettings, settings.createWorkstationClusterOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateWorkstationClusterCallable = callableFactory.createUnaryCallable(updateWorkstationClusterTransportSettings, settings.updateWorkstationClusterSettings(), clientContext);
        this.updateWorkstationClusterOperationCallable = callableFactory.createOperationCallable(updateWorkstationClusterTransportSettings, settings.updateWorkstationClusterOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteWorkstationClusterCallable = callableFactory.createUnaryCallable(deleteWorkstationClusterTransportSettings, settings.deleteWorkstationClusterSettings(), clientContext);
        this.deleteWorkstationClusterOperationCallable = callableFactory.createOperationCallable(deleteWorkstationClusterTransportSettings, settings.deleteWorkstationClusterOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getWorkstationConfigCallable = callableFactory.createUnaryCallable(getWorkstationConfigTransportSettings, settings.getWorkstationConfigSettings(), clientContext);
        this.listWorkstationConfigsCallable = callableFactory.createUnaryCallable(listWorkstationConfigsTransportSettings, settings.listWorkstationConfigsSettings(), clientContext);
        this.listWorkstationConfigsPagedCallable = callableFactory.createPagedCallable(listWorkstationConfigsTransportSettings, settings.listWorkstationConfigsSettings(), clientContext);
        this.listUsableWorkstationConfigsCallable = callableFactory.createUnaryCallable(listUsableWorkstationConfigsTransportSettings, settings.listUsableWorkstationConfigsSettings(), clientContext);
        this.listUsableWorkstationConfigsPagedCallable = callableFactory.createPagedCallable(listUsableWorkstationConfigsTransportSettings, settings.listUsableWorkstationConfigsSettings(), clientContext);
        this.createWorkstationConfigCallable = callableFactory.createUnaryCallable(createWorkstationConfigTransportSettings, settings.createWorkstationConfigSettings(), clientContext);
        this.createWorkstationConfigOperationCallable = callableFactory.createOperationCallable(createWorkstationConfigTransportSettings, settings.createWorkstationConfigOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateWorkstationConfigCallable = callableFactory.createUnaryCallable(updateWorkstationConfigTransportSettings, settings.updateWorkstationConfigSettings(), clientContext);
        this.updateWorkstationConfigOperationCallable = callableFactory.createOperationCallable(updateWorkstationConfigTransportSettings, settings.updateWorkstationConfigOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteWorkstationConfigCallable = callableFactory.createUnaryCallable(deleteWorkstationConfigTransportSettings, settings.deleteWorkstationConfigSettings(), clientContext);
        this.deleteWorkstationConfigOperationCallable = callableFactory.createOperationCallable(deleteWorkstationConfigTransportSettings, settings.deleteWorkstationConfigOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getWorkstationCallable = callableFactory.createUnaryCallable(getWorkstationTransportSettings, settings.getWorkstationSettings(), clientContext);
        this.listWorkstationsCallable = callableFactory.createUnaryCallable(listWorkstationsTransportSettings, settings.listWorkstationsSettings(), clientContext);
        this.listWorkstationsPagedCallable = callableFactory.createPagedCallable(listWorkstationsTransportSettings, settings.listWorkstationsSettings(), clientContext);
        this.listUsableWorkstationsCallable = callableFactory.createUnaryCallable(listUsableWorkstationsTransportSettings, settings.listUsableWorkstationsSettings(), clientContext);
        this.listUsableWorkstationsPagedCallable = callableFactory.createPagedCallable(listUsableWorkstationsTransportSettings, settings.listUsableWorkstationsSettings(), clientContext);
        this.createWorkstationCallable = callableFactory.createUnaryCallable(createWorkstationTransportSettings, settings.createWorkstationSettings(), clientContext);
        this.createWorkstationOperationCallable = callableFactory.createOperationCallable(createWorkstationTransportSettings, settings.createWorkstationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateWorkstationCallable = callableFactory.createUnaryCallable(updateWorkstationTransportSettings, settings.updateWorkstationSettings(), clientContext);
        this.updateWorkstationOperationCallable = callableFactory.createOperationCallable(updateWorkstationTransportSettings, settings.updateWorkstationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteWorkstationCallable = callableFactory.createUnaryCallable(deleteWorkstationTransportSettings, settings.deleteWorkstationSettings(), clientContext);
        this.deleteWorkstationOperationCallable = callableFactory.createOperationCallable(deleteWorkstationTransportSettings, settings.deleteWorkstationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.startWorkstationCallable = callableFactory.createUnaryCallable(startWorkstationTransportSettings, settings.startWorkstationSettings(), clientContext);
        this.startWorkstationOperationCallable = callableFactory.createOperationCallable(startWorkstationTransportSettings, settings.startWorkstationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.stopWorkstationCallable = callableFactory.createUnaryCallable(stopWorkstationTransportSettings, settings.stopWorkstationSettings(), clientContext);
        this.stopWorkstationOperationCallable = callableFactory.createOperationCallable(stopWorkstationTransportSettings, settings.stopWorkstationOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.generateAccessTokenCallable = callableFactory.createUnaryCallable(generateAccessTokenTransportSettings, settings.generateAccessTokenSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getWorkstationClusterMethodDescriptor);
        methodDescriptors.add(listWorkstationClustersMethodDescriptor);
        methodDescriptors.add(createWorkstationClusterMethodDescriptor);
        methodDescriptors.add(updateWorkstationClusterMethodDescriptor);
        methodDescriptors.add(deleteWorkstationClusterMethodDescriptor);
        methodDescriptors.add(getWorkstationConfigMethodDescriptor);
        methodDescriptors.add(listWorkstationConfigsMethodDescriptor);
        methodDescriptors.add(listUsableWorkstationConfigsMethodDescriptor);
        methodDescriptors.add(createWorkstationConfigMethodDescriptor);
        methodDescriptors.add(updateWorkstationConfigMethodDescriptor);
        methodDescriptors.add(deleteWorkstationConfigMethodDescriptor);
        methodDescriptors.add(getWorkstationMethodDescriptor);
        methodDescriptors.add(listWorkstationsMethodDescriptor);
        methodDescriptors.add(listUsableWorkstationsMethodDescriptor);
        methodDescriptors.add(createWorkstationMethodDescriptor);
        methodDescriptors.add(updateWorkstationMethodDescriptor);
        methodDescriptors.add(deleteWorkstationMethodDescriptor);
        methodDescriptors.add(startWorkstationMethodDescriptor);
        methodDescriptors.add(stopWorkstationMethodDescriptor);
        methodDescriptors.add(generateAccessTokenMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<GetWorkstationClusterRequest, WorkstationCluster> getWorkstationClusterCallable() {
        return this.getWorkstationClusterCallable;
    }

    @Override
    public UnaryCallable<ListWorkstationClustersRequest, ListWorkstationClustersResponse> listWorkstationClustersCallable() {
        return this.listWorkstationClustersCallable;
    }

    @Override
    public UnaryCallable<ListWorkstationClustersRequest, WorkstationsClient.ListWorkstationClustersPagedResponse> listWorkstationClustersPagedCallable() {
        return this.listWorkstationClustersPagedCallable;
    }

    @Override
    public UnaryCallable<CreateWorkstationClusterRequest, Operation> createWorkstationClusterCallable() {
        return this.createWorkstationClusterCallable;
    }

    @Override
    public OperationCallable<CreateWorkstationClusterRequest, WorkstationCluster, OperationMetadata> createWorkstationClusterOperationCallable() {
        return this.createWorkstationClusterOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateWorkstationClusterRequest, Operation> updateWorkstationClusterCallable() {
        return this.updateWorkstationClusterCallable;
    }

    @Override
    public OperationCallable<UpdateWorkstationClusterRequest, WorkstationCluster, OperationMetadata> updateWorkstationClusterOperationCallable() {
        return this.updateWorkstationClusterOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteWorkstationClusterRequest, Operation> deleteWorkstationClusterCallable() {
        return this.deleteWorkstationClusterCallable;
    }

    @Override
    public OperationCallable<DeleteWorkstationClusterRequest, WorkstationCluster, OperationMetadata> deleteWorkstationClusterOperationCallable() {
        return this.deleteWorkstationClusterOperationCallable;
    }

    @Override
    public UnaryCallable<GetWorkstationConfigRequest, WorkstationConfig> getWorkstationConfigCallable() {
        return this.getWorkstationConfigCallable;
    }

    @Override
    public UnaryCallable<ListWorkstationConfigsRequest, ListWorkstationConfigsResponse> listWorkstationConfigsCallable() {
        return this.listWorkstationConfigsCallable;
    }

    @Override
    public UnaryCallable<ListWorkstationConfigsRequest, WorkstationsClient.ListWorkstationConfigsPagedResponse> listWorkstationConfigsPagedCallable() {
        return this.listWorkstationConfigsPagedCallable;
    }

    @Override
    public UnaryCallable<ListUsableWorkstationConfigsRequest, ListUsableWorkstationConfigsResponse> listUsableWorkstationConfigsCallable() {
        return this.listUsableWorkstationConfigsCallable;
    }

    @Override
    public UnaryCallable<ListUsableWorkstationConfigsRequest, WorkstationsClient.ListUsableWorkstationConfigsPagedResponse> listUsableWorkstationConfigsPagedCallable() {
        return this.listUsableWorkstationConfigsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateWorkstationConfigRequest, Operation> createWorkstationConfigCallable() {
        return this.createWorkstationConfigCallable;
    }

    @Override
    public OperationCallable<CreateWorkstationConfigRequest, WorkstationConfig, OperationMetadata> createWorkstationConfigOperationCallable() {
        return this.createWorkstationConfigOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateWorkstationConfigRequest, Operation> updateWorkstationConfigCallable() {
        return this.updateWorkstationConfigCallable;
    }

    @Override
    public OperationCallable<UpdateWorkstationConfigRequest, WorkstationConfig, OperationMetadata> updateWorkstationConfigOperationCallable() {
        return this.updateWorkstationConfigOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteWorkstationConfigRequest, Operation> deleteWorkstationConfigCallable() {
        return this.deleteWorkstationConfigCallable;
    }

    @Override
    public OperationCallable<DeleteWorkstationConfigRequest, WorkstationConfig, OperationMetadata> deleteWorkstationConfigOperationCallable() {
        return this.deleteWorkstationConfigOperationCallable;
    }

    @Override
    public UnaryCallable<GetWorkstationRequest, Workstation> getWorkstationCallable() {
        return this.getWorkstationCallable;
    }

    @Override
    public UnaryCallable<ListWorkstationsRequest, ListWorkstationsResponse> listWorkstationsCallable() {
        return this.listWorkstationsCallable;
    }

    @Override
    public UnaryCallable<ListWorkstationsRequest, WorkstationsClient.ListWorkstationsPagedResponse> listWorkstationsPagedCallable() {
        return this.listWorkstationsPagedCallable;
    }

    @Override
    public UnaryCallable<ListUsableWorkstationsRequest, ListUsableWorkstationsResponse> listUsableWorkstationsCallable() {
        return this.listUsableWorkstationsCallable;
    }

    @Override
    public UnaryCallable<ListUsableWorkstationsRequest, WorkstationsClient.ListUsableWorkstationsPagedResponse> listUsableWorkstationsPagedCallable() {
        return this.listUsableWorkstationsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateWorkstationRequest, Operation> createWorkstationCallable() {
        return this.createWorkstationCallable;
    }

    @Override
    public OperationCallable<CreateWorkstationRequest, Workstation, OperationMetadata> createWorkstationOperationCallable() {
        return this.createWorkstationOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateWorkstationRequest, Operation> updateWorkstationCallable() {
        return this.updateWorkstationCallable;
    }

    @Override
    public OperationCallable<UpdateWorkstationRequest, Workstation, OperationMetadata> updateWorkstationOperationCallable() {
        return this.updateWorkstationOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteWorkstationRequest, Operation> deleteWorkstationCallable() {
        return this.deleteWorkstationCallable;
    }

    @Override
    public OperationCallable<DeleteWorkstationRequest, Workstation, OperationMetadata> deleteWorkstationOperationCallable() {
        return this.deleteWorkstationOperationCallable;
    }

    @Override
    public UnaryCallable<StartWorkstationRequest, Operation> startWorkstationCallable() {
        return this.startWorkstationCallable;
    }

    @Override
    public OperationCallable<StartWorkstationRequest, Workstation, OperationMetadata> startWorkstationOperationCallable() {
        return this.startWorkstationOperationCallable;
    }

    @Override
    public UnaryCallable<StopWorkstationRequest, Operation> stopWorkstationCallable() {
        return this.stopWorkstationCallable;
    }

    @Override
    public OperationCallable<StopWorkstationRequest, Workstation, OperationMetadata> stopWorkstationOperationCallable() {
        return this.stopWorkstationOperationCallable;
    }

    @Override
    public UnaryCallable<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenCallable() {
        return this.generateAccessTokenCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

