/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workflows.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.workflows.v1.CreateWorkflowRequest;
import com.google.cloud.workflows.v1.DeleteWorkflowRequest;
import com.google.cloud.workflows.v1.GetWorkflowRequest;
import com.google.cloud.workflows.v1.ListWorkflowsRequest;
import com.google.cloud.workflows.v1.ListWorkflowsResponse;
import com.google.cloud.workflows.v1.OperationMetadata;
import com.google.cloud.workflows.v1.UpdateWorkflowRequest;
import com.google.cloud.workflows.v1.Workflow;
import com.google.cloud.workflows.v1.WorkflowsClient;
import com.google.cloud.workflows.v1.stub.GrpcWorkflowsCallableFactory;
import com.google.cloud.workflows.v1.stub.WorkflowsStub;
import com.google.cloud.workflows.v1.stub.WorkflowsStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcWorkflowsStub
extends WorkflowsStub {
    private static final MethodDescriptor<ListWorkflowsRequest, ListWorkflowsResponse> listWorkflowsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.workflows.v1.Workflows/ListWorkflows").setRequestMarshaller(ProtoUtils.marshaller((Message)ListWorkflowsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListWorkflowsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetWorkflowRequest, Workflow> getWorkflowMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.workflows.v1.Workflows/GetWorkflow").setRequestMarshaller(ProtoUtils.marshaller((Message)GetWorkflowRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Workflow.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateWorkflowRequest, Operation> createWorkflowMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.workflows.v1.Workflows/CreateWorkflow").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateWorkflowRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteWorkflowRequest, Operation> deleteWorkflowMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.workflows.v1.Workflows/DeleteWorkflow").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteWorkflowRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateWorkflowRequest, Operation> updateWorkflowMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.workflows.v1.Workflows/UpdateWorkflow").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateWorkflowRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ListWorkflowsRequest, ListWorkflowsResponse> listWorkflowsCallable;
    private final UnaryCallable<ListWorkflowsRequest, WorkflowsClient.ListWorkflowsPagedResponse> listWorkflowsPagedCallable;
    private final UnaryCallable<GetWorkflowRequest, Workflow> getWorkflowCallable;
    private final UnaryCallable<CreateWorkflowRequest, Operation> createWorkflowCallable;
    private final OperationCallable<CreateWorkflowRequest, Workflow, OperationMetadata> createWorkflowOperationCallable;
    private final UnaryCallable<DeleteWorkflowRequest, Operation> deleteWorkflowCallable;
    private final OperationCallable<DeleteWorkflowRequest, Empty, OperationMetadata> deleteWorkflowOperationCallable;
    private final UnaryCallable<UpdateWorkflowRequest, Operation> updateWorkflowCallable;
    private final OperationCallable<UpdateWorkflowRequest, Workflow, OperationMetadata> updateWorkflowOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcWorkflowsStub create(WorkflowsStubSettings settings) throws IOException {
        return new GrpcWorkflowsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcWorkflowsStub create(ClientContext clientContext) throws IOException {
        return new GrpcWorkflowsStub(WorkflowsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcWorkflowsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcWorkflowsStub(WorkflowsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcWorkflowsStub(WorkflowsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcWorkflowsCallableFactory());
    }

    protected GrpcWorkflowsStub(WorkflowsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listWorkflowsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listWorkflowsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getWorkflowTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getWorkflowMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createWorkflowTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createWorkflowMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteWorkflowTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteWorkflowMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateWorkflowTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateWorkflowMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("workflow.name", String.valueOf(request.getWorkflow().getName()));
            return builder.build();
        }).build();
        this.listWorkflowsCallable = callableFactory.createUnaryCallable(listWorkflowsTransportSettings, settings.listWorkflowsSettings(), clientContext);
        this.listWorkflowsPagedCallable = callableFactory.createPagedCallable(listWorkflowsTransportSettings, settings.listWorkflowsSettings(), clientContext);
        this.getWorkflowCallable = callableFactory.createUnaryCallable(getWorkflowTransportSettings, settings.getWorkflowSettings(), clientContext);
        this.createWorkflowCallable = callableFactory.createUnaryCallable(createWorkflowTransportSettings, settings.createWorkflowSettings(), clientContext);
        this.createWorkflowOperationCallable = callableFactory.createOperationCallable(createWorkflowTransportSettings, settings.createWorkflowOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteWorkflowCallable = callableFactory.createUnaryCallable(deleteWorkflowTransportSettings, settings.deleteWorkflowSettings(), clientContext);
        this.deleteWorkflowOperationCallable = callableFactory.createOperationCallable(deleteWorkflowTransportSettings, settings.deleteWorkflowOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateWorkflowCallable = callableFactory.createUnaryCallable(updateWorkflowTransportSettings, settings.updateWorkflowSettings(), clientContext);
        this.updateWorkflowOperationCallable = callableFactory.createOperationCallable(updateWorkflowTransportSettings, settings.updateWorkflowOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListWorkflowsRequest, ListWorkflowsResponse> listWorkflowsCallable() {
        return this.listWorkflowsCallable;
    }

    @Override
    public UnaryCallable<ListWorkflowsRequest, WorkflowsClient.ListWorkflowsPagedResponse> listWorkflowsPagedCallable() {
        return this.listWorkflowsPagedCallable;
    }

    @Override
    public UnaryCallable<GetWorkflowRequest, Workflow> getWorkflowCallable() {
        return this.getWorkflowCallable;
    }

    @Override
    public UnaryCallable<CreateWorkflowRequest, Operation> createWorkflowCallable() {
        return this.createWorkflowCallable;
    }

    @Override
    public OperationCallable<CreateWorkflowRequest, Workflow, OperationMetadata> createWorkflowOperationCallable() {
        return this.createWorkflowOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteWorkflowRequest, Operation> deleteWorkflowCallable() {
        return this.deleteWorkflowCallable;
    }

    @Override
    public OperationCallable<DeleteWorkflowRequest, Empty, OperationMetadata> deleteWorkflowOperationCallable() {
        return this.deleteWorkflowOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateWorkflowRequest, Operation> updateWorkflowCallable() {
        return this.updateWorkflowCallable;
    }

    @Override
    public OperationCallable<UpdateWorkflowRequest, Workflow, OperationMetadata> updateWorkflowOperationCallable() {
        return this.updateWorkflowOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

