/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.workflows.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.workflows.v1beta.CreateWorkflowRequest;
import com.google.cloud.workflows.v1beta.DeleteWorkflowRequest;
import com.google.cloud.workflows.v1beta.GetWorkflowRequest;
import com.google.cloud.workflows.v1beta.ListWorkflowsRequest;
import com.google.cloud.workflows.v1beta.ListWorkflowsResponse;
import com.google.cloud.workflows.v1beta.LocationName;
import com.google.cloud.workflows.v1beta.OperationMetadata;
import com.google.cloud.workflows.v1beta.UpdateWorkflowRequest;
import com.google.cloud.workflows.v1beta.Workflow;
import com.google.cloud.workflows.v1beta.WorkflowName;
import com.google.cloud.workflows.v1beta.WorkflowsSettings;
import com.google.cloud.workflows.v1beta.stub.WorkflowsStub;
import com.google.cloud.workflows.v1beta.stub.WorkflowsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class WorkflowsClient
implements BackgroundResource {
    private final WorkflowsSettings settings;
    private final WorkflowsStub stub;
    private final OperationsClient operationsClient;

    public static final WorkflowsClient create() throws IOException {
        return WorkflowsClient.create(WorkflowsSettings.newBuilder().build());
    }

    public static final WorkflowsClient create(WorkflowsSettings settings) throws IOException {
        return new WorkflowsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final WorkflowsClient create(WorkflowsStub stub) {
        return new WorkflowsClient(stub);
    }

    protected WorkflowsClient(WorkflowsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((WorkflowsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected WorkflowsClient(WorkflowsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final WorkflowsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public WorkflowsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListWorkflowsPagedResponse listWorkflows(LocationName parent) {
        ListWorkflowsRequest request = ListWorkflowsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWorkflows(request);
    }

    public final ListWorkflowsPagedResponse listWorkflows(String parent) {
        ListWorkflowsRequest request = ListWorkflowsRequest.newBuilder().setParent(parent).build();
        return this.listWorkflows(request);
    }

    public final ListWorkflowsPagedResponse listWorkflows(ListWorkflowsRequest request) {
        return (ListWorkflowsPagedResponse)((Object)this.listWorkflowsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWorkflowsRequest, ListWorkflowsPagedResponse> listWorkflowsPagedCallable() {
        return this.stub.listWorkflowsPagedCallable();
    }

    public final UnaryCallable<ListWorkflowsRequest, ListWorkflowsResponse> listWorkflowsCallable() {
        return this.stub.listWorkflowsCallable();
    }

    public final Workflow getWorkflow(WorkflowName name) {
        GetWorkflowRequest request = GetWorkflowRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWorkflow(request);
    }

    public final Workflow getWorkflow(String name) {
        GetWorkflowRequest request = GetWorkflowRequest.newBuilder().setName(name).build();
        return this.getWorkflow(request);
    }

    public final Workflow getWorkflow(GetWorkflowRequest request) {
        return (Workflow)this.getWorkflowCallable().call((Object)request);
    }

    public final UnaryCallable<GetWorkflowRequest, Workflow> getWorkflowCallable() {
        return this.stub.getWorkflowCallable();
    }

    public final OperationFuture<Workflow, OperationMetadata> createWorkflowAsync(LocationName parent, Workflow workflow, String workflowId) {
        CreateWorkflowRequest request = CreateWorkflowRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWorkflow(workflow).setWorkflowId(workflowId).build();
        return this.createWorkflowAsync(request);
    }

    public final OperationFuture<Workflow, OperationMetadata> createWorkflowAsync(String parent, Workflow workflow, String workflowId) {
        CreateWorkflowRequest request = CreateWorkflowRequest.newBuilder().setParent(parent).setWorkflow(workflow).setWorkflowId(workflowId).build();
        return this.createWorkflowAsync(request);
    }

    public final OperationFuture<Workflow, OperationMetadata> createWorkflowAsync(CreateWorkflowRequest request) {
        return this.createWorkflowOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateWorkflowRequest, Workflow, OperationMetadata> createWorkflowOperationCallable() {
        return this.stub.createWorkflowOperationCallable();
    }

    public final UnaryCallable<CreateWorkflowRequest, Operation> createWorkflowCallable() {
        return this.stub.createWorkflowCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteWorkflowAsync(WorkflowName name) {
        DeleteWorkflowRequest request = DeleteWorkflowRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteWorkflowAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteWorkflowAsync(String name) {
        DeleteWorkflowRequest request = DeleteWorkflowRequest.newBuilder().setName(name).build();
        return this.deleteWorkflowAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteWorkflowAsync(DeleteWorkflowRequest request) {
        return this.deleteWorkflowOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteWorkflowRequest, Empty, OperationMetadata> deleteWorkflowOperationCallable() {
        return this.stub.deleteWorkflowOperationCallable();
    }

    public final UnaryCallable<DeleteWorkflowRequest, Operation> deleteWorkflowCallable() {
        return this.stub.deleteWorkflowCallable();
    }

    public final OperationFuture<Workflow, OperationMetadata> updateWorkflowAsync(Workflow workflow, FieldMask updateMask) {
        UpdateWorkflowRequest request = UpdateWorkflowRequest.newBuilder().setWorkflow(workflow).setUpdateMask(updateMask).build();
        return this.updateWorkflowAsync(request);
    }

    public final OperationFuture<Workflow, OperationMetadata> updateWorkflowAsync(UpdateWorkflowRequest request) {
        return this.updateWorkflowOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateWorkflowRequest, Workflow, OperationMetadata> updateWorkflowOperationCallable() {
        return this.stub.updateWorkflowOperationCallable();
    }

    public final UnaryCallable<UpdateWorkflowRequest, Operation> updateWorkflowCallable() {
        return this.stub.updateWorkflowCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListWorkflowsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWorkflowsRequest, ListWorkflowsResponse, Workflow, ListWorkflowsPage, ListWorkflowsFixedSizeCollection> {
        private ListWorkflowsFixedSizeCollection(List<ListWorkflowsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWorkflowsFixedSizeCollection createEmptyCollection() {
            return new ListWorkflowsFixedSizeCollection(null, 0);
        }

        protected ListWorkflowsFixedSizeCollection createCollection(List<ListWorkflowsPage> pages, int collectionSize) {
            return new ListWorkflowsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWorkflowsPage
    extends AbstractPage<ListWorkflowsRequest, ListWorkflowsResponse, Workflow, ListWorkflowsPage> {
        private ListWorkflowsPage(PageContext<ListWorkflowsRequest, ListWorkflowsResponse, Workflow> context, ListWorkflowsResponse response) {
            super(context, (Object)response);
        }

        private static ListWorkflowsPage createEmptyPage() {
            return new ListWorkflowsPage(null, null);
        }

        protected ListWorkflowsPage createPage(PageContext<ListWorkflowsRequest, ListWorkflowsResponse, Workflow> context, ListWorkflowsResponse response) {
            return new ListWorkflowsPage(context, response);
        }

        public ApiFuture<ListWorkflowsPage> createPageAsync(PageContext<ListWorkflowsRequest, ListWorkflowsResponse, Workflow> context, ApiFuture<ListWorkflowsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWorkflowsPagedResponse
    extends AbstractPagedListResponse<ListWorkflowsRequest, ListWorkflowsResponse, Workflow, ListWorkflowsPage, ListWorkflowsFixedSizeCollection> {
        public static ApiFuture<ListWorkflowsPagedResponse> createAsync(PageContext<ListWorkflowsRequest, ListWorkflowsResponse, Workflow> context, ApiFuture<ListWorkflowsResponse> futureResponse) {
            ApiFuture<ListWorkflowsPage> futurePage = ListWorkflowsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListWorkflowsPagedResponse((ListWorkflowsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListWorkflowsPagedResponse(ListWorkflowsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWorkflowsFixedSizeCollection.createEmptyCollection());
        }
    }
}

