/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.websecurityscanner.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.websecurityscanner.v1.CrawledUrl;
import com.google.cloud.websecurityscanner.v1.CreateScanConfigRequest;
import com.google.cloud.websecurityscanner.v1.DeleteScanConfigRequest;
import com.google.cloud.websecurityscanner.v1.Finding;
import com.google.cloud.websecurityscanner.v1.GetFindingRequest;
import com.google.cloud.websecurityscanner.v1.GetScanConfigRequest;
import com.google.cloud.websecurityscanner.v1.GetScanRunRequest;
import com.google.cloud.websecurityscanner.v1.ListCrawledUrlsRequest;
import com.google.cloud.websecurityscanner.v1.ListCrawledUrlsResponse;
import com.google.cloud.websecurityscanner.v1.ListFindingTypeStatsRequest;
import com.google.cloud.websecurityscanner.v1.ListFindingTypeStatsResponse;
import com.google.cloud.websecurityscanner.v1.ListFindingsRequest;
import com.google.cloud.websecurityscanner.v1.ListFindingsResponse;
import com.google.cloud.websecurityscanner.v1.ListScanConfigsRequest;
import com.google.cloud.websecurityscanner.v1.ListScanConfigsResponse;
import com.google.cloud.websecurityscanner.v1.ListScanRunsRequest;
import com.google.cloud.websecurityscanner.v1.ListScanRunsResponse;
import com.google.cloud.websecurityscanner.v1.ScanConfig;
import com.google.cloud.websecurityscanner.v1.ScanRun;
import com.google.cloud.websecurityscanner.v1.StartScanRunRequest;
import com.google.cloud.websecurityscanner.v1.StopScanRunRequest;
import com.google.cloud.websecurityscanner.v1.UpdateScanConfigRequest;
import com.google.cloud.websecurityscanner.v1.WebSecurityScannerClient;
import com.google.cloud.websecurityscanner.v1.stub.GrpcWebSecurityScannerStub;
import com.google.cloud.websecurityscanner.v1.stub.HttpJsonWebSecurityScannerStub;
import com.google.cloud.websecurityscanner.v1.stub.WebSecurityScannerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class WebSecurityScannerStubSettings
extends StubSettings<WebSecurityScannerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateScanConfigRequest, ScanConfig> createScanConfigSettings;
    private final UnaryCallSettings<DeleteScanConfigRequest, Empty> deleteScanConfigSettings;
    private final UnaryCallSettings<GetScanConfigRequest, ScanConfig> getScanConfigSettings;
    private final PagedCallSettings<ListScanConfigsRequest, ListScanConfigsResponse, WebSecurityScannerClient.ListScanConfigsPagedResponse> listScanConfigsSettings;
    private final UnaryCallSettings<UpdateScanConfigRequest, ScanConfig> updateScanConfigSettings;
    private final UnaryCallSettings<StartScanRunRequest, ScanRun> startScanRunSettings;
    private final UnaryCallSettings<GetScanRunRequest, ScanRun> getScanRunSettings;
    private final PagedCallSettings<ListScanRunsRequest, ListScanRunsResponse, WebSecurityScannerClient.ListScanRunsPagedResponse> listScanRunsSettings;
    private final UnaryCallSettings<StopScanRunRequest, ScanRun> stopScanRunSettings;
    private final PagedCallSettings<ListCrawledUrlsRequest, ListCrawledUrlsResponse, WebSecurityScannerClient.ListCrawledUrlsPagedResponse> listCrawledUrlsSettings;
    private final UnaryCallSettings<GetFindingRequest, Finding> getFindingSettings;
    private final PagedCallSettings<ListFindingsRequest, ListFindingsResponse, WebSecurityScannerClient.ListFindingsPagedResponse> listFindingsSettings;
    private final UnaryCallSettings<ListFindingTypeStatsRequest, ListFindingTypeStatsResponse> listFindingTypeStatsSettings;
    private static final PagedListDescriptor<ListScanConfigsRequest, ListScanConfigsResponse, ScanConfig> LIST_SCAN_CONFIGS_PAGE_STR_DESC = new PagedListDescriptor<ListScanConfigsRequest, ListScanConfigsResponse, ScanConfig>(){

        public String emptyToken() {
            return "";
        }

        public ListScanConfigsRequest injectToken(ListScanConfigsRequest payload, String token) {
            return ListScanConfigsRequest.newBuilder((ListScanConfigsRequest)payload).setPageToken(token).build();
        }

        public ListScanConfigsRequest injectPageSize(ListScanConfigsRequest payload, int pageSize) {
            return ListScanConfigsRequest.newBuilder((ListScanConfigsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListScanConfigsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListScanConfigsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ScanConfig> extractResources(ListScanConfigsResponse payload) {
            return payload.getScanConfigsList();
        }
    };
    private static final PagedListDescriptor<ListScanRunsRequest, ListScanRunsResponse, ScanRun> LIST_SCAN_RUNS_PAGE_STR_DESC = new PagedListDescriptor<ListScanRunsRequest, ListScanRunsResponse, ScanRun>(){

        public String emptyToken() {
            return "";
        }

        public ListScanRunsRequest injectToken(ListScanRunsRequest payload, String token) {
            return ListScanRunsRequest.newBuilder((ListScanRunsRequest)payload).setPageToken(token).build();
        }

        public ListScanRunsRequest injectPageSize(ListScanRunsRequest payload, int pageSize) {
            return ListScanRunsRequest.newBuilder((ListScanRunsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListScanRunsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListScanRunsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ScanRun> extractResources(ListScanRunsResponse payload) {
            return payload.getScanRunsList();
        }
    };
    private static final PagedListDescriptor<ListCrawledUrlsRequest, ListCrawledUrlsResponse, CrawledUrl> LIST_CRAWLED_URLS_PAGE_STR_DESC = new PagedListDescriptor<ListCrawledUrlsRequest, ListCrawledUrlsResponse, CrawledUrl>(){

        public String emptyToken() {
            return "";
        }

        public ListCrawledUrlsRequest injectToken(ListCrawledUrlsRequest payload, String token) {
            return ListCrawledUrlsRequest.newBuilder((ListCrawledUrlsRequest)payload).setPageToken(token).build();
        }

        public ListCrawledUrlsRequest injectPageSize(ListCrawledUrlsRequest payload, int pageSize) {
            return ListCrawledUrlsRequest.newBuilder((ListCrawledUrlsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCrawledUrlsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCrawledUrlsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CrawledUrl> extractResources(ListCrawledUrlsResponse payload) {
            return payload.getCrawledUrlsList();
        }
    };
    private static final PagedListDescriptor<ListFindingsRequest, ListFindingsResponse, Finding> LIST_FINDINGS_PAGE_STR_DESC = new PagedListDescriptor<ListFindingsRequest, ListFindingsResponse, Finding>(){

        public String emptyToken() {
            return "";
        }

        public ListFindingsRequest injectToken(ListFindingsRequest payload, String token) {
            return ListFindingsRequest.newBuilder((ListFindingsRequest)payload).setPageToken(token).build();
        }

        public ListFindingsRequest injectPageSize(ListFindingsRequest payload, int pageSize) {
            return ListFindingsRequest.newBuilder((ListFindingsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFindingsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFindingsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Finding> extractResources(ListFindingsResponse payload) {
            return payload.getFindingsList();
        }
    };
    private static final PagedListResponseFactory<ListScanConfigsRequest, ListScanConfigsResponse, WebSecurityScannerClient.ListScanConfigsPagedResponse> LIST_SCAN_CONFIGS_PAGE_STR_FACT = new PagedListResponseFactory<ListScanConfigsRequest, ListScanConfigsResponse, WebSecurityScannerClient.ListScanConfigsPagedResponse>(){

        public ApiFuture<WebSecurityScannerClient.ListScanConfigsPagedResponse> getFuturePagedResponse(UnaryCallable<ListScanConfigsRequest, ListScanConfigsResponse> callable, ListScanConfigsRequest request, ApiCallContext context, ApiFuture<ListScanConfigsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SCAN_CONFIGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return WebSecurityScannerClient.ListScanConfigsPagedResponse.createAsync((PageContext<ListScanConfigsRequest, ListScanConfigsResponse, ScanConfig>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListScanRunsRequest, ListScanRunsResponse, WebSecurityScannerClient.ListScanRunsPagedResponse> LIST_SCAN_RUNS_PAGE_STR_FACT = new PagedListResponseFactory<ListScanRunsRequest, ListScanRunsResponse, WebSecurityScannerClient.ListScanRunsPagedResponse>(){

        public ApiFuture<WebSecurityScannerClient.ListScanRunsPagedResponse> getFuturePagedResponse(UnaryCallable<ListScanRunsRequest, ListScanRunsResponse> callable, ListScanRunsRequest request, ApiCallContext context, ApiFuture<ListScanRunsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SCAN_RUNS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return WebSecurityScannerClient.ListScanRunsPagedResponse.createAsync((PageContext<ListScanRunsRequest, ListScanRunsResponse, ScanRun>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListCrawledUrlsRequest, ListCrawledUrlsResponse, WebSecurityScannerClient.ListCrawledUrlsPagedResponse> LIST_CRAWLED_URLS_PAGE_STR_FACT = new PagedListResponseFactory<ListCrawledUrlsRequest, ListCrawledUrlsResponse, WebSecurityScannerClient.ListCrawledUrlsPagedResponse>(){

        public ApiFuture<WebSecurityScannerClient.ListCrawledUrlsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCrawledUrlsRequest, ListCrawledUrlsResponse> callable, ListCrawledUrlsRequest request, ApiCallContext context, ApiFuture<ListCrawledUrlsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CRAWLED_URLS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return WebSecurityScannerClient.ListCrawledUrlsPagedResponse.createAsync((PageContext<ListCrawledUrlsRequest, ListCrawledUrlsResponse, CrawledUrl>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListFindingsRequest, ListFindingsResponse, WebSecurityScannerClient.ListFindingsPagedResponse> LIST_FINDINGS_PAGE_STR_FACT = new PagedListResponseFactory<ListFindingsRequest, ListFindingsResponse, WebSecurityScannerClient.ListFindingsPagedResponse>(){

        public ApiFuture<WebSecurityScannerClient.ListFindingsPagedResponse> getFuturePagedResponse(UnaryCallable<ListFindingsRequest, ListFindingsResponse> callable, ListFindingsRequest request, ApiCallContext context, ApiFuture<ListFindingsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FINDINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return WebSecurityScannerClient.ListFindingsPagedResponse.createAsync((PageContext<ListFindingsRequest, ListFindingsResponse, Finding>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateScanConfigRequest, ScanConfig> createScanConfigSettings() {
        return this.createScanConfigSettings;
    }

    public UnaryCallSettings<DeleteScanConfigRequest, Empty> deleteScanConfigSettings() {
        return this.deleteScanConfigSettings;
    }

    public UnaryCallSettings<GetScanConfigRequest, ScanConfig> getScanConfigSettings() {
        return this.getScanConfigSettings;
    }

    public PagedCallSettings<ListScanConfigsRequest, ListScanConfigsResponse, WebSecurityScannerClient.ListScanConfigsPagedResponse> listScanConfigsSettings() {
        return this.listScanConfigsSettings;
    }

    public UnaryCallSettings<UpdateScanConfigRequest, ScanConfig> updateScanConfigSettings() {
        return this.updateScanConfigSettings;
    }

    public UnaryCallSettings<StartScanRunRequest, ScanRun> startScanRunSettings() {
        return this.startScanRunSettings;
    }

    public UnaryCallSettings<GetScanRunRequest, ScanRun> getScanRunSettings() {
        return this.getScanRunSettings;
    }

    public PagedCallSettings<ListScanRunsRequest, ListScanRunsResponse, WebSecurityScannerClient.ListScanRunsPagedResponse> listScanRunsSettings() {
        return this.listScanRunsSettings;
    }

    public UnaryCallSettings<StopScanRunRequest, ScanRun> stopScanRunSettings() {
        return this.stopScanRunSettings;
    }

    public PagedCallSettings<ListCrawledUrlsRequest, ListCrawledUrlsResponse, WebSecurityScannerClient.ListCrawledUrlsPagedResponse> listCrawledUrlsSettings() {
        return this.listCrawledUrlsSettings;
    }

    public UnaryCallSettings<GetFindingRequest, Finding> getFindingSettings() {
        return this.getFindingSettings;
    }

    public PagedCallSettings<ListFindingsRequest, ListFindingsResponse, WebSecurityScannerClient.ListFindingsPagedResponse> listFindingsSettings() {
        return this.listFindingsSettings;
    }

    public UnaryCallSettings<ListFindingTypeStatsRequest, ListFindingTypeStatsResponse> listFindingTypeStatsSettings() {
        return this.listFindingTypeStatsSettings;
    }

    public WebSecurityScannerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcWebSecurityScannerStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonWebSecurityScannerStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "websecurityscanner";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "websecurityscanner.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "websecurityscanner.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return WebSecurityScannerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(WebSecurityScannerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(WebSecurityScannerStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return WebSecurityScannerStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected WebSecurityScannerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createScanConfigSettings = settingsBuilder.createScanConfigSettings().build();
        this.deleteScanConfigSettings = settingsBuilder.deleteScanConfigSettings().build();
        this.getScanConfigSettings = settingsBuilder.getScanConfigSettings().build();
        this.listScanConfigsSettings = settingsBuilder.listScanConfigsSettings().build();
        this.updateScanConfigSettings = settingsBuilder.updateScanConfigSettings().build();
        this.startScanRunSettings = settingsBuilder.startScanRunSettings().build();
        this.getScanRunSettings = settingsBuilder.getScanRunSettings().build();
        this.listScanRunsSettings = settingsBuilder.listScanRunsSettings().build();
        this.stopScanRunSettings = settingsBuilder.stopScanRunSettings().build();
        this.listCrawledUrlsSettings = settingsBuilder.listCrawledUrlsSettings().build();
        this.getFindingSettings = settingsBuilder.getFindingSettings().build();
        this.listFindingsSettings = settingsBuilder.listFindingsSettings().build();
        this.listFindingTypeStatsSettings = settingsBuilder.listFindingTypeStatsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<WebSecurityScannerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateScanConfigRequest, ScanConfig> createScanConfigSettings;
        private final UnaryCallSettings.Builder<DeleteScanConfigRequest, Empty> deleteScanConfigSettings;
        private final UnaryCallSettings.Builder<GetScanConfigRequest, ScanConfig> getScanConfigSettings;
        private final PagedCallSettings.Builder<ListScanConfigsRequest, ListScanConfigsResponse, WebSecurityScannerClient.ListScanConfigsPagedResponse> listScanConfigsSettings;
        private final UnaryCallSettings.Builder<UpdateScanConfigRequest, ScanConfig> updateScanConfigSettings;
        private final UnaryCallSettings.Builder<StartScanRunRequest, ScanRun> startScanRunSettings;
        private final UnaryCallSettings.Builder<GetScanRunRequest, ScanRun> getScanRunSettings;
        private final PagedCallSettings.Builder<ListScanRunsRequest, ListScanRunsResponse, WebSecurityScannerClient.ListScanRunsPagedResponse> listScanRunsSettings;
        private final UnaryCallSettings.Builder<StopScanRunRequest, ScanRun> stopScanRunSettings;
        private final PagedCallSettings.Builder<ListCrawledUrlsRequest, ListCrawledUrlsResponse, WebSecurityScannerClient.ListCrawledUrlsPagedResponse> listCrawledUrlsSettings;
        private final UnaryCallSettings.Builder<GetFindingRequest, Finding> getFindingSettings;
        private final PagedCallSettings.Builder<ListFindingsRequest, ListFindingsResponse, WebSecurityScannerClient.ListFindingsPagedResponse> listFindingsSettings;
        private final UnaryCallSettings.Builder<ListFindingTypeStatsRequest, ListFindingTypeStatsResponse> listFindingTypeStatsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createScanConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteScanConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getScanConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listScanConfigsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SCAN_CONFIGS_PAGE_STR_FACT);
            this.updateScanConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startScanRunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getScanRunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listScanRunsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SCAN_RUNS_PAGE_STR_FACT);
            this.stopScanRunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCrawledUrlsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CRAWLED_URLS_PAGE_STR_FACT);
            this.getFindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listFindingsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FINDINGS_PAGE_STR_FACT);
            this.listFindingTypeStatsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createScanConfigSettings, this.deleteScanConfigSettings, this.getScanConfigSettings, this.listScanConfigsSettings, this.updateScanConfigSettings, this.startScanRunSettings, this.getScanRunSettings, this.listScanRunsSettings, this.stopScanRunSettings, this.listCrawledUrlsSettings, this.getFindingSettings, this.listFindingsSettings, (Object[])new UnaryCallSettings.Builder[]{this.listFindingTypeStatsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(WebSecurityScannerStubSettings settings) {
            super((StubSettings)settings);
            this.createScanConfigSettings = settings.createScanConfigSettings.toBuilder();
            this.deleteScanConfigSettings = settings.deleteScanConfigSettings.toBuilder();
            this.getScanConfigSettings = settings.getScanConfigSettings.toBuilder();
            this.listScanConfigsSettings = settings.listScanConfigsSettings.toBuilder();
            this.updateScanConfigSettings = settings.updateScanConfigSettings.toBuilder();
            this.startScanRunSettings = settings.startScanRunSettings.toBuilder();
            this.getScanRunSettings = settings.getScanRunSettings.toBuilder();
            this.listScanRunsSettings = settings.listScanRunsSettings.toBuilder();
            this.stopScanRunSettings = settings.stopScanRunSettings.toBuilder();
            this.listCrawledUrlsSettings = settings.listCrawledUrlsSettings.toBuilder();
            this.getFindingSettings = settings.getFindingSettings.toBuilder();
            this.listFindingsSettings = settings.listFindingsSettings.toBuilder();
            this.listFindingTypeStatsSettings = settings.listFindingTypeStatsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createScanConfigSettings, this.deleteScanConfigSettings, this.getScanConfigSettings, this.listScanConfigsSettings, this.updateScanConfigSettings, this.startScanRunSettings, this.getScanRunSettings, this.listScanRunsSettings, this.stopScanRunSettings, this.listCrawledUrlsSettings, this.getFindingSettings, this.listFindingsSettings, (Object[])new UnaryCallSettings.Builder[]{this.listFindingTypeStatsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(WebSecurityScannerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)WebSecurityScannerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)WebSecurityScannerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(WebSecurityScannerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)WebSecurityScannerStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)WebSecurityScannerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)WebSecurityScannerStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(WebSecurityScannerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createScanConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteScanConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getScanConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listScanConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateScanConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.startScanRunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getScanRunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listScanRunsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.stopScanRunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listCrawledUrlsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getFindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listFindingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listFindingTypeStatsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateScanConfigRequest, ScanConfig> createScanConfigSettings() {
            return this.createScanConfigSettings;
        }

        public UnaryCallSettings.Builder<DeleteScanConfigRequest, Empty> deleteScanConfigSettings() {
            return this.deleteScanConfigSettings;
        }

        public UnaryCallSettings.Builder<GetScanConfigRequest, ScanConfig> getScanConfigSettings() {
            return this.getScanConfigSettings;
        }

        public PagedCallSettings.Builder<ListScanConfigsRequest, ListScanConfigsResponse, WebSecurityScannerClient.ListScanConfigsPagedResponse> listScanConfigsSettings() {
            return this.listScanConfigsSettings;
        }

        public UnaryCallSettings.Builder<UpdateScanConfigRequest, ScanConfig> updateScanConfigSettings() {
            return this.updateScanConfigSettings;
        }

        public UnaryCallSettings.Builder<StartScanRunRequest, ScanRun> startScanRunSettings() {
            return this.startScanRunSettings;
        }

        public UnaryCallSettings.Builder<GetScanRunRequest, ScanRun> getScanRunSettings() {
            return this.getScanRunSettings;
        }

        public PagedCallSettings.Builder<ListScanRunsRequest, ListScanRunsResponse, WebSecurityScannerClient.ListScanRunsPagedResponse> listScanRunsSettings() {
            return this.listScanRunsSettings;
        }

        public UnaryCallSettings.Builder<StopScanRunRequest, ScanRun> stopScanRunSettings() {
            return this.stopScanRunSettings;
        }

        public PagedCallSettings.Builder<ListCrawledUrlsRequest, ListCrawledUrlsResponse, WebSecurityScannerClient.ListCrawledUrlsPagedResponse> listCrawledUrlsSettings() {
            return this.listCrawledUrlsSettings;
        }

        public UnaryCallSettings.Builder<GetFindingRequest, Finding> getFindingSettings() {
            return this.getFindingSettings;
        }

        public PagedCallSettings.Builder<ListFindingsRequest, ListFindingsResponse, WebSecurityScannerClient.ListFindingsPagedResponse> listFindingsSettings() {
            return this.listFindingsSettings;
        }

        public UnaryCallSettings.Builder<ListFindingTypeStatsRequest, ListFindingTypeStatsResponse> listFindingTypeStatsSettings() {
            return this.listFindingTypeStatsSettings;
        }

        public WebSecurityScannerStubSettings build() throws IOException {
            return new WebSecurityScannerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

