/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.webrisk.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.webrisk.v1.stub.HttpJsonWebRiskServiceCallableFactory;
import com.google.cloud.webrisk.v1.stub.WebRiskServiceStub;
import com.google.cloud.webrisk.v1.stub.WebRiskServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import com.google.webrisk.v1.ComputeThreatListDiffRequest;
import com.google.webrisk.v1.ComputeThreatListDiffResponse;
import com.google.webrisk.v1.CreateSubmissionRequest;
import com.google.webrisk.v1.SearchHashesRequest;
import com.google.webrisk.v1.SearchHashesResponse;
import com.google.webrisk.v1.SearchUrisRequest;
import com.google.webrisk.v1.SearchUrisResponse;
import com.google.webrisk.v1.Submission;
import com.google.webrisk.v1.SubmitUriMetadata;
import com.google.webrisk.v1.SubmitUriRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonWebRiskServiceStub
extends WebRiskServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Submission.getDescriptor()).add(SubmitUriMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<ComputeThreatListDiffRequest, ComputeThreatListDiffResponse> computeThreatListDiffMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.webrisk.v1.WebRiskService/ComputeThreatListDiff").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/threatLists:computeDiff", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "constraints", (Object)request.getConstraints());
        serializer.putQueryParam(fields, "threatType", (Object)request.getThreatTypeValue());
        serializer.putQueryParam(fields, "versionToken", (Object)request.getVersionToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ComputeThreatListDiffResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SearchUrisRequest, SearchUrisResponse> searchUrisMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.webrisk.v1.WebRiskService/SearchUris").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/uris:search", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "threatTypes", (Object)request.getThreatTypesList());
        serializer.putQueryParam(fields, "uri", (Object)request.getUri());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchUrisResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SearchHashesRequest, SearchHashesResponse> searchHashesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.webrisk.v1.WebRiskService/SearchHashes").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/hashes:search", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "hashPrefix", (Object)request.getHashPrefix());
        serializer.putQueryParam(fields, "threatTypes", (Object)request.getThreatTypesList());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchHashesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateSubmissionRequest, Submission> createSubmissionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.webrisk.v1.WebRiskService/CreateSubmission").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*}/submissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("submission", (Message)request.getSubmission(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Submission.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SubmitUriRequest, Operation> submitUriMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.webrisk.v1.WebRiskService/SubmitUri").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*}/uris:submit", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<ComputeThreatListDiffRequest, ComputeThreatListDiffResponse> computeThreatListDiffCallable;
    private final UnaryCallable<SearchUrisRequest, SearchUrisResponse> searchUrisCallable;
    private final UnaryCallable<SearchHashesRequest, SearchHashesResponse> searchHashesCallable;
    private final UnaryCallable<CreateSubmissionRequest, Submission> createSubmissionCallable;
    private final UnaryCallable<SubmitUriRequest, Operation> submitUriCallable;
    private final OperationCallable<SubmitUriRequest, Submission, SubmitUriMetadata> submitUriOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonWebRiskServiceStub create(WebRiskServiceStubSettings settings) throws IOException {
        return new HttpJsonWebRiskServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonWebRiskServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonWebRiskServiceStub(WebRiskServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonWebRiskServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonWebRiskServiceStub(WebRiskServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonWebRiskServiceStub(WebRiskServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonWebRiskServiceCallableFactory());
    }

    protected HttpJsonWebRiskServiceStub(WebRiskServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*}/operations").build()).build());
        HttpJsonCallSettings computeThreatListDiffTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(computeThreatListDiffMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings searchUrisTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchUrisMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings searchHashesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchHashesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createSubmissionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createSubmissionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings submitUriTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(submitUriMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.computeThreatListDiffCallable = callableFactory.createUnaryCallable(computeThreatListDiffTransportSettings, settings.computeThreatListDiffSettings(), clientContext);
        this.searchUrisCallable = callableFactory.createUnaryCallable(searchUrisTransportSettings, settings.searchUrisSettings(), clientContext);
        this.searchHashesCallable = callableFactory.createUnaryCallable(searchHashesTransportSettings, settings.searchHashesSettings(), clientContext);
        this.createSubmissionCallable = callableFactory.createUnaryCallable(createSubmissionTransportSettings, settings.createSubmissionSettings(), clientContext);
        this.submitUriCallable = callableFactory.createUnaryCallable(submitUriTransportSettings, settings.submitUriSettings(), clientContext);
        this.submitUriOperationCallable = callableFactory.createOperationCallable(submitUriTransportSettings, settings.submitUriOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(computeThreatListDiffMethodDescriptor);
        methodDescriptors.add(searchUrisMethodDescriptor);
        methodDescriptors.add(searchHashesMethodDescriptor);
        methodDescriptors.add(createSubmissionMethodDescriptor);
        methodDescriptors.add(submitUriMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ComputeThreatListDiffRequest, ComputeThreatListDiffResponse> computeThreatListDiffCallable() {
        return this.computeThreatListDiffCallable;
    }

    @Override
    public UnaryCallable<SearchUrisRequest, SearchUrisResponse> searchUrisCallable() {
        return this.searchUrisCallable;
    }

    @Override
    public UnaryCallable<SearchHashesRequest, SearchHashesResponse> searchHashesCallable() {
        return this.searchHashesCallable;
    }

    @Override
    public UnaryCallable<CreateSubmissionRequest, Submission> createSubmissionCallable() {
        return this.createSubmissionCallable;
    }

    @Override
    public UnaryCallable<SubmitUriRequest, Operation> submitUriCallable() {
        return this.submitUriCallable;
    }

    @Override
    public OperationCallable<SubmitUriRequest, Submission, SubmitUriMetadata> submitUriOperationCallable() {
        return this.submitUriOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

