/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.webrisk.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.webrisk.v1.stub.GrpcWebRiskServiceStub;
import com.google.cloud.webrisk.v1.stub.WebRiskServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.webrisk.v1.ComputeThreatListDiffRequest;
import com.google.webrisk.v1.ComputeThreatListDiffResponse;
import com.google.webrisk.v1.CreateSubmissionRequest;
import com.google.webrisk.v1.SearchHashesRequest;
import com.google.webrisk.v1.SearchHashesResponse;
import com.google.webrisk.v1.SearchUrisRequest;
import com.google.webrisk.v1.SearchUrisResponse;
import com.google.webrisk.v1.Submission;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class WebRiskServiceStubSettings
extends StubSettings<WebRiskServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ComputeThreatListDiffRequest, ComputeThreatListDiffResponse> computeThreatListDiffSettings;
    private final UnaryCallSettings<SearchUrisRequest, SearchUrisResponse> searchUrisSettings;
    private final UnaryCallSettings<SearchHashesRequest, SearchHashesResponse> searchHashesSettings;
    private final UnaryCallSettings<CreateSubmissionRequest, Submission> createSubmissionSettings;

    public UnaryCallSettings<ComputeThreatListDiffRequest, ComputeThreatListDiffResponse> computeThreatListDiffSettings() {
        return this.computeThreatListDiffSettings;
    }

    public UnaryCallSettings<SearchUrisRequest, SearchUrisResponse> searchUrisSettings() {
        return this.searchUrisSettings;
    }

    public UnaryCallSettings<SearchHashesRequest, SearchHashesResponse> searchHashesSettings() {
        return this.searchHashesSettings;
    }

    public UnaryCallSettings<CreateSubmissionRequest, Submission> createSubmissionSettings() {
        return this.createSubmissionSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public WebRiskServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcWebRiskServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "webrisk.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "webrisk.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return WebRiskServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(WebRiskServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected WebRiskServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.computeThreatListDiffSettings = settingsBuilder.computeThreatListDiffSettings().build();
        this.searchUrisSettings = settingsBuilder.searchUrisSettings().build();
        this.searchHashesSettings = settingsBuilder.searchHashesSettings().build();
        this.createSubmissionSettings = settingsBuilder.createSubmissionSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<WebRiskServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ComputeThreatListDiffRequest, ComputeThreatListDiffResponse> computeThreatListDiffSettings;
        private final UnaryCallSettings.Builder<SearchUrisRequest, SearchUrisResponse> searchUrisSettings;
        private final UnaryCallSettings.Builder<SearchHashesRequest, SearchHashesResponse> searchHashesSettings;
        private final UnaryCallSettings.Builder<CreateSubmissionRequest, Submission> createSubmissionSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.computeThreatListDiffSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchUrisSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchHashesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSubmissionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.computeThreatListDiffSettings, this.searchUrisSettings, this.searchHashesSettings, this.createSubmissionSettings);
            Builder.initDefaults(this);
        }

        protected Builder(WebRiskServiceStubSettings settings) {
            super((StubSettings)settings);
            this.computeThreatListDiffSettings = settings.computeThreatListDiffSettings.toBuilder();
            this.searchUrisSettings = settings.searchUrisSettings.toBuilder();
            this.searchHashesSettings = settings.searchHashesSettings.toBuilder();
            this.createSubmissionSettings = settings.createSubmissionSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.computeThreatListDiffSettings, this.searchUrisSettings, this.searchHashesSettings, this.createSubmissionSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(WebRiskServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)WebRiskServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)WebRiskServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(WebRiskServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(WebRiskServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.computeThreatListDiffSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.searchUrisSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.searchHashesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createSubmissionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ComputeThreatListDiffRequest, ComputeThreatListDiffResponse> computeThreatListDiffSettings() {
            return this.computeThreatListDiffSettings;
        }

        public UnaryCallSettings.Builder<SearchUrisRequest, SearchUrisResponse> searchUrisSettings() {
            return this.searchUrisSettings;
        }

        public UnaryCallSettings.Builder<SearchHashesRequest, SearchHashesResponse> searchHashesSettings() {
            return this.searchHashesSettings;
        }

        public UnaryCallSettings.Builder<CreateSubmissionRequest, Submission> createSubmissionSettings() {
            return this.createSubmissionSettings;
        }

        public WebRiskServiceStubSettings build() throws IOException {
            return new WebRiskServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

