/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.webrisk.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.webrisk.v1beta1.WebRiskServiceV1Beta1Settings;
import com.google.cloud.webrisk.v1beta1.stub.WebRiskServiceV1Beta1Stub;
import com.google.cloud.webrisk.v1beta1.stub.WebRiskServiceV1Beta1StubSettings;
import com.google.protobuf.ByteString;
import com.google.webrisk.v1beta1.ComputeThreatListDiffRequest;
import com.google.webrisk.v1beta1.ComputeThreatListDiffResponse;
import com.google.webrisk.v1beta1.SearchHashesRequest;
import com.google.webrisk.v1beta1.SearchHashesResponse;
import com.google.webrisk.v1beta1.SearchUrisRequest;
import com.google.webrisk.v1beta1.SearchUrisResponse;
import com.google.webrisk.v1beta1.ThreatType;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class WebRiskServiceV1Beta1Client
implements BackgroundResource {
    private final WebRiskServiceV1Beta1Settings settings;
    private final WebRiskServiceV1Beta1Stub stub;

    public static final WebRiskServiceV1Beta1Client create() throws IOException {
        return WebRiskServiceV1Beta1Client.create(WebRiskServiceV1Beta1Settings.newBuilder().build());
    }

    public static final WebRiskServiceV1Beta1Client create(WebRiskServiceV1Beta1Settings settings) throws IOException {
        return new WebRiskServiceV1Beta1Client(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final WebRiskServiceV1Beta1Client create(WebRiskServiceV1Beta1Stub stub) {
        return new WebRiskServiceV1Beta1Client(stub);
    }

    protected WebRiskServiceV1Beta1Client(WebRiskServiceV1Beta1Settings settings) throws IOException {
        this.settings = settings;
        this.stub = ((WebRiskServiceV1Beta1StubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected WebRiskServiceV1Beta1Client(WebRiskServiceV1Beta1Stub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final WebRiskServiceV1Beta1Settings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public WebRiskServiceV1Beta1Stub getStub() {
        return this.stub;
    }

    public final ComputeThreatListDiffResponse computeThreatListDiff(ThreatType threatType, ByteString versionToken, ComputeThreatListDiffRequest.Constraints constraints) {
        ComputeThreatListDiffRequest request = ComputeThreatListDiffRequest.newBuilder().setThreatType(threatType).setVersionToken(versionToken).setConstraints(constraints).build();
        return this.computeThreatListDiff(request);
    }

    public final ComputeThreatListDiffResponse computeThreatListDiff(ComputeThreatListDiffRequest request) {
        return (ComputeThreatListDiffResponse)this.computeThreatListDiffCallable().call((Object)request);
    }

    public final UnaryCallable<ComputeThreatListDiffRequest, ComputeThreatListDiffResponse> computeThreatListDiffCallable() {
        return this.stub.computeThreatListDiffCallable();
    }

    public final SearchUrisResponse searchUris(String uri, List<ThreatType> threatTypes) {
        SearchUrisRequest request = SearchUrisRequest.newBuilder().setUri(uri).addAllThreatTypes(threatTypes).build();
        return this.searchUris(request);
    }

    public final SearchUrisResponse searchUris(SearchUrisRequest request) {
        return (SearchUrisResponse)this.searchUrisCallable().call((Object)request);
    }

    public final UnaryCallable<SearchUrisRequest, SearchUrisResponse> searchUrisCallable() {
        return this.stub.searchUrisCallable();
    }

    public final SearchHashesResponse searchHashes(ByteString hashPrefix, List<ThreatType> threatTypes) {
        SearchHashesRequest request = SearchHashesRequest.newBuilder().setHashPrefix(hashPrefix).addAllThreatTypes(threatTypes).build();
        return this.searchHashes(request);
    }

    public final SearchHashesResponse searchHashes(SearchHashesRequest request) {
        return (SearchHashesResponse)this.searchHashesCallable().call((Object)request);
    }

    public final UnaryCallable<SearchHashesRequest, SearchHashesResponse> searchHashesCallable() {
        return this.stub.searchHashesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

