/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vpcaccess.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.vpcaccess.v1.Connector;
import com.google.cloud.vpcaccess.v1.CreateConnectorRequest;
import com.google.cloud.vpcaccess.v1.DeleteConnectorRequest;
import com.google.cloud.vpcaccess.v1.GetConnectorRequest;
import com.google.cloud.vpcaccess.v1.ListConnectorsRequest;
import com.google.cloud.vpcaccess.v1.ListConnectorsResponse;
import com.google.cloud.vpcaccess.v1.OperationMetadata;
import com.google.cloud.vpcaccess.v1.VpcAccessServiceClient;
import com.google.cloud.vpcaccess.v1.stub.GrpcVpcAccessServiceCallableFactory;
import com.google.cloud.vpcaccess.v1.stub.VpcAccessServiceStub;
import com.google.cloud.vpcaccess.v1.stub.VpcAccessServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcVpcAccessServiceStub
extends VpcAccessServiceStub {
    private static final MethodDescriptor<CreateConnectorRequest, Operation> createConnectorMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vpcaccess.v1.VpcAccessService/CreateConnector").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateConnectorRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetConnectorRequest, Connector> getConnectorMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vpcaccess.v1.VpcAccessService/GetConnector").setRequestMarshaller(ProtoUtils.marshaller((Message)GetConnectorRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Connector.getDefaultInstance())).build();
    private static final MethodDescriptor<ListConnectorsRequest, ListConnectorsResponse> listConnectorsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vpcaccess.v1.VpcAccessService/ListConnectors").setRequestMarshaller(ProtoUtils.marshaller((Message)ListConnectorsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListConnectorsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteConnectorRequest, Operation> deleteConnectorMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vpcaccess.v1.VpcAccessService/DeleteConnector").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteConnectorRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<CreateConnectorRequest, Operation> createConnectorCallable;
    private final OperationCallable<CreateConnectorRequest, Connector, OperationMetadata> createConnectorOperationCallable;
    private final UnaryCallable<GetConnectorRequest, Connector> getConnectorCallable;
    private final UnaryCallable<ListConnectorsRequest, ListConnectorsResponse> listConnectorsCallable;
    private final UnaryCallable<ListConnectorsRequest, VpcAccessServiceClient.ListConnectorsPagedResponse> listConnectorsPagedCallable;
    private final UnaryCallable<DeleteConnectorRequest, Operation> deleteConnectorCallable;
    private final OperationCallable<DeleteConnectorRequest, Empty, OperationMetadata> deleteConnectorOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcVpcAccessServiceStub create(VpcAccessServiceStubSettings settings) throws IOException {
        return new GrpcVpcAccessServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcVpcAccessServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcVpcAccessServiceStub(VpcAccessServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcVpcAccessServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcVpcAccessServiceStub(VpcAccessServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcVpcAccessServiceStub(VpcAccessServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcVpcAccessServiceCallableFactory());
    }

    protected GrpcVpcAccessServiceStub(VpcAccessServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createConnectorTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createConnectorMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateConnectorRequest>(){

            public Map<String, String> extract(CreateConnectorRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getConnectorTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getConnectorMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetConnectorRequest>(){

            public Map<String, String> extract(GetConnectorRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listConnectorsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listConnectorsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListConnectorsRequest>(){

            public Map<String, String> extract(ListConnectorsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteConnectorTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteConnectorMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteConnectorRequest>(){

            public Map<String, String> extract(DeleteConnectorRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.createConnectorCallable = callableFactory.createUnaryCallable(createConnectorTransportSettings, settings.createConnectorSettings(), clientContext);
        this.createConnectorOperationCallable = callableFactory.createOperationCallable(createConnectorTransportSettings, settings.createConnectorOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getConnectorCallable = callableFactory.createUnaryCallable(getConnectorTransportSettings, settings.getConnectorSettings(), clientContext);
        this.listConnectorsCallable = callableFactory.createUnaryCallable(listConnectorsTransportSettings, settings.listConnectorsSettings(), clientContext);
        this.listConnectorsPagedCallable = callableFactory.createPagedCallable(listConnectorsTransportSettings, settings.listConnectorsSettings(), clientContext);
        this.deleteConnectorCallable = callableFactory.createUnaryCallable(deleteConnectorTransportSettings, settings.deleteConnectorSettings(), clientContext);
        this.deleteConnectorOperationCallable = callableFactory.createOperationCallable(deleteConnectorTransportSettings, settings.deleteConnectorOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateConnectorRequest, Operation> createConnectorCallable() {
        return this.createConnectorCallable;
    }

    @Override
    public OperationCallable<CreateConnectorRequest, Connector, OperationMetadata> createConnectorOperationCallable() {
        return this.createConnectorOperationCallable;
    }

    @Override
    public UnaryCallable<GetConnectorRequest, Connector> getConnectorCallable() {
        return this.getConnectorCallable;
    }

    @Override
    public UnaryCallable<ListConnectorsRequest, ListConnectorsResponse> listConnectorsCallable() {
        return this.listConnectorsCallable;
    }

    @Override
    public UnaryCallable<ListConnectorsRequest, VpcAccessServiceClient.ListConnectorsPagedResponse> listConnectorsPagedCallable() {
        return this.listConnectorsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteConnectorRequest, Operation> deleteConnectorCallable() {
        return this.deleteConnectorCallable;
    }

    @Override
    public OperationCallable<DeleteConnectorRequest, Empty, OperationMetadata> deleteConnectorOperationCallable() {
        return this.deleteConnectorOperationCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

