/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vpcaccess.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.vpcaccess.v1.Connector;
import com.google.cloud.vpcaccess.v1.ConnectorName;
import com.google.cloud.vpcaccess.v1.CreateConnectorRequest;
import com.google.cloud.vpcaccess.v1.DeleteConnectorRequest;
import com.google.cloud.vpcaccess.v1.GetConnectorRequest;
import com.google.cloud.vpcaccess.v1.ListConnectorsRequest;
import com.google.cloud.vpcaccess.v1.ListConnectorsResponse;
import com.google.cloud.vpcaccess.v1.LocationName;
import com.google.cloud.vpcaccess.v1.OperationMetadata;
import com.google.cloud.vpcaccess.v1.VpcAccessServiceSettings;
import com.google.cloud.vpcaccess.v1.stub.VpcAccessServiceStub;
import com.google.cloud.vpcaccess.v1.stub.VpcAccessServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class VpcAccessServiceClient
implements BackgroundResource {
    private final VpcAccessServiceSettings settings;
    private final VpcAccessServiceStub stub;
    private final OperationsClient operationsClient;

    public static final VpcAccessServiceClient create() throws IOException {
        return VpcAccessServiceClient.create(VpcAccessServiceSettings.newBuilder().build());
    }

    public static final VpcAccessServiceClient create(VpcAccessServiceSettings settings) throws IOException {
        return new VpcAccessServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final VpcAccessServiceClient create(VpcAccessServiceStub stub) {
        return new VpcAccessServiceClient(stub);
    }

    protected VpcAccessServiceClient(VpcAccessServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((VpcAccessServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected VpcAccessServiceClient(VpcAccessServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final VpcAccessServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public VpcAccessServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<Connector, OperationMetadata> createConnectorAsync(LocationName parent, String connectorId, Connector connector) {
        CreateConnectorRequest request = CreateConnectorRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConnectorId(connectorId).setConnector(connector).build();
        return this.createConnectorAsync(request);
    }

    public final OperationFuture<Connector, OperationMetadata> createConnectorAsync(String parent, String connectorId, Connector connector) {
        CreateConnectorRequest request = CreateConnectorRequest.newBuilder().setParent(parent).setConnectorId(connectorId).setConnector(connector).build();
        return this.createConnectorAsync(request);
    }

    public final OperationFuture<Connector, OperationMetadata> createConnectorAsync(CreateConnectorRequest request) {
        return this.createConnectorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateConnectorRequest, Connector, OperationMetadata> createConnectorOperationCallable() {
        return this.stub.createConnectorOperationCallable();
    }

    public final UnaryCallable<CreateConnectorRequest, Operation> createConnectorCallable() {
        return this.stub.createConnectorCallable();
    }

    public final Connector getConnector(ConnectorName name) {
        GetConnectorRequest request = GetConnectorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConnector(request);
    }

    public final Connector getConnector(String name) {
        GetConnectorRequest request = GetConnectorRequest.newBuilder().setName(name).build();
        return this.getConnector(request);
    }

    public final Connector getConnector(GetConnectorRequest request) {
        return (Connector)this.getConnectorCallable().call((Object)request);
    }

    public final UnaryCallable<GetConnectorRequest, Connector> getConnectorCallable() {
        return this.stub.getConnectorCallable();
    }

    public final ListConnectorsPagedResponse listConnectors(LocationName parent) {
        ListConnectorsRequest request = ListConnectorsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConnectors(request);
    }

    public final ListConnectorsPagedResponse listConnectors(String parent) {
        ListConnectorsRequest request = ListConnectorsRequest.newBuilder().setParent(parent).build();
        return this.listConnectors(request);
    }

    public final ListConnectorsPagedResponse listConnectors(ListConnectorsRequest request) {
        return (ListConnectorsPagedResponse)((Object)this.listConnectorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConnectorsRequest, ListConnectorsPagedResponse> listConnectorsPagedCallable() {
        return this.stub.listConnectorsPagedCallable();
    }

    public final UnaryCallable<ListConnectorsRequest, ListConnectorsResponse> listConnectorsCallable() {
        return this.stub.listConnectorsCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectorAsync(ConnectorName name) {
        DeleteConnectorRequest request = DeleteConnectorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteConnectorAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectorAsync(String name) {
        DeleteConnectorRequest request = DeleteConnectorRequest.newBuilder().setName(name).build();
        return this.deleteConnectorAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectorAsync(DeleteConnectorRequest request) {
        return this.deleteConnectorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteConnectorRequest, Empty, OperationMetadata> deleteConnectorOperationCallable() {
        return this.stub.deleteConnectorOperationCallable();
    }

    public final UnaryCallable<DeleteConnectorRequest, Operation> deleteConnectorCallable() {
        return this.stub.deleteConnectorCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListConnectorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConnectorsRequest, ListConnectorsResponse, Connector, ListConnectorsPage, ListConnectorsFixedSizeCollection> {
        private ListConnectorsFixedSizeCollection(List<ListConnectorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConnectorsFixedSizeCollection createEmptyCollection() {
            return new ListConnectorsFixedSizeCollection(null, 0);
        }

        protected ListConnectorsFixedSizeCollection createCollection(List<ListConnectorsPage> pages, int collectionSize) {
            return new ListConnectorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConnectorsPage
    extends AbstractPage<ListConnectorsRequest, ListConnectorsResponse, Connector, ListConnectorsPage> {
        private ListConnectorsPage(PageContext<ListConnectorsRequest, ListConnectorsResponse, Connector> context, ListConnectorsResponse response) {
            super(context, (Object)response);
        }

        private static ListConnectorsPage createEmptyPage() {
            return new ListConnectorsPage(null, null);
        }

        protected ListConnectorsPage createPage(PageContext<ListConnectorsRequest, ListConnectorsResponse, Connector> context, ListConnectorsResponse response) {
            return new ListConnectorsPage(context, response);
        }

        public ApiFuture<ListConnectorsPage> createPageAsync(PageContext<ListConnectorsRequest, ListConnectorsResponse, Connector> context, ApiFuture<ListConnectorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConnectorsPagedResponse
    extends AbstractPagedListResponse<ListConnectorsRequest, ListConnectorsResponse, Connector, ListConnectorsPage, ListConnectorsFixedSizeCollection> {
        public static ApiFuture<ListConnectorsPagedResponse> createAsync(PageContext<ListConnectorsRequest, ListConnectorsResponse, Connector> context, ApiFuture<ListConnectorsResponse> futureResponse) {
            ApiFuture<ListConnectorsPage> futurePage = ListConnectorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListConnectorsPage, ListConnectorsPagedResponse>(){

                public ListConnectorsPagedResponse apply(ListConnectorsPage input) {
                    return new ListConnectorsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListConnectorsPagedResponse(ListConnectorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConnectorsFixedSizeCollection.createEmptyCollection());
        }
    }
}

