/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmmigration.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.vmmigration.v1.AddGroupMigrationRequest;
import com.google.cloud.vmmigration.v1.AddGroupMigrationResponse;
import com.google.cloud.vmmigration.v1.CancelCloneJobRequest;
import com.google.cloud.vmmigration.v1.CancelCloneJobResponse;
import com.google.cloud.vmmigration.v1.CancelCutoverJobRequest;
import com.google.cloud.vmmigration.v1.CancelCutoverJobResponse;
import com.google.cloud.vmmigration.v1.CloneJob;
import com.google.cloud.vmmigration.v1.CloneJobName;
import com.google.cloud.vmmigration.v1.CreateCloneJobRequest;
import com.google.cloud.vmmigration.v1.CreateCutoverJobRequest;
import com.google.cloud.vmmigration.v1.CreateDatacenterConnectorRequest;
import com.google.cloud.vmmigration.v1.CreateGroupRequest;
import com.google.cloud.vmmigration.v1.CreateMigratingVmRequest;
import com.google.cloud.vmmigration.v1.CreateSourceRequest;
import com.google.cloud.vmmigration.v1.CreateTargetProjectRequest;
import com.google.cloud.vmmigration.v1.CreateUtilizationReportRequest;
import com.google.cloud.vmmigration.v1.CutoverJob;
import com.google.cloud.vmmigration.v1.CutoverJobName;
import com.google.cloud.vmmigration.v1.DatacenterConnector;
import com.google.cloud.vmmigration.v1.DatacenterConnectorName;
import com.google.cloud.vmmigration.v1.DeleteDatacenterConnectorRequest;
import com.google.cloud.vmmigration.v1.DeleteGroupRequest;
import com.google.cloud.vmmigration.v1.DeleteMigratingVmRequest;
import com.google.cloud.vmmigration.v1.DeleteSourceRequest;
import com.google.cloud.vmmigration.v1.DeleteTargetProjectRequest;
import com.google.cloud.vmmigration.v1.DeleteUtilizationReportRequest;
import com.google.cloud.vmmigration.v1.FetchInventoryRequest;
import com.google.cloud.vmmigration.v1.FetchInventoryResponse;
import com.google.cloud.vmmigration.v1.FinalizeMigrationRequest;
import com.google.cloud.vmmigration.v1.FinalizeMigrationResponse;
import com.google.cloud.vmmigration.v1.GetCloneJobRequest;
import com.google.cloud.vmmigration.v1.GetCutoverJobRequest;
import com.google.cloud.vmmigration.v1.GetDatacenterConnectorRequest;
import com.google.cloud.vmmigration.v1.GetGroupRequest;
import com.google.cloud.vmmigration.v1.GetMigratingVmRequest;
import com.google.cloud.vmmigration.v1.GetSourceRequest;
import com.google.cloud.vmmigration.v1.GetTargetProjectRequest;
import com.google.cloud.vmmigration.v1.GetUtilizationReportRequest;
import com.google.cloud.vmmigration.v1.Group;
import com.google.cloud.vmmigration.v1.GroupName;
import com.google.cloud.vmmigration.v1.ListCloneJobsRequest;
import com.google.cloud.vmmigration.v1.ListCloneJobsResponse;
import com.google.cloud.vmmigration.v1.ListCutoverJobsRequest;
import com.google.cloud.vmmigration.v1.ListCutoverJobsResponse;
import com.google.cloud.vmmigration.v1.ListDatacenterConnectorsRequest;
import com.google.cloud.vmmigration.v1.ListDatacenterConnectorsResponse;
import com.google.cloud.vmmigration.v1.ListGroupsRequest;
import com.google.cloud.vmmigration.v1.ListGroupsResponse;
import com.google.cloud.vmmigration.v1.ListMigratingVmsRequest;
import com.google.cloud.vmmigration.v1.ListMigratingVmsResponse;
import com.google.cloud.vmmigration.v1.ListSourcesRequest;
import com.google.cloud.vmmigration.v1.ListSourcesResponse;
import com.google.cloud.vmmigration.v1.ListTargetProjectsRequest;
import com.google.cloud.vmmigration.v1.ListTargetProjectsResponse;
import com.google.cloud.vmmigration.v1.ListUtilizationReportsRequest;
import com.google.cloud.vmmigration.v1.ListUtilizationReportsResponse;
import com.google.cloud.vmmigration.v1.LocationName;
import com.google.cloud.vmmigration.v1.MigratingVm;
import com.google.cloud.vmmigration.v1.MigratingVmName;
import com.google.cloud.vmmigration.v1.OperationMetadata;
import com.google.cloud.vmmigration.v1.PauseMigrationRequest;
import com.google.cloud.vmmigration.v1.PauseMigrationResponse;
import com.google.cloud.vmmigration.v1.RemoveGroupMigrationRequest;
import com.google.cloud.vmmigration.v1.RemoveGroupMigrationResponse;
import com.google.cloud.vmmigration.v1.ResumeMigrationRequest;
import com.google.cloud.vmmigration.v1.ResumeMigrationResponse;
import com.google.cloud.vmmigration.v1.Source;
import com.google.cloud.vmmigration.v1.SourceName;
import com.google.cloud.vmmigration.v1.StartMigrationRequest;
import com.google.cloud.vmmigration.v1.StartMigrationResponse;
import com.google.cloud.vmmigration.v1.TargetProject;
import com.google.cloud.vmmigration.v1.TargetProjectName;
import com.google.cloud.vmmigration.v1.UpdateGroupRequest;
import com.google.cloud.vmmigration.v1.UpdateMigratingVmRequest;
import com.google.cloud.vmmigration.v1.UpdateSourceRequest;
import com.google.cloud.vmmigration.v1.UpdateTargetProjectRequest;
import com.google.cloud.vmmigration.v1.UtilizationReport;
import com.google.cloud.vmmigration.v1.UtilizationReportName;
import com.google.cloud.vmmigration.v1.VmMigrationSettings;
import com.google.cloud.vmmigration.v1.stub.VmMigrationStub;
import com.google.cloud.vmmigration.v1.stub.VmMigrationStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class VmMigrationClient
implements BackgroundResource {
    private final VmMigrationSettings settings;
    private final VmMigrationStub stub;
    private final OperationsClient operationsClient;

    public static final VmMigrationClient create() throws IOException {
        return VmMigrationClient.create(VmMigrationSettings.newBuilder().build());
    }

    public static final VmMigrationClient create(VmMigrationSettings settings) throws IOException {
        return new VmMigrationClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final VmMigrationClient create(VmMigrationStub stub) {
        return new VmMigrationClient(stub);
    }

    protected VmMigrationClient(VmMigrationSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((VmMigrationStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected VmMigrationClient(VmMigrationStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final VmMigrationSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public VmMigrationStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListSourcesPagedResponse listSources(LocationName parent) {
        ListSourcesRequest request = ListSourcesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSources(request);
    }

    public final ListSourcesPagedResponse listSources(String parent) {
        ListSourcesRequest request = ListSourcesRequest.newBuilder().setParent(parent).build();
        return this.listSources(request);
    }

    public final ListSourcesPagedResponse listSources(ListSourcesRequest request) {
        return (ListSourcesPagedResponse)((Object)this.listSourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSourcesRequest, ListSourcesPagedResponse> listSourcesPagedCallable() {
        return this.stub.listSourcesPagedCallable();
    }

    public final UnaryCallable<ListSourcesRequest, ListSourcesResponse> listSourcesCallable() {
        return this.stub.listSourcesCallable();
    }

    public final Source getSource(SourceName name) {
        GetSourceRequest request = GetSourceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSource(request);
    }

    public final Source getSource(String name) {
        GetSourceRequest request = GetSourceRequest.newBuilder().setName(name).build();
        return this.getSource(request);
    }

    public final Source getSource(GetSourceRequest request) {
        return (Source)this.getSourceCallable().call((Object)request);
    }

    public final UnaryCallable<GetSourceRequest, Source> getSourceCallable() {
        return this.stub.getSourceCallable();
    }

    public final OperationFuture<Source, OperationMetadata> createSourceAsync(LocationName parent, Source source, String sourceId) {
        CreateSourceRequest request = CreateSourceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSource(source).setSourceId(sourceId).build();
        return this.createSourceAsync(request);
    }

    public final OperationFuture<Source, OperationMetadata> createSourceAsync(String parent, Source source, String sourceId) {
        CreateSourceRequest request = CreateSourceRequest.newBuilder().setParent(parent).setSource(source).setSourceId(sourceId).build();
        return this.createSourceAsync(request);
    }

    public final OperationFuture<Source, OperationMetadata> createSourceAsync(CreateSourceRequest request) {
        return this.createSourceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSourceRequest, Source, OperationMetadata> createSourceOperationCallable() {
        return this.stub.createSourceOperationCallable();
    }

    public final UnaryCallable<CreateSourceRequest, Operation> createSourceCallable() {
        return this.stub.createSourceCallable();
    }

    public final OperationFuture<Source, OperationMetadata> updateSourceAsync(Source source, FieldMask updateMask) {
        UpdateSourceRequest request = UpdateSourceRequest.newBuilder().setSource(source).setUpdateMask(updateMask).build();
        return this.updateSourceAsync(request);
    }

    public final OperationFuture<Source, OperationMetadata> updateSourceAsync(UpdateSourceRequest request) {
        return this.updateSourceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateSourceRequest, Source, OperationMetadata> updateSourceOperationCallable() {
        return this.stub.updateSourceOperationCallable();
    }

    public final UnaryCallable<UpdateSourceRequest, Operation> updateSourceCallable() {
        return this.stub.updateSourceCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSourceAsync(SourceName name) {
        DeleteSourceRequest request = DeleteSourceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteSourceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSourceAsync(String name) {
        DeleteSourceRequest request = DeleteSourceRequest.newBuilder().setName(name).build();
        return this.deleteSourceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSourceAsync(DeleteSourceRequest request) {
        return this.deleteSourceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSourceRequest, Empty, OperationMetadata> deleteSourceOperationCallable() {
        return this.stub.deleteSourceOperationCallable();
    }

    public final UnaryCallable<DeleteSourceRequest, Operation> deleteSourceCallable() {
        return this.stub.deleteSourceCallable();
    }

    public final FetchInventoryResponse fetchInventory(SourceName source) {
        FetchInventoryRequest request = FetchInventoryRequest.newBuilder().setSource(source == null ? null : source.toString()).build();
        return this.fetchInventory(request);
    }

    public final FetchInventoryResponse fetchInventory(String source) {
        FetchInventoryRequest request = FetchInventoryRequest.newBuilder().setSource(source).build();
        return this.fetchInventory(request);
    }

    public final FetchInventoryResponse fetchInventory(FetchInventoryRequest request) {
        return (FetchInventoryResponse)this.fetchInventoryCallable().call((Object)request);
    }

    public final UnaryCallable<FetchInventoryRequest, FetchInventoryResponse> fetchInventoryCallable() {
        return this.stub.fetchInventoryCallable();
    }

    public final ListUtilizationReportsPagedResponse listUtilizationReports(SourceName parent) {
        ListUtilizationReportsRequest request = ListUtilizationReportsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listUtilizationReports(request);
    }

    public final ListUtilizationReportsPagedResponse listUtilizationReports(String parent) {
        ListUtilizationReportsRequest request = ListUtilizationReportsRequest.newBuilder().setParent(parent).build();
        return this.listUtilizationReports(request);
    }

    public final ListUtilizationReportsPagedResponse listUtilizationReports(ListUtilizationReportsRequest request) {
        return (ListUtilizationReportsPagedResponse)((Object)this.listUtilizationReportsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListUtilizationReportsRequest, ListUtilizationReportsPagedResponse> listUtilizationReportsPagedCallable() {
        return this.stub.listUtilizationReportsPagedCallable();
    }

    public final UnaryCallable<ListUtilizationReportsRequest, ListUtilizationReportsResponse> listUtilizationReportsCallable() {
        return this.stub.listUtilizationReportsCallable();
    }

    public final UtilizationReport getUtilizationReport(UtilizationReportName name) {
        GetUtilizationReportRequest request = GetUtilizationReportRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getUtilizationReport(request);
    }

    public final UtilizationReport getUtilizationReport(String name) {
        GetUtilizationReportRequest request = GetUtilizationReportRequest.newBuilder().setName(name).build();
        return this.getUtilizationReport(request);
    }

    public final UtilizationReport getUtilizationReport(GetUtilizationReportRequest request) {
        return (UtilizationReport)this.getUtilizationReportCallable().call((Object)request);
    }

    public final UnaryCallable<GetUtilizationReportRequest, UtilizationReport> getUtilizationReportCallable() {
        return this.stub.getUtilizationReportCallable();
    }

    public final OperationFuture<UtilizationReport, OperationMetadata> createUtilizationReportAsync(SourceName parent, UtilizationReport utilizationReport, String utilizationReportId) {
        CreateUtilizationReportRequest request = CreateUtilizationReportRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setUtilizationReport(utilizationReport).setUtilizationReportId(utilizationReportId).build();
        return this.createUtilizationReportAsync(request);
    }

    public final OperationFuture<UtilizationReport, OperationMetadata> createUtilizationReportAsync(String parent, UtilizationReport utilizationReport, String utilizationReportId) {
        CreateUtilizationReportRequest request = CreateUtilizationReportRequest.newBuilder().setParent(parent).setUtilizationReport(utilizationReport).setUtilizationReportId(utilizationReportId).build();
        return this.createUtilizationReportAsync(request);
    }

    public final OperationFuture<UtilizationReport, OperationMetadata> createUtilizationReportAsync(CreateUtilizationReportRequest request) {
        return this.createUtilizationReportOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateUtilizationReportRequest, UtilizationReport, OperationMetadata> createUtilizationReportOperationCallable() {
        return this.stub.createUtilizationReportOperationCallable();
    }

    public final UnaryCallable<CreateUtilizationReportRequest, Operation> createUtilizationReportCallable() {
        return this.stub.createUtilizationReportCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteUtilizationReportAsync(UtilizationReportName name) {
        DeleteUtilizationReportRequest request = DeleteUtilizationReportRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteUtilizationReportAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteUtilizationReportAsync(String name) {
        DeleteUtilizationReportRequest request = DeleteUtilizationReportRequest.newBuilder().setName(name).build();
        return this.deleteUtilizationReportAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteUtilizationReportAsync(DeleteUtilizationReportRequest request) {
        return this.deleteUtilizationReportOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteUtilizationReportRequest, Empty, OperationMetadata> deleteUtilizationReportOperationCallable() {
        return this.stub.deleteUtilizationReportOperationCallable();
    }

    public final UnaryCallable<DeleteUtilizationReportRequest, Operation> deleteUtilizationReportCallable() {
        return this.stub.deleteUtilizationReportCallable();
    }

    public final ListDatacenterConnectorsPagedResponse listDatacenterConnectors(SourceName parent) {
        ListDatacenterConnectorsRequest request = ListDatacenterConnectorsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDatacenterConnectors(request);
    }

    public final ListDatacenterConnectorsPagedResponse listDatacenterConnectors(String parent) {
        ListDatacenterConnectorsRequest request = ListDatacenterConnectorsRequest.newBuilder().setParent(parent).build();
        return this.listDatacenterConnectors(request);
    }

    public final ListDatacenterConnectorsPagedResponse listDatacenterConnectors(ListDatacenterConnectorsRequest request) {
        return (ListDatacenterConnectorsPagedResponse)((Object)this.listDatacenterConnectorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDatacenterConnectorsRequest, ListDatacenterConnectorsPagedResponse> listDatacenterConnectorsPagedCallable() {
        return this.stub.listDatacenterConnectorsPagedCallable();
    }

    public final UnaryCallable<ListDatacenterConnectorsRequest, ListDatacenterConnectorsResponse> listDatacenterConnectorsCallable() {
        return this.stub.listDatacenterConnectorsCallable();
    }

    public final DatacenterConnector getDatacenterConnector(DatacenterConnectorName name) {
        GetDatacenterConnectorRequest request = GetDatacenterConnectorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDatacenterConnector(request);
    }

    public final DatacenterConnector getDatacenterConnector(String name) {
        GetDatacenterConnectorRequest request = GetDatacenterConnectorRequest.newBuilder().setName(name).build();
        return this.getDatacenterConnector(request);
    }

    public final DatacenterConnector getDatacenterConnector(GetDatacenterConnectorRequest request) {
        return (DatacenterConnector)this.getDatacenterConnectorCallable().call((Object)request);
    }

    public final UnaryCallable<GetDatacenterConnectorRequest, DatacenterConnector> getDatacenterConnectorCallable() {
        return this.stub.getDatacenterConnectorCallable();
    }

    public final OperationFuture<DatacenterConnector, OperationMetadata> createDatacenterConnectorAsync(SourceName parent, DatacenterConnector datacenterConnector, String datacenterConnectorId) {
        CreateDatacenterConnectorRequest request = CreateDatacenterConnectorRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDatacenterConnector(datacenterConnector).setDatacenterConnectorId(datacenterConnectorId).build();
        return this.createDatacenterConnectorAsync(request);
    }

    public final OperationFuture<DatacenterConnector, OperationMetadata> createDatacenterConnectorAsync(String parent, DatacenterConnector datacenterConnector, String datacenterConnectorId) {
        CreateDatacenterConnectorRequest request = CreateDatacenterConnectorRequest.newBuilder().setParent(parent).setDatacenterConnector(datacenterConnector).setDatacenterConnectorId(datacenterConnectorId).build();
        return this.createDatacenterConnectorAsync(request);
    }

    public final OperationFuture<DatacenterConnector, OperationMetadata> createDatacenterConnectorAsync(CreateDatacenterConnectorRequest request) {
        return this.createDatacenterConnectorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDatacenterConnectorRequest, DatacenterConnector, OperationMetadata> createDatacenterConnectorOperationCallable() {
        return this.stub.createDatacenterConnectorOperationCallable();
    }

    public final UnaryCallable<CreateDatacenterConnectorRequest, Operation> createDatacenterConnectorCallable() {
        return this.stub.createDatacenterConnectorCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDatacenterConnectorAsync(DatacenterConnectorName name) {
        DeleteDatacenterConnectorRequest request = DeleteDatacenterConnectorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDatacenterConnectorAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDatacenterConnectorAsync(String name) {
        DeleteDatacenterConnectorRequest request = DeleteDatacenterConnectorRequest.newBuilder().setName(name).build();
        return this.deleteDatacenterConnectorAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDatacenterConnectorAsync(DeleteDatacenterConnectorRequest request) {
        return this.deleteDatacenterConnectorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDatacenterConnectorRequest, Empty, OperationMetadata> deleteDatacenterConnectorOperationCallable() {
        return this.stub.deleteDatacenterConnectorOperationCallable();
    }

    public final UnaryCallable<DeleteDatacenterConnectorRequest, Operation> deleteDatacenterConnectorCallable() {
        return this.stub.deleteDatacenterConnectorCallable();
    }

    public final OperationFuture<MigratingVm, OperationMetadata> createMigratingVmAsync(SourceName parent, MigratingVm migratingVm, String migratingVmId) {
        CreateMigratingVmRequest request = CreateMigratingVmRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMigratingVm(migratingVm).setMigratingVmId(migratingVmId).build();
        return this.createMigratingVmAsync(request);
    }

    public final OperationFuture<MigratingVm, OperationMetadata> createMigratingVmAsync(String parent, MigratingVm migratingVm, String migratingVmId) {
        CreateMigratingVmRequest request = CreateMigratingVmRequest.newBuilder().setParent(parent).setMigratingVm(migratingVm).setMigratingVmId(migratingVmId).build();
        return this.createMigratingVmAsync(request);
    }

    public final OperationFuture<MigratingVm, OperationMetadata> createMigratingVmAsync(CreateMigratingVmRequest request) {
        return this.createMigratingVmOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateMigratingVmRequest, MigratingVm, OperationMetadata> createMigratingVmOperationCallable() {
        return this.stub.createMigratingVmOperationCallable();
    }

    public final UnaryCallable<CreateMigratingVmRequest, Operation> createMigratingVmCallable() {
        return this.stub.createMigratingVmCallable();
    }

    public final ListMigratingVmsPagedResponse listMigratingVms(SourceName parent) {
        ListMigratingVmsRequest request = ListMigratingVmsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMigratingVms(request);
    }

    public final ListMigratingVmsPagedResponse listMigratingVms(String parent) {
        ListMigratingVmsRequest request = ListMigratingVmsRequest.newBuilder().setParent(parent).build();
        return this.listMigratingVms(request);
    }

    public final ListMigratingVmsPagedResponse listMigratingVms(ListMigratingVmsRequest request) {
        return (ListMigratingVmsPagedResponse)((Object)this.listMigratingVmsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMigratingVmsRequest, ListMigratingVmsPagedResponse> listMigratingVmsPagedCallable() {
        return this.stub.listMigratingVmsPagedCallable();
    }

    public final UnaryCallable<ListMigratingVmsRequest, ListMigratingVmsResponse> listMigratingVmsCallable() {
        return this.stub.listMigratingVmsCallable();
    }

    public final MigratingVm getMigratingVm(MigratingVmName name) {
        GetMigratingVmRequest request = GetMigratingVmRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMigratingVm(request);
    }

    public final MigratingVm getMigratingVm(String name) {
        GetMigratingVmRequest request = GetMigratingVmRequest.newBuilder().setName(name).build();
        return this.getMigratingVm(request);
    }

    public final MigratingVm getMigratingVm(GetMigratingVmRequest request) {
        return (MigratingVm)this.getMigratingVmCallable().call((Object)request);
    }

    public final UnaryCallable<GetMigratingVmRequest, MigratingVm> getMigratingVmCallable() {
        return this.stub.getMigratingVmCallable();
    }

    public final OperationFuture<MigratingVm, OperationMetadata> updateMigratingVmAsync(MigratingVm migratingVm, FieldMask updateMask) {
        UpdateMigratingVmRequest request = UpdateMigratingVmRequest.newBuilder().setMigratingVm(migratingVm).setUpdateMask(updateMask).build();
        return this.updateMigratingVmAsync(request);
    }

    public final OperationFuture<MigratingVm, OperationMetadata> updateMigratingVmAsync(UpdateMigratingVmRequest request) {
        return this.updateMigratingVmOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateMigratingVmRequest, MigratingVm, OperationMetadata> updateMigratingVmOperationCallable() {
        return this.stub.updateMigratingVmOperationCallable();
    }

    public final UnaryCallable<UpdateMigratingVmRequest, Operation> updateMigratingVmCallable() {
        return this.stub.updateMigratingVmCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMigratingVmAsync(MigratingVmName name) {
        DeleteMigratingVmRequest request = DeleteMigratingVmRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteMigratingVmAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMigratingVmAsync(String name) {
        DeleteMigratingVmRequest request = DeleteMigratingVmRequest.newBuilder().setName(name).build();
        return this.deleteMigratingVmAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMigratingVmAsync(DeleteMigratingVmRequest request) {
        return this.deleteMigratingVmOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteMigratingVmRequest, Empty, OperationMetadata> deleteMigratingVmOperationCallable() {
        return this.stub.deleteMigratingVmOperationCallable();
    }

    public final UnaryCallable<DeleteMigratingVmRequest, Operation> deleteMigratingVmCallable() {
        return this.stub.deleteMigratingVmCallable();
    }

    public final OperationFuture<StartMigrationResponse, OperationMetadata> startMigrationAsync(MigratingVmName migratingVm) {
        StartMigrationRequest request = StartMigrationRequest.newBuilder().setMigratingVm(migratingVm == null ? null : migratingVm.toString()).build();
        return this.startMigrationAsync(request);
    }

    public final OperationFuture<StartMigrationResponse, OperationMetadata> startMigrationAsync(String migratingVm) {
        StartMigrationRequest request = StartMigrationRequest.newBuilder().setMigratingVm(migratingVm).build();
        return this.startMigrationAsync(request);
    }

    public final OperationFuture<StartMigrationResponse, OperationMetadata> startMigrationAsync(StartMigrationRequest request) {
        return this.startMigrationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StartMigrationRequest, StartMigrationResponse, OperationMetadata> startMigrationOperationCallable() {
        return this.stub.startMigrationOperationCallable();
    }

    public final UnaryCallable<StartMigrationRequest, Operation> startMigrationCallable() {
        return this.stub.startMigrationCallable();
    }

    public final OperationFuture<ResumeMigrationResponse, OperationMetadata> resumeMigrationAsync(ResumeMigrationRequest request) {
        return this.resumeMigrationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResumeMigrationRequest, ResumeMigrationResponse, OperationMetadata> resumeMigrationOperationCallable() {
        return this.stub.resumeMigrationOperationCallable();
    }

    public final UnaryCallable<ResumeMigrationRequest, Operation> resumeMigrationCallable() {
        return this.stub.resumeMigrationCallable();
    }

    public final OperationFuture<PauseMigrationResponse, OperationMetadata> pauseMigrationAsync(PauseMigrationRequest request) {
        return this.pauseMigrationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PauseMigrationRequest, PauseMigrationResponse, OperationMetadata> pauseMigrationOperationCallable() {
        return this.stub.pauseMigrationOperationCallable();
    }

    public final UnaryCallable<PauseMigrationRequest, Operation> pauseMigrationCallable() {
        return this.stub.pauseMigrationCallable();
    }

    public final OperationFuture<FinalizeMigrationResponse, OperationMetadata> finalizeMigrationAsync(MigratingVmName migratingVm) {
        FinalizeMigrationRequest request = FinalizeMigrationRequest.newBuilder().setMigratingVm(migratingVm == null ? null : migratingVm.toString()).build();
        return this.finalizeMigrationAsync(request);
    }

    public final OperationFuture<FinalizeMigrationResponse, OperationMetadata> finalizeMigrationAsync(String migratingVm) {
        FinalizeMigrationRequest request = FinalizeMigrationRequest.newBuilder().setMigratingVm(migratingVm).build();
        return this.finalizeMigrationAsync(request);
    }

    public final OperationFuture<FinalizeMigrationResponse, OperationMetadata> finalizeMigrationAsync(FinalizeMigrationRequest request) {
        return this.finalizeMigrationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<FinalizeMigrationRequest, FinalizeMigrationResponse, OperationMetadata> finalizeMigrationOperationCallable() {
        return this.stub.finalizeMigrationOperationCallable();
    }

    public final UnaryCallable<FinalizeMigrationRequest, Operation> finalizeMigrationCallable() {
        return this.stub.finalizeMigrationCallable();
    }

    public final OperationFuture<CloneJob, OperationMetadata> createCloneJobAsync(MigratingVmName parent, CloneJob cloneJob, String cloneJobId) {
        CreateCloneJobRequest request = CreateCloneJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCloneJob(cloneJob).setCloneJobId(cloneJobId).build();
        return this.createCloneJobAsync(request);
    }

    public final OperationFuture<CloneJob, OperationMetadata> createCloneJobAsync(String parent, CloneJob cloneJob, String cloneJobId) {
        CreateCloneJobRequest request = CreateCloneJobRequest.newBuilder().setParent(parent).setCloneJob(cloneJob).setCloneJobId(cloneJobId).build();
        return this.createCloneJobAsync(request);
    }

    public final OperationFuture<CloneJob, OperationMetadata> createCloneJobAsync(CreateCloneJobRequest request) {
        return this.createCloneJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCloneJobRequest, CloneJob, OperationMetadata> createCloneJobOperationCallable() {
        return this.stub.createCloneJobOperationCallable();
    }

    public final UnaryCallable<CreateCloneJobRequest, Operation> createCloneJobCallable() {
        return this.stub.createCloneJobCallable();
    }

    public final OperationFuture<CancelCloneJobResponse, OperationMetadata> cancelCloneJobAsync(CloneJobName name) {
        CancelCloneJobRequest request = CancelCloneJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.cancelCloneJobAsync(request);
    }

    public final OperationFuture<CancelCloneJobResponse, OperationMetadata> cancelCloneJobAsync(String name) {
        CancelCloneJobRequest request = CancelCloneJobRequest.newBuilder().setName(name).build();
        return this.cancelCloneJobAsync(request);
    }

    public final OperationFuture<CancelCloneJobResponse, OperationMetadata> cancelCloneJobAsync(CancelCloneJobRequest request) {
        return this.cancelCloneJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CancelCloneJobRequest, CancelCloneJobResponse, OperationMetadata> cancelCloneJobOperationCallable() {
        return this.stub.cancelCloneJobOperationCallable();
    }

    public final UnaryCallable<CancelCloneJobRequest, Operation> cancelCloneJobCallable() {
        return this.stub.cancelCloneJobCallable();
    }

    public final ListCloneJobsPagedResponse listCloneJobs(MigratingVmName parent) {
        ListCloneJobsRequest request = ListCloneJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCloneJobs(request);
    }

    public final ListCloneJobsPagedResponse listCloneJobs(String parent) {
        ListCloneJobsRequest request = ListCloneJobsRequest.newBuilder().setParent(parent).build();
        return this.listCloneJobs(request);
    }

    public final ListCloneJobsPagedResponse listCloneJobs(ListCloneJobsRequest request) {
        return (ListCloneJobsPagedResponse)((Object)this.listCloneJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCloneJobsRequest, ListCloneJobsPagedResponse> listCloneJobsPagedCallable() {
        return this.stub.listCloneJobsPagedCallable();
    }

    public final UnaryCallable<ListCloneJobsRequest, ListCloneJobsResponse> listCloneJobsCallable() {
        return this.stub.listCloneJobsCallable();
    }

    public final CloneJob getCloneJob(CloneJobName name) {
        GetCloneJobRequest request = GetCloneJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCloneJob(request);
    }

    public final CloneJob getCloneJob(String name) {
        GetCloneJobRequest request = GetCloneJobRequest.newBuilder().setName(name).build();
        return this.getCloneJob(request);
    }

    public final CloneJob getCloneJob(GetCloneJobRequest request) {
        return (CloneJob)this.getCloneJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetCloneJobRequest, CloneJob> getCloneJobCallable() {
        return this.stub.getCloneJobCallable();
    }

    public final OperationFuture<CutoverJob, OperationMetadata> createCutoverJobAsync(MigratingVmName parent, CutoverJob cutoverJob, String cutoverJobId) {
        CreateCutoverJobRequest request = CreateCutoverJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCutoverJob(cutoverJob).setCutoverJobId(cutoverJobId).build();
        return this.createCutoverJobAsync(request);
    }

    public final OperationFuture<CutoverJob, OperationMetadata> createCutoverJobAsync(String parent, CutoverJob cutoverJob, String cutoverJobId) {
        CreateCutoverJobRequest request = CreateCutoverJobRequest.newBuilder().setParent(parent).setCutoverJob(cutoverJob).setCutoverJobId(cutoverJobId).build();
        return this.createCutoverJobAsync(request);
    }

    public final OperationFuture<CutoverJob, OperationMetadata> createCutoverJobAsync(CreateCutoverJobRequest request) {
        return this.createCutoverJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCutoverJobRequest, CutoverJob, OperationMetadata> createCutoverJobOperationCallable() {
        return this.stub.createCutoverJobOperationCallable();
    }

    public final UnaryCallable<CreateCutoverJobRequest, Operation> createCutoverJobCallable() {
        return this.stub.createCutoverJobCallable();
    }

    public final OperationFuture<CancelCutoverJobResponse, OperationMetadata> cancelCutoverJobAsync(CutoverJobName name) {
        CancelCutoverJobRequest request = CancelCutoverJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.cancelCutoverJobAsync(request);
    }

    public final OperationFuture<CancelCutoverJobResponse, OperationMetadata> cancelCutoverJobAsync(String name) {
        CancelCutoverJobRequest request = CancelCutoverJobRequest.newBuilder().setName(name).build();
        return this.cancelCutoverJobAsync(request);
    }

    public final OperationFuture<CancelCutoverJobResponse, OperationMetadata> cancelCutoverJobAsync(CancelCutoverJobRequest request) {
        return this.cancelCutoverJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CancelCutoverJobRequest, CancelCutoverJobResponse, OperationMetadata> cancelCutoverJobOperationCallable() {
        return this.stub.cancelCutoverJobOperationCallable();
    }

    public final UnaryCallable<CancelCutoverJobRequest, Operation> cancelCutoverJobCallable() {
        return this.stub.cancelCutoverJobCallable();
    }

    public final ListCutoverJobsPagedResponse listCutoverJobs(MigratingVmName parent) {
        ListCutoverJobsRequest request = ListCutoverJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCutoverJobs(request);
    }

    public final ListCutoverJobsPagedResponse listCutoverJobs(String parent) {
        ListCutoverJobsRequest request = ListCutoverJobsRequest.newBuilder().setParent(parent).build();
        return this.listCutoverJobs(request);
    }

    public final ListCutoverJobsPagedResponse listCutoverJobs(ListCutoverJobsRequest request) {
        return (ListCutoverJobsPagedResponse)((Object)this.listCutoverJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCutoverJobsRequest, ListCutoverJobsPagedResponse> listCutoverJobsPagedCallable() {
        return this.stub.listCutoverJobsPagedCallable();
    }

    public final UnaryCallable<ListCutoverJobsRequest, ListCutoverJobsResponse> listCutoverJobsCallable() {
        return this.stub.listCutoverJobsCallable();
    }

    public final CutoverJob getCutoverJob(CutoverJobName name) {
        GetCutoverJobRequest request = GetCutoverJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCutoverJob(request);
    }

    public final CutoverJob getCutoverJob(String name) {
        GetCutoverJobRequest request = GetCutoverJobRequest.newBuilder().setName(name).build();
        return this.getCutoverJob(request);
    }

    public final CutoverJob getCutoverJob(GetCutoverJobRequest request) {
        return (CutoverJob)this.getCutoverJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetCutoverJobRequest, CutoverJob> getCutoverJobCallable() {
        return this.stub.getCutoverJobCallable();
    }

    public final ListGroupsPagedResponse listGroups(LocationName parent) {
        ListGroupsRequest request = ListGroupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGroups(request);
    }

    public final ListGroupsPagedResponse listGroups(String parent) {
        ListGroupsRequest request = ListGroupsRequest.newBuilder().setParent(parent).build();
        return this.listGroups(request);
    }

    public final ListGroupsPagedResponse listGroups(ListGroupsRequest request) {
        return (ListGroupsPagedResponse)((Object)this.listGroupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGroupsRequest, ListGroupsPagedResponse> listGroupsPagedCallable() {
        return this.stub.listGroupsPagedCallable();
    }

    public final UnaryCallable<ListGroupsRequest, ListGroupsResponse> listGroupsCallable() {
        return this.stub.listGroupsCallable();
    }

    public final Group getGroup(GroupName name) {
        GetGroupRequest request = GetGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGroup(request);
    }

    public final Group getGroup(String name) {
        GetGroupRequest request = GetGroupRequest.newBuilder().setName(name).build();
        return this.getGroup(request);
    }

    public final Group getGroup(GetGroupRequest request) {
        return (Group)this.getGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetGroupRequest, Group> getGroupCallable() {
        return this.stub.getGroupCallable();
    }

    public final OperationFuture<Group, OperationMetadata> createGroupAsync(LocationName parent, Group group, String groupId) {
        CreateGroupRequest request = CreateGroupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGroup(group).setGroupId(groupId).build();
        return this.createGroupAsync(request);
    }

    public final OperationFuture<Group, OperationMetadata> createGroupAsync(String parent, Group group, String groupId) {
        CreateGroupRequest request = CreateGroupRequest.newBuilder().setParent(parent).setGroup(group).setGroupId(groupId).build();
        return this.createGroupAsync(request);
    }

    public final OperationFuture<Group, OperationMetadata> createGroupAsync(CreateGroupRequest request) {
        return this.createGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateGroupRequest, Group, OperationMetadata> createGroupOperationCallable() {
        return this.stub.createGroupOperationCallable();
    }

    public final UnaryCallable<CreateGroupRequest, Operation> createGroupCallable() {
        return this.stub.createGroupCallable();
    }

    public final OperationFuture<Group, OperationMetadata> updateGroupAsync(Group group, FieldMask updateMask) {
        UpdateGroupRequest request = UpdateGroupRequest.newBuilder().setGroup(group).setUpdateMask(updateMask).build();
        return this.updateGroupAsync(request);
    }

    public final OperationFuture<Group, OperationMetadata> updateGroupAsync(UpdateGroupRequest request) {
        return this.updateGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateGroupRequest, Group, OperationMetadata> updateGroupOperationCallable() {
        return this.stub.updateGroupOperationCallable();
    }

    public final UnaryCallable<UpdateGroupRequest, Operation> updateGroupCallable() {
        return this.stub.updateGroupCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGroupAsync(GroupName name) {
        DeleteGroupRequest request = DeleteGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteGroupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGroupAsync(String name) {
        DeleteGroupRequest request = DeleteGroupRequest.newBuilder().setName(name).build();
        return this.deleteGroupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGroupAsync(DeleteGroupRequest request) {
        return this.deleteGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteGroupRequest, Empty, OperationMetadata> deleteGroupOperationCallable() {
        return this.stub.deleteGroupOperationCallable();
    }

    public final UnaryCallable<DeleteGroupRequest, Operation> deleteGroupCallable() {
        return this.stub.deleteGroupCallable();
    }

    public final OperationFuture<AddGroupMigrationResponse, OperationMetadata> addGroupMigrationAsync(GroupName group) {
        AddGroupMigrationRequest request = AddGroupMigrationRequest.newBuilder().setGroup(group == null ? null : group.toString()).build();
        return this.addGroupMigrationAsync(request);
    }

    public final OperationFuture<AddGroupMigrationResponse, OperationMetadata> addGroupMigrationAsync(String group) {
        AddGroupMigrationRequest request = AddGroupMigrationRequest.newBuilder().setGroup(group).build();
        return this.addGroupMigrationAsync(request);
    }

    public final OperationFuture<AddGroupMigrationResponse, OperationMetadata> addGroupMigrationAsync(AddGroupMigrationRequest request) {
        return this.addGroupMigrationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddGroupMigrationRequest, AddGroupMigrationResponse, OperationMetadata> addGroupMigrationOperationCallable() {
        return this.stub.addGroupMigrationOperationCallable();
    }

    public final UnaryCallable<AddGroupMigrationRequest, Operation> addGroupMigrationCallable() {
        return this.stub.addGroupMigrationCallable();
    }

    public final OperationFuture<RemoveGroupMigrationResponse, OperationMetadata> removeGroupMigrationAsync(GroupName group) {
        RemoveGroupMigrationRequest request = RemoveGroupMigrationRequest.newBuilder().setGroup(group == null ? null : group.toString()).build();
        return this.removeGroupMigrationAsync(request);
    }

    public final OperationFuture<RemoveGroupMigrationResponse, OperationMetadata> removeGroupMigrationAsync(String group) {
        RemoveGroupMigrationRequest request = RemoveGroupMigrationRequest.newBuilder().setGroup(group).build();
        return this.removeGroupMigrationAsync(request);
    }

    public final OperationFuture<RemoveGroupMigrationResponse, OperationMetadata> removeGroupMigrationAsync(RemoveGroupMigrationRequest request) {
        return this.removeGroupMigrationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemoveGroupMigrationRequest, RemoveGroupMigrationResponse, OperationMetadata> removeGroupMigrationOperationCallable() {
        return this.stub.removeGroupMigrationOperationCallable();
    }

    public final UnaryCallable<RemoveGroupMigrationRequest, Operation> removeGroupMigrationCallable() {
        return this.stub.removeGroupMigrationCallable();
    }

    public final ListTargetProjectsPagedResponse listTargetProjects(LocationName parent) {
        ListTargetProjectsRequest request = ListTargetProjectsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTargetProjects(request);
    }

    public final ListTargetProjectsPagedResponse listTargetProjects(String parent) {
        ListTargetProjectsRequest request = ListTargetProjectsRequest.newBuilder().setParent(parent).build();
        return this.listTargetProjects(request);
    }

    public final ListTargetProjectsPagedResponse listTargetProjects(ListTargetProjectsRequest request) {
        return (ListTargetProjectsPagedResponse)((Object)this.listTargetProjectsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTargetProjectsRequest, ListTargetProjectsPagedResponse> listTargetProjectsPagedCallable() {
        return this.stub.listTargetProjectsPagedCallable();
    }

    public final UnaryCallable<ListTargetProjectsRequest, ListTargetProjectsResponse> listTargetProjectsCallable() {
        return this.stub.listTargetProjectsCallable();
    }

    public final TargetProject getTargetProject(TargetProjectName name) {
        GetTargetProjectRequest request = GetTargetProjectRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTargetProject(request);
    }

    public final TargetProject getTargetProject(String name) {
        GetTargetProjectRequest request = GetTargetProjectRequest.newBuilder().setName(name).build();
        return this.getTargetProject(request);
    }

    public final TargetProject getTargetProject(GetTargetProjectRequest request) {
        return (TargetProject)this.getTargetProjectCallable().call((Object)request);
    }

    public final UnaryCallable<GetTargetProjectRequest, TargetProject> getTargetProjectCallable() {
        return this.stub.getTargetProjectCallable();
    }

    public final OperationFuture<TargetProject, OperationMetadata> createTargetProjectAsync(LocationName parent, TargetProject targetProject, String targetProjectId) {
        CreateTargetProjectRequest request = CreateTargetProjectRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTargetProject(targetProject).setTargetProjectId(targetProjectId).build();
        return this.createTargetProjectAsync(request);
    }

    public final OperationFuture<TargetProject, OperationMetadata> createTargetProjectAsync(String parent, TargetProject targetProject, String targetProjectId) {
        CreateTargetProjectRequest request = CreateTargetProjectRequest.newBuilder().setParent(parent).setTargetProject(targetProject).setTargetProjectId(targetProjectId).build();
        return this.createTargetProjectAsync(request);
    }

    public final OperationFuture<TargetProject, OperationMetadata> createTargetProjectAsync(CreateTargetProjectRequest request) {
        return this.createTargetProjectOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateTargetProjectRequest, TargetProject, OperationMetadata> createTargetProjectOperationCallable() {
        return this.stub.createTargetProjectOperationCallable();
    }

    public final UnaryCallable<CreateTargetProjectRequest, Operation> createTargetProjectCallable() {
        return this.stub.createTargetProjectCallable();
    }

    public final OperationFuture<TargetProject, OperationMetadata> updateTargetProjectAsync(TargetProject targetProject, FieldMask updateMask) {
        UpdateTargetProjectRequest request = UpdateTargetProjectRequest.newBuilder().setTargetProject(targetProject).setUpdateMask(updateMask).build();
        return this.updateTargetProjectAsync(request);
    }

    public final OperationFuture<TargetProject, OperationMetadata> updateTargetProjectAsync(UpdateTargetProjectRequest request) {
        return this.updateTargetProjectOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateTargetProjectRequest, TargetProject, OperationMetadata> updateTargetProjectOperationCallable() {
        return this.stub.updateTargetProjectOperationCallable();
    }

    public final UnaryCallable<UpdateTargetProjectRequest, Operation> updateTargetProjectCallable() {
        return this.stub.updateTargetProjectCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTargetProjectAsync(TargetProjectName name) {
        DeleteTargetProjectRequest request = DeleteTargetProjectRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteTargetProjectAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTargetProjectAsync(String name) {
        DeleteTargetProjectRequest request = DeleteTargetProjectRequest.newBuilder().setName(name).build();
        return this.deleteTargetProjectAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTargetProjectAsync(DeleteTargetProjectRequest request) {
        return this.deleteTargetProjectOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTargetProjectRequest, Empty, OperationMetadata> deleteTargetProjectOperationCallable() {
        return this.stub.deleteTargetProjectOperationCallable();
    }

    public final UnaryCallable<DeleteTargetProjectRequest, Operation> deleteTargetProjectCallable() {
        return this.stub.deleteTargetProjectCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTargetProjectsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetProjectsRequest, ListTargetProjectsResponse, TargetProject, ListTargetProjectsPage, ListTargetProjectsFixedSizeCollection> {
        private ListTargetProjectsFixedSizeCollection(List<ListTargetProjectsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTargetProjectsFixedSizeCollection createEmptyCollection() {
            return new ListTargetProjectsFixedSizeCollection(null, 0);
        }

        protected ListTargetProjectsFixedSizeCollection createCollection(List<ListTargetProjectsPage> pages, int collectionSize) {
            return new ListTargetProjectsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTargetProjectsPage
    extends AbstractPage<ListTargetProjectsRequest, ListTargetProjectsResponse, TargetProject, ListTargetProjectsPage> {
        private ListTargetProjectsPage(PageContext<ListTargetProjectsRequest, ListTargetProjectsResponse, TargetProject> context, ListTargetProjectsResponse response) {
            super(context, (Object)response);
        }

        private static ListTargetProjectsPage createEmptyPage() {
            return new ListTargetProjectsPage(null, null);
        }

        protected ListTargetProjectsPage createPage(PageContext<ListTargetProjectsRequest, ListTargetProjectsResponse, TargetProject> context, ListTargetProjectsResponse response) {
            return new ListTargetProjectsPage(context, response);
        }

        public ApiFuture<ListTargetProjectsPage> createPageAsync(PageContext<ListTargetProjectsRequest, ListTargetProjectsResponse, TargetProject> context, ApiFuture<ListTargetProjectsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTargetProjectsPagedResponse
    extends AbstractPagedListResponse<ListTargetProjectsRequest, ListTargetProjectsResponse, TargetProject, ListTargetProjectsPage, ListTargetProjectsFixedSizeCollection> {
        public static ApiFuture<ListTargetProjectsPagedResponse> createAsync(PageContext<ListTargetProjectsRequest, ListTargetProjectsResponse, TargetProject> context, ApiFuture<ListTargetProjectsResponse> futureResponse) {
            ApiFuture<ListTargetProjectsPage> futurePage = ListTargetProjectsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTargetProjectsPagedResponse((ListTargetProjectsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTargetProjectsPagedResponse(ListTargetProjectsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTargetProjectsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGroupsRequest, ListGroupsResponse, Group, ListGroupsPage, ListGroupsFixedSizeCollection> {
        private ListGroupsFixedSizeCollection(List<ListGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGroupsFixedSizeCollection createEmptyCollection() {
            return new ListGroupsFixedSizeCollection(null, 0);
        }

        protected ListGroupsFixedSizeCollection createCollection(List<ListGroupsPage> pages, int collectionSize) {
            return new ListGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGroupsPage
    extends AbstractPage<ListGroupsRequest, ListGroupsResponse, Group, ListGroupsPage> {
        private ListGroupsPage(PageContext<ListGroupsRequest, ListGroupsResponse, Group> context, ListGroupsResponse response) {
            super(context, (Object)response);
        }

        private static ListGroupsPage createEmptyPage() {
            return new ListGroupsPage(null, null);
        }

        protected ListGroupsPage createPage(PageContext<ListGroupsRequest, ListGroupsResponse, Group> context, ListGroupsResponse response) {
            return new ListGroupsPage(context, response);
        }

        public ApiFuture<ListGroupsPage> createPageAsync(PageContext<ListGroupsRequest, ListGroupsResponse, Group> context, ApiFuture<ListGroupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGroupsPagedResponse
    extends AbstractPagedListResponse<ListGroupsRequest, ListGroupsResponse, Group, ListGroupsPage, ListGroupsFixedSizeCollection> {
        public static ApiFuture<ListGroupsPagedResponse> createAsync(PageContext<ListGroupsRequest, ListGroupsResponse, Group> context, ApiFuture<ListGroupsResponse> futureResponse) {
            ApiFuture<ListGroupsPage> futurePage = ListGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGroupsPagedResponse((ListGroupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGroupsPagedResponse(ListGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGroupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCutoverJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCutoverJobsRequest, ListCutoverJobsResponse, CutoverJob, ListCutoverJobsPage, ListCutoverJobsFixedSizeCollection> {
        private ListCutoverJobsFixedSizeCollection(List<ListCutoverJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCutoverJobsFixedSizeCollection createEmptyCollection() {
            return new ListCutoverJobsFixedSizeCollection(null, 0);
        }

        protected ListCutoverJobsFixedSizeCollection createCollection(List<ListCutoverJobsPage> pages, int collectionSize) {
            return new ListCutoverJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCutoverJobsPage
    extends AbstractPage<ListCutoverJobsRequest, ListCutoverJobsResponse, CutoverJob, ListCutoverJobsPage> {
        private ListCutoverJobsPage(PageContext<ListCutoverJobsRequest, ListCutoverJobsResponse, CutoverJob> context, ListCutoverJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListCutoverJobsPage createEmptyPage() {
            return new ListCutoverJobsPage(null, null);
        }

        protected ListCutoverJobsPage createPage(PageContext<ListCutoverJobsRequest, ListCutoverJobsResponse, CutoverJob> context, ListCutoverJobsResponse response) {
            return new ListCutoverJobsPage(context, response);
        }

        public ApiFuture<ListCutoverJobsPage> createPageAsync(PageContext<ListCutoverJobsRequest, ListCutoverJobsResponse, CutoverJob> context, ApiFuture<ListCutoverJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCutoverJobsPagedResponse
    extends AbstractPagedListResponse<ListCutoverJobsRequest, ListCutoverJobsResponse, CutoverJob, ListCutoverJobsPage, ListCutoverJobsFixedSizeCollection> {
        public static ApiFuture<ListCutoverJobsPagedResponse> createAsync(PageContext<ListCutoverJobsRequest, ListCutoverJobsResponse, CutoverJob> context, ApiFuture<ListCutoverJobsResponse> futureResponse) {
            ApiFuture<ListCutoverJobsPage> futurePage = ListCutoverJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCutoverJobsPagedResponse((ListCutoverJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCutoverJobsPagedResponse(ListCutoverJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCutoverJobsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCloneJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCloneJobsRequest, ListCloneJobsResponse, CloneJob, ListCloneJobsPage, ListCloneJobsFixedSizeCollection> {
        private ListCloneJobsFixedSizeCollection(List<ListCloneJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCloneJobsFixedSizeCollection createEmptyCollection() {
            return new ListCloneJobsFixedSizeCollection(null, 0);
        }

        protected ListCloneJobsFixedSizeCollection createCollection(List<ListCloneJobsPage> pages, int collectionSize) {
            return new ListCloneJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCloneJobsPage
    extends AbstractPage<ListCloneJobsRequest, ListCloneJobsResponse, CloneJob, ListCloneJobsPage> {
        private ListCloneJobsPage(PageContext<ListCloneJobsRequest, ListCloneJobsResponse, CloneJob> context, ListCloneJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListCloneJobsPage createEmptyPage() {
            return new ListCloneJobsPage(null, null);
        }

        protected ListCloneJobsPage createPage(PageContext<ListCloneJobsRequest, ListCloneJobsResponse, CloneJob> context, ListCloneJobsResponse response) {
            return new ListCloneJobsPage(context, response);
        }

        public ApiFuture<ListCloneJobsPage> createPageAsync(PageContext<ListCloneJobsRequest, ListCloneJobsResponse, CloneJob> context, ApiFuture<ListCloneJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCloneJobsPagedResponse
    extends AbstractPagedListResponse<ListCloneJobsRequest, ListCloneJobsResponse, CloneJob, ListCloneJobsPage, ListCloneJobsFixedSizeCollection> {
        public static ApiFuture<ListCloneJobsPagedResponse> createAsync(PageContext<ListCloneJobsRequest, ListCloneJobsResponse, CloneJob> context, ApiFuture<ListCloneJobsResponse> futureResponse) {
            ApiFuture<ListCloneJobsPage> futurePage = ListCloneJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCloneJobsPagedResponse((ListCloneJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCloneJobsPagedResponse(ListCloneJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCloneJobsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMigratingVmsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMigratingVmsRequest, ListMigratingVmsResponse, MigratingVm, ListMigratingVmsPage, ListMigratingVmsFixedSizeCollection> {
        private ListMigratingVmsFixedSizeCollection(List<ListMigratingVmsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMigratingVmsFixedSizeCollection createEmptyCollection() {
            return new ListMigratingVmsFixedSizeCollection(null, 0);
        }

        protected ListMigratingVmsFixedSizeCollection createCollection(List<ListMigratingVmsPage> pages, int collectionSize) {
            return new ListMigratingVmsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMigratingVmsPage
    extends AbstractPage<ListMigratingVmsRequest, ListMigratingVmsResponse, MigratingVm, ListMigratingVmsPage> {
        private ListMigratingVmsPage(PageContext<ListMigratingVmsRequest, ListMigratingVmsResponse, MigratingVm> context, ListMigratingVmsResponse response) {
            super(context, (Object)response);
        }

        private static ListMigratingVmsPage createEmptyPage() {
            return new ListMigratingVmsPage(null, null);
        }

        protected ListMigratingVmsPage createPage(PageContext<ListMigratingVmsRequest, ListMigratingVmsResponse, MigratingVm> context, ListMigratingVmsResponse response) {
            return new ListMigratingVmsPage(context, response);
        }

        public ApiFuture<ListMigratingVmsPage> createPageAsync(PageContext<ListMigratingVmsRequest, ListMigratingVmsResponse, MigratingVm> context, ApiFuture<ListMigratingVmsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMigratingVmsPagedResponse
    extends AbstractPagedListResponse<ListMigratingVmsRequest, ListMigratingVmsResponse, MigratingVm, ListMigratingVmsPage, ListMigratingVmsFixedSizeCollection> {
        public static ApiFuture<ListMigratingVmsPagedResponse> createAsync(PageContext<ListMigratingVmsRequest, ListMigratingVmsResponse, MigratingVm> context, ApiFuture<ListMigratingVmsResponse> futureResponse) {
            ApiFuture<ListMigratingVmsPage> futurePage = ListMigratingVmsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMigratingVmsPagedResponse((ListMigratingVmsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMigratingVmsPagedResponse(ListMigratingVmsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMigratingVmsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDatacenterConnectorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDatacenterConnectorsRequest, ListDatacenterConnectorsResponse, DatacenterConnector, ListDatacenterConnectorsPage, ListDatacenterConnectorsFixedSizeCollection> {
        private ListDatacenterConnectorsFixedSizeCollection(List<ListDatacenterConnectorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDatacenterConnectorsFixedSizeCollection createEmptyCollection() {
            return new ListDatacenterConnectorsFixedSizeCollection(null, 0);
        }

        protected ListDatacenterConnectorsFixedSizeCollection createCollection(List<ListDatacenterConnectorsPage> pages, int collectionSize) {
            return new ListDatacenterConnectorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDatacenterConnectorsPage
    extends AbstractPage<ListDatacenterConnectorsRequest, ListDatacenterConnectorsResponse, DatacenterConnector, ListDatacenterConnectorsPage> {
        private ListDatacenterConnectorsPage(PageContext<ListDatacenterConnectorsRequest, ListDatacenterConnectorsResponse, DatacenterConnector> context, ListDatacenterConnectorsResponse response) {
            super(context, (Object)response);
        }

        private static ListDatacenterConnectorsPage createEmptyPage() {
            return new ListDatacenterConnectorsPage(null, null);
        }

        protected ListDatacenterConnectorsPage createPage(PageContext<ListDatacenterConnectorsRequest, ListDatacenterConnectorsResponse, DatacenterConnector> context, ListDatacenterConnectorsResponse response) {
            return new ListDatacenterConnectorsPage(context, response);
        }

        public ApiFuture<ListDatacenterConnectorsPage> createPageAsync(PageContext<ListDatacenterConnectorsRequest, ListDatacenterConnectorsResponse, DatacenterConnector> context, ApiFuture<ListDatacenterConnectorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDatacenterConnectorsPagedResponse
    extends AbstractPagedListResponse<ListDatacenterConnectorsRequest, ListDatacenterConnectorsResponse, DatacenterConnector, ListDatacenterConnectorsPage, ListDatacenterConnectorsFixedSizeCollection> {
        public static ApiFuture<ListDatacenterConnectorsPagedResponse> createAsync(PageContext<ListDatacenterConnectorsRequest, ListDatacenterConnectorsResponse, DatacenterConnector> context, ApiFuture<ListDatacenterConnectorsResponse> futureResponse) {
            ApiFuture<ListDatacenterConnectorsPage> futurePage = ListDatacenterConnectorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDatacenterConnectorsPagedResponse((ListDatacenterConnectorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDatacenterConnectorsPagedResponse(ListDatacenterConnectorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDatacenterConnectorsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListUtilizationReportsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUtilizationReportsRequest, ListUtilizationReportsResponse, UtilizationReport, ListUtilizationReportsPage, ListUtilizationReportsFixedSizeCollection> {
        private ListUtilizationReportsFixedSizeCollection(List<ListUtilizationReportsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListUtilizationReportsFixedSizeCollection createEmptyCollection() {
            return new ListUtilizationReportsFixedSizeCollection(null, 0);
        }

        protected ListUtilizationReportsFixedSizeCollection createCollection(List<ListUtilizationReportsPage> pages, int collectionSize) {
            return new ListUtilizationReportsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListUtilizationReportsPage
    extends AbstractPage<ListUtilizationReportsRequest, ListUtilizationReportsResponse, UtilizationReport, ListUtilizationReportsPage> {
        private ListUtilizationReportsPage(PageContext<ListUtilizationReportsRequest, ListUtilizationReportsResponse, UtilizationReport> context, ListUtilizationReportsResponse response) {
            super(context, (Object)response);
        }

        private static ListUtilizationReportsPage createEmptyPage() {
            return new ListUtilizationReportsPage(null, null);
        }

        protected ListUtilizationReportsPage createPage(PageContext<ListUtilizationReportsRequest, ListUtilizationReportsResponse, UtilizationReport> context, ListUtilizationReportsResponse response) {
            return new ListUtilizationReportsPage(context, response);
        }

        public ApiFuture<ListUtilizationReportsPage> createPageAsync(PageContext<ListUtilizationReportsRequest, ListUtilizationReportsResponse, UtilizationReport> context, ApiFuture<ListUtilizationReportsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListUtilizationReportsPagedResponse
    extends AbstractPagedListResponse<ListUtilizationReportsRequest, ListUtilizationReportsResponse, UtilizationReport, ListUtilizationReportsPage, ListUtilizationReportsFixedSizeCollection> {
        public static ApiFuture<ListUtilizationReportsPagedResponse> createAsync(PageContext<ListUtilizationReportsRequest, ListUtilizationReportsResponse, UtilizationReport> context, ApiFuture<ListUtilizationReportsResponse> futureResponse) {
            ApiFuture<ListUtilizationReportsPage> futurePage = ListUtilizationReportsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListUtilizationReportsPagedResponse((ListUtilizationReportsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListUtilizationReportsPagedResponse(ListUtilizationReportsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListUtilizationReportsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSourcesRequest, ListSourcesResponse, Source, ListSourcesPage, ListSourcesFixedSizeCollection> {
        private ListSourcesFixedSizeCollection(List<ListSourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSourcesFixedSizeCollection createEmptyCollection() {
            return new ListSourcesFixedSizeCollection(null, 0);
        }

        protected ListSourcesFixedSizeCollection createCollection(List<ListSourcesPage> pages, int collectionSize) {
            return new ListSourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSourcesPage
    extends AbstractPage<ListSourcesRequest, ListSourcesResponse, Source, ListSourcesPage> {
        private ListSourcesPage(PageContext<ListSourcesRequest, ListSourcesResponse, Source> context, ListSourcesResponse response) {
            super(context, (Object)response);
        }

        private static ListSourcesPage createEmptyPage() {
            return new ListSourcesPage(null, null);
        }

        protected ListSourcesPage createPage(PageContext<ListSourcesRequest, ListSourcesResponse, Source> context, ListSourcesResponse response) {
            return new ListSourcesPage(context, response);
        }

        public ApiFuture<ListSourcesPage> createPageAsync(PageContext<ListSourcesRequest, ListSourcesResponse, Source> context, ApiFuture<ListSourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSourcesPagedResponse
    extends AbstractPagedListResponse<ListSourcesRequest, ListSourcesResponse, Source, ListSourcesPage, ListSourcesFixedSizeCollection> {
        public static ApiFuture<ListSourcesPagedResponse> createAsync(PageContext<ListSourcesRequest, ListSourcesResponse, Source> context, ApiFuture<ListSourcesResponse> futureResponse) {
            ApiFuture<ListSourcesPage> futurePage = ListSourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSourcesPagedResponse((ListSourcesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSourcesPagedResponse(ListSourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSourcesFixedSizeCollection.createEmptyCollection());
        }
    }
}

