/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.visionai.v1.AddApplicationStreamInputRequest;
import com.google.cloud.visionai.v1.AddApplicationStreamInputResponse;
import com.google.cloud.visionai.v1.AppPlatformClient;
import com.google.cloud.visionai.v1.Application;
import com.google.cloud.visionai.v1.CreateApplicationInstancesRequest;
import com.google.cloud.visionai.v1.CreateApplicationInstancesResponse;
import com.google.cloud.visionai.v1.CreateApplicationRequest;
import com.google.cloud.visionai.v1.CreateDraftRequest;
import com.google.cloud.visionai.v1.CreateProcessorRequest;
import com.google.cloud.visionai.v1.DeleteApplicationInstancesRequest;
import com.google.cloud.visionai.v1.DeleteApplicationRequest;
import com.google.cloud.visionai.v1.DeleteDraftRequest;
import com.google.cloud.visionai.v1.DeleteProcessorRequest;
import com.google.cloud.visionai.v1.DeployApplicationRequest;
import com.google.cloud.visionai.v1.DeployApplicationResponse;
import com.google.cloud.visionai.v1.Draft;
import com.google.cloud.visionai.v1.GetApplicationRequest;
import com.google.cloud.visionai.v1.GetDraftRequest;
import com.google.cloud.visionai.v1.GetInstanceRequest;
import com.google.cloud.visionai.v1.GetProcessorRequest;
import com.google.cloud.visionai.v1.Instance;
import com.google.cloud.visionai.v1.ListApplicationsRequest;
import com.google.cloud.visionai.v1.ListApplicationsResponse;
import com.google.cloud.visionai.v1.ListDraftsRequest;
import com.google.cloud.visionai.v1.ListDraftsResponse;
import com.google.cloud.visionai.v1.ListInstancesRequest;
import com.google.cloud.visionai.v1.ListInstancesResponse;
import com.google.cloud.visionai.v1.ListPrebuiltProcessorsRequest;
import com.google.cloud.visionai.v1.ListPrebuiltProcessorsResponse;
import com.google.cloud.visionai.v1.ListProcessorsRequest;
import com.google.cloud.visionai.v1.ListProcessorsResponse;
import com.google.cloud.visionai.v1.OperationMetadata;
import com.google.cloud.visionai.v1.Processor;
import com.google.cloud.visionai.v1.RemoveApplicationStreamInputRequest;
import com.google.cloud.visionai.v1.RemoveApplicationStreamInputResponse;
import com.google.cloud.visionai.v1.UndeployApplicationRequest;
import com.google.cloud.visionai.v1.UndeployApplicationResponse;
import com.google.cloud.visionai.v1.UpdateApplicationInstancesRequest;
import com.google.cloud.visionai.v1.UpdateApplicationInstancesResponse;
import com.google.cloud.visionai.v1.UpdateApplicationRequest;
import com.google.cloud.visionai.v1.UpdateApplicationStreamInputRequest;
import com.google.cloud.visionai.v1.UpdateApplicationStreamInputResponse;
import com.google.cloud.visionai.v1.UpdateDraftRequest;
import com.google.cloud.visionai.v1.UpdateProcessorRequest;
import com.google.cloud.visionai.v1.stub.AppPlatformStub;
import com.google.cloud.visionai.v1.stub.GrpcAppPlatformStub;
import com.google.cloud.visionai.v1.stub.HttpJsonAppPlatformStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AppPlatformStubSettings
extends StubSettings<AppPlatformStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListApplicationsRequest, ListApplicationsResponse, AppPlatformClient.ListApplicationsPagedResponse> listApplicationsSettings;
    private final UnaryCallSettings<GetApplicationRequest, Application> getApplicationSettings;
    private final UnaryCallSettings<CreateApplicationRequest, Operation> createApplicationSettings;
    private final OperationCallSettings<CreateApplicationRequest, Application, OperationMetadata> createApplicationOperationSettings;
    private final UnaryCallSettings<UpdateApplicationRequest, Operation> updateApplicationSettings;
    private final OperationCallSettings<UpdateApplicationRequest, Application, OperationMetadata> updateApplicationOperationSettings;
    private final UnaryCallSettings<DeleteApplicationRequest, Operation> deleteApplicationSettings;
    private final OperationCallSettings<DeleteApplicationRequest, Empty, OperationMetadata> deleteApplicationOperationSettings;
    private final UnaryCallSettings<DeployApplicationRequest, Operation> deployApplicationSettings;
    private final OperationCallSettings<DeployApplicationRequest, DeployApplicationResponse, OperationMetadata> deployApplicationOperationSettings;
    private final UnaryCallSettings<UndeployApplicationRequest, Operation> undeployApplicationSettings;
    private final OperationCallSettings<UndeployApplicationRequest, UndeployApplicationResponse, OperationMetadata> undeployApplicationOperationSettings;
    private final UnaryCallSettings<AddApplicationStreamInputRequest, Operation> addApplicationStreamInputSettings;
    private final OperationCallSettings<AddApplicationStreamInputRequest, AddApplicationStreamInputResponse, OperationMetadata> addApplicationStreamInputOperationSettings;
    private final UnaryCallSettings<RemoveApplicationStreamInputRequest, Operation> removeApplicationStreamInputSettings;
    private final OperationCallSettings<RemoveApplicationStreamInputRequest, RemoveApplicationStreamInputResponse, OperationMetadata> removeApplicationStreamInputOperationSettings;
    private final UnaryCallSettings<UpdateApplicationStreamInputRequest, Operation> updateApplicationStreamInputSettings;
    private final OperationCallSettings<UpdateApplicationStreamInputRequest, UpdateApplicationStreamInputResponse, OperationMetadata> updateApplicationStreamInputOperationSettings;
    private final PagedCallSettings<ListInstancesRequest, ListInstancesResponse, AppPlatformClient.ListInstancesPagedResponse> listInstancesSettings;
    private final UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings;
    private final UnaryCallSettings<CreateApplicationInstancesRequest, Operation> createApplicationInstancesSettings;
    private final OperationCallSettings<CreateApplicationInstancesRequest, CreateApplicationInstancesResponse, OperationMetadata> createApplicationInstancesOperationSettings;
    private final UnaryCallSettings<DeleteApplicationInstancesRequest, Operation> deleteApplicationInstancesSettings;
    private final OperationCallSettings<DeleteApplicationInstancesRequest, Instance, OperationMetadata> deleteApplicationInstancesOperationSettings;
    private final UnaryCallSettings<UpdateApplicationInstancesRequest, Operation> updateApplicationInstancesSettings;
    private final OperationCallSettings<UpdateApplicationInstancesRequest, UpdateApplicationInstancesResponse, OperationMetadata> updateApplicationInstancesOperationSettings;
    private final PagedCallSettings<ListDraftsRequest, ListDraftsResponse, AppPlatformClient.ListDraftsPagedResponse> listDraftsSettings;
    private final UnaryCallSettings<GetDraftRequest, Draft> getDraftSettings;
    private final UnaryCallSettings<CreateDraftRequest, Operation> createDraftSettings;
    private final OperationCallSettings<CreateDraftRequest, Draft, OperationMetadata> createDraftOperationSettings;
    private final UnaryCallSettings<UpdateDraftRequest, Operation> updateDraftSettings;
    private final OperationCallSettings<UpdateDraftRequest, Draft, OperationMetadata> updateDraftOperationSettings;
    private final UnaryCallSettings<DeleteDraftRequest, Operation> deleteDraftSettings;
    private final OperationCallSettings<DeleteDraftRequest, Empty, OperationMetadata> deleteDraftOperationSettings;
    private final PagedCallSettings<ListProcessorsRequest, ListProcessorsResponse, AppPlatformClient.ListProcessorsPagedResponse> listProcessorsSettings;
    private final UnaryCallSettings<ListPrebuiltProcessorsRequest, ListPrebuiltProcessorsResponse> listPrebuiltProcessorsSettings;
    private final UnaryCallSettings<GetProcessorRequest, Processor> getProcessorSettings;
    private final UnaryCallSettings<CreateProcessorRequest, Operation> createProcessorSettings;
    private final OperationCallSettings<CreateProcessorRequest, Processor, OperationMetadata> createProcessorOperationSettings;
    private final UnaryCallSettings<UpdateProcessorRequest, Operation> updateProcessorSettings;
    private final OperationCallSettings<UpdateProcessorRequest, Processor, OperationMetadata> updateProcessorOperationSettings;
    private final UnaryCallSettings<DeleteProcessorRequest, Operation> deleteProcessorSettings;
    private final OperationCallSettings<DeleteProcessorRequest, Empty, OperationMetadata> deleteProcessorOperationSettings;
    private static final PagedListDescriptor<ListApplicationsRequest, ListApplicationsResponse, Application> LIST_APPLICATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListApplicationsRequest, ListApplicationsResponse, Application>(){

        public String emptyToken() {
            return "";
        }

        public ListApplicationsRequest injectToken(ListApplicationsRequest payload, String token) {
            return ListApplicationsRequest.newBuilder((ListApplicationsRequest)payload).setPageToken(token).build();
        }

        public ListApplicationsRequest injectPageSize(ListApplicationsRequest payload, int pageSize) {
            return ListApplicationsRequest.newBuilder((ListApplicationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListApplicationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListApplicationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Application> extractResources(ListApplicationsResponse payload) {
            return payload.getApplicationsList() == null ? ImmutableList.of() : payload.getApplicationsList();
        }
    };
    private static final PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance> LIST_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesRequest injectToken(ListInstancesRequest payload, String token) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageToken(token).build();
        }

        public ListInstancesRequest injectPageSize(ListInstancesRequest payload, int pageSize) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInstancesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Instance> extractResources(ListInstancesResponse payload) {
            return payload.getInstancesList() == null ? ImmutableList.of() : payload.getInstancesList();
        }
    };
    private static final PagedListDescriptor<ListDraftsRequest, ListDraftsResponse, Draft> LIST_DRAFTS_PAGE_STR_DESC = new PagedListDescriptor<ListDraftsRequest, ListDraftsResponse, Draft>(){

        public String emptyToken() {
            return "";
        }

        public ListDraftsRequest injectToken(ListDraftsRequest payload, String token) {
            return ListDraftsRequest.newBuilder((ListDraftsRequest)payload).setPageToken(token).build();
        }

        public ListDraftsRequest injectPageSize(ListDraftsRequest payload, int pageSize) {
            return ListDraftsRequest.newBuilder((ListDraftsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDraftsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDraftsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Draft> extractResources(ListDraftsResponse payload) {
            return payload.getDraftsList() == null ? ImmutableList.of() : payload.getDraftsList();
        }
    };
    private static final PagedListDescriptor<ListProcessorsRequest, ListProcessorsResponse, Processor> LIST_PROCESSORS_PAGE_STR_DESC = new PagedListDescriptor<ListProcessorsRequest, ListProcessorsResponse, Processor>(){

        public String emptyToken() {
            return "";
        }

        public ListProcessorsRequest injectToken(ListProcessorsRequest payload, String token) {
            return ListProcessorsRequest.newBuilder((ListProcessorsRequest)payload).setPageToken(token).build();
        }

        public ListProcessorsRequest injectPageSize(ListProcessorsRequest payload, int pageSize) {
            return ListProcessorsRequest.newBuilder((ListProcessorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListProcessorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListProcessorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Processor> extractResources(ListProcessorsResponse payload) {
            return payload.getProcessorsList() == null ? ImmutableList.of() : payload.getProcessorsList();
        }
    };
    private static final PagedListResponseFactory<ListApplicationsRequest, ListApplicationsResponse, AppPlatformClient.ListApplicationsPagedResponse> LIST_APPLICATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListApplicationsRequest, ListApplicationsResponse, AppPlatformClient.ListApplicationsPagedResponse>(){

        public ApiFuture<AppPlatformClient.ListApplicationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListApplicationsRequest, ListApplicationsResponse> callable, ListApplicationsRequest request, ApiCallContext context, ApiFuture<ListApplicationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_APPLICATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AppPlatformClient.ListApplicationsPagedResponse.createAsync((PageContext<ListApplicationsRequest, ListApplicationsResponse, Application>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, AppPlatformClient.ListInstancesPagedResponse> LIST_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, AppPlatformClient.ListInstancesPagedResponse>(){

        public ApiFuture<AppPlatformClient.ListInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesRequest, ListInstancesResponse> callable, ListInstancesRequest request, ApiCallContext context, ApiFuture<ListInstancesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AppPlatformClient.ListInstancesPagedResponse.createAsync((PageContext<ListInstancesRequest, ListInstancesResponse, Instance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDraftsRequest, ListDraftsResponse, AppPlatformClient.ListDraftsPagedResponse> LIST_DRAFTS_PAGE_STR_FACT = new PagedListResponseFactory<ListDraftsRequest, ListDraftsResponse, AppPlatformClient.ListDraftsPagedResponse>(){

        public ApiFuture<AppPlatformClient.ListDraftsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDraftsRequest, ListDraftsResponse> callable, ListDraftsRequest request, ApiCallContext context, ApiFuture<ListDraftsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DRAFTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AppPlatformClient.ListDraftsPagedResponse.createAsync((PageContext<ListDraftsRequest, ListDraftsResponse, Draft>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListProcessorsRequest, ListProcessorsResponse, AppPlatformClient.ListProcessorsPagedResponse> LIST_PROCESSORS_PAGE_STR_FACT = new PagedListResponseFactory<ListProcessorsRequest, ListProcessorsResponse, AppPlatformClient.ListProcessorsPagedResponse>(){

        public ApiFuture<AppPlatformClient.ListProcessorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListProcessorsRequest, ListProcessorsResponse> callable, ListProcessorsRequest request, ApiCallContext context, ApiFuture<ListProcessorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PROCESSORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AppPlatformClient.ListProcessorsPagedResponse.createAsync((PageContext<ListProcessorsRequest, ListProcessorsResponse, Processor>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListApplicationsRequest, ListApplicationsResponse, AppPlatformClient.ListApplicationsPagedResponse> listApplicationsSettings() {
        return this.listApplicationsSettings;
    }

    public UnaryCallSettings<GetApplicationRequest, Application> getApplicationSettings() {
        return this.getApplicationSettings;
    }

    public UnaryCallSettings<CreateApplicationRequest, Operation> createApplicationSettings() {
        return this.createApplicationSettings;
    }

    public OperationCallSettings<CreateApplicationRequest, Application, OperationMetadata> createApplicationOperationSettings() {
        return this.createApplicationOperationSettings;
    }

    public UnaryCallSettings<UpdateApplicationRequest, Operation> updateApplicationSettings() {
        return this.updateApplicationSettings;
    }

    public OperationCallSettings<UpdateApplicationRequest, Application, OperationMetadata> updateApplicationOperationSettings() {
        return this.updateApplicationOperationSettings;
    }

    public UnaryCallSettings<DeleteApplicationRequest, Operation> deleteApplicationSettings() {
        return this.deleteApplicationSettings;
    }

    public OperationCallSettings<DeleteApplicationRequest, Empty, OperationMetadata> deleteApplicationOperationSettings() {
        return this.deleteApplicationOperationSettings;
    }

    public UnaryCallSettings<DeployApplicationRequest, Operation> deployApplicationSettings() {
        return this.deployApplicationSettings;
    }

    public OperationCallSettings<DeployApplicationRequest, DeployApplicationResponse, OperationMetadata> deployApplicationOperationSettings() {
        return this.deployApplicationOperationSettings;
    }

    public UnaryCallSettings<UndeployApplicationRequest, Operation> undeployApplicationSettings() {
        return this.undeployApplicationSettings;
    }

    public OperationCallSettings<UndeployApplicationRequest, UndeployApplicationResponse, OperationMetadata> undeployApplicationOperationSettings() {
        return this.undeployApplicationOperationSettings;
    }

    public UnaryCallSettings<AddApplicationStreamInputRequest, Operation> addApplicationStreamInputSettings() {
        return this.addApplicationStreamInputSettings;
    }

    public OperationCallSettings<AddApplicationStreamInputRequest, AddApplicationStreamInputResponse, OperationMetadata> addApplicationStreamInputOperationSettings() {
        return this.addApplicationStreamInputOperationSettings;
    }

    public UnaryCallSettings<RemoveApplicationStreamInputRequest, Operation> removeApplicationStreamInputSettings() {
        return this.removeApplicationStreamInputSettings;
    }

    public OperationCallSettings<RemoveApplicationStreamInputRequest, RemoveApplicationStreamInputResponse, OperationMetadata> removeApplicationStreamInputOperationSettings() {
        return this.removeApplicationStreamInputOperationSettings;
    }

    public UnaryCallSettings<UpdateApplicationStreamInputRequest, Operation> updateApplicationStreamInputSettings() {
        return this.updateApplicationStreamInputSettings;
    }

    public OperationCallSettings<UpdateApplicationStreamInputRequest, UpdateApplicationStreamInputResponse, OperationMetadata> updateApplicationStreamInputOperationSettings() {
        return this.updateApplicationStreamInputOperationSettings;
    }

    public PagedCallSettings<ListInstancesRequest, ListInstancesResponse, AppPlatformClient.ListInstancesPagedResponse> listInstancesSettings() {
        return this.listInstancesSettings;
    }

    public UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings() {
        return this.getInstanceSettings;
    }

    public UnaryCallSettings<CreateApplicationInstancesRequest, Operation> createApplicationInstancesSettings() {
        return this.createApplicationInstancesSettings;
    }

    public OperationCallSettings<CreateApplicationInstancesRequest, CreateApplicationInstancesResponse, OperationMetadata> createApplicationInstancesOperationSettings() {
        return this.createApplicationInstancesOperationSettings;
    }

    public UnaryCallSettings<DeleteApplicationInstancesRequest, Operation> deleteApplicationInstancesSettings() {
        return this.deleteApplicationInstancesSettings;
    }

    public OperationCallSettings<DeleteApplicationInstancesRequest, Instance, OperationMetadata> deleteApplicationInstancesOperationSettings() {
        return this.deleteApplicationInstancesOperationSettings;
    }

    public UnaryCallSettings<UpdateApplicationInstancesRequest, Operation> updateApplicationInstancesSettings() {
        return this.updateApplicationInstancesSettings;
    }

    public OperationCallSettings<UpdateApplicationInstancesRequest, UpdateApplicationInstancesResponse, OperationMetadata> updateApplicationInstancesOperationSettings() {
        return this.updateApplicationInstancesOperationSettings;
    }

    public PagedCallSettings<ListDraftsRequest, ListDraftsResponse, AppPlatformClient.ListDraftsPagedResponse> listDraftsSettings() {
        return this.listDraftsSettings;
    }

    public UnaryCallSettings<GetDraftRequest, Draft> getDraftSettings() {
        return this.getDraftSettings;
    }

    public UnaryCallSettings<CreateDraftRequest, Operation> createDraftSettings() {
        return this.createDraftSettings;
    }

    public OperationCallSettings<CreateDraftRequest, Draft, OperationMetadata> createDraftOperationSettings() {
        return this.createDraftOperationSettings;
    }

    public UnaryCallSettings<UpdateDraftRequest, Operation> updateDraftSettings() {
        return this.updateDraftSettings;
    }

    public OperationCallSettings<UpdateDraftRequest, Draft, OperationMetadata> updateDraftOperationSettings() {
        return this.updateDraftOperationSettings;
    }

    public UnaryCallSettings<DeleteDraftRequest, Operation> deleteDraftSettings() {
        return this.deleteDraftSettings;
    }

    public OperationCallSettings<DeleteDraftRequest, Empty, OperationMetadata> deleteDraftOperationSettings() {
        return this.deleteDraftOperationSettings;
    }

    public PagedCallSettings<ListProcessorsRequest, ListProcessorsResponse, AppPlatformClient.ListProcessorsPagedResponse> listProcessorsSettings() {
        return this.listProcessorsSettings;
    }

    public UnaryCallSettings<ListPrebuiltProcessorsRequest, ListPrebuiltProcessorsResponse> listPrebuiltProcessorsSettings() {
        return this.listPrebuiltProcessorsSettings;
    }

    public UnaryCallSettings<GetProcessorRequest, Processor> getProcessorSettings() {
        return this.getProcessorSettings;
    }

    public UnaryCallSettings<CreateProcessorRequest, Operation> createProcessorSettings() {
        return this.createProcessorSettings;
    }

    public OperationCallSettings<CreateProcessorRequest, Processor, OperationMetadata> createProcessorOperationSettings() {
        return this.createProcessorOperationSettings;
    }

    public UnaryCallSettings<UpdateProcessorRequest, Operation> updateProcessorSettings() {
        return this.updateProcessorSettings;
    }

    public OperationCallSettings<UpdateProcessorRequest, Processor, OperationMetadata> updateProcessorOperationSettings() {
        return this.updateProcessorOperationSettings;
    }

    public UnaryCallSettings<DeleteProcessorRequest, Operation> deleteProcessorSettings() {
        return this.deleteProcessorSettings;
    }

    public OperationCallSettings<DeleteProcessorRequest, Empty, OperationMetadata> deleteProcessorOperationSettings() {
        return this.deleteProcessorOperationSettings;
    }

    public AppPlatformStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAppPlatformStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAppPlatformStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "visionai";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "visionai.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "visionai.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AppPlatformStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AppPlatformStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AppPlatformStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AppPlatformStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AppPlatformStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listApplicationsSettings = settingsBuilder.listApplicationsSettings().build();
        this.getApplicationSettings = settingsBuilder.getApplicationSettings().build();
        this.createApplicationSettings = settingsBuilder.createApplicationSettings().build();
        this.createApplicationOperationSettings = settingsBuilder.createApplicationOperationSettings().build();
        this.updateApplicationSettings = settingsBuilder.updateApplicationSettings().build();
        this.updateApplicationOperationSettings = settingsBuilder.updateApplicationOperationSettings().build();
        this.deleteApplicationSettings = settingsBuilder.deleteApplicationSettings().build();
        this.deleteApplicationOperationSettings = settingsBuilder.deleteApplicationOperationSettings().build();
        this.deployApplicationSettings = settingsBuilder.deployApplicationSettings().build();
        this.deployApplicationOperationSettings = settingsBuilder.deployApplicationOperationSettings().build();
        this.undeployApplicationSettings = settingsBuilder.undeployApplicationSettings().build();
        this.undeployApplicationOperationSettings = settingsBuilder.undeployApplicationOperationSettings().build();
        this.addApplicationStreamInputSettings = settingsBuilder.addApplicationStreamInputSettings().build();
        this.addApplicationStreamInputOperationSettings = settingsBuilder.addApplicationStreamInputOperationSettings().build();
        this.removeApplicationStreamInputSettings = settingsBuilder.removeApplicationStreamInputSettings().build();
        this.removeApplicationStreamInputOperationSettings = settingsBuilder.removeApplicationStreamInputOperationSettings().build();
        this.updateApplicationStreamInputSettings = settingsBuilder.updateApplicationStreamInputSettings().build();
        this.updateApplicationStreamInputOperationSettings = settingsBuilder.updateApplicationStreamInputOperationSettings().build();
        this.listInstancesSettings = settingsBuilder.listInstancesSettings().build();
        this.getInstanceSettings = settingsBuilder.getInstanceSettings().build();
        this.createApplicationInstancesSettings = settingsBuilder.createApplicationInstancesSettings().build();
        this.createApplicationInstancesOperationSettings = settingsBuilder.createApplicationInstancesOperationSettings().build();
        this.deleteApplicationInstancesSettings = settingsBuilder.deleteApplicationInstancesSettings().build();
        this.deleteApplicationInstancesOperationSettings = settingsBuilder.deleteApplicationInstancesOperationSettings().build();
        this.updateApplicationInstancesSettings = settingsBuilder.updateApplicationInstancesSettings().build();
        this.updateApplicationInstancesOperationSettings = settingsBuilder.updateApplicationInstancesOperationSettings().build();
        this.listDraftsSettings = settingsBuilder.listDraftsSettings().build();
        this.getDraftSettings = settingsBuilder.getDraftSettings().build();
        this.createDraftSettings = settingsBuilder.createDraftSettings().build();
        this.createDraftOperationSettings = settingsBuilder.createDraftOperationSettings().build();
        this.updateDraftSettings = settingsBuilder.updateDraftSettings().build();
        this.updateDraftOperationSettings = settingsBuilder.updateDraftOperationSettings().build();
        this.deleteDraftSettings = settingsBuilder.deleteDraftSettings().build();
        this.deleteDraftOperationSettings = settingsBuilder.deleteDraftOperationSettings().build();
        this.listProcessorsSettings = settingsBuilder.listProcessorsSettings().build();
        this.listPrebuiltProcessorsSettings = settingsBuilder.listPrebuiltProcessorsSettings().build();
        this.getProcessorSettings = settingsBuilder.getProcessorSettings().build();
        this.createProcessorSettings = settingsBuilder.createProcessorSettings().build();
        this.createProcessorOperationSettings = settingsBuilder.createProcessorOperationSettings().build();
        this.updateProcessorSettings = settingsBuilder.updateProcessorSettings().build();
        this.updateProcessorOperationSettings = settingsBuilder.updateProcessorOperationSettings().build();
        this.deleteProcessorSettings = settingsBuilder.deleteProcessorSettings().build();
        this.deleteProcessorOperationSettings = settingsBuilder.deleteProcessorOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AppPlatformStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListApplicationsRequest, ListApplicationsResponse, AppPlatformClient.ListApplicationsPagedResponse> listApplicationsSettings;
        private final UnaryCallSettings.Builder<GetApplicationRequest, Application> getApplicationSettings;
        private final UnaryCallSettings.Builder<CreateApplicationRequest, Operation> createApplicationSettings;
        private final OperationCallSettings.Builder<CreateApplicationRequest, Application, OperationMetadata> createApplicationOperationSettings;
        private final UnaryCallSettings.Builder<UpdateApplicationRequest, Operation> updateApplicationSettings;
        private final OperationCallSettings.Builder<UpdateApplicationRequest, Application, OperationMetadata> updateApplicationOperationSettings;
        private final UnaryCallSettings.Builder<DeleteApplicationRequest, Operation> deleteApplicationSettings;
        private final OperationCallSettings.Builder<DeleteApplicationRequest, Empty, OperationMetadata> deleteApplicationOperationSettings;
        private final UnaryCallSettings.Builder<DeployApplicationRequest, Operation> deployApplicationSettings;
        private final OperationCallSettings.Builder<DeployApplicationRequest, DeployApplicationResponse, OperationMetadata> deployApplicationOperationSettings;
        private final UnaryCallSettings.Builder<UndeployApplicationRequest, Operation> undeployApplicationSettings;
        private final OperationCallSettings.Builder<UndeployApplicationRequest, UndeployApplicationResponse, OperationMetadata> undeployApplicationOperationSettings;
        private final UnaryCallSettings.Builder<AddApplicationStreamInputRequest, Operation> addApplicationStreamInputSettings;
        private final OperationCallSettings.Builder<AddApplicationStreamInputRequest, AddApplicationStreamInputResponse, OperationMetadata> addApplicationStreamInputOperationSettings;
        private final UnaryCallSettings.Builder<RemoveApplicationStreamInputRequest, Operation> removeApplicationStreamInputSettings;
        private final OperationCallSettings.Builder<RemoveApplicationStreamInputRequest, RemoveApplicationStreamInputResponse, OperationMetadata> removeApplicationStreamInputOperationSettings;
        private final UnaryCallSettings.Builder<UpdateApplicationStreamInputRequest, Operation> updateApplicationStreamInputSettings;
        private final OperationCallSettings.Builder<UpdateApplicationStreamInputRequest, UpdateApplicationStreamInputResponse, OperationMetadata> updateApplicationStreamInputOperationSettings;
        private final PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, AppPlatformClient.ListInstancesPagedResponse> listInstancesSettings;
        private final UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings;
        private final UnaryCallSettings.Builder<CreateApplicationInstancesRequest, Operation> createApplicationInstancesSettings;
        private final OperationCallSettings.Builder<CreateApplicationInstancesRequest, CreateApplicationInstancesResponse, OperationMetadata> createApplicationInstancesOperationSettings;
        private final UnaryCallSettings.Builder<DeleteApplicationInstancesRequest, Operation> deleteApplicationInstancesSettings;
        private final OperationCallSettings.Builder<DeleteApplicationInstancesRequest, Instance, OperationMetadata> deleteApplicationInstancesOperationSettings;
        private final UnaryCallSettings.Builder<UpdateApplicationInstancesRequest, Operation> updateApplicationInstancesSettings;
        private final OperationCallSettings.Builder<UpdateApplicationInstancesRequest, UpdateApplicationInstancesResponse, OperationMetadata> updateApplicationInstancesOperationSettings;
        private final PagedCallSettings.Builder<ListDraftsRequest, ListDraftsResponse, AppPlatformClient.ListDraftsPagedResponse> listDraftsSettings;
        private final UnaryCallSettings.Builder<GetDraftRequest, Draft> getDraftSettings;
        private final UnaryCallSettings.Builder<CreateDraftRequest, Operation> createDraftSettings;
        private final OperationCallSettings.Builder<CreateDraftRequest, Draft, OperationMetadata> createDraftOperationSettings;
        private final UnaryCallSettings.Builder<UpdateDraftRequest, Operation> updateDraftSettings;
        private final OperationCallSettings.Builder<UpdateDraftRequest, Draft, OperationMetadata> updateDraftOperationSettings;
        private final UnaryCallSettings.Builder<DeleteDraftRequest, Operation> deleteDraftSettings;
        private final OperationCallSettings.Builder<DeleteDraftRequest, Empty, OperationMetadata> deleteDraftOperationSettings;
        private final PagedCallSettings.Builder<ListProcessorsRequest, ListProcessorsResponse, AppPlatformClient.ListProcessorsPagedResponse> listProcessorsSettings;
        private final UnaryCallSettings.Builder<ListPrebuiltProcessorsRequest, ListPrebuiltProcessorsResponse> listPrebuiltProcessorsSettings;
        private final UnaryCallSettings.Builder<GetProcessorRequest, Processor> getProcessorSettings;
        private final UnaryCallSettings.Builder<CreateProcessorRequest, Operation> createProcessorSettings;
        private final OperationCallSettings.Builder<CreateProcessorRequest, Processor, OperationMetadata> createProcessorOperationSettings;
        private final UnaryCallSettings.Builder<UpdateProcessorRequest, Operation> updateProcessorSettings;
        private final OperationCallSettings.Builder<UpdateProcessorRequest, Processor, OperationMetadata> updateProcessorOperationSettings;
        private final UnaryCallSettings.Builder<DeleteProcessorRequest, Operation> deleteProcessorSettings;
        private final OperationCallSettings.Builder<DeleteProcessorRequest, Empty, OperationMetadata> deleteProcessorOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listApplicationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_APPLICATIONS_PAGE_STR_FACT);
            this.getApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createApplicationOperationSettings = OperationCallSettings.newBuilder();
            this.updateApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateApplicationOperationSettings = OperationCallSettings.newBuilder();
            this.deleteApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteApplicationOperationSettings = OperationCallSettings.newBuilder();
            this.deployApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deployApplicationOperationSettings = OperationCallSettings.newBuilder();
            this.undeployApplicationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeployApplicationOperationSettings = OperationCallSettings.newBuilder();
            this.addApplicationStreamInputSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addApplicationStreamInputOperationSettings = OperationCallSettings.newBuilder();
            this.removeApplicationStreamInputSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeApplicationStreamInputOperationSettings = OperationCallSettings.newBuilder();
            this.updateApplicationStreamInputSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateApplicationStreamInputOperationSettings = OperationCallSettings.newBuilder();
            this.listInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCES_PAGE_STR_FACT);
            this.getInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createApplicationInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createApplicationInstancesOperationSettings = OperationCallSettings.newBuilder();
            this.deleteApplicationInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteApplicationInstancesOperationSettings = OperationCallSettings.newBuilder();
            this.updateApplicationInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateApplicationInstancesOperationSettings = OperationCallSettings.newBuilder();
            this.listDraftsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DRAFTS_PAGE_STR_FACT);
            this.getDraftSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDraftSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDraftOperationSettings = OperationCallSettings.newBuilder();
            this.updateDraftSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDraftOperationSettings = OperationCallSettings.newBuilder();
            this.deleteDraftSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDraftOperationSettings = OperationCallSettings.newBuilder();
            this.listProcessorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PROCESSORS_PAGE_STR_FACT);
            this.listPrebuiltProcessorsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getProcessorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createProcessorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createProcessorOperationSettings = OperationCallSettings.newBuilder();
            this.updateProcessorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateProcessorOperationSettings = OperationCallSettings.newBuilder();
            this.deleteProcessorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteProcessorOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listApplicationsSettings, this.getApplicationSettings, this.createApplicationSettings, this.updateApplicationSettings, this.deleteApplicationSettings, this.deployApplicationSettings, this.undeployApplicationSettings, this.addApplicationStreamInputSettings, this.removeApplicationStreamInputSettings, this.updateApplicationStreamInputSettings, this.listInstancesSettings, this.getInstanceSettings, (Object[])new UnaryCallSettings.Builder[]{this.createApplicationInstancesSettings, this.deleteApplicationInstancesSettings, this.updateApplicationInstancesSettings, this.listDraftsSettings, this.getDraftSettings, this.createDraftSettings, this.updateDraftSettings, this.deleteDraftSettings, this.listProcessorsSettings, this.listPrebuiltProcessorsSettings, this.getProcessorSettings, this.createProcessorSettings, this.updateProcessorSettings, this.deleteProcessorSettings});
            Builder.initDefaults(this);
        }

        protected Builder(AppPlatformStubSettings settings) {
            super((StubSettings)settings);
            this.listApplicationsSettings = settings.listApplicationsSettings.toBuilder();
            this.getApplicationSettings = settings.getApplicationSettings.toBuilder();
            this.createApplicationSettings = settings.createApplicationSettings.toBuilder();
            this.createApplicationOperationSettings = settings.createApplicationOperationSettings.toBuilder();
            this.updateApplicationSettings = settings.updateApplicationSettings.toBuilder();
            this.updateApplicationOperationSettings = settings.updateApplicationOperationSettings.toBuilder();
            this.deleteApplicationSettings = settings.deleteApplicationSettings.toBuilder();
            this.deleteApplicationOperationSettings = settings.deleteApplicationOperationSettings.toBuilder();
            this.deployApplicationSettings = settings.deployApplicationSettings.toBuilder();
            this.deployApplicationOperationSettings = settings.deployApplicationOperationSettings.toBuilder();
            this.undeployApplicationSettings = settings.undeployApplicationSettings.toBuilder();
            this.undeployApplicationOperationSettings = settings.undeployApplicationOperationSettings.toBuilder();
            this.addApplicationStreamInputSettings = settings.addApplicationStreamInputSettings.toBuilder();
            this.addApplicationStreamInputOperationSettings = settings.addApplicationStreamInputOperationSettings.toBuilder();
            this.removeApplicationStreamInputSettings = settings.removeApplicationStreamInputSettings.toBuilder();
            this.removeApplicationStreamInputOperationSettings = settings.removeApplicationStreamInputOperationSettings.toBuilder();
            this.updateApplicationStreamInputSettings = settings.updateApplicationStreamInputSettings.toBuilder();
            this.updateApplicationStreamInputOperationSettings = settings.updateApplicationStreamInputOperationSettings.toBuilder();
            this.listInstancesSettings = settings.listInstancesSettings.toBuilder();
            this.getInstanceSettings = settings.getInstanceSettings.toBuilder();
            this.createApplicationInstancesSettings = settings.createApplicationInstancesSettings.toBuilder();
            this.createApplicationInstancesOperationSettings = settings.createApplicationInstancesOperationSettings.toBuilder();
            this.deleteApplicationInstancesSettings = settings.deleteApplicationInstancesSettings.toBuilder();
            this.deleteApplicationInstancesOperationSettings = settings.deleteApplicationInstancesOperationSettings.toBuilder();
            this.updateApplicationInstancesSettings = settings.updateApplicationInstancesSettings.toBuilder();
            this.updateApplicationInstancesOperationSettings = settings.updateApplicationInstancesOperationSettings.toBuilder();
            this.listDraftsSettings = settings.listDraftsSettings.toBuilder();
            this.getDraftSettings = settings.getDraftSettings.toBuilder();
            this.createDraftSettings = settings.createDraftSettings.toBuilder();
            this.createDraftOperationSettings = settings.createDraftOperationSettings.toBuilder();
            this.updateDraftSettings = settings.updateDraftSettings.toBuilder();
            this.updateDraftOperationSettings = settings.updateDraftOperationSettings.toBuilder();
            this.deleteDraftSettings = settings.deleteDraftSettings.toBuilder();
            this.deleteDraftOperationSettings = settings.deleteDraftOperationSettings.toBuilder();
            this.listProcessorsSettings = settings.listProcessorsSettings.toBuilder();
            this.listPrebuiltProcessorsSettings = settings.listPrebuiltProcessorsSettings.toBuilder();
            this.getProcessorSettings = settings.getProcessorSettings.toBuilder();
            this.createProcessorSettings = settings.createProcessorSettings.toBuilder();
            this.createProcessorOperationSettings = settings.createProcessorOperationSettings.toBuilder();
            this.updateProcessorSettings = settings.updateProcessorSettings.toBuilder();
            this.updateProcessorOperationSettings = settings.updateProcessorOperationSettings.toBuilder();
            this.deleteProcessorSettings = settings.deleteProcessorSettings.toBuilder();
            this.deleteProcessorOperationSettings = settings.deleteProcessorOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listApplicationsSettings, this.getApplicationSettings, this.createApplicationSettings, this.updateApplicationSettings, this.deleteApplicationSettings, this.deployApplicationSettings, this.undeployApplicationSettings, this.addApplicationStreamInputSettings, this.removeApplicationStreamInputSettings, this.updateApplicationStreamInputSettings, this.listInstancesSettings, this.getInstanceSettings, (Object[])new UnaryCallSettings.Builder[]{this.createApplicationInstancesSettings, this.deleteApplicationInstancesSettings, this.updateApplicationInstancesSettings, this.listDraftsSettings, this.getDraftSettings, this.createDraftSettings, this.updateDraftSettings, this.deleteDraftSettings, this.listProcessorsSettings, this.listPrebuiltProcessorsSettings, this.getProcessorSettings, this.createProcessorSettings, this.updateProcessorSettings, this.deleteProcessorSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AppPlatformStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AppPlatformStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AppPlatformStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AppPlatformStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AppPlatformStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AppPlatformStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AppPlatformStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AppPlatformStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listApplicationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deployApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.undeployApplicationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.addApplicationStreamInputSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.removeApplicationStreamInputSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateApplicationStreamInputSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createApplicationInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteApplicationInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateApplicationInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDraftsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDraftSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createDraftSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateDraftSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteDraftSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listProcessorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listPrebuiltProcessorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getProcessorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createProcessorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateProcessorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteProcessorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createApplicationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Application.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateApplicationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Application.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteApplicationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deployApplicationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DeployApplicationResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.undeployApplicationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(UndeployApplicationResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.addApplicationStreamInputOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AddApplicationStreamInputResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.removeApplicationStreamInputOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(RemoveApplicationStreamInputResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateApplicationStreamInputOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(UpdateApplicationStreamInputResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createApplicationInstancesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CreateApplicationInstancesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteApplicationInstancesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateApplicationInstancesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(UpdateApplicationInstancesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createDraftOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Draft.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateDraftOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Draft.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteDraftOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createProcessorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Processor.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateProcessorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Processor.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteProcessorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListApplicationsRequest, ListApplicationsResponse, AppPlatformClient.ListApplicationsPagedResponse> listApplicationsSettings() {
            return this.listApplicationsSettings;
        }

        public UnaryCallSettings.Builder<GetApplicationRequest, Application> getApplicationSettings() {
            return this.getApplicationSettings;
        }

        public UnaryCallSettings.Builder<CreateApplicationRequest, Operation> createApplicationSettings() {
            return this.createApplicationSettings;
        }

        public OperationCallSettings.Builder<CreateApplicationRequest, Application, OperationMetadata> createApplicationOperationSettings() {
            return this.createApplicationOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateApplicationRequest, Operation> updateApplicationSettings() {
            return this.updateApplicationSettings;
        }

        public OperationCallSettings.Builder<UpdateApplicationRequest, Application, OperationMetadata> updateApplicationOperationSettings() {
            return this.updateApplicationOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteApplicationRequest, Operation> deleteApplicationSettings() {
            return this.deleteApplicationSettings;
        }

        public OperationCallSettings.Builder<DeleteApplicationRequest, Empty, OperationMetadata> deleteApplicationOperationSettings() {
            return this.deleteApplicationOperationSettings;
        }

        public UnaryCallSettings.Builder<DeployApplicationRequest, Operation> deployApplicationSettings() {
            return this.deployApplicationSettings;
        }

        public OperationCallSettings.Builder<DeployApplicationRequest, DeployApplicationResponse, OperationMetadata> deployApplicationOperationSettings() {
            return this.deployApplicationOperationSettings;
        }

        public UnaryCallSettings.Builder<UndeployApplicationRequest, Operation> undeployApplicationSettings() {
            return this.undeployApplicationSettings;
        }

        public OperationCallSettings.Builder<UndeployApplicationRequest, UndeployApplicationResponse, OperationMetadata> undeployApplicationOperationSettings() {
            return this.undeployApplicationOperationSettings;
        }

        public UnaryCallSettings.Builder<AddApplicationStreamInputRequest, Operation> addApplicationStreamInputSettings() {
            return this.addApplicationStreamInputSettings;
        }

        public OperationCallSettings.Builder<AddApplicationStreamInputRequest, AddApplicationStreamInputResponse, OperationMetadata> addApplicationStreamInputOperationSettings() {
            return this.addApplicationStreamInputOperationSettings;
        }

        public UnaryCallSettings.Builder<RemoveApplicationStreamInputRequest, Operation> removeApplicationStreamInputSettings() {
            return this.removeApplicationStreamInputSettings;
        }

        public OperationCallSettings.Builder<RemoveApplicationStreamInputRequest, RemoveApplicationStreamInputResponse, OperationMetadata> removeApplicationStreamInputOperationSettings() {
            return this.removeApplicationStreamInputOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateApplicationStreamInputRequest, Operation> updateApplicationStreamInputSettings() {
            return this.updateApplicationStreamInputSettings;
        }

        public OperationCallSettings.Builder<UpdateApplicationStreamInputRequest, UpdateApplicationStreamInputResponse, OperationMetadata> updateApplicationStreamInputOperationSettings() {
            return this.updateApplicationStreamInputOperationSettings;
        }

        public PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, AppPlatformClient.ListInstancesPagedResponse> listInstancesSettings() {
            return this.listInstancesSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings() {
            return this.getInstanceSettings;
        }

        public UnaryCallSettings.Builder<CreateApplicationInstancesRequest, Operation> createApplicationInstancesSettings() {
            return this.createApplicationInstancesSettings;
        }

        public OperationCallSettings.Builder<CreateApplicationInstancesRequest, CreateApplicationInstancesResponse, OperationMetadata> createApplicationInstancesOperationSettings() {
            return this.createApplicationInstancesOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteApplicationInstancesRequest, Operation> deleteApplicationInstancesSettings() {
            return this.deleteApplicationInstancesSettings;
        }

        public OperationCallSettings.Builder<DeleteApplicationInstancesRequest, Instance, OperationMetadata> deleteApplicationInstancesOperationSettings() {
            return this.deleteApplicationInstancesOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateApplicationInstancesRequest, Operation> updateApplicationInstancesSettings() {
            return this.updateApplicationInstancesSettings;
        }

        public OperationCallSettings.Builder<UpdateApplicationInstancesRequest, UpdateApplicationInstancesResponse, OperationMetadata> updateApplicationInstancesOperationSettings() {
            return this.updateApplicationInstancesOperationSettings;
        }

        public PagedCallSettings.Builder<ListDraftsRequest, ListDraftsResponse, AppPlatformClient.ListDraftsPagedResponse> listDraftsSettings() {
            return this.listDraftsSettings;
        }

        public UnaryCallSettings.Builder<GetDraftRequest, Draft> getDraftSettings() {
            return this.getDraftSettings;
        }

        public UnaryCallSettings.Builder<CreateDraftRequest, Operation> createDraftSettings() {
            return this.createDraftSettings;
        }

        public OperationCallSettings.Builder<CreateDraftRequest, Draft, OperationMetadata> createDraftOperationSettings() {
            return this.createDraftOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateDraftRequest, Operation> updateDraftSettings() {
            return this.updateDraftSettings;
        }

        public OperationCallSettings.Builder<UpdateDraftRequest, Draft, OperationMetadata> updateDraftOperationSettings() {
            return this.updateDraftOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteDraftRequest, Operation> deleteDraftSettings() {
            return this.deleteDraftSettings;
        }

        public OperationCallSettings.Builder<DeleteDraftRequest, Empty, OperationMetadata> deleteDraftOperationSettings() {
            return this.deleteDraftOperationSettings;
        }

        public PagedCallSettings.Builder<ListProcessorsRequest, ListProcessorsResponse, AppPlatformClient.ListProcessorsPagedResponse> listProcessorsSettings() {
            return this.listProcessorsSettings;
        }

        public UnaryCallSettings.Builder<ListPrebuiltProcessorsRequest, ListPrebuiltProcessorsResponse> listPrebuiltProcessorsSettings() {
            return this.listPrebuiltProcessorsSettings;
        }

        public UnaryCallSettings.Builder<GetProcessorRequest, Processor> getProcessorSettings() {
            return this.getProcessorSettings;
        }

        public UnaryCallSettings.Builder<CreateProcessorRequest, Operation> createProcessorSettings() {
            return this.createProcessorSettings;
        }

        public OperationCallSettings.Builder<CreateProcessorRequest, Processor, OperationMetadata> createProcessorOperationSettings() {
            return this.createProcessorOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateProcessorRequest, Operation> updateProcessorSettings() {
            return this.updateProcessorSettings;
        }

        public OperationCallSettings.Builder<UpdateProcessorRequest, Processor, OperationMetadata> updateProcessorOperationSettings() {
            return this.updateProcessorOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteProcessorRequest, Operation> deleteProcessorSettings() {
            return this.deleteProcessorSettings;
        }

        public OperationCallSettings.Builder<DeleteProcessorRequest, Empty, OperationMetadata> deleteProcessorOperationSettings() {
            return this.deleteProcessorOperationSettings;
        }

        public AppPlatformStubSettings build() throws IOException {
            return new AppPlatformStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

