/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.visionai.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.visionai.v1.AddApplicationStreamInputRequest;
import com.google.cloud.visionai.v1.AddApplicationStreamInputResponse;
import com.google.cloud.visionai.v1.AppPlatformSettings;
import com.google.cloud.visionai.v1.Application;
import com.google.cloud.visionai.v1.ApplicationName;
import com.google.cloud.visionai.v1.CreateApplicationInstancesRequest;
import com.google.cloud.visionai.v1.CreateApplicationInstancesResponse;
import com.google.cloud.visionai.v1.CreateApplicationRequest;
import com.google.cloud.visionai.v1.CreateDraftRequest;
import com.google.cloud.visionai.v1.CreateProcessorRequest;
import com.google.cloud.visionai.v1.DeleteApplicationInstancesRequest;
import com.google.cloud.visionai.v1.DeleteApplicationRequest;
import com.google.cloud.visionai.v1.DeleteDraftRequest;
import com.google.cloud.visionai.v1.DeleteProcessorRequest;
import com.google.cloud.visionai.v1.DeployApplicationRequest;
import com.google.cloud.visionai.v1.DeployApplicationResponse;
import com.google.cloud.visionai.v1.Draft;
import com.google.cloud.visionai.v1.DraftName;
import com.google.cloud.visionai.v1.GetApplicationRequest;
import com.google.cloud.visionai.v1.GetDraftRequest;
import com.google.cloud.visionai.v1.GetInstanceRequest;
import com.google.cloud.visionai.v1.GetProcessorRequest;
import com.google.cloud.visionai.v1.Instance;
import com.google.cloud.visionai.v1.InstanceName;
import com.google.cloud.visionai.v1.ListApplicationsRequest;
import com.google.cloud.visionai.v1.ListApplicationsResponse;
import com.google.cloud.visionai.v1.ListDraftsRequest;
import com.google.cloud.visionai.v1.ListDraftsResponse;
import com.google.cloud.visionai.v1.ListInstancesRequest;
import com.google.cloud.visionai.v1.ListInstancesResponse;
import com.google.cloud.visionai.v1.ListPrebuiltProcessorsRequest;
import com.google.cloud.visionai.v1.ListPrebuiltProcessorsResponse;
import com.google.cloud.visionai.v1.ListProcessorsRequest;
import com.google.cloud.visionai.v1.ListProcessorsResponse;
import com.google.cloud.visionai.v1.LocationName;
import com.google.cloud.visionai.v1.OperationMetadata;
import com.google.cloud.visionai.v1.Processor;
import com.google.cloud.visionai.v1.ProcessorName;
import com.google.cloud.visionai.v1.RemoveApplicationStreamInputRequest;
import com.google.cloud.visionai.v1.RemoveApplicationStreamInputResponse;
import com.google.cloud.visionai.v1.UndeployApplicationRequest;
import com.google.cloud.visionai.v1.UndeployApplicationResponse;
import com.google.cloud.visionai.v1.UpdateApplicationInstancesRequest;
import com.google.cloud.visionai.v1.UpdateApplicationInstancesResponse;
import com.google.cloud.visionai.v1.UpdateApplicationRequest;
import com.google.cloud.visionai.v1.UpdateApplicationStreamInputRequest;
import com.google.cloud.visionai.v1.UpdateApplicationStreamInputResponse;
import com.google.cloud.visionai.v1.UpdateDraftRequest;
import com.google.cloud.visionai.v1.UpdateProcessorRequest;
import com.google.cloud.visionai.v1.stub.AppPlatformStub;
import com.google.cloud.visionai.v1.stub.AppPlatformStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AppPlatformClient
implements BackgroundResource {
    private final AppPlatformSettings settings;
    private final AppPlatformStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final AppPlatformClient create() throws IOException {
        return AppPlatformClient.create(AppPlatformSettings.newBuilder().build());
    }

    public static final AppPlatformClient create(AppPlatformSettings settings) throws IOException {
        return new AppPlatformClient(settings);
    }

    public static final AppPlatformClient create(AppPlatformStub stub) {
        return new AppPlatformClient(stub);
    }

    protected AppPlatformClient(AppPlatformSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AppPlatformStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected AppPlatformClient(AppPlatformStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final AppPlatformSettings getSettings() {
        return this.settings;
    }

    public AppPlatformStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListApplicationsPagedResponse listApplications(LocationName parent) {
        ListApplicationsRequest request = ListApplicationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listApplications(request);
    }

    public final ListApplicationsPagedResponse listApplications(String parent) {
        ListApplicationsRequest request = ListApplicationsRequest.newBuilder().setParent(parent).build();
        return this.listApplications(request);
    }

    public final ListApplicationsPagedResponse listApplications(ListApplicationsRequest request) {
        return (ListApplicationsPagedResponse)((Object)this.listApplicationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListApplicationsRequest, ListApplicationsPagedResponse> listApplicationsPagedCallable() {
        return this.stub.listApplicationsPagedCallable();
    }

    public final UnaryCallable<ListApplicationsRequest, ListApplicationsResponse> listApplicationsCallable() {
        return this.stub.listApplicationsCallable();
    }

    public final Application getApplication(ApplicationName name) {
        GetApplicationRequest request = GetApplicationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getApplication(request);
    }

    public final Application getApplication(String name) {
        GetApplicationRequest request = GetApplicationRequest.newBuilder().setName(name).build();
        return this.getApplication(request);
    }

    public final Application getApplication(GetApplicationRequest request) {
        return (Application)this.getApplicationCallable().call((Object)request);
    }

    public final UnaryCallable<GetApplicationRequest, Application> getApplicationCallable() {
        return this.stub.getApplicationCallable();
    }

    public final OperationFuture<Application, OperationMetadata> createApplicationAsync(LocationName parent, Application application) {
        CreateApplicationRequest request = CreateApplicationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setApplication(application).build();
        return this.createApplicationAsync(request);
    }

    public final OperationFuture<Application, OperationMetadata> createApplicationAsync(String parent, Application application) {
        CreateApplicationRequest request = CreateApplicationRequest.newBuilder().setParent(parent).setApplication(application).build();
        return this.createApplicationAsync(request);
    }

    public final OperationFuture<Application, OperationMetadata> createApplicationAsync(CreateApplicationRequest request) {
        return this.createApplicationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateApplicationRequest, Application, OperationMetadata> createApplicationOperationCallable() {
        return this.stub.createApplicationOperationCallable();
    }

    public final UnaryCallable<CreateApplicationRequest, Operation> createApplicationCallable() {
        return this.stub.createApplicationCallable();
    }

    public final OperationFuture<Application, OperationMetadata> updateApplicationAsync(Application application, FieldMask updateMask) {
        UpdateApplicationRequest request = UpdateApplicationRequest.newBuilder().setApplication(application).setUpdateMask(updateMask).build();
        return this.updateApplicationAsync(request);
    }

    public final OperationFuture<Application, OperationMetadata> updateApplicationAsync(UpdateApplicationRequest request) {
        return this.updateApplicationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateApplicationRequest, Application, OperationMetadata> updateApplicationOperationCallable() {
        return this.stub.updateApplicationOperationCallable();
    }

    public final UnaryCallable<UpdateApplicationRequest, Operation> updateApplicationCallable() {
        return this.stub.updateApplicationCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteApplicationAsync(ApplicationName name) {
        DeleteApplicationRequest request = DeleteApplicationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteApplicationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteApplicationAsync(String name) {
        DeleteApplicationRequest request = DeleteApplicationRequest.newBuilder().setName(name).build();
        return this.deleteApplicationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteApplicationAsync(DeleteApplicationRequest request) {
        return this.deleteApplicationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteApplicationRequest, Empty, OperationMetadata> deleteApplicationOperationCallable() {
        return this.stub.deleteApplicationOperationCallable();
    }

    public final UnaryCallable<DeleteApplicationRequest, Operation> deleteApplicationCallable() {
        return this.stub.deleteApplicationCallable();
    }

    public final OperationFuture<DeployApplicationResponse, OperationMetadata> deployApplicationAsync(ApplicationName name) {
        DeployApplicationRequest request = DeployApplicationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deployApplicationAsync(request);
    }

    public final OperationFuture<DeployApplicationResponse, OperationMetadata> deployApplicationAsync(String name) {
        DeployApplicationRequest request = DeployApplicationRequest.newBuilder().setName(name).build();
        return this.deployApplicationAsync(request);
    }

    public final OperationFuture<DeployApplicationResponse, OperationMetadata> deployApplicationAsync(DeployApplicationRequest request) {
        return this.deployApplicationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeployApplicationRequest, DeployApplicationResponse, OperationMetadata> deployApplicationOperationCallable() {
        return this.stub.deployApplicationOperationCallable();
    }

    public final UnaryCallable<DeployApplicationRequest, Operation> deployApplicationCallable() {
        return this.stub.deployApplicationCallable();
    }

    public final OperationFuture<UndeployApplicationResponse, OperationMetadata> undeployApplicationAsync(ApplicationName name) {
        UndeployApplicationRequest request = UndeployApplicationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.undeployApplicationAsync(request);
    }

    public final OperationFuture<UndeployApplicationResponse, OperationMetadata> undeployApplicationAsync(String name) {
        UndeployApplicationRequest request = UndeployApplicationRequest.newBuilder().setName(name).build();
        return this.undeployApplicationAsync(request);
    }

    public final OperationFuture<UndeployApplicationResponse, OperationMetadata> undeployApplicationAsync(UndeployApplicationRequest request) {
        return this.undeployApplicationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeployApplicationRequest, UndeployApplicationResponse, OperationMetadata> undeployApplicationOperationCallable() {
        return this.stub.undeployApplicationOperationCallable();
    }

    public final UnaryCallable<UndeployApplicationRequest, Operation> undeployApplicationCallable() {
        return this.stub.undeployApplicationCallable();
    }

    public final OperationFuture<AddApplicationStreamInputResponse, OperationMetadata> addApplicationStreamInputAsync(ApplicationName name) {
        AddApplicationStreamInputRequest request = AddApplicationStreamInputRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.addApplicationStreamInputAsync(request);
    }

    public final OperationFuture<AddApplicationStreamInputResponse, OperationMetadata> addApplicationStreamInputAsync(String name) {
        AddApplicationStreamInputRequest request = AddApplicationStreamInputRequest.newBuilder().setName(name).build();
        return this.addApplicationStreamInputAsync(request);
    }

    public final OperationFuture<AddApplicationStreamInputResponse, OperationMetadata> addApplicationStreamInputAsync(AddApplicationStreamInputRequest request) {
        return this.addApplicationStreamInputOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddApplicationStreamInputRequest, AddApplicationStreamInputResponse, OperationMetadata> addApplicationStreamInputOperationCallable() {
        return this.stub.addApplicationStreamInputOperationCallable();
    }

    public final UnaryCallable<AddApplicationStreamInputRequest, Operation> addApplicationStreamInputCallable() {
        return this.stub.addApplicationStreamInputCallable();
    }

    public final OperationFuture<RemoveApplicationStreamInputResponse, OperationMetadata> removeApplicationStreamInputAsync(ApplicationName name) {
        RemoveApplicationStreamInputRequest request = RemoveApplicationStreamInputRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.removeApplicationStreamInputAsync(request);
    }

    public final OperationFuture<RemoveApplicationStreamInputResponse, OperationMetadata> removeApplicationStreamInputAsync(String name) {
        RemoveApplicationStreamInputRequest request = RemoveApplicationStreamInputRequest.newBuilder().setName(name).build();
        return this.removeApplicationStreamInputAsync(request);
    }

    public final OperationFuture<RemoveApplicationStreamInputResponse, OperationMetadata> removeApplicationStreamInputAsync(RemoveApplicationStreamInputRequest request) {
        return this.removeApplicationStreamInputOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemoveApplicationStreamInputRequest, RemoveApplicationStreamInputResponse, OperationMetadata> removeApplicationStreamInputOperationCallable() {
        return this.stub.removeApplicationStreamInputOperationCallable();
    }

    public final UnaryCallable<RemoveApplicationStreamInputRequest, Operation> removeApplicationStreamInputCallable() {
        return this.stub.removeApplicationStreamInputCallable();
    }

    public final OperationFuture<UpdateApplicationStreamInputResponse, OperationMetadata> updateApplicationStreamInputAsync(ApplicationName name) {
        UpdateApplicationStreamInputRequest request = UpdateApplicationStreamInputRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.updateApplicationStreamInputAsync(request);
    }

    public final OperationFuture<UpdateApplicationStreamInputResponse, OperationMetadata> updateApplicationStreamInputAsync(String name) {
        UpdateApplicationStreamInputRequest request = UpdateApplicationStreamInputRequest.newBuilder().setName(name).build();
        return this.updateApplicationStreamInputAsync(request);
    }

    public final OperationFuture<UpdateApplicationStreamInputResponse, OperationMetadata> updateApplicationStreamInputAsync(UpdateApplicationStreamInputRequest request) {
        return this.updateApplicationStreamInputOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateApplicationStreamInputRequest, UpdateApplicationStreamInputResponse, OperationMetadata> updateApplicationStreamInputOperationCallable() {
        return this.stub.updateApplicationStreamInputOperationCallable();
    }

    public final UnaryCallable<UpdateApplicationStreamInputRequest, Operation> updateApplicationStreamInputCallable() {
        return this.stub.updateApplicationStreamInputCallable();
    }

    public final ListInstancesPagedResponse listInstances(ApplicationName parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(String parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(ListInstancesRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final Instance getInstance(InstanceName name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(String name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(GetInstanceRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    public final OperationFuture<CreateApplicationInstancesResponse, OperationMetadata> createApplicationInstancesAsync(ApplicationName name) {
        CreateApplicationInstancesRequest request = CreateApplicationInstancesRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.createApplicationInstancesAsync(request);
    }

    public final OperationFuture<CreateApplicationInstancesResponse, OperationMetadata> createApplicationInstancesAsync(String name) {
        CreateApplicationInstancesRequest request = CreateApplicationInstancesRequest.newBuilder().setName(name).build();
        return this.createApplicationInstancesAsync(request);
    }

    public final OperationFuture<CreateApplicationInstancesResponse, OperationMetadata> createApplicationInstancesAsync(CreateApplicationInstancesRequest request) {
        return this.createApplicationInstancesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateApplicationInstancesRequest, CreateApplicationInstancesResponse, OperationMetadata> createApplicationInstancesOperationCallable() {
        return this.stub.createApplicationInstancesOperationCallable();
    }

    public final UnaryCallable<CreateApplicationInstancesRequest, Operation> createApplicationInstancesCallable() {
        return this.stub.createApplicationInstancesCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> deleteApplicationInstancesAsync(ApplicationName name) {
        DeleteApplicationInstancesRequest request = DeleteApplicationInstancesRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteApplicationInstancesAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> deleteApplicationInstancesAsync(String name) {
        DeleteApplicationInstancesRequest request = DeleteApplicationInstancesRequest.newBuilder().setName(name).build();
        return this.deleteApplicationInstancesAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> deleteApplicationInstancesAsync(DeleteApplicationInstancesRequest request) {
        return this.deleteApplicationInstancesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteApplicationInstancesRequest, Instance, OperationMetadata> deleteApplicationInstancesOperationCallable() {
        return this.stub.deleteApplicationInstancesOperationCallable();
    }

    public final UnaryCallable<DeleteApplicationInstancesRequest, Operation> deleteApplicationInstancesCallable() {
        return this.stub.deleteApplicationInstancesCallable();
    }

    public final OperationFuture<UpdateApplicationInstancesResponse, OperationMetadata> updateApplicationInstancesAsync(ApplicationName name, List<UpdateApplicationInstancesRequest.UpdateApplicationInstance> applicationInstances) {
        UpdateApplicationInstancesRequest request = UpdateApplicationInstancesRequest.newBuilder().setName(name == null ? null : name.toString()).addAllApplicationInstances(applicationInstances).build();
        return this.updateApplicationInstancesAsync(request);
    }

    public final OperationFuture<UpdateApplicationInstancesResponse, OperationMetadata> updateApplicationInstancesAsync(String name, List<UpdateApplicationInstancesRequest.UpdateApplicationInstance> applicationInstances) {
        UpdateApplicationInstancesRequest request = UpdateApplicationInstancesRequest.newBuilder().setName(name).addAllApplicationInstances(applicationInstances).build();
        return this.updateApplicationInstancesAsync(request);
    }

    public final OperationFuture<UpdateApplicationInstancesResponse, OperationMetadata> updateApplicationInstancesAsync(UpdateApplicationInstancesRequest request) {
        return this.updateApplicationInstancesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateApplicationInstancesRequest, UpdateApplicationInstancesResponse, OperationMetadata> updateApplicationInstancesOperationCallable() {
        return this.stub.updateApplicationInstancesOperationCallable();
    }

    public final UnaryCallable<UpdateApplicationInstancesRequest, Operation> updateApplicationInstancesCallable() {
        return this.stub.updateApplicationInstancesCallable();
    }

    public final ListDraftsPagedResponse listDrafts(ApplicationName parent) {
        ListDraftsRequest request = ListDraftsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDrafts(request);
    }

    public final ListDraftsPagedResponse listDrafts(String parent) {
        ListDraftsRequest request = ListDraftsRequest.newBuilder().setParent(parent).build();
        return this.listDrafts(request);
    }

    public final ListDraftsPagedResponse listDrafts(ListDraftsRequest request) {
        return (ListDraftsPagedResponse)((Object)this.listDraftsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDraftsRequest, ListDraftsPagedResponse> listDraftsPagedCallable() {
        return this.stub.listDraftsPagedCallable();
    }

    public final UnaryCallable<ListDraftsRequest, ListDraftsResponse> listDraftsCallable() {
        return this.stub.listDraftsCallable();
    }

    public final Draft getDraft(DraftName name) {
        GetDraftRequest request = GetDraftRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDraft(request);
    }

    public final Draft getDraft(String name) {
        GetDraftRequest request = GetDraftRequest.newBuilder().setName(name).build();
        return this.getDraft(request);
    }

    public final Draft getDraft(GetDraftRequest request) {
        return (Draft)this.getDraftCallable().call((Object)request);
    }

    public final UnaryCallable<GetDraftRequest, Draft> getDraftCallable() {
        return this.stub.getDraftCallable();
    }

    public final OperationFuture<Draft, OperationMetadata> createDraftAsync(ApplicationName parent, Draft draft, String draftId) {
        CreateDraftRequest request = CreateDraftRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDraft(draft).setDraftId(draftId).build();
        return this.createDraftAsync(request);
    }

    public final OperationFuture<Draft, OperationMetadata> createDraftAsync(String parent, Draft draft, String draftId) {
        CreateDraftRequest request = CreateDraftRequest.newBuilder().setParent(parent).setDraft(draft).setDraftId(draftId).build();
        return this.createDraftAsync(request);
    }

    public final OperationFuture<Draft, OperationMetadata> createDraftAsync(CreateDraftRequest request) {
        return this.createDraftOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDraftRequest, Draft, OperationMetadata> createDraftOperationCallable() {
        return this.stub.createDraftOperationCallable();
    }

    public final UnaryCallable<CreateDraftRequest, Operation> createDraftCallable() {
        return this.stub.createDraftCallable();
    }

    public final OperationFuture<Draft, OperationMetadata> updateDraftAsync(Draft draft, FieldMask updateMask) {
        UpdateDraftRequest request = UpdateDraftRequest.newBuilder().setDraft(draft).setUpdateMask(updateMask).build();
        return this.updateDraftAsync(request);
    }

    public final OperationFuture<Draft, OperationMetadata> updateDraftAsync(UpdateDraftRequest request) {
        return this.updateDraftOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDraftRequest, Draft, OperationMetadata> updateDraftOperationCallable() {
        return this.stub.updateDraftOperationCallable();
    }

    public final UnaryCallable<UpdateDraftRequest, Operation> updateDraftCallable() {
        return this.stub.updateDraftCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDraftAsync(DraftName name) {
        DeleteDraftRequest request = DeleteDraftRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDraftAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDraftAsync(String name) {
        DeleteDraftRequest request = DeleteDraftRequest.newBuilder().setName(name).build();
        return this.deleteDraftAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDraftAsync(DeleteDraftRequest request) {
        return this.deleteDraftOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDraftRequest, Empty, OperationMetadata> deleteDraftOperationCallable() {
        return this.stub.deleteDraftOperationCallable();
    }

    public final UnaryCallable<DeleteDraftRequest, Operation> deleteDraftCallable() {
        return this.stub.deleteDraftCallable();
    }

    public final ListProcessorsPagedResponse listProcessors(LocationName parent) {
        ListProcessorsRequest request = ListProcessorsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProcessors(request);
    }

    public final ListProcessorsPagedResponse listProcessors(String parent) {
        ListProcessorsRequest request = ListProcessorsRequest.newBuilder().setParent(parent).build();
        return this.listProcessors(request);
    }

    public final ListProcessorsPagedResponse listProcessors(ListProcessorsRequest request) {
        return (ListProcessorsPagedResponse)((Object)this.listProcessorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProcessorsRequest, ListProcessorsPagedResponse> listProcessorsPagedCallable() {
        return this.stub.listProcessorsPagedCallable();
    }

    public final UnaryCallable<ListProcessorsRequest, ListProcessorsResponse> listProcessorsCallable() {
        return this.stub.listProcessorsCallable();
    }

    public final ListPrebuiltProcessorsResponse listPrebuiltProcessors(LocationName parent) {
        ListPrebuiltProcessorsRequest request = ListPrebuiltProcessorsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPrebuiltProcessors(request);
    }

    public final ListPrebuiltProcessorsResponse listPrebuiltProcessors(String parent) {
        ListPrebuiltProcessorsRequest request = ListPrebuiltProcessorsRequest.newBuilder().setParent(parent).build();
        return this.listPrebuiltProcessors(request);
    }

    public final ListPrebuiltProcessorsResponse listPrebuiltProcessors(ListPrebuiltProcessorsRequest request) {
        return (ListPrebuiltProcessorsResponse)this.listPrebuiltProcessorsCallable().call((Object)request);
    }

    public final UnaryCallable<ListPrebuiltProcessorsRequest, ListPrebuiltProcessorsResponse> listPrebuiltProcessorsCallable() {
        return this.stub.listPrebuiltProcessorsCallable();
    }

    public final Processor getProcessor(ProcessorName name) {
        GetProcessorRequest request = GetProcessorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProcessor(request);
    }

    public final Processor getProcessor(String name) {
        GetProcessorRequest request = GetProcessorRequest.newBuilder().setName(name).build();
        return this.getProcessor(request);
    }

    public final Processor getProcessor(GetProcessorRequest request) {
        return (Processor)this.getProcessorCallable().call((Object)request);
    }

    public final UnaryCallable<GetProcessorRequest, Processor> getProcessorCallable() {
        return this.stub.getProcessorCallable();
    }

    public final OperationFuture<Processor, OperationMetadata> createProcessorAsync(LocationName parent, Processor processor, String processorId) {
        CreateProcessorRequest request = CreateProcessorRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setProcessor(processor).setProcessorId(processorId).build();
        return this.createProcessorAsync(request);
    }

    public final OperationFuture<Processor, OperationMetadata> createProcessorAsync(String parent, Processor processor, String processorId) {
        CreateProcessorRequest request = CreateProcessorRequest.newBuilder().setParent(parent).setProcessor(processor).setProcessorId(processorId).build();
        return this.createProcessorAsync(request);
    }

    public final OperationFuture<Processor, OperationMetadata> createProcessorAsync(CreateProcessorRequest request) {
        return this.createProcessorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateProcessorRequest, Processor, OperationMetadata> createProcessorOperationCallable() {
        return this.stub.createProcessorOperationCallable();
    }

    public final UnaryCallable<CreateProcessorRequest, Operation> createProcessorCallable() {
        return this.stub.createProcessorCallable();
    }

    public final OperationFuture<Processor, OperationMetadata> updateProcessorAsync(Processor processor, FieldMask updateMask) {
        UpdateProcessorRequest request = UpdateProcessorRequest.newBuilder().setProcessor(processor).setUpdateMask(updateMask).build();
        return this.updateProcessorAsync(request);
    }

    public final OperationFuture<Processor, OperationMetadata> updateProcessorAsync(UpdateProcessorRequest request) {
        return this.updateProcessorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateProcessorRequest, Processor, OperationMetadata> updateProcessorOperationCallable() {
        return this.stub.updateProcessorOperationCallable();
    }

    public final UnaryCallable<UpdateProcessorRequest, Operation> updateProcessorCallable() {
        return this.stub.updateProcessorCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteProcessorAsync(ProcessorName name) {
        DeleteProcessorRequest request = DeleteProcessorRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteProcessorAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteProcessorAsync(String name) {
        DeleteProcessorRequest request = DeleteProcessorRequest.newBuilder().setName(name).build();
        return this.deleteProcessorAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteProcessorAsync(DeleteProcessorRequest request) {
        return this.deleteProcessorOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteProcessorRequest, Empty, OperationMetadata> deleteProcessorOperationCallable() {
        return this.stub.deleteProcessorOperationCallable();
    }

    public final UnaryCallable<DeleteProcessorRequest, Operation> deleteProcessorCallable() {
        return this.stub.deleteProcessorCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListProcessorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProcessorsRequest, ListProcessorsResponse, Processor, ListProcessorsPage, ListProcessorsFixedSizeCollection> {
        private ListProcessorsFixedSizeCollection(List<ListProcessorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProcessorsFixedSizeCollection createEmptyCollection() {
            return new ListProcessorsFixedSizeCollection(null, 0);
        }

        protected ListProcessorsFixedSizeCollection createCollection(List<ListProcessorsPage> pages, int collectionSize) {
            return new ListProcessorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProcessorsPage
    extends AbstractPage<ListProcessorsRequest, ListProcessorsResponse, Processor, ListProcessorsPage> {
        private ListProcessorsPage(PageContext<ListProcessorsRequest, ListProcessorsResponse, Processor> context, ListProcessorsResponse response) {
            super(context, (Object)response);
        }

        private static ListProcessorsPage createEmptyPage() {
            return new ListProcessorsPage(null, null);
        }

        protected ListProcessorsPage createPage(PageContext<ListProcessorsRequest, ListProcessorsResponse, Processor> context, ListProcessorsResponse response) {
            return new ListProcessorsPage(context, response);
        }

        public ApiFuture<ListProcessorsPage> createPageAsync(PageContext<ListProcessorsRequest, ListProcessorsResponse, Processor> context, ApiFuture<ListProcessorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProcessorsPagedResponse
    extends AbstractPagedListResponse<ListProcessorsRequest, ListProcessorsResponse, Processor, ListProcessorsPage, ListProcessorsFixedSizeCollection> {
        public static ApiFuture<ListProcessorsPagedResponse> createAsync(PageContext<ListProcessorsRequest, ListProcessorsResponse, Processor> context, ApiFuture<ListProcessorsResponse> futureResponse) {
            ApiFuture<ListProcessorsPage> futurePage = ListProcessorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListProcessorsPagedResponse((ListProcessorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListProcessorsPagedResponse(ListProcessorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProcessorsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDraftsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDraftsRequest, ListDraftsResponse, Draft, ListDraftsPage, ListDraftsFixedSizeCollection> {
        private ListDraftsFixedSizeCollection(List<ListDraftsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDraftsFixedSizeCollection createEmptyCollection() {
            return new ListDraftsFixedSizeCollection(null, 0);
        }

        protected ListDraftsFixedSizeCollection createCollection(List<ListDraftsPage> pages, int collectionSize) {
            return new ListDraftsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDraftsPage
    extends AbstractPage<ListDraftsRequest, ListDraftsResponse, Draft, ListDraftsPage> {
        private ListDraftsPage(PageContext<ListDraftsRequest, ListDraftsResponse, Draft> context, ListDraftsResponse response) {
            super(context, (Object)response);
        }

        private static ListDraftsPage createEmptyPage() {
            return new ListDraftsPage(null, null);
        }

        protected ListDraftsPage createPage(PageContext<ListDraftsRequest, ListDraftsResponse, Draft> context, ListDraftsResponse response) {
            return new ListDraftsPage(context, response);
        }

        public ApiFuture<ListDraftsPage> createPageAsync(PageContext<ListDraftsRequest, ListDraftsResponse, Draft> context, ApiFuture<ListDraftsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDraftsPagedResponse
    extends AbstractPagedListResponse<ListDraftsRequest, ListDraftsResponse, Draft, ListDraftsPage, ListDraftsFixedSizeCollection> {
        public static ApiFuture<ListDraftsPagedResponse> createAsync(PageContext<ListDraftsRequest, ListDraftsResponse, Draft> context, ApiFuture<ListDraftsResponse> futureResponse) {
            ApiFuture<ListDraftsPage> futurePage = ListDraftsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDraftsPagedResponse((ListDraftsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDraftsPagedResponse(ListDraftsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDraftsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInstancesPagedResponse((ListInstancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListApplicationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListApplicationsRequest, ListApplicationsResponse, Application, ListApplicationsPage, ListApplicationsFixedSizeCollection> {
        private ListApplicationsFixedSizeCollection(List<ListApplicationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListApplicationsFixedSizeCollection createEmptyCollection() {
            return new ListApplicationsFixedSizeCollection(null, 0);
        }

        protected ListApplicationsFixedSizeCollection createCollection(List<ListApplicationsPage> pages, int collectionSize) {
            return new ListApplicationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListApplicationsPage
    extends AbstractPage<ListApplicationsRequest, ListApplicationsResponse, Application, ListApplicationsPage> {
        private ListApplicationsPage(PageContext<ListApplicationsRequest, ListApplicationsResponse, Application> context, ListApplicationsResponse response) {
            super(context, (Object)response);
        }

        private static ListApplicationsPage createEmptyPage() {
            return new ListApplicationsPage(null, null);
        }

        protected ListApplicationsPage createPage(PageContext<ListApplicationsRequest, ListApplicationsResponse, Application> context, ListApplicationsResponse response) {
            return new ListApplicationsPage(context, response);
        }

        public ApiFuture<ListApplicationsPage> createPageAsync(PageContext<ListApplicationsRequest, ListApplicationsResponse, Application> context, ApiFuture<ListApplicationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListApplicationsPagedResponse
    extends AbstractPagedListResponse<ListApplicationsRequest, ListApplicationsResponse, Application, ListApplicationsPage, ListApplicationsFixedSizeCollection> {
        public static ApiFuture<ListApplicationsPagedResponse> createAsync(PageContext<ListApplicationsRequest, ListApplicationsResponse, Application> context, ApiFuture<ListApplicationsResponse> futureResponse) {
            ApiFuture<ListApplicationsPage> futurePage = ListApplicationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListApplicationsPagedResponse((ListApplicationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListApplicationsPagedResponse(ListApplicationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListApplicationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

