/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest;
import com.google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse;
import com.google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest;
import com.google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse;
import com.google.cloud.vision.v1.BatchAnnotateFilesRequest;
import com.google.cloud.vision.v1.BatchAnnotateFilesResponse;
import com.google.cloud.vision.v1.BatchAnnotateImagesRequest;
import com.google.cloud.vision.v1.BatchAnnotateImagesResponse;
import com.google.cloud.vision.v1.OperationMetadata;
import com.google.cloud.vision.v1.stub.GrpcImageAnnotatorStub;
import com.google.cloud.vision.v1.stub.HttpJsonImageAnnotatorStub;
import com.google.cloud.vision.v1.stub.ImageAnnotatorStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ImageAnnotatorStubSettings
extends StubSettings<ImageAnnotatorStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-vision").build();
    private final UnaryCallSettings<BatchAnnotateImagesRequest, BatchAnnotateImagesResponse> batchAnnotateImagesSettings;
    private final UnaryCallSettings<BatchAnnotateFilesRequest, BatchAnnotateFilesResponse> batchAnnotateFilesSettings;
    private final UnaryCallSettings<AsyncBatchAnnotateImagesRequest, Operation> asyncBatchAnnotateImagesSettings;
    private final OperationCallSettings<AsyncBatchAnnotateImagesRequest, AsyncBatchAnnotateImagesResponse, OperationMetadata> asyncBatchAnnotateImagesOperationSettings;
    private final UnaryCallSettings<AsyncBatchAnnotateFilesRequest, Operation> asyncBatchAnnotateFilesSettings;
    private final OperationCallSettings<AsyncBatchAnnotateFilesRequest, AsyncBatchAnnotateFilesResponse, OperationMetadata> asyncBatchAnnotateFilesOperationSettings;

    public UnaryCallSettings<BatchAnnotateImagesRequest, BatchAnnotateImagesResponse> batchAnnotateImagesSettings() {
        return this.batchAnnotateImagesSettings;
    }

    public UnaryCallSettings<BatchAnnotateFilesRequest, BatchAnnotateFilesResponse> batchAnnotateFilesSettings() {
        return this.batchAnnotateFilesSettings;
    }

    public UnaryCallSettings<AsyncBatchAnnotateImagesRequest, Operation> asyncBatchAnnotateImagesSettings() {
        return this.asyncBatchAnnotateImagesSettings;
    }

    public OperationCallSettings<AsyncBatchAnnotateImagesRequest, AsyncBatchAnnotateImagesResponse, OperationMetadata> asyncBatchAnnotateImagesOperationSettings() {
        return this.asyncBatchAnnotateImagesOperationSettings;
    }

    public UnaryCallSettings<AsyncBatchAnnotateFilesRequest, Operation> asyncBatchAnnotateFilesSettings() {
        return this.asyncBatchAnnotateFilesSettings;
    }

    public OperationCallSettings<AsyncBatchAnnotateFilesRequest, AsyncBatchAnnotateFilesResponse, OperationMetadata> asyncBatchAnnotateFilesOperationSettings() {
        return this.asyncBatchAnnotateFilesOperationSettings;
    }

    public ImageAnnotatorStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcImageAnnotatorStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonImageAnnotatorStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return ImageAnnotatorStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "vision";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "vision.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "vision.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ImageAnnotatorStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ImageAnnotatorStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ImageAnnotatorStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ImageAnnotatorStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ImageAnnotatorStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.batchAnnotateImagesSettings = settingsBuilder.batchAnnotateImagesSettings().build();
        this.batchAnnotateFilesSettings = settingsBuilder.batchAnnotateFilesSettings().build();
        this.asyncBatchAnnotateImagesSettings = settingsBuilder.asyncBatchAnnotateImagesSettings().build();
        this.asyncBatchAnnotateImagesOperationSettings = settingsBuilder.asyncBatchAnnotateImagesOperationSettings().build();
        this.asyncBatchAnnotateFilesSettings = settingsBuilder.asyncBatchAnnotateFilesSettings().build();
        this.asyncBatchAnnotateFilesOperationSettings = settingsBuilder.asyncBatchAnnotateFilesOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ImageAnnotatorStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<BatchAnnotateImagesRequest, BatchAnnotateImagesResponse> batchAnnotateImagesSettings;
        private final UnaryCallSettings.Builder<BatchAnnotateFilesRequest, BatchAnnotateFilesResponse> batchAnnotateFilesSettings;
        private final UnaryCallSettings.Builder<AsyncBatchAnnotateImagesRequest, Operation> asyncBatchAnnotateImagesSettings;
        private final OperationCallSettings.Builder<AsyncBatchAnnotateImagesRequest, AsyncBatchAnnotateImagesResponse, OperationMetadata> asyncBatchAnnotateImagesOperationSettings;
        private final UnaryCallSettings.Builder<AsyncBatchAnnotateFilesRequest, Operation> asyncBatchAnnotateFilesSettings;
        private final OperationCallSettings.Builder<AsyncBatchAnnotateFilesRequest, AsyncBatchAnnotateFilesResponse, OperationMetadata> asyncBatchAnnotateFilesOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.batchAnnotateImagesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchAnnotateFilesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.asyncBatchAnnotateImagesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.asyncBatchAnnotateImagesOperationSettings = OperationCallSettings.newBuilder();
            this.asyncBatchAnnotateFilesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.asyncBatchAnnotateFilesOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.batchAnnotateImagesSettings, this.batchAnnotateFilesSettings, this.asyncBatchAnnotateImagesSettings, this.asyncBatchAnnotateFilesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ImageAnnotatorStubSettings settings) {
            super((StubSettings)settings);
            this.batchAnnotateImagesSettings = settings.batchAnnotateImagesSettings.toBuilder();
            this.batchAnnotateFilesSettings = settings.batchAnnotateFilesSettings.toBuilder();
            this.asyncBatchAnnotateImagesSettings = settings.asyncBatchAnnotateImagesSettings.toBuilder();
            this.asyncBatchAnnotateImagesOperationSettings = settings.asyncBatchAnnotateImagesOperationSettings.toBuilder();
            this.asyncBatchAnnotateFilesSettings = settings.asyncBatchAnnotateFilesSettings.toBuilder();
            this.asyncBatchAnnotateFilesOperationSettings = settings.asyncBatchAnnotateFilesOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.batchAnnotateImagesSettings, this.batchAnnotateFilesSettings, this.asyncBatchAnnotateImagesSettings, this.asyncBatchAnnotateFilesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ImageAnnotatorStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ImageAnnotatorStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ImageAnnotatorStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ImageAnnotatorStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ImageAnnotatorStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ImageAnnotatorStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ImageAnnotatorStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ImageAnnotatorStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.batchAnnotateImagesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.batchAnnotateFilesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.asyncBatchAnnotateImagesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.asyncBatchAnnotateFilesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.asyncBatchAnnotateImagesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AsyncBatchAnnotateImagesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)20000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)86400000L)).build()));
            builder.asyncBatchAnnotateFilesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AsyncBatchAnnotateFilesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)20000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)86400000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<BatchAnnotateImagesRequest, BatchAnnotateImagesResponse> batchAnnotateImagesSettings() {
            return this.batchAnnotateImagesSettings;
        }

        public UnaryCallSettings.Builder<BatchAnnotateFilesRequest, BatchAnnotateFilesResponse> batchAnnotateFilesSettings() {
            return this.batchAnnotateFilesSettings;
        }

        public UnaryCallSettings.Builder<AsyncBatchAnnotateImagesRequest, Operation> asyncBatchAnnotateImagesSettings() {
            return this.asyncBatchAnnotateImagesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<AsyncBatchAnnotateImagesRequest, AsyncBatchAnnotateImagesResponse, OperationMetadata> asyncBatchAnnotateImagesOperationSettings() {
            return this.asyncBatchAnnotateImagesOperationSettings;
        }

        public UnaryCallSettings.Builder<AsyncBatchAnnotateFilesRequest, Operation> asyncBatchAnnotateFilesSettings() {
            return this.asyncBatchAnnotateFilesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<AsyncBatchAnnotateFilesRequest, AsyncBatchAnnotateFilesResponse, OperationMetadata> asyncBatchAnnotateFilesOperationSettings() {
            return this.asyncBatchAnnotateFilesOperationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return ImageAnnotatorStubSettings.getDefaultEndpoint();
        }

        public ImageAnnotatorStubSettings build() throws IOException {
            return new ImageAnnotatorStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

