/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.transcoder.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.video.transcoder.v1.CreateJobRequest;
import com.google.cloud.video.transcoder.v1.CreateJobTemplateRequest;
import com.google.cloud.video.transcoder.v1.DeleteJobRequest;
import com.google.cloud.video.transcoder.v1.DeleteJobTemplateRequest;
import com.google.cloud.video.transcoder.v1.GetJobRequest;
import com.google.cloud.video.transcoder.v1.GetJobTemplateRequest;
import com.google.cloud.video.transcoder.v1.Job;
import com.google.cloud.video.transcoder.v1.JobTemplate;
import com.google.cloud.video.transcoder.v1.ListJobTemplatesRequest;
import com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse;
import com.google.cloud.video.transcoder.v1.ListJobsRequest;
import com.google.cloud.video.transcoder.v1.ListJobsResponse;
import com.google.cloud.video.transcoder.v1.TranscoderServiceClient;
import com.google.cloud.video.transcoder.v1.stub.GrpcTranscoderServiceStub;
import com.google.cloud.video.transcoder.v1.stub.HttpJsonTranscoderServiceStub;
import com.google.cloud.video.transcoder.v1.stub.TranscoderServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class TranscoderServiceStubSettings
extends StubSettings<TranscoderServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateJobRequest, Job> createJobSettings;
    private final PagedCallSettings<ListJobsRequest, ListJobsResponse, TranscoderServiceClient.ListJobsPagedResponse> listJobsSettings;
    private final UnaryCallSettings<GetJobRequest, Job> getJobSettings;
    private final UnaryCallSettings<DeleteJobRequest, Empty> deleteJobSettings;
    private final UnaryCallSettings<CreateJobTemplateRequest, JobTemplate> createJobTemplateSettings;
    private final PagedCallSettings<ListJobTemplatesRequest, ListJobTemplatesResponse, TranscoderServiceClient.ListJobTemplatesPagedResponse> listJobTemplatesSettings;
    private final UnaryCallSettings<GetJobTemplateRequest, JobTemplate> getJobTemplateSettings;
    private final UnaryCallSettings<DeleteJobTemplateRequest, Empty> deleteJobTemplateSettings;
    private static final PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job> LIST_JOBS_PAGE_STR_DESC = new PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job>(){

        public String emptyToken() {
            return "";
        }

        public ListJobsRequest injectToken(ListJobsRequest payload, String token) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageToken(token).build();
        }

        public ListJobsRequest injectPageSize(ListJobsRequest payload, int pageSize) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Job> extractResources(ListJobsResponse payload) {
            return payload.getJobsList() == null ? ImmutableList.of() : payload.getJobsList();
        }
    };
    private static final PagedListDescriptor<ListJobTemplatesRequest, ListJobTemplatesResponse, JobTemplate> LIST_JOB_TEMPLATES_PAGE_STR_DESC = new PagedListDescriptor<ListJobTemplatesRequest, ListJobTemplatesResponse, JobTemplate>(){

        public String emptyToken() {
            return "";
        }

        public ListJobTemplatesRequest injectToken(ListJobTemplatesRequest payload, String token) {
            return ListJobTemplatesRequest.newBuilder((ListJobTemplatesRequest)payload).setPageToken(token).build();
        }

        public ListJobTemplatesRequest injectPageSize(ListJobTemplatesRequest payload, int pageSize) {
            return ListJobTemplatesRequest.newBuilder((ListJobTemplatesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListJobTemplatesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListJobTemplatesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<JobTemplate> extractResources(ListJobTemplatesResponse payload) {
            return payload.getJobTemplatesList() == null ? ImmutableList.of() : payload.getJobTemplatesList();
        }
    };
    private static final PagedListResponseFactory<ListJobsRequest, ListJobsResponse, TranscoderServiceClient.ListJobsPagedResponse> LIST_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<ListJobsRequest, ListJobsResponse, TranscoderServiceClient.ListJobsPagedResponse>(){

        public ApiFuture<TranscoderServiceClient.ListJobsPagedResponse> getFuturePagedResponse(UnaryCallable<ListJobsRequest, ListJobsResponse> callable, ListJobsRequest request, ApiCallContext context, ApiFuture<ListJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TranscoderServiceClient.ListJobsPagedResponse.createAsync((PageContext<ListJobsRequest, ListJobsResponse, Job>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListJobTemplatesRequest, ListJobTemplatesResponse, TranscoderServiceClient.ListJobTemplatesPagedResponse> LIST_JOB_TEMPLATES_PAGE_STR_FACT = new PagedListResponseFactory<ListJobTemplatesRequest, ListJobTemplatesResponse, TranscoderServiceClient.ListJobTemplatesPagedResponse>(){

        public ApiFuture<TranscoderServiceClient.ListJobTemplatesPagedResponse> getFuturePagedResponse(UnaryCallable<ListJobTemplatesRequest, ListJobTemplatesResponse> callable, ListJobTemplatesRequest request, ApiCallContext context, ApiFuture<ListJobTemplatesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_JOB_TEMPLATES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TranscoderServiceClient.ListJobTemplatesPagedResponse.createAsync((PageContext<ListJobTemplatesRequest, ListJobTemplatesResponse, JobTemplate>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateJobRequest, Job> createJobSettings() {
        return this.createJobSettings;
    }

    public PagedCallSettings<ListJobsRequest, ListJobsResponse, TranscoderServiceClient.ListJobsPagedResponse> listJobsSettings() {
        return this.listJobsSettings;
    }

    public UnaryCallSettings<GetJobRequest, Job> getJobSettings() {
        return this.getJobSettings;
    }

    public UnaryCallSettings<DeleteJobRequest, Empty> deleteJobSettings() {
        return this.deleteJobSettings;
    }

    public UnaryCallSettings<CreateJobTemplateRequest, JobTemplate> createJobTemplateSettings() {
        return this.createJobTemplateSettings;
    }

    public PagedCallSettings<ListJobTemplatesRequest, ListJobTemplatesResponse, TranscoderServiceClient.ListJobTemplatesPagedResponse> listJobTemplatesSettings() {
        return this.listJobTemplatesSettings;
    }

    public UnaryCallSettings<GetJobTemplateRequest, JobTemplate> getJobTemplateSettings() {
        return this.getJobTemplateSettings;
    }

    public UnaryCallSettings<DeleteJobTemplateRequest, Empty> deleteJobTemplateSettings() {
        return this.deleteJobTemplateSettings;
    }

    public TranscoderServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTranscoderServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTranscoderServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "transcoder.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "transcoder.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TranscoderServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TranscoderServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TranscoderServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return TranscoderServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TranscoderServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createJobSettings = settingsBuilder.createJobSettings().build();
        this.listJobsSettings = settingsBuilder.listJobsSettings().build();
        this.getJobSettings = settingsBuilder.getJobSettings().build();
        this.deleteJobSettings = settingsBuilder.deleteJobSettings().build();
        this.createJobTemplateSettings = settingsBuilder.createJobTemplateSettings().build();
        this.listJobTemplatesSettings = settingsBuilder.listJobTemplatesSettings().build();
        this.getJobTemplateSettings = settingsBuilder.getJobTemplateSettings().build();
        this.deleteJobTemplateSettings = settingsBuilder.deleteJobTemplateSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TranscoderServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateJobRequest, Job> createJobSettings;
        private final PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, TranscoderServiceClient.ListJobsPagedResponse> listJobsSettings;
        private final UnaryCallSettings.Builder<GetJobRequest, Job> getJobSettings;
        private final UnaryCallSettings.Builder<DeleteJobRequest, Empty> deleteJobSettings;
        private final UnaryCallSettings.Builder<CreateJobTemplateRequest, JobTemplate> createJobTemplateSettings;
        private final PagedCallSettings.Builder<ListJobTemplatesRequest, ListJobTemplatesResponse, TranscoderServiceClient.ListJobTemplatesPagedResponse> listJobTemplatesSettings;
        private final UnaryCallSettings.Builder<GetJobTemplateRequest, JobTemplate> getJobTemplateSettings;
        private final UnaryCallSettings.Builder<DeleteJobTemplateRequest, Empty> deleteJobTemplateSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_JOBS_PAGE_STR_FACT);
            this.getJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createJobTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listJobTemplatesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_JOB_TEMPLATES_PAGE_STR_FACT);
            this.getJobTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteJobTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createJobSettings, this.listJobsSettings, this.getJobSettings, this.deleteJobSettings, this.createJobTemplateSettings, this.listJobTemplatesSettings, this.getJobTemplateSettings, this.deleteJobTemplateSettings);
            Builder.initDefaults(this);
        }

        protected Builder(TranscoderServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createJobSettings = settings.createJobSettings.toBuilder();
            this.listJobsSettings = settings.listJobsSettings.toBuilder();
            this.getJobSettings = settings.getJobSettings.toBuilder();
            this.deleteJobSettings = settings.deleteJobSettings.toBuilder();
            this.createJobTemplateSettings = settings.createJobTemplateSettings.toBuilder();
            this.listJobTemplatesSettings = settings.listJobTemplatesSettings.toBuilder();
            this.getJobTemplateSettings = settings.getJobTemplateSettings.toBuilder();
            this.deleteJobTemplateSettings = settings.deleteJobTemplateSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createJobSettings, this.listJobsSettings, this.getJobSettings, this.deleteJobSettings, this.createJobTemplateSettings, this.listJobTemplatesSettings, this.getJobTemplateSettings, this.deleteJobTemplateSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TranscoderServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TranscoderServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TranscoderServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TranscoderServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(TranscoderServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)TranscoderServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)TranscoderServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TranscoderServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TranscoderServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(TranscoderServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createJobTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listJobTemplatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getJobTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteJobTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateJobRequest, Job> createJobSettings() {
            return this.createJobSettings;
        }

        public PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, TranscoderServiceClient.ListJobsPagedResponse> listJobsSettings() {
            return this.listJobsSettings;
        }

        public UnaryCallSettings.Builder<GetJobRequest, Job> getJobSettings() {
            return this.getJobSettings;
        }

        public UnaryCallSettings.Builder<DeleteJobRequest, Empty> deleteJobSettings() {
            return this.deleteJobSettings;
        }

        public UnaryCallSettings.Builder<CreateJobTemplateRequest, JobTemplate> createJobTemplateSettings() {
            return this.createJobTemplateSettings;
        }

        public PagedCallSettings.Builder<ListJobTemplatesRequest, ListJobTemplatesResponse, TranscoderServiceClient.ListJobTemplatesPagedResponse> listJobTemplatesSettings() {
            return this.listJobTemplatesSettings;
        }

        public UnaryCallSettings.Builder<GetJobTemplateRequest, JobTemplate> getJobTemplateSettings() {
            return this.getJobTemplateSettings;
        }

        public UnaryCallSettings.Builder<DeleteJobTemplateRequest, Empty> deleteJobTemplateSettings() {
            return this.deleteJobTemplateSettings;
        }

        public TranscoderServiceStubSettings build() throws IOException {
            return new TranscoderServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

