/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.videointelligence.v1beta2;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.grpc.GrpcExtraHeaderData;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.videointelligence.v1beta2.AnnotateVideoProgress;
import com.google.cloud.videointelligence.v1beta2.AnnotateVideoRequest;
import com.google.cloud.videointelligence.v1beta2.AnnotateVideoResponse;
import com.google.cloud.videointelligence.v1beta2.stub.GrpcVideoIntelligenceServiceStub;
import com.google.cloud.videointelligence.v1beta2.stub.VideoIntelligenceServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class VideoIntelligenceServiceSettings
extends ClientSettings<VideoIntelligenceServiceSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/videointelligence/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private final UnaryCallSettings<AnnotateVideoRequest, Operation> annotateVideoSettings;
    private final OperationCallSettings<AnnotateVideoRequest, AnnotateVideoResponse, AnnotateVideoProgress> annotateVideoOperationSettings;

    public UnaryCallSettings<AnnotateVideoRequest, Operation> annotateVideoSettings() {
        return this.annotateVideoSettings;
    }

    public OperationCallSettings<AnnotateVideoRequest, AnnotateVideoResponse, AnnotateVideoProgress> annotateVideoOperationSettings() {
        return this.annotateVideoOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public VideoIntelligenceServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcVideoIntelligenceServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "videointelligence.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return VideoIntelligenceServiceSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratorHeader(DEFAULT_GAPIC_NAME, VideoIntelligenceServiceSettings.getGapicVersion()).setApiClientHeaderLineKey("x-goog-api-client").addApiClientHeaderLineData(GrpcExtraHeaderData.getXGoogApiClientData());
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(VideoIntelligenceServiceSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private VideoIntelligenceServiceSettings(Builder settingsBuilder) throws IOException {
        super((ClientSettings.Builder)settingsBuilder);
        this.annotateVideoSettings = settingsBuilder.annotateVideoSettings().build();
        this.annotateVideoOperationSettings = settingsBuilder.annotateVideoOperationSettings().build();
    }

    public static class Builder
    extends ClientSettings.Builder<VideoIntelligenceServiceSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AnnotateVideoRequest, Operation> annotateVideoSettings;
        private final OperationCallSettings.Builder<AnnotateVideoRequest, AnnotateVideoResponse, AnnotateVideoProgress> annotateVideoOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            this((ClientContext)null);
        }

        private Builder(ClientContext clientContext) {
            super(clientContext);
            this.annotateVideoSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.annotateVideoOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.annotateVideoSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(VideoIntelligenceServiceSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)VideoIntelligenceServiceSettings.defaultCredentialsProviderBuilder().build());
            builder.setHeaderProvider((HeaderProvider)VideoIntelligenceServiceSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(VideoIntelligenceServiceSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.annotateVideoSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.annotateVideoOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AnnotateVideoResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AnnotateVideoProgress.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)20000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)86400000L)).build()));
            return builder;
        }

        private Builder(VideoIntelligenceServiceSettings settings) {
            super((ClientSettings)settings);
            this.annotateVideoSettings = settings.annotateVideoSettings.toBuilder();
            this.annotateVideoOperationSettings = settings.annotateVideoOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.annotateVideoSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            ClientSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public UnaryCallSettings.Builder<AnnotateVideoRequest, Operation> annotateVideoSettings() {
            return this.annotateVideoSettings;
        }

        public OperationCallSettings.Builder<AnnotateVideoRequest, AnnotateVideoResponse, AnnotateVideoProgress> annotateVideoOperationSettings() {
            return this.annotateVideoOperationSettings;
        }

        public VideoIntelligenceServiceSettings build() throws IOException {
            return new VideoIntelligenceServiceSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(2.5).setMaxRetryDelay(Duration.ofMillis((long)120000L)).setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

