/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.vertexai.Transport;
import com.google.cloud.vertexai.api.LlmUtilityServiceClient;
import com.google.cloud.vertexai.api.LlmUtilityServiceSettings;
import com.google.cloud.vertexai.api.PredictionServiceClient;
import com.google.cloud.vertexai.api.PredictionServiceSettings;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VertexAI
implements AutoCloseable {
    private final String projectId;
    private final String location;
    private final String apiEndpoint;
    private final Transport transport;
    private final CredentialsProvider credentialsProvider;
    private final transient Supplier<PredictionServiceClient> predictionClientSupplier;
    private final transient Supplier<LlmUtilityServiceClient> llmClientSupplier;

    @InternalApi
    static Optional<String> getEnvironmentVariable(String envKey) {
        return Optional.ofNullable(System.getenv(envKey));
    }

    public VertexAI(String projectId, String location) {
        this(projectId, location, Transport.GRPC, (List<String>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public VertexAI() {
        this(null, null, Transport.GRPC, (List<String>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private VertexAI(String projectId, String location, Transport transport, List<String> scopes, Optional<Credentials> credentials, Optional<String> apiEndpoint, Optional<Supplier<PredictionServiceClient>> predictionClientSupplierOpt, Optional<Supplier<LlmUtilityServiceClient>> llmClientSupplierOpt) {
        if (!scopes.isEmpty() && credentials.isPresent()) {
            throw new IllegalArgumentException("At most one of Credentials and scopes should be specified.");
        }
        Preconditions.checkNotNull((Object)((Object)transport), (Object)"transport can't be null");
        this.location = Strings.isNullOrEmpty((String)location) ? this.inferLocation() : location;
        this.transport = transport;
        this.credentialsProvider = credentials.isPresent() ? FixedCredentialsProvider.create((Credentials)credentials.get()) : (scopes.isEmpty() ? PredictionServiceSettings.defaultCredentialsProviderBuilder().build() : GoogleCredentialsProvider.newBuilder().setScopesToApply(scopes).setUseJwtAccessWithScope(true).build());
        this.projectId = Strings.isNullOrEmpty((String)projectId) ? this.inferProjectId() : projectId;
        this.predictionClientSupplier = Suppliers.memoize(predictionClientSupplierOpt.orElse((Supplier<PredictionServiceClient>)((Supplier)this::newPredictionServiceClient)));
        this.llmClientSupplier = Suppliers.memoize(llmClientSupplierOpt.orElse((Supplier<LlmUtilityServiceClient>)((Supplier)this::newLlmUtilityClient)));
        this.apiEndpoint = apiEndpoint.orElse(String.format("%s-aiplatform.googleapis.com", this.location));
    }

    public Transport getTransport() {
        return this.transport;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public Credentials getCredentials() throws IOException {
        return this.credentialsProvider.getCredentials();
    }

    @InternalApi
    public PredictionServiceClient getPredictionServiceClient() {
        return (PredictionServiceClient)this.predictionClientSupplier.get();
    }

    private PredictionServiceClient newPredictionServiceClient() {
        Logger defaultCredentialsProviderLogger = Logger.getLogger("com.google.auth.oauth2.DefaultCredentialsProvider");
        Level previousLevel = defaultCredentialsProviderLogger.getLevel();
        defaultCredentialsProviderLogger.setLevel(Level.SEVERE);
        try {
            PredictionServiceClient predictionServiceClient = PredictionServiceClient.create(this.getPredictionServiceSettings());
            return predictionServiceClient;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            defaultCredentialsProviderLogger.setLevel(previousLevel);
        }
    }

    private PredictionServiceSettings getPredictionServiceSettings() throws IOException {
        PredictionServiceSettings.Builder builder = this.transport == Transport.REST ? PredictionServiceSettings.newHttpJsonBuilder() : PredictionServiceSettings.newBuilder();
        builder.setEndpoint(String.format("%s:443", this.apiEndpoint));
        builder.setCredentialsProvider(this.credentialsProvider);
        FixedHeaderProvider headerProvider = FixedHeaderProvider.create((String[])new String[]{"user-agent", String.format("%s/%s", "model-builder", GaxProperties.getLibraryVersion(PredictionServiceSettings.class))});
        builder.setHeaderProvider((HeaderProvider)headerProvider);
        return builder.build();
    }

    @InternalApi
    public LlmUtilityServiceClient getLlmUtilityClient() {
        return (LlmUtilityServiceClient)this.llmClientSupplier.get();
    }

    private LlmUtilityServiceClient newLlmUtilityClient() {
        Logger defaultCredentialsProviderLogger = Logger.getLogger("com.google.auth.oauth2.DefaultCredentialsProvider");
        Level previousLevel = defaultCredentialsProviderLogger.getLevel();
        defaultCredentialsProviderLogger.setLevel(Level.SEVERE);
        try {
            LlmUtilityServiceClient llmUtilityServiceClient = LlmUtilityServiceClient.create(this.getLlmUtilityServiceClientSettings());
            return llmUtilityServiceClient;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            defaultCredentialsProviderLogger.setLevel(previousLevel);
        }
    }

    private String inferProjectId() {
        String projectNotFoundErrorMessage = "Unable to infer your project. Please provide a project Id by one of the following:\n- Passing a constructor argument by using new VertexAI(String projectId, String location)\n- Setting project using 'gcloud config set project my-project'";
        Optional<String> projectIdOptional = VertexAI.getEnvironmentVariable("GOOGLE_CLOUD_PROJECT");
        if (projectIdOptional.isPresent()) {
            return projectIdOptional.get();
        }
        try {
            return Optional.ofNullable((GoogleCredentials)this.credentialsProvider.getCredentials()).map(credentials -> credentials.getQuotaProjectId()).orElseThrow(() -> new IllegalArgumentException("Unable to infer your project. Please provide a project Id by one of the following:\n- Passing a constructor argument by using new VertexAI(String projectId, String location)\n- Setting project using 'gcloud config set project my-project'"));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to infer your project. Please provide a project Id by one of the following:\n- Passing a constructor argument by using new VertexAI(String projectId, String location)\n- Setting project using 'gcloud config set project my-project'", e);
        }
    }

    private String inferLocation() {
        return VertexAI.getEnvironmentVariable("GOOGLE_CLOUD_REGION").orElse(VertexAI.getEnvironmentVariable("CLOUD_ML_REGION").orElse("us-central1"));
    }

    private LlmUtilityServiceSettings getLlmUtilityServiceClientSettings() throws IOException {
        LlmUtilityServiceSettings.Builder settingsBuilder = this.transport == Transport.REST ? LlmUtilityServiceSettings.newHttpJsonBuilder() : LlmUtilityServiceSettings.newBuilder();
        settingsBuilder.setEndpoint(String.format("%s:443", this.apiEndpoint));
        settingsBuilder.setCredentialsProvider(this.credentialsProvider);
        FixedHeaderProvider headerProvider = FixedHeaderProvider.create((String[])new String[]{"user-agent", String.format("%s/%s", "model-builder", GaxProperties.getLibraryVersion(LlmUtilityServiceSettings.class))});
        settingsBuilder.setHeaderProvider((HeaderProvider)headerProvider);
        return settingsBuilder.build();
    }

    @Override
    public void close() {
        ((PredictionServiceClient)this.predictionClientSupplier.get()).close();
        ((LlmUtilityServiceClient)this.llmClientSupplier.get()).close();
    }

    public static class Builder {
        private String projectId;
        private String location;
        private Transport transport = Transport.GRPC;
        private ImmutableList<String> scopes = ImmutableList.of();
        private Optional<Credentials> credentials = Optional.empty();
        private Optional<String> apiEndpoint = Optional.empty();
        private Supplier<PredictionServiceClient> predictionClientSupplier;
        private Supplier<LlmUtilityServiceClient> llmClientSupplier;

        public VertexAI build() {
            return new VertexAI(this.projectId, this.location, this.transport, (List)this.scopes, this.credentials, this.apiEndpoint, Optional.ofNullable(this.predictionClientSupplier), Optional.ofNullable(this.llmClientSupplier));
        }

        @CanIgnoreReturnValue
        public Builder setProjectId(String projectId) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"projectId can't be null or empty");
            this.projectId = projectId;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLocation(String location) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)location) ? 1 : 0) != 0, (Object)"location can't be null or empty");
            this.location = location;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setApiEndpoint(String apiEndpoint) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)apiEndpoint) ? 1 : 0) != 0, (Object)"apiEndpoint can't be null or empty");
            this.apiEndpoint = Optional.of(apiEndpoint);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTransport(Transport transport) {
            Preconditions.checkNotNull((Object)((Object)transport), (Object)"transport can't be null");
            this.transport = transport;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCredentials(Credentials credentials) {
            Preconditions.checkNotNull((Object)credentials, (Object)"credentials can't be null");
            this.credentials = Optional.of(credentials);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPredictionClientSupplier(Supplier<PredictionServiceClient> predictionClientSupplier) {
            this.predictionClientSupplier = predictionClientSupplier;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLlmClientSupplier(Supplier<LlmUtilityServiceClient> llmClientSupplier) {
            this.llmClientSupplier = llmClientSupplier;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setScopes(List<String> scopes) {
            Preconditions.checkNotNull(scopes, (Object)"scopes can't be null");
            this.scopes = ImmutableList.copyOf(scopes);
            return this;
        }
    }
}

