/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.generativeai;

import com.google.cloud.vertexai.api.FunctionDeclaration;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;

public final class FunctionDeclarationMaker {
    public static FunctionDeclaration fromJsonString(String jsonString) throws InvalidProtocolBufferException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)jsonString) ? 1 : 0) != 0, (Object)"Input String can't be null or empty.");
        FunctionDeclaration.Builder builder = FunctionDeclaration.newBuilder();
        JsonFormat.parser().merge(jsonString, (Message.Builder)builder);
        FunctionDeclaration declaration = builder.build();
        if (declaration.getName().isEmpty()) {
            throw new IllegalArgumentException("name field must be present.");
        }
        return declaration;
    }

    public static FunctionDeclaration fromJsonObject(JsonObject jsonObject) throws InvalidProtocolBufferException {
        Preconditions.checkNotNull((Object)jsonObject, (Object)"JsonObject can't be null.");
        return FunctionDeclarationMaker.fromJsonString(jsonObject.toString());
    }
}

