/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.api.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.vertexai.api.CreateEndpointOperationMetadata;
import com.google.cloud.vertexai.api.CreateEndpointRequest;
import com.google.cloud.vertexai.api.DeleteEndpointRequest;
import com.google.cloud.vertexai.api.DeleteOperationMetadata;
import com.google.cloud.vertexai.api.DeployModelOperationMetadata;
import com.google.cloud.vertexai.api.DeployModelRequest;
import com.google.cloud.vertexai.api.DeployModelResponse;
import com.google.cloud.vertexai.api.Endpoint;
import com.google.cloud.vertexai.api.EndpointServiceClient;
import com.google.cloud.vertexai.api.GetEndpointRequest;
import com.google.cloud.vertexai.api.ListEndpointsRequest;
import com.google.cloud.vertexai.api.ListEndpointsResponse;
import com.google.cloud.vertexai.api.MutateDeployedModelOperationMetadata;
import com.google.cloud.vertexai.api.MutateDeployedModelRequest;
import com.google.cloud.vertexai.api.MutateDeployedModelResponse;
import com.google.cloud.vertexai.api.UndeployModelOperationMetadata;
import com.google.cloud.vertexai.api.UndeployModelRequest;
import com.google.cloud.vertexai.api.UndeployModelResponse;
import com.google.cloud.vertexai.api.UpdateEndpointRequest;
import com.google.cloud.vertexai.api.stub.EndpointServiceStub;
import com.google.cloud.vertexai.api.stub.GrpcEndpointServiceStub;
import com.google.cloud.vertexai.api.stub.HttpJsonEndpointServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class EndpointServiceStubSettings
extends StubSettings<EndpointServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateEndpointRequest, Operation> createEndpointSettings;
    private final OperationCallSettings<CreateEndpointRequest, Endpoint, CreateEndpointOperationMetadata> createEndpointOperationSettings;
    private final UnaryCallSettings<GetEndpointRequest, Endpoint> getEndpointSettings;
    private final PagedCallSettings<ListEndpointsRequest, ListEndpointsResponse, EndpointServiceClient.ListEndpointsPagedResponse> listEndpointsSettings;
    private final UnaryCallSettings<UpdateEndpointRequest, Endpoint> updateEndpointSettings;
    private final UnaryCallSettings<DeleteEndpointRequest, Operation> deleteEndpointSettings;
    private final OperationCallSettings<DeleteEndpointRequest, Empty, DeleteOperationMetadata> deleteEndpointOperationSettings;
    private final UnaryCallSettings<DeployModelRequest, Operation> deployModelSettings;
    private final OperationCallSettings<DeployModelRequest, DeployModelResponse, DeployModelOperationMetadata> deployModelOperationSettings;
    private final UnaryCallSettings<UndeployModelRequest, Operation> undeployModelSettings;
    private final OperationCallSettings<UndeployModelRequest, UndeployModelResponse, UndeployModelOperationMetadata> undeployModelOperationSettings;
    private final UnaryCallSettings<MutateDeployedModelRequest, Operation> mutateDeployedModelSettings;
    private final OperationCallSettings<MutateDeployedModelRequest, MutateDeployedModelResponse, MutateDeployedModelOperationMetadata> mutateDeployedModelOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, EndpointServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListEndpointsRequest, ListEndpointsResponse, Endpoint> LIST_ENDPOINTS_PAGE_STR_DESC = new PagedListDescriptor<ListEndpointsRequest, ListEndpointsResponse, Endpoint>(){

        public String emptyToken() {
            return "";
        }

        public ListEndpointsRequest injectToken(ListEndpointsRequest payload, String token) {
            return ListEndpointsRequest.newBuilder((ListEndpointsRequest)payload).setPageToken(token).build();
        }

        public ListEndpointsRequest injectPageSize(ListEndpointsRequest payload, int pageSize) {
            return ListEndpointsRequest.newBuilder((ListEndpointsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEndpointsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEndpointsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Endpoint> extractResources(ListEndpointsResponse payload) {
            return payload.getEndpointsList() == null ? ImmutableList.of() : payload.getEndpointsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListEndpointsRequest, ListEndpointsResponse, EndpointServiceClient.ListEndpointsPagedResponse> LIST_ENDPOINTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEndpointsRequest, ListEndpointsResponse, EndpointServiceClient.ListEndpointsPagedResponse>(){

        public ApiFuture<EndpointServiceClient.ListEndpointsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEndpointsRequest, ListEndpointsResponse> callable, ListEndpointsRequest request, ApiCallContext context, ApiFuture<ListEndpointsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENDPOINTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EndpointServiceClient.ListEndpointsPagedResponse.createAsync((PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, EndpointServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, EndpointServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<EndpointServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EndpointServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateEndpointRequest, Operation> createEndpointSettings() {
        return this.createEndpointSettings;
    }

    public OperationCallSettings<CreateEndpointRequest, Endpoint, CreateEndpointOperationMetadata> createEndpointOperationSettings() {
        return this.createEndpointOperationSettings;
    }

    public UnaryCallSettings<GetEndpointRequest, Endpoint> getEndpointSettings() {
        return this.getEndpointSettings;
    }

    public PagedCallSettings<ListEndpointsRequest, ListEndpointsResponse, EndpointServiceClient.ListEndpointsPagedResponse> listEndpointsSettings() {
        return this.listEndpointsSettings;
    }

    public UnaryCallSettings<UpdateEndpointRequest, Endpoint> updateEndpointSettings() {
        return this.updateEndpointSettings;
    }

    public UnaryCallSettings<DeleteEndpointRequest, Operation> deleteEndpointSettings() {
        return this.deleteEndpointSettings;
    }

    public OperationCallSettings<DeleteEndpointRequest, Empty, DeleteOperationMetadata> deleteEndpointOperationSettings() {
        return this.deleteEndpointOperationSettings;
    }

    public UnaryCallSettings<DeployModelRequest, Operation> deployModelSettings() {
        return this.deployModelSettings;
    }

    public OperationCallSettings<DeployModelRequest, DeployModelResponse, DeployModelOperationMetadata> deployModelOperationSettings() {
        return this.deployModelOperationSettings;
    }

    public UnaryCallSettings<UndeployModelRequest, Operation> undeployModelSettings() {
        return this.undeployModelSettings;
    }

    public OperationCallSettings<UndeployModelRequest, UndeployModelResponse, UndeployModelOperationMetadata> undeployModelOperationSettings() {
        return this.undeployModelOperationSettings;
    }

    public UnaryCallSettings<MutateDeployedModelRequest, Operation> mutateDeployedModelSettings() {
        return this.mutateDeployedModelSettings;
    }

    public OperationCallSettings<MutateDeployedModelRequest, MutateDeployedModelResponse, MutateDeployedModelOperationMetadata> mutateDeployedModelOperationSettings() {
        return this.mutateDeployedModelOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, EndpointServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public EndpointServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEndpointServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonEndpointServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return EndpointServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "aiplatform";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EndpointServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EndpointServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EndpointServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return EndpointServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EndpointServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createEndpointSettings = settingsBuilder.createEndpointSettings().build();
        this.createEndpointOperationSettings = settingsBuilder.createEndpointOperationSettings().build();
        this.getEndpointSettings = settingsBuilder.getEndpointSettings().build();
        this.listEndpointsSettings = settingsBuilder.listEndpointsSettings().build();
        this.updateEndpointSettings = settingsBuilder.updateEndpointSettings().build();
        this.deleteEndpointSettings = settingsBuilder.deleteEndpointSettings().build();
        this.deleteEndpointOperationSettings = settingsBuilder.deleteEndpointOperationSettings().build();
        this.deployModelSettings = settingsBuilder.deployModelSettings().build();
        this.deployModelOperationSettings = settingsBuilder.deployModelOperationSettings().build();
        this.undeployModelSettings = settingsBuilder.undeployModelSettings().build();
        this.undeployModelOperationSettings = settingsBuilder.undeployModelOperationSettings().build();
        this.mutateDeployedModelSettings = settingsBuilder.mutateDeployedModelSettings().build();
        this.mutateDeployedModelOperationSettings = settingsBuilder.mutateDeployedModelOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EndpointServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateEndpointRequest, Operation> createEndpointSettings;
        private final OperationCallSettings.Builder<CreateEndpointRequest, Endpoint, CreateEndpointOperationMetadata> createEndpointOperationSettings;
        private final UnaryCallSettings.Builder<GetEndpointRequest, Endpoint> getEndpointSettings;
        private final PagedCallSettings.Builder<ListEndpointsRequest, ListEndpointsResponse, EndpointServiceClient.ListEndpointsPagedResponse> listEndpointsSettings;
        private final UnaryCallSettings.Builder<UpdateEndpointRequest, Endpoint> updateEndpointSettings;
        private final UnaryCallSettings.Builder<DeleteEndpointRequest, Operation> deleteEndpointSettings;
        private final OperationCallSettings.Builder<DeleteEndpointRequest, Empty, DeleteOperationMetadata> deleteEndpointOperationSettings;
        private final UnaryCallSettings.Builder<DeployModelRequest, Operation> deployModelSettings;
        private final OperationCallSettings.Builder<DeployModelRequest, DeployModelResponse, DeployModelOperationMetadata> deployModelOperationSettings;
        private final UnaryCallSettings.Builder<UndeployModelRequest, Operation> undeployModelSettings;
        private final OperationCallSettings.Builder<UndeployModelRequest, UndeployModelResponse, UndeployModelOperationMetadata> undeployModelOperationSettings;
        private final UnaryCallSettings.Builder<MutateDeployedModelRequest, Operation> mutateDeployedModelSettings;
        private final OperationCallSettings.Builder<MutateDeployedModelRequest, MutateDeployedModelResponse, MutateDeployedModelOperationMetadata> mutateDeployedModelOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, EndpointServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEndpointOperationSettings = OperationCallSettings.newBuilder();
            this.getEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEndpointsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENDPOINTS_PAGE_STR_FACT);
            this.updateEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEndpointSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEndpointOperationSettings = OperationCallSettings.newBuilder();
            this.deployModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deployModelOperationSettings = OperationCallSettings.newBuilder();
            this.undeployModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeployModelOperationSettings = OperationCallSettings.newBuilder();
            this.mutateDeployedModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.mutateDeployedModelOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createEndpointSettings, this.getEndpointSettings, this.listEndpointsSettings, this.updateEndpointSettings, this.deleteEndpointSettings, this.deployModelSettings, this.undeployModelSettings, this.mutateDeployedModelSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(EndpointServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createEndpointSettings = settings.createEndpointSettings.toBuilder();
            this.createEndpointOperationSettings = settings.createEndpointOperationSettings.toBuilder();
            this.getEndpointSettings = settings.getEndpointSettings.toBuilder();
            this.listEndpointsSettings = settings.listEndpointsSettings.toBuilder();
            this.updateEndpointSettings = settings.updateEndpointSettings.toBuilder();
            this.deleteEndpointSettings = settings.deleteEndpointSettings.toBuilder();
            this.deleteEndpointOperationSettings = settings.deleteEndpointOperationSettings.toBuilder();
            this.deployModelSettings = settings.deployModelSettings.toBuilder();
            this.deployModelOperationSettings = settings.deployModelOperationSettings.toBuilder();
            this.undeployModelSettings = settings.undeployModelSettings.toBuilder();
            this.undeployModelOperationSettings = settings.undeployModelOperationSettings.toBuilder();
            this.mutateDeployedModelSettings = settings.mutateDeployedModelSettings.toBuilder();
            this.mutateDeployedModelOperationSettings = settings.mutateDeployedModelOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createEndpointSettings, this.getEndpointSettings, this.listEndpointsSettings, this.updateEndpointSettings, this.deleteEndpointSettings, this.deployModelSettings, this.undeployModelSettings, this.mutateDeployedModelSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EndpointServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EndpointServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EndpointServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EndpointServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)EndpointServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)EndpointServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EndpointServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EndpointServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listEndpointsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteEndpointSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deployModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.undeployModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.mutateDeployedModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createEndpointOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Endpoint.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateEndpointOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteEndpointOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deployModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DeployModelResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeployModelOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.undeployModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(UndeployModelResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UndeployModelOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.mutateDeployedModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MutateDeployedModelResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(MutateDeployedModelOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateEndpointRequest, Operation> createEndpointSettings() {
            return this.createEndpointSettings;
        }

        public OperationCallSettings.Builder<CreateEndpointRequest, Endpoint, CreateEndpointOperationMetadata> createEndpointOperationSettings() {
            return this.createEndpointOperationSettings;
        }

        public UnaryCallSettings.Builder<GetEndpointRequest, Endpoint> getEndpointSettings() {
            return this.getEndpointSettings;
        }

        public PagedCallSettings.Builder<ListEndpointsRequest, ListEndpointsResponse, EndpointServiceClient.ListEndpointsPagedResponse> listEndpointsSettings() {
            return this.listEndpointsSettings;
        }

        public UnaryCallSettings.Builder<UpdateEndpointRequest, Endpoint> updateEndpointSettings() {
            return this.updateEndpointSettings;
        }

        public UnaryCallSettings.Builder<DeleteEndpointRequest, Operation> deleteEndpointSettings() {
            return this.deleteEndpointSettings;
        }

        public OperationCallSettings.Builder<DeleteEndpointRequest, Empty, DeleteOperationMetadata> deleteEndpointOperationSettings() {
            return this.deleteEndpointOperationSettings;
        }

        public UnaryCallSettings.Builder<DeployModelRequest, Operation> deployModelSettings() {
            return this.deployModelSettings;
        }

        public OperationCallSettings.Builder<DeployModelRequest, DeployModelResponse, DeployModelOperationMetadata> deployModelOperationSettings() {
            return this.deployModelOperationSettings;
        }

        public UnaryCallSettings.Builder<UndeployModelRequest, Operation> undeployModelSettings() {
            return this.undeployModelSettings;
        }

        public OperationCallSettings.Builder<UndeployModelRequest, UndeployModelResponse, UndeployModelOperationMetadata> undeployModelOperationSettings() {
            return this.undeployModelOperationSettings;
        }

        public UnaryCallSettings.Builder<MutateDeployedModelRequest, Operation> mutateDeployedModelSettings() {
            return this.mutateDeployedModelSettings;
        }

        public OperationCallSettings.Builder<MutateDeployedModelRequest, MutateDeployedModelResponse, MutateDeployedModelOperationMetadata> mutateDeployedModelOperationSettings() {
            return this.mutateDeployedModelOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, EndpointServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return EndpointServiceStubSettings.getDefaultEndpoint();
        }

        public EndpointServiceStubSettings build() throws IOException {
            return new EndpointServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

