/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.generativeai;

import com.google.cloud.vertexai.api.Blob;
import com.google.cloud.vertexai.api.FileData;
import com.google.cloud.vertexai.api.FunctionResponse;
import com.google.cloud.vertexai.api.Part;
import com.google.protobuf.ByteString;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.net.URI;
import java.util.Map;

public class PartMaker {
    private PartMaker() {
    }

    public static Part fromMimeTypeAndData(String mimeType, Object partData) {
        Part part;
        if (partData instanceof byte[]) {
            byte[] bytes = (byte[])partData;
            ByteString byteData = ByteString.copyFrom((byte[])bytes);
            part = Part.newBuilder().setInlineData(Blob.newBuilder().setMimeType(mimeType).setData(byteData)).build();
        } else if (partData instanceof String) {
            String uri = (String)partData;
            part = Part.newBuilder().setFileData(FileData.newBuilder().setMimeType(mimeType).setFileUri(uri)).build();
        } else if (partData instanceof URI) {
            URI uri = (URI)partData;
            part = Part.newBuilder().setFileData(FileData.newBuilder().setMimeType(mimeType).setFileUri(uri.toString())).build();
        } else if (partData instanceof ByteString) {
            ByteString byteData = (ByteString)partData;
            part = Part.newBuilder().setInlineData(Blob.newBuilder().setMimeType(mimeType).setData(byteData)).build();
        } else {
            throw new IllegalArgumentException("The second element of the input List can only be one of the following format: byte[], String, URI, ByteString");
        }
        return part;
    }

    public static Part fromFunctionResponse(String name, Struct response) {
        return Part.newBuilder().setFunctionResponse(FunctionResponse.newBuilder().setName(name).setResponse(response)).build();
    }

    public static Part fromFunctionResponse(String name, Map<String, Object> response) {
        Struct.Builder structBuilder = Struct.newBuilder();
        response.forEach((key, value) -> {
            if (value instanceof String) {
                String stringValue = (String)value;
                structBuilder.putFields(key, Value.newBuilder().setStringValue(stringValue).build());
            } else if (value instanceof Number) {
                double doubleValue = ((Number)value).doubleValue();
                structBuilder.putFields(key, Value.newBuilder().setNumberValue(doubleValue).build());
            } else if (value instanceof Boolean) {
                Boolean boolValue = (Boolean)value;
                structBuilder.putFields(key, Value.newBuilder().setBoolValue(boolValue.booleanValue()).build());
            } else if (value == null) {
                structBuilder.putFields(key, Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build());
            } else {
                throw new IllegalArgumentException("The value in the map can only be one of the following format: String, Number, Boolean, null.");
            }
        });
        return Part.newBuilder().setFunctionResponse(FunctionResponse.newBuilder().setName(name).setResponse(structBuilder)).build();
    }
}

