/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.generativeai;

import com.google.cloud.vertexai.api.Candidate;
import com.google.cloud.vertexai.api.CitationMetadata;
import com.google.cloud.vertexai.api.Content;
import com.google.cloud.vertexai.api.FunctionCall;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.api.Part;
import com.google.cloud.vertexai.generativeai.ResponseStream;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ResponseHandler {
    public static String getText(GenerateContentResponse response) {
        ResponseHandler.checkFinishReason(ResponseHandler.getFinishReason(response));
        String text = "";
        List parts = response.getCandidates(0).getContent().getPartsList();
        for (Part part : parts) {
            text = text + part.getText();
        }
        return text;
    }

    public static ImmutableList<FunctionCall> getFunctionCalls(GenerateContentResponse response) {
        ResponseHandler.checkFinishReason(ResponseHandler.getFinishReason(response));
        if (response.getCandidatesCount() == 0) {
            return ImmutableList.of();
        }
        return (ImmutableList)response.getCandidates(0).getContent().getPartsList().stream().filter(part -> part.hasFunctionCall()).map(part -> part.getFunctionCall()).collect(ImmutableList.toImmutableList());
    }

    public static Content getContent(GenerateContentResponse response) {
        ResponseHandler.checkFinishReason(ResponseHandler.getFinishReason(response));
        return response.getCandidates(0).getContent();
    }

    public static Candidate.FinishReason getFinishReason(GenerateContentResponse response) {
        if (response.getCandidatesCount() != 1) {
            throw new IllegalArgumentException(String.format("This response should have exactly 1 candidate, but it has %s.", response.getCandidatesCount()));
        }
        return response.getCandidates(0).getFinishReason();
    }

    static GenerateContentResponse aggregateStreamIntoResponse(ResponseStream<GenerateContentResponse> responseStream) {
        GenerateContentResponse res = GenerateContentResponse.getDefaultInstance();
        HashMap<Integer, Candidate> candidates = new HashMap<Integer, Candidate>();
        HashMap aggregatedContentParts = new HashMap();
        HashMap aggregatedCitationMetadata = new HashMap();
        Iterator<GenerateContentResponse> iterator = responseStream.iterator();
        while (iterator.hasNext()) {
            GenerateContentResponse response;
            res = response = iterator.next();
            for (Candidate candidate2 : response.getCandidatesList()) {
                int index2 = candidate2.getIndex();
                candidates.put(index2, candidate2);
                if (candidate2.hasContent()) {
                    ArrayList<Object> aggregatedParts;
                    List parts = candidate2.getContent().getPartsList();
                    List<Object> list = aggregatedParts = aggregatedContentParts.containsKey(index2) ? (List)aggregatedContentParts.get(index2) : new ArrayList<Object>();
                    if (aggregatedParts.size() == 0 || parts.size() == 0) {
                        aggregatedParts.addAll(parts);
                    } else {
                        Part aggregatedTailPart = (Part)aggregatedParts.get(aggregatedParts.size() - 1);
                        Part currentResponseHeadPart = (Part)parts.get(0);
                        if (!aggregatedTailPart.hasText() || !currentResponseHeadPart.hasText()) {
                            aggregatedParts.addAll(parts);
                        } else {
                            aggregatedParts.remove(aggregatedParts.size() - 1);
                            aggregatedParts.add(Part.newBuilder().setText(aggregatedTailPart.getText() + currentResponseHeadPart.getText()).build());
                            aggregatedParts.addAll(parts.subList(1, parts.size()));
                        }
                    }
                    aggregatedContentParts.put(index2, aggregatedParts);
                }
                if (!candidate2.hasCitationMetadata()) continue;
                List citations = candidate2.getCitationMetadata().getCitationsList();
                ArrayList aggregatedCitations = aggregatedCitationMetadata.containsKey(index2) ? (List)aggregatedCitationMetadata.get(index2) : new ArrayList();
                aggregatedCitations.addAll(citations);
                aggregatedCitationMetadata.put(index2, aggregatedCitations);
            }
        }
        ArrayList aggregatedCandidates = new ArrayList();
        candidates.forEach((index, candidate) -> {
            Candidate.Builder candidateBuilder = candidate.toBuilder();
            if (aggregatedContentParts.containsKey(index)) {
                candidateBuilder.setContent(Content.newBuilder().setRole("model").addAllParts((Iterable)aggregatedContentParts.get(index)));
            }
            if (aggregatedCitationMetadata.containsKey(index)) {
                candidateBuilder.setCitationMetadata(CitationMetadata.newBuilder().addAllCitations((Iterable)aggregatedCitationMetadata.get(index)));
            }
            aggregatedCandidates.add(candidateBuilder.build());
        });
        res = res.toBuilder().clearCandidates().addAllCandidates(aggregatedCandidates).build();
        return res;
    }

    private static void checkFinishReason(Candidate.FinishReason finishReason) {
        if (finishReason == Candidate.FinishReason.SAFETY) {
            throw new IllegalArgumentException("The response is blocked due to safety reason.");
        }
        if (finishReason == Candidate.FinishReason.RECITATION) {
            throw new IllegalArgumentException("The response is blocked due to unauthorized citations.");
        }
    }
}

