/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.api.stub;

import com.google.api.HttpBody;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.vertexai.api.CountTokensRequest;
import com.google.cloud.vertexai.api.CountTokensResponse;
import com.google.cloud.vertexai.api.DirectPredictRequest;
import com.google.cloud.vertexai.api.DirectPredictResponse;
import com.google.cloud.vertexai.api.DirectRawPredictRequest;
import com.google.cloud.vertexai.api.DirectRawPredictResponse;
import com.google.cloud.vertexai.api.ExplainRequest;
import com.google.cloud.vertexai.api.ExplainResponse;
import com.google.cloud.vertexai.api.GenerateContentRequest;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.api.PredictRequest;
import com.google.cloud.vertexai.api.PredictResponse;
import com.google.cloud.vertexai.api.PredictionServiceClient;
import com.google.cloud.vertexai.api.RawPredictRequest;
import com.google.cloud.vertexai.api.StreamingPredictRequest;
import com.google.cloud.vertexai.api.StreamingPredictResponse;
import com.google.cloud.vertexai.api.StreamingRawPredictRequest;
import com.google.cloud.vertexai.api.StreamingRawPredictResponse;
import com.google.cloud.vertexai.api.stub.GrpcPredictionServiceCallableFactory;
import com.google.cloud.vertexai.api.stub.PredictionServiceStub;
import com.google.cloud.vertexai.api.stub.PredictionServiceStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcPredictionServiceStub
extends PredictionServiceStub {
    private static final MethodDescriptor<PredictRequest, PredictResponse> predictMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PredictionService/Predict").setRequestMarshaller(ProtoUtils.marshaller((Message)PredictRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PredictResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<RawPredictRequest, HttpBody> rawPredictMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PredictionService/RawPredict").setRequestMarshaller(ProtoUtils.marshaller((Message)RawPredictRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)HttpBody.getDefaultInstance())).build();
    private static final MethodDescriptor<DirectPredictRequest, DirectPredictResponse> directPredictMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PredictionService/DirectPredict").setRequestMarshaller(ProtoUtils.marshaller((Message)DirectPredictRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DirectPredictResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DirectRawPredictRequest, DirectRawPredictResponse> directRawPredictMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PredictionService/DirectRawPredict").setRequestMarshaller(ProtoUtils.marshaller((Message)DirectRawPredictRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DirectRawPredictResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<StreamingPredictRequest, StreamingPredictResponse> streamingPredictMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.cloud.aiplatform.v1beta1.PredictionService/StreamingPredict").setRequestMarshaller(ProtoUtils.marshaller((Message)StreamingPredictRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StreamingPredictResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<StreamingPredictRequest, StreamingPredictResponse> serverStreamingPredictMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.cloud.aiplatform.v1beta1.PredictionService/ServerStreamingPredict").setRequestMarshaller(ProtoUtils.marshaller((Message)StreamingPredictRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StreamingPredictResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<StreamingRawPredictRequest, StreamingRawPredictResponse> streamingRawPredictMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.cloud.aiplatform.v1beta1.PredictionService/StreamingRawPredict").setRequestMarshaller(ProtoUtils.marshaller((Message)StreamingRawPredictRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StreamingRawPredictResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ExplainRequest, ExplainResponse> explainMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PredictionService/Explain").setRequestMarshaller(ProtoUtils.marshaller((Message)ExplainRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ExplainResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CountTokensRequest, CountTokensResponse> countTokensMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.aiplatform.v1beta1.PredictionService/CountTokens").setRequestMarshaller(ProtoUtils.marshaller((Message)CountTokensRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CountTokensResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GenerateContentRequest, GenerateContentResponse> streamGenerateContentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.cloud.aiplatform.v1beta1.PredictionService/StreamGenerateContent").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateContentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateContentResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<PredictRequest, PredictResponse> predictCallable;
    private final UnaryCallable<RawPredictRequest, HttpBody> rawPredictCallable;
    private final UnaryCallable<DirectPredictRequest, DirectPredictResponse> directPredictCallable;
    private final UnaryCallable<DirectRawPredictRequest, DirectRawPredictResponse> directRawPredictCallable;
    private final BidiStreamingCallable<StreamingPredictRequest, StreamingPredictResponse> streamingPredictCallable;
    private final ServerStreamingCallable<StreamingPredictRequest, StreamingPredictResponse> serverStreamingPredictCallable;
    private final BidiStreamingCallable<StreamingRawPredictRequest, StreamingRawPredictResponse> streamingRawPredictCallable;
    private final UnaryCallable<ExplainRequest, ExplainResponse> explainCallable;
    private final UnaryCallable<CountTokensRequest, CountTokensResponse> countTokensCallable;
    private final ServerStreamingCallable<GenerateContentRequest, GenerateContentResponse> streamGenerateContentCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, PredictionServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcPredictionServiceStub create(PredictionServiceStubSettings settings) throws IOException {
        return new GrpcPredictionServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcPredictionServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcPredictionServiceStub(PredictionServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcPredictionServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcPredictionServiceStub(PredictionServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcPredictionServiceStub(PredictionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcPredictionServiceCallableFactory());
    }

    protected GrpcPredictionServiceStub(PredictionServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings predictTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(predictMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("endpoint", String.valueOf(request.getEndpoint()));
            return builder.build();
        }).build();
        GrpcCallSettings rawPredictTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(rawPredictMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("endpoint", String.valueOf(request.getEndpoint()));
            return builder.build();
        }).build();
        GrpcCallSettings directPredictTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(directPredictMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("endpoint", String.valueOf(request.getEndpoint()));
            return builder.build();
        }).build();
        GrpcCallSettings directRawPredictTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(directRawPredictMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("endpoint", String.valueOf(request.getEndpoint()));
            return builder.build();
        }).build();
        GrpcCallSettings streamingPredictTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(streamingPredictMethodDescriptor).build();
        GrpcCallSettings serverStreamingPredictTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(serverStreamingPredictMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("endpoint", String.valueOf(request.getEndpoint()));
            return builder.build();
        }).build();
        GrpcCallSettings streamingRawPredictTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(streamingRawPredictMethodDescriptor).build();
        GrpcCallSettings explainTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(explainMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("endpoint", String.valueOf(request.getEndpoint()));
            return builder.build();
        }).build();
        GrpcCallSettings countTokensTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(countTokensMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("endpoint", String.valueOf(request.getEndpoint()));
            return builder.build();
        }).build();
        GrpcCallSettings streamGenerateContentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(streamGenerateContentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("model", String.valueOf(request.getModel()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.predictCallable = callableFactory.createUnaryCallable(predictTransportSettings, settings.predictSettings(), clientContext);
        this.rawPredictCallable = callableFactory.createUnaryCallable(rawPredictTransportSettings, settings.rawPredictSettings(), clientContext);
        this.directPredictCallable = callableFactory.createUnaryCallable(directPredictTransportSettings, settings.directPredictSettings(), clientContext);
        this.directRawPredictCallable = callableFactory.createUnaryCallable(directRawPredictTransportSettings, settings.directRawPredictSettings(), clientContext);
        this.streamingPredictCallable = callableFactory.createBidiStreamingCallable(streamingPredictTransportSettings, settings.streamingPredictSettings(), clientContext);
        this.serverStreamingPredictCallable = callableFactory.createServerStreamingCallable(serverStreamingPredictTransportSettings, settings.serverStreamingPredictSettings(), clientContext);
        this.streamingRawPredictCallable = callableFactory.createBidiStreamingCallable(streamingRawPredictTransportSettings, settings.streamingRawPredictSettings(), clientContext);
        this.explainCallable = callableFactory.createUnaryCallable(explainTransportSettings, settings.explainSettings(), clientContext);
        this.countTokensCallable = callableFactory.createUnaryCallable(countTokensTransportSettings, settings.countTokensSettings(), clientContext);
        this.streamGenerateContentCallable = callableFactory.createServerStreamingCallable(streamGenerateContentTransportSettings, settings.streamGenerateContentSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<PredictRequest, PredictResponse> predictCallable() {
        return this.predictCallable;
    }

    @Override
    public UnaryCallable<RawPredictRequest, HttpBody> rawPredictCallable() {
        return this.rawPredictCallable;
    }

    @Override
    public UnaryCallable<DirectPredictRequest, DirectPredictResponse> directPredictCallable() {
        return this.directPredictCallable;
    }

    @Override
    public UnaryCallable<DirectRawPredictRequest, DirectRawPredictResponse> directRawPredictCallable() {
        return this.directRawPredictCallable;
    }

    @Override
    public BidiStreamingCallable<StreamingPredictRequest, StreamingPredictResponse> streamingPredictCallable() {
        return this.streamingPredictCallable;
    }

    @Override
    public ServerStreamingCallable<StreamingPredictRequest, StreamingPredictResponse> serverStreamingPredictCallable() {
        return this.serverStreamingPredictCallable;
    }

    @Override
    public BidiStreamingCallable<StreamingRawPredictRequest, StreamingRawPredictResponse> streamingRawPredictCallable() {
        return this.streamingRawPredictCallable;
    }

    @Override
    public UnaryCallable<ExplainRequest, ExplainResponse> explainCallable() {
        return this.explainCallable;
    }

    @Override
    public UnaryCallable<CountTokensRequest, CountTokensResponse> countTokensCallable() {
        return this.countTokensCallable;
    }

    @Override
    public ServerStreamingCallable<GenerateContentRequest, GenerateContentResponse> streamGenerateContentCallable() {
        return this.streamGenerateContentCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, PredictionServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

