/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vectorsearch.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.vectorsearch.v1beta.AggregateDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.AggregateDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.BatchSearchDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.BatchSearchDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.DataObject;
import com.google.cloud.vectorsearch.v1beta.DataObjectSearchServiceClient;
import com.google.cloud.vectorsearch.v1beta.QueryDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.QueryDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.SearchDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.SearchDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.SearchResult;
import com.google.cloud.vectorsearch.v1beta.stub.DataObjectSearchServiceStub;
import com.google.cloud.vectorsearch.v1beta.stub.GrpcDataObjectSearchServiceStub;
import com.google.cloud.vectorsearch.v1beta.stub.HttpJsonDataObjectSearchServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class DataObjectSearchServiceStubSettings
extends StubSettings<DataObjectSearchServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<SearchDataObjectsRequest, SearchDataObjectsResponse, DataObjectSearchServiceClient.SearchDataObjectsPagedResponse> searchDataObjectsSettings;
    private final PagedCallSettings<QueryDataObjectsRequest, QueryDataObjectsResponse, DataObjectSearchServiceClient.QueryDataObjectsPagedResponse> queryDataObjectsSettings;
    private final UnaryCallSettings<AggregateDataObjectsRequest, AggregateDataObjectsResponse> aggregateDataObjectsSettings;
    private final UnaryCallSettings<BatchSearchDataObjectsRequest, BatchSearchDataObjectsResponse> batchSearchDataObjectsSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataObjectSearchServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<SearchDataObjectsRequest, SearchDataObjectsResponse, SearchResult> SEARCH_DATA_OBJECTS_PAGE_STR_DESC = new PagedListDescriptor<SearchDataObjectsRequest, SearchDataObjectsResponse, SearchResult>(){

        public String emptyToken() {
            return "";
        }

        public SearchDataObjectsRequest injectToken(SearchDataObjectsRequest payload, String token) {
            return SearchDataObjectsRequest.newBuilder((SearchDataObjectsRequest)payload).setPageToken(token).build();
        }

        public SearchDataObjectsRequest injectPageSize(SearchDataObjectsRequest payload, int pageSize) {
            return SearchDataObjectsRequest.newBuilder((SearchDataObjectsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchDataObjectsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchDataObjectsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SearchResult> extractResources(SearchDataObjectsResponse payload) {
            return payload.getResultsList();
        }
    };
    private static final PagedListDescriptor<QueryDataObjectsRequest, QueryDataObjectsResponse, DataObject> QUERY_DATA_OBJECTS_PAGE_STR_DESC = new PagedListDescriptor<QueryDataObjectsRequest, QueryDataObjectsResponse, DataObject>(){

        public String emptyToken() {
            return "";
        }

        public QueryDataObjectsRequest injectToken(QueryDataObjectsRequest payload, String token) {
            return QueryDataObjectsRequest.newBuilder((QueryDataObjectsRequest)payload).setPageToken(token).build();
        }

        public QueryDataObjectsRequest injectPageSize(QueryDataObjectsRequest payload, int pageSize) {
            return QueryDataObjectsRequest.newBuilder((QueryDataObjectsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(QueryDataObjectsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(QueryDataObjectsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataObject> extractResources(QueryDataObjectsResponse payload) {
            return payload.getDataObjectsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<SearchDataObjectsRequest, SearchDataObjectsResponse, DataObjectSearchServiceClient.SearchDataObjectsPagedResponse> SEARCH_DATA_OBJECTS_PAGE_STR_FACT = new PagedListResponseFactory<SearchDataObjectsRequest, SearchDataObjectsResponse, DataObjectSearchServiceClient.SearchDataObjectsPagedResponse>(){

        public ApiFuture<DataObjectSearchServiceClient.SearchDataObjectsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchDataObjectsRequest, SearchDataObjectsResponse> callable, SearchDataObjectsRequest request, ApiCallContext context, ApiFuture<SearchDataObjectsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_DATA_OBJECTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataObjectSearchServiceClient.SearchDataObjectsPagedResponse.createAsync((PageContext<SearchDataObjectsRequest, SearchDataObjectsResponse, SearchResult>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<QueryDataObjectsRequest, QueryDataObjectsResponse, DataObjectSearchServiceClient.QueryDataObjectsPagedResponse> QUERY_DATA_OBJECTS_PAGE_STR_FACT = new PagedListResponseFactory<QueryDataObjectsRequest, QueryDataObjectsResponse, DataObjectSearchServiceClient.QueryDataObjectsPagedResponse>(){

        public ApiFuture<DataObjectSearchServiceClient.QueryDataObjectsPagedResponse> getFuturePagedResponse(UnaryCallable<QueryDataObjectsRequest, QueryDataObjectsResponse> callable, QueryDataObjectsRequest request, ApiCallContext context, ApiFuture<QueryDataObjectsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)QUERY_DATA_OBJECTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataObjectSearchServiceClient.QueryDataObjectsPagedResponse.createAsync((PageContext<QueryDataObjectsRequest, QueryDataObjectsResponse, DataObject>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataObjectSearchServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataObjectSearchServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<DataObjectSearchServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataObjectSearchServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<SearchDataObjectsRequest, SearchDataObjectsResponse, DataObjectSearchServiceClient.SearchDataObjectsPagedResponse> searchDataObjectsSettings() {
        return this.searchDataObjectsSettings;
    }

    public PagedCallSettings<QueryDataObjectsRequest, QueryDataObjectsResponse, DataObjectSearchServiceClient.QueryDataObjectsPagedResponse> queryDataObjectsSettings() {
        return this.queryDataObjectsSettings;
    }

    public UnaryCallSettings<AggregateDataObjectsRequest, AggregateDataObjectsResponse> aggregateDataObjectsSettings() {
        return this.aggregateDataObjectsSettings;
    }

    public UnaryCallSettings<BatchSearchDataObjectsRequest, BatchSearchDataObjectsResponse> batchSearchDataObjectsSettings() {
        return this.batchSearchDataObjectsSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataObjectSearchServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public DataObjectSearchServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataObjectSearchServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDataObjectSearchServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "vectorsearch";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "vectorsearch.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "vectorsearch.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataObjectSearchServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataObjectSearchServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataObjectSearchServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DataObjectSearchServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataObjectSearchServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.searchDataObjectsSettings = settingsBuilder.searchDataObjectsSettings().build();
        this.queryDataObjectsSettings = settingsBuilder.queryDataObjectsSettings().build();
        this.aggregateDataObjectsSettings = settingsBuilder.aggregateDataObjectsSettings().build();
        this.batchSearchDataObjectsSettings = settingsBuilder.batchSearchDataObjectsSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataObjectSearchServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<SearchDataObjectsRequest, SearchDataObjectsResponse, DataObjectSearchServiceClient.SearchDataObjectsPagedResponse> searchDataObjectsSettings;
        private final PagedCallSettings.Builder<QueryDataObjectsRequest, QueryDataObjectsResponse, DataObjectSearchServiceClient.QueryDataObjectsPagedResponse> queryDataObjectsSettings;
        private final UnaryCallSettings.Builder<AggregateDataObjectsRequest, AggregateDataObjectsResponse> aggregateDataObjectsSettings;
        private final UnaryCallSettings.Builder<BatchSearchDataObjectsRequest, BatchSearchDataObjectsResponse> batchSearchDataObjectsSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataObjectSearchServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.searchDataObjectsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_DATA_OBJECTS_PAGE_STR_FACT);
            this.queryDataObjectsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)QUERY_DATA_OBJECTS_PAGE_STR_FACT);
            this.aggregateDataObjectsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchSearchDataObjectsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.searchDataObjectsSettings, this.queryDataObjectsSettings, this.aggregateDataObjectsSettings, this.batchSearchDataObjectsSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DataObjectSearchServiceStubSettings settings) {
            super((StubSettings)settings);
            this.searchDataObjectsSettings = settings.searchDataObjectsSettings.toBuilder();
            this.queryDataObjectsSettings = settings.queryDataObjectsSettings.toBuilder();
            this.aggregateDataObjectsSettings = settings.aggregateDataObjectsSettings.toBuilder();
            this.batchSearchDataObjectsSettings = settings.batchSearchDataObjectsSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.searchDataObjectsSettings, this.queryDataObjectsSettings, this.aggregateDataObjectsSettings, this.batchSearchDataObjectsSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataObjectSearchServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataObjectSearchServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataObjectSearchServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataObjectSearchServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DataObjectSearchServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DataObjectSearchServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataObjectSearchServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataObjectSearchServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.searchDataObjectsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.queryDataObjectsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.aggregateDataObjectsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.batchSearchDataObjectsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<SearchDataObjectsRequest, SearchDataObjectsResponse, DataObjectSearchServiceClient.SearchDataObjectsPagedResponse> searchDataObjectsSettings() {
            return this.searchDataObjectsSettings;
        }

        public PagedCallSettings.Builder<QueryDataObjectsRequest, QueryDataObjectsResponse, DataObjectSearchServiceClient.QueryDataObjectsPagedResponse> queryDataObjectsSettings() {
            return this.queryDataObjectsSettings;
        }

        public UnaryCallSettings.Builder<AggregateDataObjectsRequest, AggregateDataObjectsResponse> aggregateDataObjectsSettings() {
            return this.aggregateDataObjectsSettings;
        }

        public UnaryCallSettings.Builder<BatchSearchDataObjectsRequest, BatchSearchDataObjectsResponse> batchSearchDataObjectsSettings() {
            return this.batchSearchDataObjectsSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataObjectSearchServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public DataObjectSearchServiceStubSettings build() throws IOException {
            return new DataObjectSearchServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(300000L)).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

