/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vectorsearch.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.vectorsearch.v1beta.Collection;
import com.google.cloud.vectorsearch.v1beta.CollectionName;
import com.google.cloud.vectorsearch.v1beta.CreateCollectionRequest;
import com.google.cloud.vectorsearch.v1beta.CreateIndexRequest;
import com.google.cloud.vectorsearch.v1beta.DeleteCollectionRequest;
import com.google.cloud.vectorsearch.v1beta.DeleteIndexRequest;
import com.google.cloud.vectorsearch.v1beta.GetCollectionRequest;
import com.google.cloud.vectorsearch.v1beta.GetIndexRequest;
import com.google.cloud.vectorsearch.v1beta.ImportDataObjectsMetadata;
import com.google.cloud.vectorsearch.v1beta.ImportDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.ImportDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.Index;
import com.google.cloud.vectorsearch.v1beta.IndexName;
import com.google.cloud.vectorsearch.v1beta.ListCollectionsRequest;
import com.google.cloud.vectorsearch.v1beta.ListCollectionsResponse;
import com.google.cloud.vectorsearch.v1beta.ListIndexesRequest;
import com.google.cloud.vectorsearch.v1beta.ListIndexesResponse;
import com.google.cloud.vectorsearch.v1beta.LocationName;
import com.google.cloud.vectorsearch.v1beta.OperationMetadata;
import com.google.cloud.vectorsearch.v1beta.UpdateCollectionRequest;
import com.google.cloud.vectorsearch.v1beta.VectorSearchServiceSettings;
import com.google.cloud.vectorsearch.v1beta.stub.VectorSearchServiceStub;
import com.google.cloud.vectorsearch.v1beta.stub.VectorSearchServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class VectorSearchServiceClient
implements BackgroundResource {
    private final VectorSearchServiceSettings settings;
    private final VectorSearchServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final VectorSearchServiceClient create() throws IOException {
        return VectorSearchServiceClient.create(VectorSearchServiceSettings.newBuilder().build());
    }

    public static final VectorSearchServiceClient create(VectorSearchServiceSettings settings) throws IOException {
        return new VectorSearchServiceClient(settings);
    }

    public static final VectorSearchServiceClient create(VectorSearchServiceStub stub) {
        return new VectorSearchServiceClient(stub);
    }

    protected VectorSearchServiceClient(VectorSearchServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((VectorSearchServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected VectorSearchServiceClient(VectorSearchServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final VectorSearchServiceSettings getSettings() {
        return this.settings;
    }

    public VectorSearchServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListCollectionsPagedResponse listCollections(LocationName parent) {
        ListCollectionsRequest request = ListCollectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCollections(request);
    }

    public final ListCollectionsPagedResponse listCollections(String parent) {
        ListCollectionsRequest request = ListCollectionsRequest.newBuilder().setParent(parent).build();
        return this.listCollections(request);
    }

    public final ListCollectionsPagedResponse listCollections(ListCollectionsRequest request) {
        return (ListCollectionsPagedResponse)((Object)this.listCollectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCollectionsRequest, ListCollectionsPagedResponse> listCollectionsPagedCallable() {
        return this.stub.listCollectionsPagedCallable();
    }

    public final UnaryCallable<ListCollectionsRequest, ListCollectionsResponse> listCollectionsCallable() {
        return this.stub.listCollectionsCallable();
    }

    public final Collection getCollection(CollectionName name) {
        GetCollectionRequest request = GetCollectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCollection(request);
    }

    public final Collection getCollection(String name) {
        GetCollectionRequest request = GetCollectionRequest.newBuilder().setName(name).build();
        return this.getCollection(request);
    }

    public final Collection getCollection(GetCollectionRequest request) {
        return (Collection)this.getCollectionCallable().call((Object)request);
    }

    public final UnaryCallable<GetCollectionRequest, Collection> getCollectionCallable() {
        return this.stub.getCollectionCallable();
    }

    public final OperationFuture<Collection, OperationMetadata> createCollectionAsync(LocationName parent, Collection collection, String collectionId) {
        CreateCollectionRequest request = CreateCollectionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCollection(collection).setCollectionId(collectionId).build();
        return this.createCollectionAsync(request);
    }

    public final OperationFuture<Collection, OperationMetadata> createCollectionAsync(String parent, Collection collection, String collectionId) {
        CreateCollectionRequest request = CreateCollectionRequest.newBuilder().setParent(parent).setCollection(collection).setCollectionId(collectionId).build();
        return this.createCollectionAsync(request);
    }

    public final OperationFuture<Collection, OperationMetadata> createCollectionAsync(CreateCollectionRequest request) {
        return this.createCollectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCollectionRequest, Collection, OperationMetadata> createCollectionOperationCallable() {
        return this.stub.createCollectionOperationCallable();
    }

    public final UnaryCallable<CreateCollectionRequest, Operation> createCollectionCallable() {
        return this.stub.createCollectionCallable();
    }

    public final OperationFuture<Collection, OperationMetadata> updateCollectionAsync(Collection collection, FieldMask updateMask) {
        UpdateCollectionRequest request = UpdateCollectionRequest.newBuilder().setCollection(collection).setUpdateMask(updateMask).build();
        return this.updateCollectionAsync(request);
    }

    public final OperationFuture<Collection, OperationMetadata> updateCollectionAsync(UpdateCollectionRequest request) {
        return this.updateCollectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateCollectionRequest, Collection, OperationMetadata> updateCollectionOperationCallable() {
        return this.stub.updateCollectionOperationCallable();
    }

    public final UnaryCallable<UpdateCollectionRequest, Operation> updateCollectionCallable() {
        return this.stub.updateCollectionCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCollectionAsync(CollectionName name) {
        DeleteCollectionRequest request = DeleteCollectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCollectionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCollectionAsync(String name) {
        DeleteCollectionRequest request = DeleteCollectionRequest.newBuilder().setName(name).build();
        return this.deleteCollectionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCollectionAsync(DeleteCollectionRequest request) {
        return this.deleteCollectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCollectionRequest, Empty, OperationMetadata> deleteCollectionOperationCallable() {
        return this.stub.deleteCollectionOperationCallable();
    }

    public final UnaryCallable<DeleteCollectionRequest, Operation> deleteCollectionCallable() {
        return this.stub.deleteCollectionCallable();
    }

    public final ListIndexesPagedResponse listIndexes(CollectionName parent) {
        ListIndexesRequest request = ListIndexesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listIndexes(request);
    }

    public final ListIndexesPagedResponse listIndexes(String parent) {
        ListIndexesRequest request = ListIndexesRequest.newBuilder().setParent(parent).build();
        return this.listIndexes(request);
    }

    public final ListIndexesPagedResponse listIndexes(ListIndexesRequest request) {
        return (ListIndexesPagedResponse)((Object)this.listIndexesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListIndexesRequest, ListIndexesPagedResponse> listIndexesPagedCallable() {
        return this.stub.listIndexesPagedCallable();
    }

    public final UnaryCallable<ListIndexesRequest, ListIndexesResponse> listIndexesCallable() {
        return this.stub.listIndexesCallable();
    }

    public final Index getIndex(IndexName name) {
        GetIndexRequest request = GetIndexRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getIndex(request);
    }

    public final Index getIndex(String name) {
        GetIndexRequest request = GetIndexRequest.newBuilder().setName(name).build();
        return this.getIndex(request);
    }

    public final Index getIndex(GetIndexRequest request) {
        return (Index)this.getIndexCallable().call((Object)request);
    }

    public final UnaryCallable<GetIndexRequest, Index> getIndexCallable() {
        return this.stub.getIndexCallable();
    }

    public final OperationFuture<Index, OperationMetadata> createIndexAsync(CollectionName parent, Index index, String indexId) {
        CreateIndexRequest request = CreateIndexRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setIndex(index).setIndexId(indexId).build();
        return this.createIndexAsync(request);
    }

    public final OperationFuture<Index, OperationMetadata> createIndexAsync(String parent, Index index, String indexId) {
        CreateIndexRequest request = CreateIndexRequest.newBuilder().setParent(parent).setIndex(index).setIndexId(indexId).build();
        return this.createIndexAsync(request);
    }

    public final OperationFuture<Index, OperationMetadata> createIndexAsync(CreateIndexRequest request) {
        return this.createIndexOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateIndexRequest, Index, OperationMetadata> createIndexOperationCallable() {
        return this.stub.createIndexOperationCallable();
    }

    public final UnaryCallable<CreateIndexRequest, Operation> createIndexCallable() {
        return this.stub.createIndexCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteIndexAsync(IndexName name) {
        DeleteIndexRequest request = DeleteIndexRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteIndexAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteIndexAsync(String name) {
        DeleteIndexRequest request = DeleteIndexRequest.newBuilder().setName(name).build();
        return this.deleteIndexAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteIndexAsync(DeleteIndexRequest request) {
        return this.deleteIndexOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteIndexRequest, Empty, OperationMetadata> deleteIndexOperationCallable() {
        return this.stub.deleteIndexOperationCallable();
    }

    public final UnaryCallable<DeleteIndexRequest, Operation> deleteIndexCallable() {
        return this.stub.deleteIndexCallable();
    }

    public final OperationFuture<ImportDataObjectsResponse, ImportDataObjectsMetadata> importDataObjectsAsync(ImportDataObjectsRequest request) {
        return this.importDataObjectsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportDataObjectsRequest, ImportDataObjectsResponse, ImportDataObjectsMetadata> importDataObjectsOperationCallable() {
        return this.stub.importDataObjectsOperationCallable();
    }

    public final UnaryCallable<ImportDataObjectsRequest, Operation> importDataObjectsCallable() {
        return this.stub.importDataObjectsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListIndexesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListIndexesRequest, ListIndexesResponse, Index, ListIndexesPage, ListIndexesFixedSizeCollection> {
        private ListIndexesFixedSizeCollection(List<ListIndexesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListIndexesFixedSizeCollection createEmptyCollection() {
            return new ListIndexesFixedSizeCollection(null, 0);
        }

        protected ListIndexesFixedSizeCollection createCollection(List<ListIndexesPage> pages, int collectionSize) {
            return new ListIndexesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListIndexesPage
    extends AbstractPage<ListIndexesRequest, ListIndexesResponse, Index, ListIndexesPage> {
        private ListIndexesPage(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ListIndexesResponse response) {
            super(context, (Object)response);
        }

        private static ListIndexesPage createEmptyPage() {
            return new ListIndexesPage(null, null);
        }

        protected ListIndexesPage createPage(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ListIndexesResponse response) {
            return new ListIndexesPage(context, response);
        }

        public ApiFuture<ListIndexesPage> createPageAsync(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ApiFuture<ListIndexesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListIndexesPagedResponse
    extends AbstractPagedListResponse<ListIndexesRequest, ListIndexesResponse, Index, ListIndexesPage, ListIndexesFixedSizeCollection> {
        public static ApiFuture<ListIndexesPagedResponse> createAsync(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ApiFuture<ListIndexesResponse> futureResponse) {
            ApiFuture<ListIndexesPage> futurePage = ListIndexesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListIndexesPagedResponse((ListIndexesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListIndexesPagedResponse(ListIndexesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListIndexesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCollectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCollectionsRequest, ListCollectionsResponse, Collection, ListCollectionsPage, ListCollectionsFixedSizeCollection> {
        private ListCollectionsFixedSizeCollection(List<ListCollectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCollectionsFixedSizeCollection createEmptyCollection() {
            return new ListCollectionsFixedSizeCollection(null, 0);
        }

        protected ListCollectionsFixedSizeCollection createCollection(List<ListCollectionsPage> pages, int collectionSize) {
            return new ListCollectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCollectionsPage
    extends AbstractPage<ListCollectionsRequest, ListCollectionsResponse, Collection, ListCollectionsPage> {
        private ListCollectionsPage(PageContext<ListCollectionsRequest, ListCollectionsResponse, Collection> context, ListCollectionsResponse response) {
            super(context, (Object)response);
        }

        private static ListCollectionsPage createEmptyPage() {
            return new ListCollectionsPage(null, null);
        }

        protected ListCollectionsPage createPage(PageContext<ListCollectionsRequest, ListCollectionsResponse, Collection> context, ListCollectionsResponse response) {
            return new ListCollectionsPage(context, response);
        }

        public ApiFuture<ListCollectionsPage> createPageAsync(PageContext<ListCollectionsRequest, ListCollectionsResponse, Collection> context, ApiFuture<ListCollectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCollectionsPagedResponse
    extends AbstractPagedListResponse<ListCollectionsRequest, ListCollectionsResponse, Collection, ListCollectionsPage, ListCollectionsFixedSizeCollection> {
        public static ApiFuture<ListCollectionsPagedResponse> createAsync(PageContext<ListCollectionsRequest, ListCollectionsResponse, Collection> context, ApiFuture<ListCollectionsResponse> futureResponse) {
            ApiFuture<ListCollectionsPage> futurePage = ListCollectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCollectionsPagedResponse((ListCollectionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCollectionsPagedResponse(ListCollectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCollectionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

