/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vectorsearch.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.vectorsearch.v1beta.BatchCreateDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.BatchCreateDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.BatchDeleteDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.BatchUpdateDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.BatchUpdateDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.CollectionName;
import com.google.cloud.vectorsearch.v1beta.CreateDataObjectRequest;
import com.google.cloud.vectorsearch.v1beta.DataObject;
import com.google.cloud.vectorsearch.v1beta.DataObjectName;
import com.google.cloud.vectorsearch.v1beta.DataObjectServiceSettings;
import com.google.cloud.vectorsearch.v1beta.DeleteDataObjectRequest;
import com.google.cloud.vectorsearch.v1beta.GetDataObjectRequest;
import com.google.cloud.vectorsearch.v1beta.UpdateDataObjectRequest;
import com.google.cloud.vectorsearch.v1beta.stub.DataObjectServiceStub;
import com.google.cloud.vectorsearch.v1beta.stub.DataObjectServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DataObjectServiceClient
implements BackgroundResource {
    private final DataObjectServiceSettings settings;
    private final DataObjectServiceStub stub;

    public static final DataObjectServiceClient create() throws IOException {
        return DataObjectServiceClient.create(DataObjectServiceSettings.newBuilder().build());
    }

    public static final DataObjectServiceClient create(DataObjectServiceSettings settings) throws IOException {
        return new DataObjectServiceClient(settings);
    }

    public static final DataObjectServiceClient create(DataObjectServiceStub stub) {
        return new DataObjectServiceClient(stub);
    }

    protected DataObjectServiceClient(DataObjectServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataObjectServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected DataObjectServiceClient(DataObjectServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DataObjectServiceSettings getSettings() {
        return this.settings;
    }

    public DataObjectServiceStub getStub() {
        return this.stub;
    }

    public final DataObject createDataObject(CollectionName parent, DataObject dataObject, String dataObjectId) {
        CreateDataObjectRequest request = CreateDataObjectRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataObject(dataObject).setDataObjectId(dataObjectId).build();
        return this.createDataObject(request);
    }

    public final DataObject createDataObject(String parent, DataObject dataObject, String dataObjectId) {
        CreateDataObjectRequest request = CreateDataObjectRequest.newBuilder().setParent(parent).setDataObject(dataObject).setDataObjectId(dataObjectId).build();
        return this.createDataObject(request);
    }

    public final DataObject createDataObject(CreateDataObjectRequest request) {
        return (DataObject)this.createDataObjectCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDataObjectRequest, DataObject> createDataObjectCallable() {
        return this.stub.createDataObjectCallable();
    }

    public final BatchCreateDataObjectsResponse batchCreateDataObjects(BatchCreateDataObjectsRequest request) {
        return (BatchCreateDataObjectsResponse)this.batchCreateDataObjectsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchCreateDataObjectsRequest, BatchCreateDataObjectsResponse> batchCreateDataObjectsCallable() {
        return this.stub.batchCreateDataObjectsCallable();
    }

    public final DataObject getDataObject(DataObjectName name) {
        GetDataObjectRequest request = GetDataObjectRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataObject(request);
    }

    public final DataObject getDataObject(String name) {
        GetDataObjectRequest request = GetDataObjectRequest.newBuilder().setName(name).build();
        return this.getDataObject(request);
    }

    public final DataObject getDataObject(GetDataObjectRequest request) {
        return (DataObject)this.getDataObjectCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataObjectRequest, DataObject> getDataObjectCallable() {
        return this.stub.getDataObjectCallable();
    }

    public final DataObject updateDataObject(DataObject dataObject, FieldMask updateMask) {
        UpdateDataObjectRequest request = UpdateDataObjectRequest.newBuilder().setDataObject(dataObject).setUpdateMask(updateMask).build();
        return this.updateDataObject(request);
    }

    public final DataObject updateDataObject(UpdateDataObjectRequest request) {
        return (DataObject)this.updateDataObjectCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDataObjectRequest, DataObject> updateDataObjectCallable() {
        return this.stub.updateDataObjectCallable();
    }

    public final BatchUpdateDataObjectsResponse batchUpdateDataObjects(CollectionName parent, List<UpdateDataObjectRequest> requests) {
        BatchUpdateDataObjectsRequest request = BatchUpdateDataObjectsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchUpdateDataObjects(request);
    }

    public final BatchUpdateDataObjectsResponse batchUpdateDataObjects(String parent, List<UpdateDataObjectRequest> requests) {
        BatchUpdateDataObjectsRequest request = BatchUpdateDataObjectsRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchUpdateDataObjects(request);
    }

    public final BatchUpdateDataObjectsResponse batchUpdateDataObjects(BatchUpdateDataObjectsRequest request) {
        return (BatchUpdateDataObjectsResponse)this.batchUpdateDataObjectsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchUpdateDataObjectsRequest, BatchUpdateDataObjectsResponse> batchUpdateDataObjectsCallable() {
        return this.stub.batchUpdateDataObjectsCallable();
    }

    public final void deleteDataObject(DataObjectName name) {
        DeleteDataObjectRequest request = DeleteDataObjectRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDataObject(request);
    }

    public final void deleteDataObject(String name) {
        DeleteDataObjectRequest request = DeleteDataObjectRequest.newBuilder().setName(name).build();
        this.deleteDataObject(request);
    }

    public final void deleteDataObject(DeleteDataObjectRequest request) {
        this.deleteDataObjectCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDataObjectRequest, Empty> deleteDataObjectCallable() {
        return this.stub.deleteDataObjectCallable();
    }

    public final void batchDeleteDataObjects(CollectionName parent, List<DeleteDataObjectRequest> requests) {
        BatchDeleteDataObjectsRequest request = BatchDeleteDataObjectsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        this.batchDeleteDataObjects(request);
    }

    public final void batchDeleteDataObjects(String parent, List<DeleteDataObjectRequest> requests) {
        BatchDeleteDataObjectsRequest request = BatchDeleteDataObjectsRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        this.batchDeleteDataObjects(request);
    }

    public final void batchDeleteDataObjects(BatchDeleteDataObjectsRequest request) {
        this.batchDeleteDataObjectsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchDeleteDataObjectsRequest, Empty> batchDeleteDataObjectsCallable() {
        return this.stub.batchDeleteDataObjectsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

