/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.v3beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.translate.v3beta1.BatchTranslateDocumentMetadata;
import com.google.cloud.translate.v3beta1.BatchTranslateDocumentRequest;
import com.google.cloud.translate.v3beta1.BatchTranslateDocumentResponse;
import com.google.cloud.translate.v3beta1.BatchTranslateMetadata;
import com.google.cloud.translate.v3beta1.BatchTranslateResponse;
import com.google.cloud.translate.v3beta1.BatchTranslateTextRequest;
import com.google.cloud.translate.v3beta1.CreateGlossaryMetadata;
import com.google.cloud.translate.v3beta1.CreateGlossaryRequest;
import com.google.cloud.translate.v3beta1.DeleteGlossaryMetadata;
import com.google.cloud.translate.v3beta1.DeleteGlossaryRequest;
import com.google.cloud.translate.v3beta1.DeleteGlossaryResponse;
import com.google.cloud.translate.v3beta1.DetectLanguageRequest;
import com.google.cloud.translate.v3beta1.DetectLanguageResponse;
import com.google.cloud.translate.v3beta1.GetGlossaryRequest;
import com.google.cloud.translate.v3beta1.GetSupportedLanguagesRequest;
import com.google.cloud.translate.v3beta1.Glossary;
import com.google.cloud.translate.v3beta1.ListGlossariesRequest;
import com.google.cloud.translate.v3beta1.ListGlossariesResponse;
import com.google.cloud.translate.v3beta1.SupportedLanguages;
import com.google.cloud.translate.v3beta1.TranslateDocumentRequest;
import com.google.cloud.translate.v3beta1.TranslateDocumentResponse;
import com.google.cloud.translate.v3beta1.TranslateTextRequest;
import com.google.cloud.translate.v3beta1.TranslateTextResponse;
import com.google.cloud.translate.v3beta1.TranslationServiceClient;
import com.google.cloud.translate.v3beta1.stub.GrpcTranslationServiceStub;
import com.google.cloud.translate.v3beta1.stub.HttpJsonTranslationServiceStub;
import com.google.cloud.translate.v3beta1.stub.TranslationServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class TranslationServiceStubSettings
extends StubSettings<TranslationServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-translation").build();
    private final UnaryCallSettings<TranslateTextRequest, TranslateTextResponse> translateTextSettings;
    private final UnaryCallSettings<DetectLanguageRequest, DetectLanguageResponse> detectLanguageSettings;
    private final UnaryCallSettings<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesSettings;
    private final UnaryCallSettings<TranslateDocumentRequest, TranslateDocumentResponse> translateDocumentSettings;
    private final UnaryCallSettings<BatchTranslateTextRequest, Operation> batchTranslateTextSettings;
    private final OperationCallSettings<BatchTranslateTextRequest, BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextOperationSettings;
    private final UnaryCallSettings<BatchTranslateDocumentRequest, Operation> batchTranslateDocumentSettings;
    private final OperationCallSettings<BatchTranslateDocumentRequest, BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentOperationSettings;
    private final UnaryCallSettings<CreateGlossaryRequest, Operation> createGlossarySettings;
    private final OperationCallSettings<CreateGlossaryRequest, Glossary, CreateGlossaryMetadata> createGlossaryOperationSettings;
    private final PagedCallSettings<ListGlossariesRequest, ListGlossariesResponse, TranslationServiceClient.ListGlossariesPagedResponse> listGlossariesSettings;
    private final UnaryCallSettings<GetGlossaryRequest, Glossary> getGlossarySettings;
    private final UnaryCallSettings<DeleteGlossaryRequest, Operation> deleteGlossarySettings;
    private final OperationCallSettings<DeleteGlossaryRequest, DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryOperationSettings;
    private static final PagedListDescriptor<ListGlossariesRequest, ListGlossariesResponse, Glossary> LIST_GLOSSARIES_PAGE_STR_DESC = new PagedListDescriptor<ListGlossariesRequest, ListGlossariesResponse, Glossary>(){

        public String emptyToken() {
            return "";
        }

        public ListGlossariesRequest injectToken(ListGlossariesRequest payload, String token) {
            return ListGlossariesRequest.newBuilder((ListGlossariesRequest)payload).setPageToken(token).build();
        }

        public ListGlossariesRequest injectPageSize(ListGlossariesRequest payload, int pageSize) {
            return ListGlossariesRequest.newBuilder((ListGlossariesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGlossariesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGlossariesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Glossary> extractResources(ListGlossariesResponse payload) {
            return payload.getGlossariesList() == null ? ImmutableList.of() : payload.getGlossariesList();
        }
    };
    private static final PagedListResponseFactory<ListGlossariesRequest, ListGlossariesResponse, TranslationServiceClient.ListGlossariesPagedResponse> LIST_GLOSSARIES_PAGE_STR_FACT = new PagedListResponseFactory<ListGlossariesRequest, ListGlossariesResponse, TranslationServiceClient.ListGlossariesPagedResponse>(){

        public ApiFuture<TranslationServiceClient.ListGlossariesPagedResponse> getFuturePagedResponse(UnaryCallable<ListGlossariesRequest, ListGlossariesResponse> callable, ListGlossariesRequest request, ApiCallContext context, ApiFuture<ListGlossariesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GLOSSARIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TranslationServiceClient.ListGlossariesPagedResponse.createAsync((PageContext<ListGlossariesRequest, ListGlossariesResponse, Glossary>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<TranslateTextRequest, TranslateTextResponse> translateTextSettings() {
        return this.translateTextSettings;
    }

    public UnaryCallSettings<DetectLanguageRequest, DetectLanguageResponse> detectLanguageSettings() {
        return this.detectLanguageSettings;
    }

    public UnaryCallSettings<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesSettings() {
        return this.getSupportedLanguagesSettings;
    }

    public UnaryCallSettings<TranslateDocumentRequest, TranslateDocumentResponse> translateDocumentSettings() {
        return this.translateDocumentSettings;
    }

    public UnaryCallSettings<BatchTranslateTextRequest, Operation> batchTranslateTextSettings() {
        return this.batchTranslateTextSettings;
    }

    public OperationCallSettings<BatchTranslateTextRequest, BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextOperationSettings() {
        return this.batchTranslateTextOperationSettings;
    }

    public UnaryCallSettings<BatchTranslateDocumentRequest, Operation> batchTranslateDocumentSettings() {
        return this.batchTranslateDocumentSettings;
    }

    public OperationCallSettings<BatchTranslateDocumentRequest, BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentOperationSettings() {
        return this.batchTranslateDocumentOperationSettings;
    }

    public UnaryCallSettings<CreateGlossaryRequest, Operation> createGlossarySettings() {
        return this.createGlossarySettings;
    }

    public OperationCallSettings<CreateGlossaryRequest, Glossary, CreateGlossaryMetadata> createGlossaryOperationSettings() {
        return this.createGlossaryOperationSettings;
    }

    public PagedCallSettings<ListGlossariesRequest, ListGlossariesResponse, TranslationServiceClient.ListGlossariesPagedResponse> listGlossariesSettings() {
        return this.listGlossariesSettings;
    }

    public UnaryCallSettings<GetGlossaryRequest, Glossary> getGlossarySettings() {
        return this.getGlossarySettings;
    }

    public UnaryCallSettings<DeleteGlossaryRequest, Operation> deleteGlossarySettings() {
        return this.deleteGlossarySettings;
    }

    public OperationCallSettings<DeleteGlossaryRequest, DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryOperationSettings() {
        return this.deleteGlossaryOperationSettings;
    }

    public TranslationServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTranslationServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTranslationServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "translate";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "translate.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "translate.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TranslationServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TranslationServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TranslationServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return TranslationServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TranslationServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.translateTextSettings = settingsBuilder.translateTextSettings().build();
        this.detectLanguageSettings = settingsBuilder.detectLanguageSettings().build();
        this.getSupportedLanguagesSettings = settingsBuilder.getSupportedLanguagesSettings().build();
        this.translateDocumentSettings = settingsBuilder.translateDocumentSettings().build();
        this.batchTranslateTextSettings = settingsBuilder.batchTranslateTextSettings().build();
        this.batchTranslateTextOperationSettings = settingsBuilder.batchTranslateTextOperationSettings().build();
        this.batchTranslateDocumentSettings = settingsBuilder.batchTranslateDocumentSettings().build();
        this.batchTranslateDocumentOperationSettings = settingsBuilder.batchTranslateDocumentOperationSettings().build();
        this.createGlossarySettings = settingsBuilder.createGlossarySettings().build();
        this.createGlossaryOperationSettings = settingsBuilder.createGlossaryOperationSettings().build();
        this.listGlossariesSettings = settingsBuilder.listGlossariesSettings().build();
        this.getGlossarySettings = settingsBuilder.getGlossarySettings().build();
        this.deleteGlossarySettings = settingsBuilder.deleteGlossarySettings().build();
        this.deleteGlossaryOperationSettings = settingsBuilder.deleteGlossaryOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TranslationServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<TranslateTextRequest, TranslateTextResponse> translateTextSettings;
        private final UnaryCallSettings.Builder<DetectLanguageRequest, DetectLanguageResponse> detectLanguageSettings;
        private final UnaryCallSettings.Builder<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesSettings;
        private final UnaryCallSettings.Builder<TranslateDocumentRequest, TranslateDocumentResponse> translateDocumentSettings;
        private final UnaryCallSettings.Builder<BatchTranslateTextRequest, Operation> batchTranslateTextSettings;
        private final OperationCallSettings.Builder<BatchTranslateTextRequest, BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextOperationSettings;
        private final UnaryCallSettings.Builder<BatchTranslateDocumentRequest, Operation> batchTranslateDocumentSettings;
        private final OperationCallSettings.Builder<BatchTranslateDocumentRequest, BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentOperationSettings;
        private final UnaryCallSettings.Builder<CreateGlossaryRequest, Operation> createGlossarySettings;
        private final OperationCallSettings.Builder<CreateGlossaryRequest, Glossary, CreateGlossaryMetadata> createGlossaryOperationSettings;
        private final PagedCallSettings.Builder<ListGlossariesRequest, ListGlossariesResponse, TranslationServiceClient.ListGlossariesPagedResponse> listGlossariesSettings;
        private final UnaryCallSettings.Builder<GetGlossaryRequest, Glossary> getGlossarySettings;
        private final UnaryCallSettings.Builder<DeleteGlossaryRequest, Operation> deleteGlossarySettings;
        private final OperationCallSettings.Builder<DeleteGlossaryRequest, DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.translateTextSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.detectLanguageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSupportedLanguagesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.translateDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchTranslateTextSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchTranslateTextOperationSettings = OperationCallSettings.newBuilder();
            this.batchTranslateDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchTranslateDocumentOperationSettings = OperationCallSettings.newBuilder();
            this.createGlossarySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGlossaryOperationSettings = OperationCallSettings.newBuilder();
            this.listGlossariesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GLOSSARIES_PAGE_STR_FACT);
            this.getGlossarySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGlossarySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGlossaryOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.translateTextSettings, this.detectLanguageSettings, this.getSupportedLanguagesSettings, this.translateDocumentSettings, this.batchTranslateTextSettings, this.batchTranslateDocumentSettings, this.createGlossarySettings, this.listGlossariesSettings, this.getGlossarySettings, this.deleteGlossarySettings);
            Builder.initDefaults(this);
        }

        protected Builder(TranslationServiceStubSettings settings) {
            super((StubSettings)settings);
            this.translateTextSettings = settings.translateTextSettings.toBuilder();
            this.detectLanguageSettings = settings.detectLanguageSettings.toBuilder();
            this.getSupportedLanguagesSettings = settings.getSupportedLanguagesSettings.toBuilder();
            this.translateDocumentSettings = settings.translateDocumentSettings.toBuilder();
            this.batchTranslateTextSettings = settings.batchTranslateTextSettings.toBuilder();
            this.batchTranslateTextOperationSettings = settings.batchTranslateTextOperationSettings.toBuilder();
            this.batchTranslateDocumentSettings = settings.batchTranslateDocumentSettings.toBuilder();
            this.batchTranslateDocumentOperationSettings = settings.batchTranslateDocumentOperationSettings.toBuilder();
            this.createGlossarySettings = settings.createGlossarySettings.toBuilder();
            this.createGlossaryOperationSettings = settings.createGlossaryOperationSettings.toBuilder();
            this.listGlossariesSettings = settings.listGlossariesSettings.toBuilder();
            this.getGlossarySettings = settings.getGlossarySettings.toBuilder();
            this.deleteGlossarySettings = settings.deleteGlossarySettings.toBuilder();
            this.deleteGlossaryOperationSettings = settings.deleteGlossaryOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.translateTextSettings, this.detectLanguageSettings, this.getSupportedLanguagesSettings, this.translateDocumentSettings, this.batchTranslateTextSettings, this.batchTranslateDocumentSettings, this.createGlossarySettings, this.listGlossariesSettings, this.getGlossarySettings, this.deleteGlossarySettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TranslationServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TranslationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TranslationServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TranslationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)TranslationServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)TranslationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TranslationServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TranslationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.translateTextSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.detectLanguageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getSupportedLanguagesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.translateDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.batchTranslateTextSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.batchTranslateDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createGlossarySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listGlossariesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getGlossarySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteGlossarySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.batchTranslateTextOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchTranslateResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchTranslateMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.batchTranslateDocumentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchTranslateDocumentResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchTranslateDocumentMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createGlossaryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Glossary.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateGlossaryMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteGlossaryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DeleteGlossaryResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteGlossaryMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<TranslateTextRequest, TranslateTextResponse> translateTextSettings() {
            return this.translateTextSettings;
        }

        public UnaryCallSettings.Builder<DetectLanguageRequest, DetectLanguageResponse> detectLanguageSettings() {
            return this.detectLanguageSettings;
        }

        public UnaryCallSettings.Builder<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesSettings() {
            return this.getSupportedLanguagesSettings;
        }

        public UnaryCallSettings.Builder<TranslateDocumentRequest, TranslateDocumentResponse> translateDocumentSettings() {
            return this.translateDocumentSettings;
        }

        public UnaryCallSettings.Builder<BatchTranslateTextRequest, Operation> batchTranslateTextSettings() {
            return this.batchTranslateTextSettings;
        }

        public OperationCallSettings.Builder<BatchTranslateTextRequest, BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextOperationSettings() {
            return this.batchTranslateTextOperationSettings;
        }

        public UnaryCallSettings.Builder<BatchTranslateDocumentRequest, Operation> batchTranslateDocumentSettings() {
            return this.batchTranslateDocumentSettings;
        }

        public OperationCallSettings.Builder<BatchTranslateDocumentRequest, BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentOperationSettings() {
            return this.batchTranslateDocumentOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateGlossaryRequest, Operation> createGlossarySettings() {
            return this.createGlossarySettings;
        }

        public OperationCallSettings.Builder<CreateGlossaryRequest, Glossary, CreateGlossaryMetadata> createGlossaryOperationSettings() {
            return this.createGlossaryOperationSettings;
        }

        public PagedCallSettings.Builder<ListGlossariesRequest, ListGlossariesResponse, TranslationServiceClient.ListGlossariesPagedResponse> listGlossariesSettings() {
            return this.listGlossariesSettings;
        }

        public UnaryCallSettings.Builder<GetGlossaryRequest, Glossary> getGlossarySettings() {
            return this.getGlossarySettings;
        }

        public UnaryCallSettings.Builder<DeleteGlossaryRequest, Operation> deleteGlossarySettings() {
            return this.deleteGlossarySettings;
        }

        public OperationCallSettings.Builder<DeleteGlossaryRequest, DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryOperationSettings() {
            return this.deleteGlossaryOperationSettings;
        }

        public TranslationServiceStubSettings build() throws IOException {
            return new TranslationServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

