/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate;

import com.google.auth.Credentials;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.cloud.ServiceRpc;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.translate.Translate;
import com.google.cloud.translate.TranslateFactory;
import com.google.cloud.translate.TranslateImpl;
import com.google.cloud.translate.spi.TranslateRpcFactory;
import com.google.cloud.translate.spi.v2.HttpTranslateRpc;
import com.google.cloud.translate.spi.v2.TranslateRpc;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TranslateOptions
extends ServiceOptions<Translate, TranslateOptions> {
    private static final long serialVersionUID = -572597134540398216L;
    private static final Logger logger = Logger.getLogger(TranslateOptions.class.getName());
    public static final String API_KEY_ENV_NAME = "GOOGLE_API_KEY";
    private static final String API_SHORT_NAME = "Translate";
    private static final String DEFAULT_HOST = "https://translation.googleapis.com";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/cloud-platform");
    private final String apiKey;
    private final String targetLanguage;

    private TranslateOptions(Builder builder) {
        super(TranslateFactory.class, TranslateRpcFactory.class, (ServiceOptions.Builder)builder, (ServiceDefaults)new TranslateDefaults());
        if (builder.getCredentials() != null) {
            this.apiKey = null;
            if (builder.apiKey != null) {
                logger.log(Level.WARNING, "Ignoring API key: using explicit setting for credentials instead.");
            } else if (TranslateOptions.getDefaultApiKey() != null) {
                logger.log(Level.WARNING, "Ignoring API key set in environment variable {0}: using explicit setting for credentials instead.", API_KEY_ENV_NAME);
            }
        } else if (builder.apiKey != null) {
            this.credentials = null;
            this.apiKey = builder.apiKey;
            logger.log(Level.WARNING, "Ignoring Application Default Credentials {0}: using explicit setting for API key instead.", "GOOGLE_APPLICATION_CREDENTIALS");
        } else if (this.credentials != null) {
            this.apiKey = null;
            if (TranslateOptions.getDefaultApiKey() != null) {
                logger.log(Level.WARNING, "Ignoring API key set in environment variable {0}: using Application Default Credentials instead.", API_KEY_ENV_NAME);
            }
        } else {
            this.apiKey = TranslateOptions.getDefaultApiKey();
        }
        this.targetLanguage = (String)MoreObjects.firstNonNull((Object)builder.targetLanguage, (Object)Locale.ENGLISH.getLanguage());
    }

    public static HttpTransportOptions getDefaultHttpTransportOptions() {
        return HttpTransportOptions.newBuilder().build();
    }

    public static String getDefaultApiKey() {
        return System.getProperty(API_KEY_ENV_NAME, System.getenv(API_KEY_ENV_NAME));
    }

    protected boolean projectIdRequired() {
        return false;
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    protected TranslateRpc getTranslateRpcV2() {
        return (TranslateRpc)this.getRpc();
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getTargetLanguage() {
        return this.targetLanguage;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TranslateOptions)) {
            return false;
        }
        TranslateOptions options = (TranslateOptions)((Object)obj);
        return this.baseEquals(options) && Objects.equals(this.apiKey, options.apiKey) && Objects.equals(this.targetLanguage, options.targetLanguage);
    }

    public static TranslateOptions getDefaultInstance() {
        return TranslateOptions.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static class TranslateDefaults
    implements ServiceDefaults<Translate, TranslateOptions> {
        private TranslateDefaults() {
        }

        public TranslateFactory getDefaultServiceFactory() {
            return DefaultTranslateFactory.INSTANCE;
        }

        public TranslateRpcFactory getDefaultRpcFactory() {
            return DefaultTranslateRpcFactory.INSTANCE;
        }

        public TransportOptions getDefaultTransportOptions() {
            return TranslateOptions.getDefaultHttpTransportOptions();
        }
    }

    public static class Builder
    extends ServiceOptions.Builder<Translate, TranslateOptions, Builder> {
        private String apiKey;
        private String targetLanguage;

        private Builder() {
        }

        private Builder(TranslateOptions options) {
            super((ServiceOptions)options);
            this.apiKey = options.apiKey;
        }

        public Credentials getCredentials() {
            return this.credentials;
        }

        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof HttpTransportOptions)) {
                throw new IllegalArgumentException("Only http transport is allowed for Translate.");
            }
            return (Builder)super.setTransportOptions(transportOptions);
        }

        public Builder setProjectId(String projectId) {
            super.setProjectId(projectId);
            return (Builder)this.self();
        }

        @Deprecated
        public Builder setApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder setTargetLanguage(String targetLanguage) {
            this.targetLanguage = targetLanguage;
            return (Builder)this.self();
        }

        public TranslateOptions build() {
            return new TranslateOptions(this);
        }
    }

    public static class DefaultTranslateRpcFactory
    implements TranslateRpcFactory {
        private static final TranslateRpcFactory INSTANCE = new DefaultTranslateRpcFactory();

        public ServiceRpc create(TranslateOptions options) {
            return new HttpTranslateRpc(options);
        }
    }

    public static class DefaultTranslateFactory
    implements TranslateFactory {
        private static final TranslateFactory INSTANCE = new DefaultTranslateFactory();

        public Translate create(TranslateOptions options) {
            return new TranslateImpl(options);
        }
    }
}

