/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.v3.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.translate.v3.BatchTranslateDocumentMetadata;
import com.google.cloud.translate.v3.BatchTranslateDocumentRequest;
import com.google.cloud.translate.v3.BatchTranslateDocumentResponse;
import com.google.cloud.translate.v3.BatchTranslateMetadata;
import com.google.cloud.translate.v3.BatchTranslateResponse;
import com.google.cloud.translate.v3.BatchTranslateTextRequest;
import com.google.cloud.translate.v3.CreateGlossaryMetadata;
import com.google.cloud.translate.v3.CreateGlossaryRequest;
import com.google.cloud.translate.v3.DeleteGlossaryMetadata;
import com.google.cloud.translate.v3.DeleteGlossaryRequest;
import com.google.cloud.translate.v3.DeleteGlossaryResponse;
import com.google.cloud.translate.v3.DetectLanguageRequest;
import com.google.cloud.translate.v3.DetectLanguageResponse;
import com.google.cloud.translate.v3.GetGlossaryRequest;
import com.google.cloud.translate.v3.GetSupportedLanguagesRequest;
import com.google.cloud.translate.v3.Glossary;
import com.google.cloud.translate.v3.ListGlossariesRequest;
import com.google.cloud.translate.v3.ListGlossariesResponse;
import com.google.cloud.translate.v3.SupportedLanguages;
import com.google.cloud.translate.v3.TranslateDocumentRequest;
import com.google.cloud.translate.v3.TranslateDocumentResponse;
import com.google.cloud.translate.v3.TranslateTextRequest;
import com.google.cloud.translate.v3.TranslateTextResponse;
import com.google.cloud.translate.v3.TranslationServiceClient;
import com.google.cloud.translate.v3.stub.HttpJsonTranslationServiceCallableFactory;
import com.google.cloud.translate.v3.stub.TranslationServiceStub;
import com.google.cloud.translate.v3.stub.TranslationServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonTranslationServiceStub
extends TranslationServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(DeleteGlossaryMetadata.getDescriptor()).add(BatchTranslateResponse.getDescriptor()).add(BatchTranslateMetadata.getDescriptor()).add(Glossary.getDescriptor()).add(CreateGlossaryMetadata.getDescriptor()).add(BatchTranslateDocumentResponse.getDescriptor()).add(DeleteGlossaryResponse.getDescriptor()).add(BatchTranslateDocumentMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<TranslateTextRequest, TranslateTextResponse> translateTextMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.translation.v3.TranslationService/TranslateText").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{parent=projects/*/locations/*}:translateText", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v3/{parent=projects/*}:translateText"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TranslateTextResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DetectLanguageRequest, DetectLanguageResponse> detectLanguageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.translation.v3.TranslationService/DetectLanguage").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{parent=projects/*/locations/*}:detectLanguage", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v3/{parent=projects/*}:detectLanguage"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DetectLanguageResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.translation.v3.TranslationService/GetSupportedLanguages").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{parent=projects/*/locations/*}/supportedLanguages", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v3/{parent=projects/*}/supportedLanguages"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "displayLanguageCode", (Object)request.getDisplayLanguageCode());
        serializer.putQueryParam(fields, "model", (Object)request.getModel());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SupportedLanguages.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TranslateDocumentRequest, TranslateDocumentResponse> translateDocumentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.translation.v3.TranslationService/TranslateDocument").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{parent=projects/*/locations/*}:translateDocument", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TranslateDocumentResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<BatchTranslateTextRequest, Operation> batchTranslateTextMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.translation.v3.TranslationService/BatchTranslateText").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{parent=projects/*/locations/*}:batchTranslateText", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<BatchTranslateDocumentRequest, Operation> batchTranslateDocumentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.translation.v3.TranslationService/BatchTranslateDocument").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{parent=projects/*/locations/*}:batchTranslateDocument", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<CreateGlossaryRequest, Operation> createGlossaryMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.translation.v3.TranslationService/CreateGlossary").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{parent=projects/*/locations/*}/glossaries", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("glossary", (Message)request.getGlossary())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListGlossariesRequest, ListGlossariesResponse> listGlossariesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.translation.v3.TranslationService/ListGlossaries").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{parent=projects/*/locations/*}/glossaries", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListGlossariesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetGlossaryRequest, Glossary> getGlossaryMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.translation.v3.TranslationService/GetGlossary").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=projects/*/locations/*/glossaries/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Glossary.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteGlossaryRequest, Operation> deleteGlossaryMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.translation.v3.TranslationService/DeleteGlossary").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=projects/*/locations/*/glossaries/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<TranslateTextRequest, TranslateTextResponse> translateTextCallable;
    private final UnaryCallable<DetectLanguageRequest, DetectLanguageResponse> detectLanguageCallable;
    private final UnaryCallable<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesCallable;
    private final UnaryCallable<TranslateDocumentRequest, TranslateDocumentResponse> translateDocumentCallable;
    private final UnaryCallable<BatchTranslateTextRequest, Operation> batchTranslateTextCallable;
    private final OperationCallable<BatchTranslateTextRequest, BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextOperationCallable;
    private final UnaryCallable<BatchTranslateDocumentRequest, Operation> batchTranslateDocumentCallable;
    private final OperationCallable<BatchTranslateDocumentRequest, BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentOperationCallable;
    private final UnaryCallable<CreateGlossaryRequest, Operation> createGlossaryCallable;
    private final OperationCallable<CreateGlossaryRequest, Glossary, CreateGlossaryMetadata> createGlossaryOperationCallable;
    private final UnaryCallable<ListGlossariesRequest, ListGlossariesResponse> listGlossariesCallable;
    private final UnaryCallable<ListGlossariesRequest, TranslationServiceClient.ListGlossariesPagedResponse> listGlossariesPagedCallable;
    private final UnaryCallable<GetGlossaryRequest, Glossary> getGlossaryCallable;
    private final UnaryCallable<DeleteGlossaryRequest, Operation> deleteGlossaryCallable;
    private final OperationCallable<DeleteGlossaryRequest, DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonTranslationServiceStub create(TranslationServiceStubSettings settings) throws IOException {
        return new HttpJsonTranslationServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonTranslationServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonTranslationServiceStub(TranslationServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonTranslationServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonTranslationServiceStub(TranslationServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonTranslationServiceStub(TranslationServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonTranslationServiceCallableFactory());
    }

    protected HttpJsonTranslationServiceStub(TranslationServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings translateTextTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(translateTextMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings detectLanguageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(detectLanguageMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getSupportedLanguagesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getSupportedLanguagesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings translateDocumentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(translateDocumentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings batchTranslateTextTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchTranslateTextMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings batchTranslateDocumentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(batchTranslateDocumentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createGlossaryTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createGlossaryMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listGlossariesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listGlossariesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getGlossaryTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getGlossaryMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteGlossaryTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteGlossaryMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.translateTextCallable = callableFactory.createUnaryCallable(translateTextTransportSettings, settings.translateTextSettings(), clientContext);
        this.detectLanguageCallable = callableFactory.createUnaryCallable(detectLanguageTransportSettings, settings.detectLanguageSettings(), clientContext);
        this.getSupportedLanguagesCallable = callableFactory.createUnaryCallable(getSupportedLanguagesTransportSettings, settings.getSupportedLanguagesSettings(), clientContext);
        this.translateDocumentCallable = callableFactory.createUnaryCallable(translateDocumentTransportSettings, settings.translateDocumentSettings(), clientContext);
        this.batchTranslateTextCallable = callableFactory.createUnaryCallable(batchTranslateTextTransportSettings, settings.batchTranslateTextSettings(), clientContext);
        this.batchTranslateTextOperationCallable = callableFactory.createOperationCallable(batchTranslateTextTransportSettings, settings.batchTranslateTextOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.batchTranslateDocumentCallable = callableFactory.createUnaryCallable(batchTranslateDocumentTransportSettings, settings.batchTranslateDocumentSettings(), clientContext);
        this.batchTranslateDocumentOperationCallable = callableFactory.createOperationCallable(batchTranslateDocumentTransportSettings, settings.batchTranslateDocumentOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.createGlossaryCallable = callableFactory.createUnaryCallable(createGlossaryTransportSettings, settings.createGlossarySettings(), clientContext);
        this.createGlossaryOperationCallable = callableFactory.createOperationCallable(createGlossaryTransportSettings, settings.createGlossaryOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listGlossariesCallable = callableFactory.createUnaryCallable(listGlossariesTransportSettings, settings.listGlossariesSettings(), clientContext);
        this.listGlossariesPagedCallable = callableFactory.createPagedCallable(listGlossariesTransportSettings, settings.listGlossariesSettings(), clientContext);
        this.getGlossaryCallable = callableFactory.createUnaryCallable(getGlossaryTransportSettings, settings.getGlossarySettings(), clientContext);
        this.deleteGlossaryCallable = callableFactory.createUnaryCallable(deleteGlossaryTransportSettings, settings.deleteGlossarySettings(), clientContext);
        this.deleteGlossaryOperationCallable = callableFactory.createOperationCallable(deleteGlossaryTransportSettings, settings.deleteGlossaryOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(translateTextMethodDescriptor);
        methodDescriptors.add(detectLanguageMethodDescriptor);
        methodDescriptors.add(getSupportedLanguagesMethodDescriptor);
        methodDescriptors.add(translateDocumentMethodDescriptor);
        methodDescriptors.add(batchTranslateTextMethodDescriptor);
        methodDescriptors.add(batchTranslateDocumentMethodDescriptor);
        methodDescriptors.add(createGlossaryMethodDescriptor);
        methodDescriptors.add(listGlossariesMethodDescriptor);
        methodDescriptors.add(getGlossaryMethodDescriptor);
        methodDescriptors.add(deleteGlossaryMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<TranslateTextRequest, TranslateTextResponse> translateTextCallable() {
        return this.translateTextCallable;
    }

    @Override
    public UnaryCallable<DetectLanguageRequest, DetectLanguageResponse> detectLanguageCallable() {
        return this.detectLanguageCallable;
    }

    @Override
    public UnaryCallable<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesCallable() {
        return this.getSupportedLanguagesCallable;
    }

    @Override
    public UnaryCallable<TranslateDocumentRequest, TranslateDocumentResponse> translateDocumentCallable() {
        return this.translateDocumentCallable;
    }

    @Override
    public UnaryCallable<BatchTranslateTextRequest, Operation> batchTranslateTextCallable() {
        return this.batchTranslateTextCallable;
    }

    @Override
    public OperationCallable<BatchTranslateTextRequest, BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextOperationCallable() {
        return this.batchTranslateTextOperationCallable;
    }

    @Override
    public UnaryCallable<BatchTranslateDocumentRequest, Operation> batchTranslateDocumentCallable() {
        return this.batchTranslateDocumentCallable;
    }

    @Override
    public OperationCallable<BatchTranslateDocumentRequest, BatchTranslateDocumentResponse, BatchTranslateDocumentMetadata> batchTranslateDocumentOperationCallable() {
        return this.batchTranslateDocumentOperationCallable;
    }

    @Override
    public UnaryCallable<CreateGlossaryRequest, Operation> createGlossaryCallable() {
        return this.createGlossaryCallable;
    }

    @Override
    public OperationCallable<CreateGlossaryRequest, Glossary, CreateGlossaryMetadata> createGlossaryOperationCallable() {
        return this.createGlossaryOperationCallable;
    }

    @Override
    public UnaryCallable<ListGlossariesRequest, ListGlossariesResponse> listGlossariesCallable() {
        return this.listGlossariesCallable;
    }

    @Override
    public UnaryCallable<ListGlossariesRequest, TranslationServiceClient.ListGlossariesPagedResponse> listGlossariesPagedCallable() {
        return this.listGlossariesPagedCallable;
    }

    @Override
    public UnaryCallable<GetGlossaryRequest, Glossary> getGlossaryCallable() {
        return this.getGlossaryCallable;
    }

    @Override
    public UnaryCallable<DeleteGlossaryRequest, Operation> deleteGlossaryCallable() {
        return this.deleteGlossaryCallable;
    }

    @Override
    public OperationCallable<DeleteGlossaryRequest, DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryOperationCallable() {
        return this.deleteGlossaryOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

